/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.printer.idea.GraphCellPainter;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.RefPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphCommitCellRender
extends ColoredTableCellRenderer {
    private static final Logger LOG = Logger.getInstance(GraphCommitCellRender.class);
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final GraphCellPainter myPainter;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final RefPainter myRefPainter;
    @NotNull
    private final IssueLinkRenderer myIssueLinkRenderer;
    @Nullable
    private PaintInfo myGraphImage;
    @Nullable
    private Collection<VcsRef> myRefs;

    public GraphCommitCellRender(@NotNull VcsLogColorManager colorManager, @NotNull VcsLogDataHolder dataHolder, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table) {
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "<init>"));
        }
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "<init>"));
        }
        this.myDataHolder = dataHolder;
        this.myPainter = painter;
        this.myGraphTable = table;
        this.myRefPainter = new RefPainter(colorManager, false){

            @Override
            protected int getRowHeight() {
                return GraphCommitCellRender.this.myGraphTable.getRowHeight();
            }
        };
        this.myIssueLinkRenderer = new IssueLinkRenderer(dataHolder.getProject(), (SimpleColoredComponent)this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myRefs != null) {
            this.myRefPainter.drawLabels((Graphics2D)g, this.collectLabelsForRefs(this.myRefs), this.myGraphImage != null ? this.myGraphImage.getWidth() : 0);
        }
        if (this.myGraphImage != null) {
            UIUtil.drawImage((Graphics)g, (Image)this.myGraphImage.getImage(), (int)0, (int)0, null);
        } else {
            LOG.error("Image is null");
        }
    }

    protected void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int graphPadding;
        if (value == null) {
            return;
        }
        GraphCommitCell cell = GraphCommitCellRender.getAssertCommitCell(value);
        this.myGraphImage = this.getGraphImage(row);
        this.myRefs = cell.getRefsToThisCommit();
        if (this.myGraphImage != null) {
            graphPadding = this.myGraphImage.getWidth();
            if (graphPadding < 2) {
                LOG.error("Too small image width: " + graphPadding);
            }
        } else {
            graphPadding = 0;
        }
        int textPadding = graphPadding + this.calcRefsPadding(this.myRefs);
        this.setBorder(null);
        this.append("");
        this.appendTextPadding(textPadding);
        this.myIssueLinkRenderer.appendTextWithLinks(cell.getText(), this.myGraphTable.applyHighlighters((Component)((Object)this), row, column, "", hasFocus, isSelected));
    }

    @Nullable
    private PaintInfo getGraphImage(int row) {
        Collection printElements = this.myGraphTable.getVisibleGraph().getRowInfo(row).getPrintElements();
        int maxIndex = 0;
        for (PrintElement printElement : printElements) {
            maxIndex = Math.max(maxIndex, printElement.getPositionInCurrentRow());
        }
        BufferedImage image = UIUtil.createImage((int)(15 * (++maxIndex + 4)), (int)this.myGraphTable.getRowHeight(), (int)2);
        Graphics2D g2 = image.createGraphics();
        this.myPainter.draw(g2, printElements);
        int width = maxIndex * 15;
        return new PaintInfo(image, width);
    }

    private static GraphCommitCell getAssertCommitCell(Object value) {
        assert (value instanceof GraphCommitCell) : "Value of incorrect class was supplied: " + value;
        return (GraphCommitCell)value;
    }

    @NotNull
    private Map<String, Color> collectLabelsForRefs(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "collectLabelsForRefs"));
        }
        if (refs.isEmpty()) {
            Map<String, Color> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "collectLabelsForRefs"));
            }
            return map;
        }
        VirtualFile root = refs.iterator().next().getRoot();
        refs = ContainerUtil.sorted(refs, (Comparator)this.myDataHolder.getLogProvider(root).getReferenceManager().getLabelsOrderComparator());
        List<VcsRef> branches = GraphCommitCellRender.getBranches(refs);
        Collection tags = ContainerUtil.subtract((Collection)refs, branches);
        Map<String, Color> map = GraphCommitCellRender.getLabelsForRefs(branches, tags);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "collectLabelsForRefs"));
        }
        return map;
    }

    private int calcRefsPadding(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "calcRefsPadding"));
        }
        return this.myRefPainter.getLabelsWidth(this.collectLabelsForRefs(refs).keySet(), this.getFontMetrics(RefPainter.DEFAULT_FONT));
    }

    @NotNull
    private static Map<String, Color> getLabelsForRefs(@NotNull List<VcsRef> branches, @NotNull Collection<VcsRef> tags) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "getLabelsForRefs"));
        }
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "getLabelsForRefs"));
        }
        LinkedHashMap labels = ContainerUtil.newLinkedHashMap();
        for (VcsRef branch : branches) {
            labels.put(branch.getName(), branch.getType().getBackgroundColor());
        }
        if (!tags.isEmpty()) {
            VcsRef firstTag = tags.iterator().next();
            Color color = firstTag.getType().getBackgroundColor();
            if (tags.size() > 1) {
                labels.put(firstTag.getName() + " +", color);
            } else {
                labels.put(firstTag.getName(), color);
            }
        }
        LinkedHashMap linkedHashMap = labels;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/GraphCommitCellRender", "getLabelsForRefs"));
        }
        return linkedHashMap;
    }

    private static List<VcsRef> getBranches(Collection<VcsRef> refs) {
        return ContainerUtil.filter(refs, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return ref.getType().isBranch();
            }
        });
    }

    private static class PaintInfo {
        private int myWidth;
        @NotNull
        private Image myImage;

        PaintInfo(@NotNull Image image, int width) {
            if (image == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/vcs/log/ui/render/GraphCommitCellRender$PaintInfo", "<init>"));
            }
            this.myImage = image;
            this.myWidth = width;
        }

        @NotNull
        Image getImage() {
            Image image = this.myImage;
            if (image == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/GraphCommitCellRender$PaintInfo", "getImage"));
            }
            return image;
        }

        int getWidth() {
            return this.myWidth;
        }
    }
}

