/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryFullyQualifiedNameInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreJavadoc = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean inSameFile = (Boolean)infos[0];
        if (inSameFile) {
            String string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.problem.descriptor2", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.problem.descriptor1", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryFullyQualifiedNameFix((Boolean)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryFullyQualifiedNameVisitor();
    }

    private static boolean acceptFqnInJavadoc(PsiJavaFile javaFile, String fullyQualifiedName, CodeStyleSettings styleSettings) {
        if ("package-info.java".equals(javaFile.getName())) {
            return true;
        }
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)styleSettings.getCustomSettings(JavaCodeStyleSettings.class);
        if (javaSettings.CLASS_NAMES_IN_JAVADOC == 1) {
            return !ImportHelper.isAlreadyImported(javaFile, fullyQualifiedName);
        }
        return javaSettings.useFqNamesInJavadocAlways();
    }

    private static class UnnecessaryFullyQualifiedNameVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryFullyQualifiedNameVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            this.checkReference((PsiJavaCodeReferenceElement)expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            this.checkReference(reference);
        }

        private void checkReference(PsiJavaCodeReferenceElement reference) {
            PsiElement qualifier = reference.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (parent instanceof PsiMethodCallExpression || parent instanceof PsiAssignmentExpression || parent instanceof PsiVariable) {
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{PsiImportStatementBase.class, PsiPackageStatement.class, JavaCodeFragment.class});
            if (element != null) {
                return;
            }
            PsiFile containingFile = reference.getContainingFile();
            if (!(containingFile instanceof PsiJavaFile)) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)reference.getProject());
            PsiDocComment containingComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiDocComment.class);
            if (containingComment != null && UnnecessaryFullyQualifiedNameInspection.acceptFqnInJavadoc((PsiJavaFile)containingFile, reference.getQualifiedName(), styleSettings)) {
                return;
            }
            PsiJavaCodeReferenceElement qualifierReference = (PsiJavaCodeReferenceElement)qualifier;
            PsiElement qualifierTarget = qualifierReference.resolve();
            if (!(qualifierTarget instanceof PsiPackage)) {
                return;
            }
            ArrayList<PsiJavaCodeReferenceElement> references = new ArrayList<PsiJavaCodeReferenceElement>(2);
            references.add(reference);
            if (styleSettings.INSERT_INNER_CLASS_IMPORTS) {
                UnnecessaryFullyQualifiedNameVisitor.collectInnerClassNames(reference, references);
            }
            Collections.reverse(references);
            for (PsiJavaCodeReferenceElement aReference : references) {
                PsiClass aClass;
                String qualifiedName;
                PsiElement referenceTarget = aReference.resolve();
                if (!(referenceTarget instanceof PsiClass) || (qualifiedName = (aClass = (PsiClass)referenceTarget).getQualifiedName()) == null || !ImportUtils.nameCanBeImported(qualifiedName, (PsiElement)reference)) continue;
                boolean inSameFile = aClass.getContainingFile() == containingFile;
                this.registerError(aReference.getQualifier(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{inSameFile});
                break;
            }
        }

        private static void collectInnerClassNames(PsiJavaCodeReferenceElement reference, List<PsiJavaCodeReferenceElement> references) {
            PsiJavaCodeReferenceElement parentReference;
            PsiElement rParent = reference.getParent();
            while (rParent instanceof PsiJavaCodeReferenceElement && reference.equals((parentReference = (PsiJavaCodeReferenceElement)rParent).getQualifier())) {
                references.add(parentReference);
                rParent = rParent.getParent();
            }
        }
    }

    private static class UnnecessaryFullyQualifiedNameFix
    extends InspectionGadgetsFix {
        private final boolean inSameFile;

        public UnnecessaryFullyQualifiedNameFix(boolean inSameFile) {
            this.inSameFile = inSameFile;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace fully qualified name" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection$UnnecessaryFullyQualifiedNameFix", "getFamilyName"));
            }
            return "Replace fully qualified name";
        }

        @NotNull
        public String getName() {
            String string = this.inSameFile ? InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.remove.quickfix", new Object[0]) : InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection$UnnecessaryFullyQualifiedNameFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)descriptor.getPsiElement().getParent();
            PsiFile file = referenceElement.getContainingFile();
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            ImportUtils.addImportIfNeeded(aClass, (PsiElement)referenceElement);
            String fullyQualifiedText = referenceElement.getText();
            QualificationRemover qualificationRemover = new QualificationRemover(fullyQualifiedText);
            file.accept((PsiElementVisitor)qualificationRemover);
            if (this.isOnTheFly()) {
                Collection shortenedElements = qualificationRemover.getShortenedElements();
                HighlightUtils.highlightElements(shortenedElements);
                UnnecessaryFullyQualifiedNameFix.showStatusMessage(file.getProject(), shortenedElements.size());
            }
        }

        private static void showStatusMessage(Project project, int elementCount) {
            WindowManager windowManager = WindowManager.getInstance();
            StatusBar statusBar = windowManager.getStatusBar(project);
            if (statusBar == null) {
                return;
            }
            statusBar.setInfo(InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.status.bar.escape.highlighting.message", elementCount));
        }

        private static class QualificationRemover
        extends JavaRecursiveElementVisitor {
            private final String fullyQualifiedText;
            private final List<PsiElement> shortenedElements = new ArrayList<PsiElement>();

            private QualificationRemover(String fullyQualifiedText) {
                this.fullyQualifiedText = fullyQualifiedText;
            }

            private Collection<PsiElement> getShortenedElements() {
                return Collections.unmodifiableCollection(this.shortenedElements);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class);
                if (parent != null) {
                    return;
                }
                String text = reference.getText();
                if (!text.equals(this.fullyQualifiedText)) {
                    return;
                }
                PsiElement qualifier = reference.getQualifier();
                if (qualifier == null) {
                    return;
                }
                try {
                    qualifier.delete();
                }
                catch (IncorrectOperationException e) {
                    Class<?> aClass = ((Object)((Object)this)).getClass();
                    String className = aClass.getName();
                    Logger logger = Logger.getInstance((String)className);
                    logger.error((Throwable)e);
                }
                this.shortenedElements.add((PsiElement)reference);
            }
        }
    }
}

