/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.KotlinOutputParserHelper;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class AndroidPackage$KotlinOutputParserHelper$c9d219ea {
    @NotNull
    static final String COLON = ":";
    static final Pattern POSITION_PATTERN;

    public static final boolean parse(@JetValueParameter(name="line") @NotNull String line, @JetValueParameter(name="reader") @NotNull OutputLineReader reader, @JetValueParameter(name="messages") @NotNull List<Object> messages, @JetValueParameter(name="logger") @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        int colonIndex1 = AndroidPackage$KotlinOutputParserHelper$c9d219ea.colon(line);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = AndroidPackage$KotlinOutputParserHelper$c9d219ea.substringBeforeAndTrim(line, colonIndex1);
        if (!AndroidPackage$KotlinOutputParserHelper$c9d219ea.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = AndroidPackage$KotlinOutputParserHelper$c9d219ea.substringAfterAndTrim(line, colonIndex1);
        int colonIndex2 = AndroidPackage$KotlinOutputParserHelper$c9d219ea.skipDriveOnWin(AndroidPackage$KotlinOutputParserHelper$c9d219ea.colon(lineWoSeverity), lineWoSeverity);
        if (colonIndex2 >= 0) {
            String path = AndroidPackage$KotlinOutputParserHelper$c9d219ea.substringBeforeAndTrim(lineWoSeverity, colonIndex2);
            File file = new File(path);
            if (!file.isFile() && Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)file.getName()), (Object)"kt") ^ true) {
                return AndroidPackage$KotlinOutputParserHelper$c9d219ea.addMessage(KotlinOutputParserHelper.createMessage$default(KotlinOutputParserHelper.INSTANCE$, logger, severity, AndroidPackage$KotlinOutputParserHelper$c9d219ea.amendNextLinesIfNeeded(lineWoSeverity, reader), null, null, null, null, 120), messages);
            }
            String lineWoPath = AndroidPackage$KotlinOutputParserHelper$c9d219ea.substringAfterAndTrim(lineWoSeverity, colonIndex2);
            int colonIndex3 = AndroidPackage$KotlinOutputParserHelper$c9d219ea.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                String position = AndroidPackage$KotlinOutputParserHelper$c9d219ea.substringBeforeAndTrim(lineWoPath, colonIndex3);
                Matcher matcher = POSITION_PATTERN.matcher(position);
                String message = AndroidPackage$KotlinOutputParserHelper$c9d219ea.amendNextLinesIfNeeded(AndroidPackage$KotlinOutputParserHelper$c9d219ea.substringAfterAndTrim(lineWoPath, colonIndex3), reader);
                if (matcher.matches()) {
                    String lineNumber = matcher.group(1);
                    String symbolNumber = matcher.group(2);
                    if (lineNumber != null && symbolNumber != null) {
                        try {
                            return AndroidPackage$KotlinOutputParserHelper$c9d219ea.addMessage(KotlinOutputParserHelper.INSTANCE$.createMessage(logger, severity, message, path, KotlinPackage.toInt((String)lineNumber), KotlinPackage.toInt((String)symbolNumber), KotlinPackage.toInt((String)symbolNumber)), messages);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                return AndroidPackage$KotlinOutputParserHelper$c9d219ea.addMessage(KotlinOutputParserHelper.createMessage$default(KotlinOutputParserHelper.INSTANCE$, logger, severity, message, null, null, null, null, 120), messages);
            }
            return AndroidPackage$KotlinOutputParserHelper$c9d219ea.addMessage(KotlinOutputParserHelper.createMessage$default(KotlinOutputParserHelper.INSTANCE$, logger, severity, AndroidPackage$KotlinOutputParserHelper$c9d219ea.amendNextLinesIfNeeded(lineWoSeverity, reader), null, null, null, null, 120), messages);
        }
        return false;
    }

    @NotNull
    public static final String getCOLON() {
        return COLON;
    }

    public static final Pattern getPOSITION_PATTERN() {
        return POSITION_PATTERN;
    }

    @NotNull
    public static final String amendNextLinesIfNeeded(@JetValueParameter(name="$receiver") String $receiver, @JetValueParameter(name="reader") @NotNull OutputLineReader reader) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        String nextLine = reader.readLine();
        StringBuilder builder = new StringBuilder($receiver);
        while (nextLine != null) {
            String string = nextLine;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (AndroidPackage$KotlinOutputParserHelper$c9d219ea.isNextMessage(string)) break;
            builder.append("\n").append(nextLine);
            if (!reader.hasNextLine()) break;
            nextLine = reader.readLine();
        }
        if (nextLine != null) {
            String string = nextLine;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            reader.pushBack(string);
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public static final boolean isNextMessage(@JetValueParameter(name="$receiver") String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int colonIndex1 = KotlinPackage.indexOf$default((String)$receiver, (String)COLON, (int)0, (boolean)false, (int)6);
        return colonIndex1 >= 0 && AndroidPackage$KotlinOutputParserHelper$c9d219ea.startsWithSeverityPrefix(KotlinPackage.substring((String)$receiver, (int)0, (int)colonIndex1)) || StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILURE") || StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILED");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean startsWithSeverityPrefix(@JetValueParameter(name="$receiver") String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = KotlinPackage.trim((String)$receiver);
        switch (string.hashCode()) {
            case 119: {
                if (!string.equals("w")) return false;
                return true;
            }
            case 118: {
                if (!string.equals("v")) return false;
                return true;
            }
            case 101: {
                if (!string.equals("e")) return false;
                return true;
            }
            case 105: {
                if (!string.equals("i")) return false;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final String substringAfterAndTrim(@JetValueParameter(name="$receiver") String $receiver, @JetValueParameter(name="index") int index2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinPackage.trim((String)KotlinPackage.substring((String)$receiver, (int)(index2 + 1)));
    }

    @NotNull
    public static final String substringBeforeAndTrim(@JetValueParameter(name="$receiver") String $receiver, @JetValueParameter(name="index") int index2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinPackage.trim((String)KotlinPackage.substring((String)$receiver, (int)0, (int)index2));
    }

    public static final int colon(@JetValueParameter(name="$receiver") String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinPackage.indexOf$default((String)$receiver, (String)COLON, (int)0, (boolean)false, (int)6);
    }

    public static final int skipDriveOnWin(@JetValueParameter(name="$receiver") int $receiver, @JetValueParameter(name="line") @NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        return $receiver == 1 ? KotlinPackage.indexOf$default((String)line, (String)COLON, (int)($receiver + 1), (boolean)false, (int)4) : $receiver;
    }

    public static final boolean addMessage(@JetValueParameter(name="message", type="?") @Nullable Object message, @JetValueParameter(name="messages") @NotNull List<Object> messages) {
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        if (message == null) {
            return false;
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Object lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = Intrinsics.areEqual((Object)lastMessage, (Object)message);
        }
        if (!duplicatesPrevious) {
            messages.add(message);
        }
        return true;
    }

    static {
        COLON = COLON;
        POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
    }
}

