/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.codegen.AbstractClassBuilder;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class StubClassBuilder
extends AbstractClassBuilder {
    private static final InnerClassSourceStrategy<Object> EMPTY_STRATEGY = new InnerClassSourceStrategy<Object>(){

        public Object findInnerClass(String s, Object o) {
            return null;
        }

        public void accept(Object innerClass, StubBuildingVisitor<Object> visitor2) {
            throw new UnsupportedOperationException("Shall not be called!");
        }
    };
    private final StubElement parent;
    private StubBuildingVisitor v;
    private final Stack<StubElement> parentStack;
    private boolean isPackageClass;

    public StubClassBuilder(@NotNull Stack<StubElement> parentStack) {
        if (parentStack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStack", "org/jetbrains/kotlin/asJava/StubClassBuilder", "<init>"));
        }
        this.isPackageClass = false;
        this.parentStack = parentStack;
        this.parent = (StubElement)parentStack.peek();
    }

    @Override
    @NotNull
    public ClassVisitor getVisitor() {
        assert (this.v != null) : "Called before class is defined";
        StubBuildingVisitor stubBuildingVisitor = this.v;
        if (stubBuildingVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/StubClassBuilder", "getVisitor"));
        }
        return stubBuildingVisitor;
    }

    @Override
    public void defineClass(PsiElement origin, int version, int access, @NotNull String name2, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        FqName packageName;
        String packageClassName;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/StubClassBuilder", "defineClass"));
        }
        if (superName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superName", "org/jetbrains/kotlin/asJava/StubClassBuilder", "defineClass"));
        }
        if (interfaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaces", "org/jetbrains/kotlin/asJava/StubClassBuilder", "defineClass"));
        }
        assert (this.v == null) : "defineClass() called twice?";
        this.v = new StubBuildingVisitor(null, EMPTY_STRATEGY, this.parent, access, null);
        super.defineClass(origin, version, access, name2, signature, superName, interfaces);
        if (origin instanceof JetFile && (name2.equals(packageClassName = PackageClassUtils.getPackageClassName(packageName = ((JetFile)origin).getPackageFqName())) || name2.endsWith("/" + packageClassName))) {
            this.isPackageClass = true;
        }
        if (!this.isPackageClass) {
            this.parentStack.push((Object)this.v.getResult());
        }
        ((StubBase)this.v.getResult()).putUserData(ClsWrapperStubPsiFactory.ORIGIN_ELEMENT, (Object)origin);
    }

    @Override
    @NotNull
    public MethodVisitor newMethod(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/asJava/StubClassBuilder", "newMethod"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/StubClassBuilder", "newMethod"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/asJava/StubClassBuilder", "newMethod"));
        }
        MethodVisitor internalVisitor = super.newMethod(origin, access, name2, desc, signature, exceptions);
        if (internalVisitor != EMPTY_METHOD_VISITOR) {
            this.markLastChild(origin.getElement());
        }
        MethodVisitor methodVisitor = internalVisitor;
        if (methodVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/StubClassBuilder", "newMethod"));
        }
        return methodVisitor;
    }

    @Override
    @NotNull
    public FieldVisitor newField(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable Object value2) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/asJava/StubClassBuilder", "newField"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/StubClassBuilder", "newField"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/asJava/StubClassBuilder", "newField"));
        }
        FieldVisitor internalVisitor = super.newField(origin, access, name2, desc, signature, value2);
        if (internalVisitor != EMPTY_FIELD_VISITOR) {
            this.markLastChild(origin.getElement());
        }
        FieldVisitor fieldVisitor = internalVisitor;
        if (fieldVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/StubClassBuilder", "newField"));
        }
        return fieldVisitor;
    }

    private void markLastChild(@Nullable PsiElement origin) {
        List children2 = this.v.getResult().getChildrenStubs();
        StubBase last = (StubBase)children2.get(children2.size() - 1);
        PsiElement oldOrigin = (PsiElement)last.getUserData(ClsWrapperStubPsiFactory.ORIGIN_ELEMENT);
        if (oldOrigin != null) {
            throw new IllegalStateException("Rewriting origin element: " + oldOrigin.getText() + " for stub " + last.toString());
        }
        last.putUserData(ClsWrapperStubPsiFactory.ORIGIN_ELEMENT, (Object)origin);
    }

    @Override
    public void done() {
        if (!this.isPackageClass) {
            StubElement pop = (StubElement)this.parentStack.pop();
            assert (pop == this.v.getResult());
        }
        super.done();
    }
}

