/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.context.PackageFacadeContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationContainer;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.DiagnosticsPackage;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class PropertyCodegen {
    private final GenerationState state;
    private final ClassBuilder v;
    private final FunctionCodegen functionCodegen;
    private final JetTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final FieldOwnerContext context;
    private final MemberCodegen<?> memberCodegen;
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context2, @NotNull ClassBuilder v, @NotNull FunctionCodegen functionCodegen, @NotNull MemberCodegen<?> memberCodegen) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/PropertyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/PropertyCodegen", "<init>"));
        }
        if (functionCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCodegen", "org/jetbrains/kotlin/codegen/PropertyCodegen", "<init>"));
        }
        if (memberCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberCodegen", "org/jetbrains/kotlin/codegen/PropertyCodegen", "<init>"));
        }
        this.state = functionCodegen.state;
        this.v = v;
        this.functionCodegen = functionCodegen;
        this.typeMapper = this.state.getTypeMapper();
        this.bindingContext = this.state.getBindingContext();
        this.context = context2;
        this.memberCodegen = memberCodegen;
        this.kind = context2.getContextKind();
    }

    public void gen(@NotNull JetProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/PropertyCodegen", "gen"));
        }
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (variableDescriptor instanceof PropertyDescriptor) : "Property " + property.getText() + " should have a property descriptor: " + variableDescriptor;
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        this.gen(property, propertyDescriptor, property.getGetter(), property.getSetter());
    }

    public void generateInPackageFacade(@NotNull DeserializedPropertyDescriptor deserializedProperty) {
        if (deserializedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deserializedProperty", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateInPackageFacade"));
        }
        assert (this.context instanceof PackageFacadeContext) : "should be called only for generating package facade: " + this.context;
        this.gen(null, deserializedProperty, null, null);
    }

    private void gen(@Nullable JetProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable JetPropertyAccessor getter, @Nullable JetPropertyAccessor setter) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "gen"));
        }
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.TRAIT_IMPL) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor2;
        if (this.context instanceof PackageFacadeContext) {
            Type ownerType = ((PackageFacadeContext)this.context).getDelegateToClassType();
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, descriptor2, AsmUtil.shortNameByAsmType(ownerType));
        } else {
            assert (declaration != null) : "Declaration is null for different context: " + this.context;
            if (!this.generateBackingField(declaration, descriptor2)) {
                this.generateSyntheticMethodIfNeeded(descriptor2);
            }
        }
        if (this.isAccessorNeeded(declaration, descriptor2, getter)) {
            this.generateGetter(declaration, descriptor2, getter);
        }
        if (this.isAccessorNeeded(declaration, descriptor2, setter)) {
            this.generateSetter(declaration, descriptor2, setter);
        }
        this.context.recordSyntheticAccessorIfNeeded(descriptor2, this.bindingContext);
    }

    private boolean isAccessorNeeded(@Nullable JetProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable JetPropertyAccessor accessor) {
        boolean isDefaultAccessor;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "isAccessorNeeded"));
        }
        boolean bl = isDefaultAccessor = accessor == null || !accessor.hasBody();
        if (this.kind == OwnerKind.TRAIT_IMPL && isDefaultAccessor) {
            return false;
        }
        if (declaration == null) {
            return true;
        }
        if (declaration.hasDelegate() || declaration.getReceiverTypeReference() != null) {
            return true;
        }
        if (DescriptorUtils.isCompanionObject(descriptor2.getContainingDeclaration())) {
            return true;
        }
        if (this.kind == OwnerKind.IMPLEMENTATION && Visibilities.isPrivate(descriptor2.getVisibility())) {
            return !isDefaultAccessor;
        }
        return true;
    }

    public void generatePrimaryConstructorProperty(JetParameter p, PropertyDescriptor descriptor2) {
        this.generateBackingField(p, descriptor2);
        if (!Visibilities.isPrivate(descriptor2.getVisibility())) {
            this.generateGetter(p, descriptor2, null);
            if (descriptor2.isVar()) {
                this.generateSetter(p, descriptor2, null);
            }
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(JetParameter p, PropertyDescriptor descriptor2) {
        JetExpression defaultValue;
        JvmMethodSignature signature = this.typeMapper.mapAnnotationParameterSignature(descriptor2);
        String name2 = p.getName();
        if (name2 == null) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.OtherOrigin(p, descriptor2), 1025, name2, signature.getAsmMethod().getDescriptor(), signature.getGenericsSignature(), null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL && (defaultValue = p.getDefaultValue()) != null) {
            CompileTimeConstant constant = ExpressionCodegen.getCompileTimeConstant(defaultValue, this.bindingContext);
            assert (constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
            AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(mv, this.typeMapper);
            annotationCodegen.generateAnnotationDefaultValue(constant, descriptor2.getType());
        }
        mv.visitEnd();
    }

    private boolean generateBackingField(@NotNull JetNamedDeclaration p, @NotNull PropertyDescriptor descriptor2) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (JvmCodegenUtil.isInterface(descriptor2.getContainingDeclaration()) || this.kind == OwnerKind.TRAIT_IMPL) {
            return false;
        }
        if (p instanceof JetProperty && ((JetProperty)p).hasDelegate()) {
            this.generatePropertyDelegateAccess((JetProperty)p, descriptor2);
        } else if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            this.generateBackingFieldAccess(p, descriptor2);
        } else {
            return false;
        }
        return true;
    }

    private void generateSyntheticMethodIfNeeded(@NotNull PropertyDescriptor descriptor2) {
        String desc;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateSyntheticMethodIfNeeded"));
        }
        if (descriptor2.getAnnotations().isEmpty()) {
            return;
        }
        ReceiverParameterDescriptor receiver = descriptor2.getExtensionReceiverParameter();
        String name2 = JvmAbi.getSyntheticMethodNameForAnnotatedProperty(descriptor2.getName());
        String string = desc = receiver == null ? "()V" : "(" + this.typeMapper.mapType(receiver.getType()) + ")V";
        if (!DescriptorUtils.isTrait(this.context.getContextDescriptor()) || this.kind == OwnerKind.TRAIT_IMPL) {
            int flags = 135194;
            MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.OtherOrigin(descriptor2), flags, name2, desc, null, null);
            AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(descriptor2, Type.VOID_TYPE);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitEnd();
        } else {
            Type tImplType = this.typeMapper.mapTraitImpl((ClassDescriptor)this.context.getContextDescriptor());
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, descriptor2, AsmUtil.shortNameByAsmType(tImplType));
        }
        if (this.kind != OwnerKind.TRAIT_IMPL) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2, new Method(name2, desc));
        }
    }

    private void generateBackingField(JetNamedDeclaration element, PropertyDescriptor propertyDescriptor, boolean isDelegate, JetType jetType, Object defaultValue) {
        int modifiers = AsmUtil.getDeprecatedAccessFlag(propertyDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.FIELD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(propertyDescriptor.getOriginal())) continue;
            modifiers |= flagAnnotation.getJvmFlag();
        }
        if (this.kind == OwnerKind.PACKAGE) {
            modifiers |= 8;
        }
        if (!propertyDescriptor.isVar() || isDelegate) {
            modifiers |= 0x10;
        }
        Type type2 = this.typeMapper.mapType(jetType);
        ClassBuilder builder = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        if (AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor)) {
            modifiers |= 8 | AsmUtil.getVisibilityForSpecialPropertyBackingField(propertyDescriptor, isDelegate);
            if (AsmUtil.isPropertyWithBackingFieldInOuterClass(propertyDescriptor)) {
                ImplementationBodyCodegen codegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
                builder = codegen.v;
                backingFieldContext = codegen.context;
                this.v.getSerializationBindings().put(JvmSerializationBindings.STATIC_FIELD_IN_OUTER_CLASS, propertyDescriptor);
            }
        } else if (this.kind != OwnerKind.PACKAGE || isDelegate) {
            modifiers |= 2;
        }
        if (AsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addCompanionObjectPropertyToCopy(propertyDescriptor, defaultValue);
        }
        String name2 = backingFieldContext.getFieldName(propertyDescriptor, isDelegate);
        this.v.getSerializationBindings().put(JvmSerializationBindings.FIELD_FOR_PROPERTY, propertyDescriptor, Pair.create((Object)type2, (Object)name2));
        FieldVisitor fv = builder.newField(DiagnosticsPackage.OtherOrigin(element, propertyDescriptor), modifiers, name2, type2.getDescriptor(), this.typeMapper.mapFieldSignature(jetType), defaultValue);
        AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(propertyDescriptor, type2);
    }

    private void generatePropertyDelegateAccess(JetProperty p, PropertyDescriptor propertyDescriptor) {
        JetType delegateType;
        JetExpression delegateExpression = p.getDelegateExpression();
        JetType jetType = delegateType = delegateExpression != null ? this.bindingContext.getType(p.getDelegateExpression()) : null;
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType("Delegate type");
        }
        this.generateBackingField(p, propertyDescriptor, true, delegateType, null);
    }

    private void generateBackingFieldAccess(JetNamedDeclaration p, PropertyDescriptor propertyDescriptor) {
        CompileTimeConstant<?> initializer;
        Object value2 = null;
        if (this.shouldWriteFieldInitializer(propertyDescriptor) && (initializer = propertyDescriptor.getCompileTimeInitializer()) != null) {
            value2 = initializer.getValue();
        }
        this.generateBackingField(p, propertyDescriptor, false, propertyDescriptor.getType(), value2);
    }

    private boolean shouldWriteFieldInitializer(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "shouldWriteFieldInitializer"));
        }
        if (!descriptor2.isVar()) {
            Type type2 = this.typeMapper.mapType(descriptor2);
            return AsmUtil.isPrimitive(type2) || "java.lang.String".equals(type2.getClassName());
        }
        return false;
    }

    private void generateGetter(@Nullable JetNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @Nullable JetPropertyAccessor getter) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateGetter"));
        }
        this.generateAccessor(p, getter, descriptor2.getGetter() != null ? descriptor2.getGetter() : DescriptorFactory.createDefaultGetter(descriptor2));
    }

    private void generateSetter(@Nullable JetNamedDeclaration p, @NotNull PropertyDescriptor descriptor2, @Nullable JetPropertyAccessor setter) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateSetter"));
        }
        if (!descriptor2.isVar()) {
            return;
        }
        this.generateAccessor(p, setter, descriptor2.getSetter() != null ? descriptor2.getSetter() : DescriptorFactory.createDefaultSetter(descriptor2));
    }

    private void generateAccessor(@Nullable JetNamedDeclaration p, @Nullable JetPropertyAccessor accessor, @NotNull PropertyAccessorDescriptor accessorDescriptor) {
        if (accessorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorDescriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "generateAccessor"));
        }
        FunctionGenerationStrategy.CodegenBased strategy = accessor == null || !accessor.hasBody() ? (p instanceof JetProperty && ((JetProperty)p).hasDelegate() ? new DelegatedPropertyAccessorStrategy(this.state, accessorDescriptor, PropertyCodegen.indexOfDelegatedProperty((JetProperty)p)) : new DefaultPropertyAccessorStrategy(this.state, accessorDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, accessorDescriptor, accessor);
        this.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(accessor != null ? accessor : p, accessorDescriptor), accessorDescriptor, strategy);
    }

    public static int indexOfDelegatedProperty(@NotNull JetProperty property) {
        JetDeclarationContainer container2;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/PropertyCodegen", "indexOfDelegatedProperty"));
        }
        PsiElement parent = property.getParent();
        if (parent instanceof JetClassBody) {
            container2 = (JetClassOrObject)parent.getParent();
        } else if (parent instanceof JetFile) {
            container2 = (JetFile)parent;
        } else {
            throw new UnsupportedOperationException("Unknown delegated property container: " + parent);
        }
        int index2 = 0;
        for (JetDeclaration declaration : container2.getDeclarations()) {
            if (!(declaration instanceof JetProperty) || !((JetProperty)declaration).hasDelegate()) continue;
            if (declaration == property) {
                return index2;
            }
            ++index2;
        }
        throw new IllegalStateException("Delegated property not found in its parent: " + PsiUtilPackage.getElementTextWithContext(property));
    }

    public static StackValue invokeDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull ExpressionCodegen codegen, @NotNull JetTypeMapper typeMapper, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall, final int indexInPropertyMetadataArray, int propertyMetadataArgumentIndex) {
        Type owner;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen", "invokeDelegatedPropertyConventionMethod"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/PropertyCodegen", "invokeDelegatedPropertyConventionMethod"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/PropertyCodegen", "invokeDelegatedPropertyConventionMethod"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/PropertyCodegen", "invokeDelegatedPropertyConventionMethod"));
        }
        CodegenContext<ClassOrPackageFragmentDescriptor> ownerContext = codegen.getContext().getClassOrPackageParentContext();
        if (ownerContext instanceof ClassContext) {
            owner = typeMapper.mapClass((ClassifierDescriptor)((ClassContext)ownerContext).getContextDescriptor());
        } else if (ownerContext instanceof PackageContext) {
            owner = ((PackageContext)ownerContext).getPackagePartType();
        } else {
            throw new UnsupportedOperationException("Unknown context: " + ownerContext);
        }
        codegen.tempVariables.put(resolvedCall.getCall().getValueArguments().get(propertyMetadataArgumentIndex).asElement(), new StackValue(AsmTypes.PROPERTY_METADATA_TYPE){

            @Override
            public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/PropertyCodegen$1", "putSelector"));
                }
                if (v == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/PropertyCodegen$1", "putSelector"));
                }
                StackValue.Field array = StackValue.field(Type.getType((String)("[" + AsmTypes.PROPERTY_METADATA_TYPE)), owner, "$propertyMetadata", true, StackValue.none());
                StackValue.arrayElement(AsmTypes.PROPERTY_METADATA_TYPE, array, StackValue.constant(indexInPropertyMetadataArray, Type.INT_TYPE)).put(type2, v);
            }
        });
        StackValue.Property delegatedProperty = codegen.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
        return codegen.invokeFunction(resolvedCall, delegatedProperty);
    }

    @NotNull
    public static String getterName(Name propertyName) {
        String string = "get" + StringUtil.capitalizeWithJavaBeanConvention((String)propertyName.asString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/PropertyCodegen", "getterName"));
        }
        return string;
    }

    @NotNull
    public static String setterName(Name propertyName) {
        String string = "set" + StringUtil.capitalizeWithJavaBeanConvention((String)propertyName.asString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/PropertyCodegen", "setterName"));
        }
        return string;
    }

    public void genDelegate(@NotNull PropertyDescriptor delegate2, @NotNull PropertyDescriptor delegateTo, @NotNull StackValue field) {
        PropertySetterDescriptor setter;
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/codegen/PropertyCodegen", "genDelegate"));
        }
        if (delegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateTo", "org/jetbrains/kotlin/codegen/PropertyCodegen", "genDelegate"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/codegen/PropertyCodegen", "genDelegate"));
        }
        ClassDescriptor toClass = (ClassDescriptor)delegateTo.getContainingDeclaration();
        PropertyGetterDescriptor getter = delegate2.getGetter();
        if (getter != null) {
            this.functionCodegen.genDelegate(getter, delegateTo.getGetter().getOriginal(), toClass, field);
        }
        if ((setter = delegate2.getSetter()) != null) {
            this.functionCodegen.genDelegate(setter, delegateTo.getSetter().getOriginal(), toClass, field);
        }
    }

    private static class DelegatedPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        private final int index;

        public DelegatedPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor2, int index2) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "<init>"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "<init>"));
            }
            super(state, descriptor2);
            this.index = index2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "doGenerateBody"));
            }
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "doGenerateBody"));
            }
            InstructionAdapter v = codegen.v;
            BindingContext bindingContext2 = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall = bindingContext2.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.callableDescriptor);
            assert (resolvedCall != null) : "Resolve call should be recorded for delegate call " + signature.toString();
            StackValue lastValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(((PropertyAccessorDescriptor)this.callableDescriptor).getCorrespondingProperty(), codegen, this.state.getTypeMapper(), resolvedCall, this.index, 1);
            Type asmType = signature.getReturnType();
            lastValue.put(asmType, v);
            v.areturn(asmType);
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor2) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            super(state, descriptor2);
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "doGenerateBody"));
            }
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "doGenerateBody"));
            }
            InstructionAdapter v = codegen.v;
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)this.callableDescriptor).getCorrespondingProperty();
            StackValue.Property property = codegen.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
            PsiElement jetProperty = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
            if (jetProperty instanceof JetProperty || jetProperty instanceof JetParameter) {
                codegen.markLineNumber((JetElement)jetProperty, false);
            }
            if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                Type type2 = signature.getReturnType();
                property.put(type2, v);
                v.areturn(type2);
            } else if (this.callableDescriptor instanceof PropertySetterDescriptor) {
                List<ValueParameterDescriptor> valueParameters = ((PropertyAccessorDescriptor)this.callableDescriptor).getValueParameters();
                assert (valueParameters.size() == 1) : "Property setter should have only one value parameter but has " + this.callableDescriptor;
                int parameterIndex = codegen.lookupLocalIndex(valueParameters.get(0));
                assert (parameterIndex >= 0) : "Local index for setter parameter should be positive or zero: " + this.callableDescriptor;
                Type type3 = codegen.typeMapper.mapType(propertyDescriptor);
                property.store(StackValue.local(parameterIndex, type3), codegen.v);
                v.visitInsn(177);
            } else {
                throw new IllegalStateException("Unknown property accessor: " + this.callableDescriptor);
            }
        }
    }
}

