/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.StoredStackValuesDescriptor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44 {
    public static final boolean needToProcess(@JetValueParameter(name="node") @NotNull MethodNode node2, @JetValueParameter(name="frames") @NotNull Frame<BasicValue>[] frames) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        Intrinsics.checkParameterIsNotNull(frames, (String)"frames");
        AbstractInsnNode[] insns = node2.instructions.toArray();
        int balance = 0;
        boolean isThereAnyInlineMarker = false;
        for (Pair pair2 : KotlinPackage.zip((Object[])insns, (Object[])frames)) {
            AbstractInsnNode insn = (AbstractInsnNode)pair2.component1();
            Frame frame = (Frame)pair2.component2();
            AbstractInsnNode abstractInsnNode = insn;
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insn");
            if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isInlineMarker$default(abstractInsnNode, null, 2)) {
                isThereAnyInlineMarker = true;
                if (frame == null) {
                    return false;
                }
            }
            AbstractInsnNode abstractInsnNode2 = insn;
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode2, (String)"insn");
            if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isBeforeInlineMarker(abstractInsnNode2)) {
                ++balance;
            } else {
                AbstractInsnNode abstractInsnNode3 = insn;
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode3, (String)"insn");
                if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isAfterInlineMarker(abstractInsnNode3)) {
                    --balance;
                }
            }
            if (balance >= 0) continue;
            return false;
        }
        return balance == 0 && isThereAnyInlineMarker;
    }

    public static final boolean isBeforeInlineMarker(@JetValueParameter(name="insn") @NotNull AbstractInsnNode insn) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        return OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isInlineMarker(insn, InlineCodegenUtil.INLINE_MARKER_BEFORE_METHOD_NAME);
    }

    public static final boolean isAfterInlineMarker(@JetValueParameter(name="insn") @NotNull AbstractInsnNode insn) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        return OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isInlineMarker(insn, InlineCodegenUtil.INLINE_MARKER_AFTER_METHOD_NAME);
    }

    public static final boolean isInlineMarker(@JetValueParameter(name="insn") @NotNull AbstractInsnNode insn, @JetValueParameter(name="markerName", type="?") @Nullable String markerName) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        return insn.getOpcode() == Opcodes.INVOKESTATIC && insn instanceof MethodInsnNode && Intrinsics.areEqual((Object)((MethodInsnNode)insn).owner, (Object)InlineCodegenUtil.INLINE_MARKER_CLASS_NAME) && (markerName != null ? Intrinsics.areEqual((Object)markerName, (Object)((MethodInsnNode)insn).name) : Intrinsics.areEqual((Object)((MethodInsnNode)insn).name, (Object)InlineCodegenUtil.INLINE_MARKER_BEFORE_METHOD_NAME) || Intrinsics.areEqual((Object)((MethodInsnNode)insn).name, (Object)InlineCodegenUtil.INLINE_MARKER_AFTER_METHOD_NAME));
    }

    public static /* synthetic */ boolean isInlineMarker$default(AbstractInsnNode abstractInsnNode, String string, int n) {
        if ((n & 2) != 0) {
            string = null;
        }
        return OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isInlineMarker(abstractInsnNode, string);
    }

    public static final void process(@JetValueParameter(name="methodNode") @NotNull MethodNode methodNode, @JetValueParameter(name="frames") @NotNull Frame<BasicValue>[] frames) {
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Intrinsics.checkParameterIsNotNull(frames, (String)"frames");
        AbstractInsnNode[] insns = methodNode.instructions.toArray();
        Stack storedValuesDescriptorsStack = new Stack();
        int firstAvailableVarIndex = methodNode.maxLocals;
        int currentStoredValuesCount = 0;
        for (Pair pair2 : KotlinPackage.zip((Object[])insns, (Object[])frames)) {
            StoredStackValuesDescriptor desc;
            AbstractInsnNode insn = (AbstractInsnNode)pair2.component1();
            Frame frame = (Frame)pair2.component2();
            AbstractInsnNode abstractInsnNode = insn;
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insn");
            if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isBeforeInlineMarker(abstractInsnNode)) {
                if (frame == null) {
                    throw (Throwable)((Object)new AssertionError((Object)"process method shouldn't be called if frame is null before inline marker"));
                }
                AbstractInsnNode abstractInsnNode2 = insn;
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode2, (String)"insn");
                desc = OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.storeStackValues(methodNode, (Frame<BasicValue>)frame, abstractInsnNode2, firstAvailableVarIndex, currentStoredValuesCount);
                firstAvailableVarIndex += desc.getStoredStackSize();
                currentStoredValuesCount += desc.getStoredValuesCount();
                storedValuesDescriptorsStack.push((Object)desc);
            } else {
                AbstractInsnNode abstractInsnNode3 = insn;
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode3, (String)"insn");
                if (OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isAfterInlineMarker(abstractInsnNode3)) {
                    if (frame == null) {
                        throw (Throwable)((Object)new AssertionError((Object)"process method shouldn't be called if frame is null before inline marker"));
                    }
                    if ((StoredStackValuesDescriptor)storedValuesDescriptorsStack.pop() == null) {
                        throw (Throwable)((Object)new AssertionError((Object)"should be non null becase markers are balanced"));
                    }
                    AbstractInsnNode abstractInsnNode4 = insn;
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode4, (String)"insn");
                    OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.loadStackValues(methodNode, (Frame<BasicValue>)frame, abstractInsnNode4, desc);
                    firstAvailableVarIndex -= desc.getStoredStackSize();
                    currentStoredValuesCount -= desc.getStoredValuesCount();
                }
            }
            AbstractInsnNode abstractInsnNode5 = insn;
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode5, (String)"insn");
            if (!OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isInlineMarker$default(abstractInsnNode5, null, 2)) continue;
            methodNode.instructions.remove(insn);
        }
    }

    public static final void removeInlineMarkers(@JetValueParameter(name="node") @NotNull MethodNode node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        AbstractInsnNode[] abstractInsnNodeArray = node2.instructions.toArray();
        for (int i = 0; i < abstractInsnNodeArray.length; ++i) {
            AbstractInsnNode insn;
            AbstractInsnNode abstractInsnNode = insn = abstractInsnNodeArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insn");
            if (!OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.isInlineMarker$default(abstractInsnNode, null, 2)) continue;
            node2.instructions.remove(insn);
        }
    }

    @NotNull
    public static final StoredStackValuesDescriptor storeStackValues(@JetValueParameter(name="node") @NotNull MethodNode node2, @JetValueParameter(name="frame") @NotNull Frame<BasicValue> frame, @JetValueParameter(name="beforeInlineMarker") @NotNull AbstractInsnNode beforeInlineMarker, @JetValueParameter(name="firstAvailableVarIndex") int firstAvailableVarIndex, @JetValueParameter(name="alreadyStoredValuesCount") int alreadyStoredValuesCount) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        Intrinsics.checkParameterIsNotNull(frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)beforeInlineMarker, (String)"beforeInlineMarker");
        int stackSize = 0;
        List<BasicValue> values2 = OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.getStackValuesStartingFrom(frame, alreadyStoredValuesCount);
        for (BasicValue value2 : KotlinPackage.reverse((Iterable)values2)) {
            InsnList insnList = node2.instructions;
            Type type2 = value2.getType();
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            insnList.insertBefore(beforeInlineMarker, (AbstractInsnNode)new VarInsnNode(type2.getOpcode(Opcodes.ISTORE), firstAvailableVarIndex + stackSize));
            stackSize += value2.getSize();
        }
        OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.updateMaxLocals(node2, firstAvailableVarIndex + stackSize);
        return new StoredStackValuesDescriptor(values2, firstAvailableVarIndex, stackSize, alreadyStoredValuesCount);
    }

    public static final void loadStackValues(@JetValueParameter(name="node") @NotNull MethodNode node2, @JetValueParameter(name="frame") @NotNull Frame<BasicValue> frame, @JetValueParameter(name="afterInlineMarker") @NotNull AbstractInsnNode afterInlineMarker, @JetValueParameter(name="desc") @NotNull StoredStackValuesDescriptor desc) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        Intrinsics.checkParameterIsNotNull(frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)afterInlineMarker, (String)"afterInlineMarker");
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        if (!desc.getIsStored()) {
            return;
        }
        InsnList insns = node2.instructions;
        int returnValueVarIndex = -1;
        Type returnType2 = null;
        if (frame.getStackSize() != desc.getTotalValuesCountOnStackBeforeInline()) {
            KotlinPackage.assert((frame.getStackSize() - desc.getTotalValuesCountOnStackBeforeInline() == 1 ? 1 : 0) != 0, (Object)"Stack sizes should not differ by more than 1 (returned value)");
            returnValueVarIndex = desc.getNextFreeVarIndex();
            Value value2 = frame.getStack(frame.getStackSize() - 1);
            if (value2 == null) {
                Intrinsics.throwNpe();
            }
            Type type2 = returnType2 = ((BasicValue)value2).getType();
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            OptimizationPackage$StoreStackBeforeInlineMethodTransformer$4edcef44.updateMaxLocals(node2, returnValueVarIndex + type2.getSize());
            Type type3 = returnType2;
            if (type3 == null) {
                Intrinsics.throwNpe();
            }
            insns.insertBefore(afterInlineMarker, (AbstractInsnNode)new VarInsnNode(type3.getOpcode(Opcodes.ISTORE), returnValueVarIndex));
        }
        int currentVarIndex = desc.getFirstVariableIndex() + desc.getStoredStackSize();
        for (BasicValue value3 : desc.getValues()) {
            currentVarIndex -= value3.getSize();
            Type type4 = value3.getType();
            if (type4 == null) {
                Intrinsics.throwNpe();
            }
            insns.insertBefore(afterInlineMarker, (AbstractInsnNode)new VarInsnNode(type4.getOpcode(Opcodes.ILOAD), currentVarIndex));
        }
        if (returnValueVarIndex != -1) {
            Type type5 = returnType2;
            if (type5 == null) {
                Intrinsics.throwNpe();
            }
            insns.insertBefore(afterInlineMarker, (AbstractInsnNode)new VarInsnNode(type5.getOpcode(Opcodes.ILOAD), returnValueVarIndex));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <V extends BasicValue> List<V> getStackValuesStartingFrom(@JetValueParameter(name="$receiver") Frame<V> $receiver, @JetValueParameter(name="from") int from) {
        void destination;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable $receiver3 = (Iterable)new IntRange(from, $receiver.getStackSize() - 1);
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver2) {
            void it;
            int n = ((Number)item).intValue();
            void var8_8 = destination;
            BasicValue basicValue = (BasicValue)$receiver.getStack((int)it);
            var8_8.add(basicValue);
        }
        return KotlinPackage.requireNoNulls((List)((List)destination));
    }

    public static final void updateMaxLocals(@JetValueParameter(name="$receiver") MethodNode $receiver, @JetValueParameter(name="newMaxLocals") int newMaxLocals) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.maxLocals = Math.max($receiver.maxLocals, newMaxLocals);
    }
}

