/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.SubstitutingScope;
import org.jetbrains.kotlin.types.DescriptorSubstitutor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorImpl;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

public class LazySubstitutingClassDescriptor
implements ClassDescriptor {
    private final ClassDescriptor original;
    private final TypeSubstitutor originalSubstitutor;
    private TypeSubstitutor newSubstitutor;
    private List<TypeParameterDescriptor> typeParameters;
    private TypeConstructor typeConstructor;

    public LazySubstitutingClassDescriptor(ClassDescriptor descriptor2, TypeSubstitutor substitutor3) {
        this.original = descriptor2;
        this.originalSubstitutor = substitutor3;
    }

    private TypeSubstitutor getSubstitutor() {
        if (this.newSubstitutor == null) {
            if (this.originalSubstitutor.isEmpty()) {
                this.newSubstitutor = this.originalSubstitutor;
            } else {
                List<TypeParameterDescriptor> originalTypeParameters = this.original.getTypeConstructor().getParameters();
                this.typeParameters = new ArrayList<TypeParameterDescriptor>(originalTypeParameters.size());
                this.newSubstitutor = DescriptorSubstitutor.substituteTypeParameters(originalTypeParameters, this.originalSubstitutor, this, this.typeParameters);
            }
        }
        return this.newSubstitutor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor originalTypeConstructor = this.original.getTypeConstructor();
        if (this.originalSubstitutor.isEmpty()) {
            TypeConstructor typeConstructor2 = originalTypeConstructor;
            if (typeConstructor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getTypeConstructor"));
            }
            return typeConstructor2;
        }
        if (this.typeConstructor == null) {
            TypeSubstitutor substitutor3 = this.getSubstitutor();
            Collection<JetType> originalSupertypes = originalTypeConstructor.getSupertypes();
            ArrayList<JetType> supertypes2 = new ArrayList<JetType>(originalSupertypes.size());
            for (JetType supertype : originalSupertypes) {
                supertypes2.add(substitutor3.substitute(supertype, Variance.INVARIANT));
            }
            this.typeConstructor = TypeConstructorImpl.createForClass(this, originalTypeConstructor.getAnnotations(), originalTypeConstructor.isFinal(), originalTypeConstructor.toString(), this.typeParameters, supertypes2);
        }
        TypeConstructor typeConstructor3 = this.typeConstructor;
        if (typeConstructor3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getTypeConstructor"));
        }
        return typeConstructor3;
    }

    @Override
    @NotNull
    public JetScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
        }
        JetScope memberScope2 = this.original.getMemberScope(typeArguments);
        if (this.originalSubstitutor.isEmpty()) {
            JetScope jetScope = memberScope2;
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
            }
            return jetScope;
        }
        SubstitutingScope substitutingScope = new SubstitutingScope(memberScope2, this.getSubstitutor());
        if (substitutingScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getMemberScope"));
        }
        return substitutingScope;
    }

    @Override
    @NotNull
    public JetScope getStaticScope() {
        JetScope jetScope = this.original.getStaticScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getStaticScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        List<TypeProjection> typeProjections = TypeUtils.getDefaultTypeProjections(this.getTypeConstructor().getParameters());
        JetTypeImpl jetTypeImpl = new JetTypeImpl(this.getAnnotations(), this.getTypeConstructor(), false, typeProjections, this.getMemberScope(typeProjections));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getDefaultType"));
        }
        return jetTypeImpl;
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Collection<ConstructorDescriptor> originalConstructors = this.original.getConstructors();
        ArrayList<ConstructorDescriptor> result2 = new ArrayList<ConstructorDescriptor>(originalConstructors.size());
        for (ConstructorDescriptor constructor2 : originalConstructors) {
            result2.add((ConstructorDescriptor)constructor2.substitute(this.getSubstitutor()));
        }
        ArrayList<ConstructorDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getConstructors"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.original.getAnnotations();
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getAnnotations"));
        }
        return annotations2;
    }

    @Override
    @NotNull
    public Name getName() {
        Name name2 = this.original.getName();
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getName"));
        }
        return name2;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        DeclarationDescriptor declarationDescriptor = this.original.getOriginal();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getOriginal"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.original.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor3) {
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "substitute"));
        }
        if (substitutor3.isEmpty()) {
            LazySubstitutingClassDescriptor lazySubstitutingClassDescriptor = this;
            if (lazySubstitutingClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "substitute"));
            }
            return lazySubstitutingClassDescriptor;
        }
        LazySubstitutingClassDescriptor lazySubstitutingClassDescriptor = new LazySubstitutingClassDescriptor(this, TypeSubstitutor.create(substitutor3.getSubstitution(), this.getSubstitutor().getSubstitution()));
        if (lazySubstitutingClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "substitute"));
        }
        return lazySubstitutingClassDescriptor;
    }

    @Override
    public ClassDescriptor getCompanionObjectDescriptor() {
        return this.original.getCompanionObjectDescriptor();
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.original.getKind();
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.original.getModality();
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.original.getVisibility();
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.original.isInner();
    }

    @Override
    public boolean isCompanionObject() {
        return this.original.isCompanionObject();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitClassDescriptor(this, data2);
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        JetScope jetScope = this.original.getUnsubstitutedInnerClassesScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getUnsubstitutedInnerClassesScope"));
        }
        return jetScope;
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.original.getUnsubstitutedPrimaryConstructor();
    }

    @Override
    @NotNull
    public SourceElement getSource() {
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        if (sourceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/LazySubstitutingClassDescriptor", "getSource"));
        }
        return sourceElement;
    }
}

