/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.types.JetType;

public class JetAddFunctionToClassifierAction
implements QuestionAction {
    private final List<FunctionDescriptor> functionsToAdd;
    private final Project project;
    private final Editor editor;

    public JetAddFunctionToClassifierAction(@NotNull Project project, @NotNull Editor editor, @NotNull List<FunctionDescriptor> functionsToAdd) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/actions/JetAddFunctionToClassifierAction", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/actions/JetAddFunctionToClassifierAction", "<init>"));
        }
        if (functionsToAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionsToAdd", "org/jetbrains/kotlin/idea/actions/JetAddFunctionToClassifierAction", "<init>"));
        }
        this.project = project;
        this.editor = editor;
        this.functionsToAdd = new ArrayList<FunctionDescriptor>(functionsToAdd);
    }

    private static void addFunction(@NotNull Project project, final @NotNull ClassDescriptor typeDescriptor, final @NotNull FunctionDescriptor functionDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/actions/JetAddFunctionToClassifierAction", "addFunction"));
        }
        if (typeDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDescriptor", "org/jetbrains/kotlin/idea/actions/JetAddFunctionToClassifierAction", "addFunction"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/actions/JetAddFunctionToClassifierAction", "addFunction"));
        }
        final String signatureString = IdeDescriptorRenderers.SOURCE_CODE.render(functionDescriptor);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final JetClass classifierDeclaration = (JetClass)DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, typeDescriptor);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(classifierDeclaration);
                        JetClassBody body2 = classifierDeclaration.getBody();
                        if (body2 == null) {
                            PsiElement whitespaceBefore = classifierDeclaration.add(psiFactory.createWhiteSpace());
                            body2 = (JetClassBody)classifierDeclaration.addAfter((PsiElement)psiFactory.createEmptyClassBody(), whitespaceBefore);
                            classifierDeclaration.addAfter(psiFactory.createNewLine(), (PsiElement)body2);
                        }
                        String functionBody = "";
                        if (typeDescriptor.getKind() != ClassKind.INTERFACE && functionDescriptor.getModality() != Modality.ABSTRACT) {
                            functionBody = "{}";
                            JetType returnType2 = functionDescriptor.getReturnType();
                            if (returnType2 == null || !KotlinBuiltIns.isUnit(returnType2)) {
                                functionBody = "{ throw UnsupportedOperationException() }";
                            }
                        }
                        JetNamedFunction functionElement = psiFactory.createFunction(signatureString + functionBody);
                        PsiElement anchor2 = body2.getRBrace();
                        JetNamedFunction insertedFunctionElement = (JetNamedFunction)body2.addBefore(functionElement, anchor2);
                        ShortenReferences.DEFAULT.process(insertedFunctionElement);
                    }
                });
            }
        }, JetBundle.message("add.function.to.type.action", new Object[0]), null);
    }

    public boolean execute() {
        if (this.functionsToAdd.isEmpty()) {
            return false;
        }
        if (this.functionsToAdd.size() == 1 || !this.editor.getComponent().isShowing()) {
            this.addFunction(this.functionsToAdd.get(0));
        } else {
            this.chooseFunctionAndAdd();
        }
        return true;
    }

    private void chooseFunctionAndAdd() {
        JBPopupFactory.getInstance().createListPopup(this.getFunctionPopup()).showInBestPositionFor(this.editor);
    }

    private ListPopupStep getFunctionPopup() {
        return new BaseListPopupStep<FunctionDescriptor>(JetBundle.message("add.function.to.type.action.type.chooser", new Object[0]), this.functionsToAdd){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public PopupStep onChosen(FunctionDescriptor selectedValue, boolean finalChoice) {
                if (finalChoice) {
                    JetAddFunctionToClassifierAction.this.addFunction(selectedValue);
                }
                return FINAL_CHOICE;
            }

            public Icon getIconFor(FunctionDescriptor aValue) {
                return PlatformIcons.FUNCTION_ICON;
            }

            @NotNull
            public String getTextFor(FunctionDescriptor functionDescriptor) {
                ClassDescriptor type2 = (ClassDescriptor)functionDescriptor.getContainingDeclaration();
                String string = JetBundle.message("add.function.to.type.action.single", IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(functionDescriptor), type2.getName().toString());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/actions/JetAddFunctionToClassifierAction$2", "getTextFor"));
                }
                return string;
            }
        };
    }

    private void addFunction(FunctionDescriptor functionToAdd) {
        JetAddFunctionToClassifierAction.addFunction(this.project, (ClassDescriptor)functionToAdd.getContainingDeclaration(), functionToAdd);
    }
}

