/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Map;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.JetIcons;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils;

public class NewKotlinFileAction
extends CreateFileFromTemplateAction
implements DumbAware {
    public NewKotlinFileAction() {
        super(JetBundle.message("new.kotlin.file.action", new Object[0]), "Creates new Kotlin file", JetFileType.INSTANCE.getIcon());
    }

    protected void postProcess(PsiFile createdElement, String templateName, Map<String, String> customProperties) {
        super.postProcess((PsiElement)createdElement, templateName, customProperties);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)createdElement);
        if (module != null) {
            ConfigureKotlinInProjectUtils.showConfigureKotlinNotificationIfNeeded(module);
        }
    }

    protected void buildDialog(Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        builder.setTitle(JetBundle.message("new.kotlin.file.action", new Object[0])).addKind("Kotlin file", JetFileType.INSTANCE.getIcon(), "Kotlin File").addKind("Class", JetIcons.CLASS, "Kotlin Class").addKind("Interface", JetIcons.TRAIT, "Kotlin Interface").addKind("Enum class", JetIcons.ENUM, "Kotlin Enum").addKind("Object", JetIcons.OBJECT, "Kotlin Object");
    }

    protected String getActionName(PsiDirectory directory, String newName, String templateName) {
        return JetBundle.message("new.kotlin.file.action", new Object[0]);
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (super.isAvailable(dataContext)) {
            IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            assert (ideView != null && project != null);
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (PsiDirectory dir : ideView.getDirectories()) {
                if (!projectFileIndex.isInSourceContent(dir.getVirtualFile())) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof NewKotlinFileAction;
    }
}

