/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.JetFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetSourceFilterScope;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;

public class JetGotoSymbolContributor
implements ChooseByNameContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        Collection items = StubIndex.getInstance().getAllKeys(JetFunctionShortNameIndex.getInstance().getKey(), project);
        items.addAll(StubIndex.getInstance().getAllKeys(JetPropertyShortNameIndex.getInstance().getKey(), project));
        String[] stringArray = ArrayUtil.toStringArray((Collection)items);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/JetGotoSymbolContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name2, String pattern, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope baseScope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        GlobalSearchScope noLibrarySourceScope = JetSourceFilterScope.kotlinSourceAndClassFiles(baseScope, project);
        Collection<JetNamedFunction> functions2 = JetFunctionShortNameIndex.getInstance().get(name2, project, noLibrarySourceScope);
        Collection<JetProperty> properties2 = JetPropertyShortNameIndex.getInstance().get(name2, project, noLibrarySourceScope);
        ArrayList<JetProperty> items = new ArrayList<JetProperty>(Collections2.filter(functions2, (Predicate)Predicates.notNull()));
        items.addAll(properties2);
        NavigationItem[] navigationItemArray = (NavigationItem[])ArrayUtil.toObjectArray(items, NavigationItem.class);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/JetGotoSymbolContributor", "getItemsByName"));
        }
        return navigationItemArray;
    }
}

