/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.SdkInfo;
import org.jetbrains.kotlin.utils.UtilsPackage;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ResolvePackage$IdeaModuleInfos$2a459351 {
    @NotNull
    static final String LIBRARY_NAME_PREFIX = "library ";

    @NotNull
    public static final String getLIBRARY_NAME_PREFIX() {
        return LIBRARY_NAME_PREFIX;
    }

    @NotNull
    public static final List<IdeaModuleInfo> orderEntryToModuleInfo(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="orderEntry") @NotNull OrderEntry orderEntry, @JetValueParameter(name="productionOnly") boolean productionOnly) {
        List<IdeaModuleInfo> list;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)orderEntry, (String)"orderEntry");
        Function1<Module, List<? extends ModuleSourceInfo>> toInfos$ = new Function1<Module, List<? extends ModuleSourceInfo>>(productionOnly){
            final /* synthetic */ boolean $productionOnly;

            @NotNull
            public final List<ModuleSourceInfo> invoke(@JetValueParameter(name="$receiver") Module $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return this.$productionOnly ? KotlinPackage.listOf((Object)ResolvePackage$IdeaModuleInfos$2a459351.productionSourceInfo($receiver)) : KotlinPackage.listOf((Object[])new ModuleSourceInfo[]{ResolvePackage$IdeaModuleInfos$2a459351.testSourceInfo($receiver), ResolvePackage$IdeaModuleInfos$2a459351.productionSourceInfo($receiver)});
            }
            {
                this.$productionOnly = bl;
                super(1);
            }
        };
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            list = toInfos$.invoke(((ModuleSourceOrderEntry)orderEntry).getOwnerModule());
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            list = KotlinPackage.orEmpty(module != null ? toInfos$.invoke(module) : null);
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library == null) {
                return KotlinPackage.listOf();
            }
            Library library2 = library;
            list = UtilsPackage.emptyOrSingletonList(new LibraryInfo(project, library2));
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                return KotlinPackage.listOf();
            }
            Sdk sdk2 = sdk;
            list = UtilsPackage.emptyOrSingletonList(new SdkInfo(project, sdk2));
        } else {
            throw (Throwable)new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list;
    }

    public static final <T> T cached(@JetValueParameter(name="$receiver") Module $receiver, @JetValueParameter(name="provider") @NotNull CachedValueProvider<T> provider2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(provider2, (String)"provider");
        return (T)CachedValuesManager.getManager((Project)$receiver.getProject()).getCachedValue((UserDataHolder)$receiver, provider2);
    }

    @NotNull
    public static final List<IdeaModuleInfo> ideaModelDependencies(@JetValueParameter(name="module") @NotNull Module module, @JetValueParameter(name="productionOnly") boolean productionOnly) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        LinkedHashSet result2 = new LinkedHashSet();
        OrderEnumerator dependencyEnumerator = ModuleRootManager.getInstance((Module)module).orderEntries().compileOnly().recursively().exportedOnly();
        if (productionOnly) {
            dependencyEnumerator.productionOnly();
        }
        dependencyEnumerator.forEach((Processor)new Processor<OrderEntry>(result2, module, productionOnly){
            final /* synthetic */ LinkedHashSet $result;
            final /* synthetic */ Module $module;
            final /* synthetic */ boolean $productionOnly;

            public final boolean process(@JetValueParameter(name="orderEntry") OrderEntry orderEntry) {
                Project project = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.getProject()");
                OrderEntry orderEntry2 = orderEntry;
                if (orderEntry2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$result.addAll((Collection)ResolvePackage$IdeaModuleInfos$2a459351.orderEntryToModuleInfo(project, orderEntry2, this.$productionOnly));
                return true;
            }
            {
                this.$result = linkedHashSet;
                this.$module = module;
                this.$productionOnly = bl;
            }
        });
        return KotlinPackage.toList((Iterable)result2);
    }

    public static final boolean isTests(@JetValueParameter(name="$receiver") ModuleSourceInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ModuleTestSourceInfo;
    }

    @NotNull
    public static final ModuleProductionSourceInfo productionSourceInfo(@JetValueParameter(name="$receiver") Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new ModuleProductionSourceInfo($receiver);
    }

    @NotNull
    public static final ModuleTestSourceInfo testSourceInfo(@JetValueParameter(name="$receiver") Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new ModuleTestSourceInfo($receiver);
    }

    public static final boolean isLibraryClasses(@JetValueParameter(name="$receiver") IdeaModuleInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof SdkInfo || $receiver instanceof LibraryInfo;
    }

    static {
        LIBRARY_NAME_PREFIX = LIBRARY_NAME_PREFIX;
    }
}

