/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.asJava.FakeLightClassForFileOfPackage;
import org.jetbrains.kotlin.asJava.KotlinLightClassForPackage;
import org.jetbrains.kotlin.asJava.KotlinLightElement;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage$IdeaModuleInfos$2a459351;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage$KotlinCacheService$59662027;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage$getModuleInfo$658f7d43;
import org.jetbrains.kotlin.idea.caches.resolve.SdkInfo;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.PsiPackage;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ResolvePackage$getModuleInfo$658f7d43 {
    @NotNull
    public static final IdeaModuleInfo getModuleInfo(@JetValueParameter(name="$receiver") PsiElement $receiver) {
        ModuleInfo explicitModuleInfo;
        String doNotAnalyze;
        PsiElement context2;
        JetFile containingJetFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        getModuleInfo.1 logAndReturnDefault$ = getModuleInfo.1.INSTANCE$;
        if ($receiver instanceof KotlinLightElement) {
            return ResolvePackage$getModuleInfo$658f7d43.getModuleInfoForLightElement((KotlinLightElement)$receiver);
        }
        PsiElement psiElement = $receiver;
        if (!(psiElement instanceof JetElement)) {
            psiElement = null;
        }
        JetElement jetElement = (JetElement)psiElement;
        Object object = jetElement != null ? jetElement.getContainingFile() : null;
        if (!(object instanceof JetFile)) {
            object = null;
        }
        JetFile jetFile = containingJetFile = (JetFile)object;
        Object object2 = context2 = jetFile != null ? PsiPackage.getAnalysisContext(jetFile) : null;
        if (context2 != null) {
            return ResolvePackage$getModuleInfo$658f7d43.getModuleInfo(context2);
        }
        JetFile jetFile2 = containingJetFile;
        String string = doNotAnalyze = jetFile2 != null ? PsiPackage.getDoNotAnalyze(jetFile2) : null;
        if (doNotAnalyze != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Should not analyze element: ").append($receiver.getText()).append(" in file ");
            Object object3 = containingJetFile;
            if (object3 == null || (object3 = ((JetFile)object3).getName()) == null) {
                object3 = " <no file>";
            }
            return logAndReturnDefault$.invoke(stringBuilder.append((String)object3).append("\n").append(doNotAnalyze).toString());
        }
        JetFile jetFile3 = containingJetFile;
        ModuleInfo moduleInfo = explicitModuleInfo = jetFile3 != null ? PsiPackage.getModuleInfo(jetFile3) : null;
        if (explicitModuleInfo instanceof IdeaModuleInfo) {
            return (IdeaModuleInfo)explicitModuleInfo;
        }
        if (containingJetFile instanceof JetCodeFragment) {
            Object object4 = ((JetCodeFragment)containingJetFile).getContext();
            if (object4 == null || (object4 = ResolvePackage$getModuleInfo$658f7d43.getModuleInfo(object4)) == null) {
                object4 = logAndReturnDefault$.invoke("Analyzing code fragment of type " + ((JetCodeFragment)containingJetFile).getClass() + " with no context element" + "\n" + "Text:" + "\n" + ((JetCodeFragment)containingJetFile).getText());
            }
            return object4;
        }
        Project project = $receiver.getProject();
        PsiFile psiFile = $receiver.getContainingFile();
        if (psiFile == null) {
            return logAndReturnDefault$.invoke("Analyzing element of type " + $receiver.getClass() + " with no containing file" + "\n" + "Text:" + "\n" + $receiver.getText());
        }
        PsiFile containingFile2 = psiFile;
        VirtualFile virtualFile = containingFile2.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return logAndReturnDefault$.invoke("Analyzing non-physical file " + containingFile2 + " of type " + containingFile2.getClass());
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        PsiFile psiFile2 = containingFile2;
        if (!(psiFile2 instanceof JetFile)) {
            psiFile2 = null;
        }
        JetFile jetFile4 = (JetFile)psiFile2;
        return ResolvePackage$getModuleInfo$658f7d43.getModuleInfoByVirtualFile(project2, virtualFile2, jetFile4 != null ? jetFile4.isCompiled() : false);
    }

    @NotNull
    public static final IdeaModuleInfo getModuleInfoByVirtualFile(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="virtualFile") @NotNull VirtualFile virtualFile, @JetValueParameter(name="isDecompiledFile") boolean isDecompiledFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(virtualFile);
        if (module != null) {
            Function0<Unit> warnIfDecompiled$ = new Function0<Unit>(isDecompiledFile, virtualFile, module){
                final /* synthetic */ boolean $isDecompiledFile;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Module $module;

                public final void invoke() {
                    if (this.$isDecompiledFile) {
                        ResolvePackage$KotlinCacheService$59662027.getLOG().warn("Decompiled file for " + this.$virtualFile.getCanonicalPath() + " is in content of " + this.$module);
                    }
                }
                {
                    this.$isDecompiledFile = bl;
                    this.$virtualFile = virtualFile;
                    this.$module = module;
                    super(0);
                }
            };
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            if (moduleFileIndex.isInTestSourceContent(virtualFile)) {
                warnIfDecompiled$.invoke();
                return ResolvePackage$IdeaModuleInfos$2a459351.testSourceInfo(module);
            }
            if (moduleFileIndex.isInSourceContent(virtualFile)) {
                warnIfDecompiled$.invoke();
                return ResolvePackage$IdeaModuleInfos$2a459351.productionSourceInfo(module);
            }
        }
        List orderEntries = projectFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry orderEntry : orderEntries) {
            OrderEntry orderEntry2 = orderEntry;
            if (orderEntry2 instanceof LibraryOrderEntry) {
                Library library;
                if (((LibraryOrderEntry)orderEntry).getLibrary() == null) {
                    continue;
                }
                if (ProjectRootsUtil.isLibraryClassFile(project, virtualFile) && !isDecompiledFile) {
                    return new LibraryInfo(project, library);
                }
                if (!ProjectRootsUtil.isLibraryFile(project, virtualFile) && !isDecompiledFile) continue;
                return new LibrarySourceInfo(project, library);
            }
            if (!(orderEntry2 instanceof JdkOrderEntry)) continue;
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                continue;
            }
            Sdk sdk2 = sdk;
            return new SdkInfo(project, sdk2);
        }
        return NotUnderContentRootModuleInfo.INSTANCE$;
    }

    @NotNull
    public static final IdeaModuleInfo getModuleInfoForLightElement(@JetValueParameter(name="$receiver") KotlinLightElement<?, ?> $receiver) {
        NavigatablePsiElement navigatablePsiElement;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if ($receiver instanceof KotlinLightClassForDecompiledDeclaration) {
            Project project = ((KotlinLightClassForDecompiledDeclaration)$receiver).getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"getProject()");
            VirtualFile virtualFile = ((KotlinLightClassForDecompiledDeclaration)$receiver).getContainingFile().getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"getContainingFile().getVirtualFile()");
            return ResolvePackage$getModuleInfo$658f7d43.getModuleInfoByVirtualFile(project, virtualFile, false);
        }
        Object obj = $receiver.getOrigin();
        if (obj != null) {
            navigatablePsiElement = (NavigatablePsiElement)obj;
        } else {
            PsiFile psiFile;
            KotlinLightElement<?, ?> kotlinLightElement = $receiver;
            if (kotlinLightElement instanceof FakeLightClassForFileOfPackage) {
                psiFile = ((FakeLightClassForFileOfPackage)$receiver).getContainingFile();
                if (psiFile == null) {
                    Intrinsics.throwNpe();
                }
            } else if (kotlinLightElement instanceof KotlinLightClassForPackage) {
                psiFile = (PsiFile)KotlinPackage.first((Iterable)((KotlinLightClassForPackage)$receiver).getFiles());
            } else {
                throw (Throwable)new IllegalStateException("Unknown light class without origin is referenced by IDE lazy resolve: " + $receiver.getClass());
            }
            navigatablePsiElement = (NavigatablePsiElement)psiFile;
        }
        NavigatablePsiElement element = navigatablePsiElement;
        return ResolvePackage$getModuleInfo$658f7d43.getModuleInfo((PsiElement)element);
    }
}

