/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Queue;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleIndex;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage$IdeaModuleInfos$2a459351;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ResolvePackage$moduleDependents$0b0c2d5b {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ModuleSourceInfo> getDependentModules(@JetValueParameter(name="$receiver") ModuleSourceInfo $receiver) {
        void var3_5;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Set<Module> dependents = ResolvePackage$moduleDependents$0b0c2d5b.getDependents($receiver.getModule());
        if (ResolvePackage$IdeaModuleInfos$2a459351.isTests($receiver)) {
            void $receiver2;
            Iterable iterable = dependents;
            Collection destination = new HashSet();
            for (Object item : $receiver2) {
                void it;
                Module module = (Module)item;
                Collection collection = destination;
                ModuleTestSourceInfo moduleTestSourceInfo = ResolvePackage$IdeaModuleInfos$2a459351.testSourceInfo((Module)it);
                collection.add(moduleTestSourceInfo);
            }
            return (Set)destination;
        }
        Iterable $receiver2 = dependents;
        Collection destination = new HashSet();
        for (Object element : $receiver2) {
            Module it = (Module)element;
            Iterable list = KotlinPackage.listOf((Object[])new ModuleSourceInfo[]{ResolvePackage$IdeaModuleInfos$2a459351.productionSourceInfo(it), ResolvePackage$IdeaModuleInfos$2a459351.testSourceInfo(it)});
            KotlinPackage.addAll((Collection)destination, (Iterable)list);
        }
        return (Set)var3_5;
    }

    @NotNull
    public static final Set<Module> getDependents(@JetValueParameter(name="module") @NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        THashSet result2 = new THashSet();
        result2.add((Object)module);
        THashSet processedExporting = new THashSet();
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.getProject()");
        ModuleIndex index2 = ResolvePackage$moduleDependents$0b0c2d5b.getModuleIndex(project);
        Queue walkingQueue = new Queue(10);
        walkingQueue.addLast((Object)module);
        while (!walkingQueue.isEmpty()) {
            Module current;
            Module module2 = current = (Module)walkingQueue.pullFirst();
            if (module2 == null) {
                Intrinsics.throwNpe();
            }
            processedExporting.add((Object)module2);
            result2.addAll(index2.getPlainUsages().get((Object)current));
            for (Module dependent : index2.getExportingUsages().get((Object)current)) {
                result2.add((Object)dependent);
                if (!processedExporting.add((Object)dependent)) continue;
                walkingQueue.addLast((Object)dependent);
            }
        }
        return (Set)result2;
    }

    @NotNull
    public static final ModuleIndex getModuleIndex(@JetValueParameter(name="project") @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, new CachedValueProvider<T>(project){
            final /* synthetic */ Project $project;

            @NotNull
            public final CachedValueProvider.Result<ModuleIndex> compute() {
                ModuleIndex index2 = new ModuleIndex();
                Module[] moduleArray = ModuleManager.getInstance((Project)this.$project).getModules();
                for (int i = 0; i < moduleArray.length; ++i) {
                    Module module = moduleArray[i];
                    OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
                    for (int j = 0; j < orderEntryArray.length; ++j) {
                        Module referenced;
                        OrderEntry orderEntry = orderEntryArray[j];
                        if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                        MultiMap<Module, Module> map2 = ((ModuleOrderEntry)orderEntry).isExported() ? index2.getExportingUsages() : index2.getPlainUsages();
                        map2.putValue((Object)referenced, (Object)module);
                    }
                }
                return new CachedValueProvider.Result((Object)index2, new Object[]{ProjectRootModificationTracker.getInstance((Project)this.$project)});
            }
            {
                this.$project = project;
            }
        });
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (ModuleIndex)object;
    }
}

