/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.JetFunctionPsiElementCellRenderer;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.types.JetType;

public class GotoSuperActionHandler
implements CodeInsightActionHandler {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        void var7_11;
        String message;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler", "invoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.super");
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return;
        }
        JetDeclaration declaration = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JetNamedFunction.class, JetClass.class, JetProperty.class, JetObjectDeclaration.class});
        if (declaration == null) {
            return;
        }
        DeclarationDescriptor descriptor2 = ResolvePackage.resolveToDescriptor(declaration);
        if (descriptor2 instanceof ClassDescriptor) {
            Collection<JetType> supertypes2 = ((ClassDescriptor)descriptor2).getTypeConstructor().getSupertypes();
            List superclasses = ContainerUtil.mapNotNull(supertypes2, (Function)new Function<JetType, ClassDescriptor>(){

                public ClassDescriptor fun(JetType type2) {
                    ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
                    if (descriptor2 instanceof ClassDescriptor) {
                        return (ClassDescriptor)descriptor2;
                    }
                    return null;
                }
            });
            ContainerUtil.removeDuplicates((Collection)superclasses);
            List list = superclasses;
            message = JetBundle.message("goto.super.class.chooser.title", new Object[0]);
        } else {
            if (!(descriptor2 instanceof CallableMemberDescriptor)) return;
            Set<CallableMemberDescriptor> set = OverrideResolver.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)descriptor2);
            if (descriptor2 instanceof PropertyDescriptor) {
                message = JetBundle.message("goto.super.property.chooser.title", new Object[0]);
            } else {
                if (!(descriptor2 instanceof SimpleFunctionDescriptor)) throw new IllegalStateException("Unknown member type: " + descriptor2.getClass().getName());
                message = JetBundle.message("goto.super.function.chooser.title", new Object[0]);
            }
        }
        List superDeclarations = ContainerUtil.mapNotNull((Collection)var7_11, (Function)new Function<DeclarationDescriptor, PsiElement>(){

            public PsiElement fun(DeclarationDescriptor descriptor2) {
                if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)descriptor2)) {
                    return null;
                }
                return DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            }
        });
        if (superDeclarations.isEmpty()) {
            return;
        }
        if (superDeclarations.size() == 1) {
            Navigatable navigatable = EditSourceUtil.getDescriptor((PsiElement)((PsiElement)superDeclarations.get(0)));
            if (navigatable == null || !navigatable.canNavigate()) return;
            navigatable.navigate(true);
            return;
        } else {
            PsiElement[] superDeclarationsArray = PsiUtilCore.toPsiElementArray((Collection)superDeclarations);
            JBPopup popup = descriptor2 instanceof ClassDescriptor ? NavigationUtil.getPsiElementPopup((PsiElement[])superDeclarationsArray, (String)message) : NavigationUtil.getPsiElementPopup((PsiElement[])superDeclarationsArray, (PsiElementListCellRenderer)new JetFunctionPsiElementCellRenderer(), (String)message);
            popup.showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

