/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.google.common.collect.LinkedHashMultimap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.core.codeInsight.OverrideImplementMethodsHandler;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.types.JetType;

public class OverrideMethodsHandler
extends OverrideImplementMethodsHandler {
    @Override
    protected Set<CallableMemberDescriptor> collectMethodsToGenerate(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/codeInsight/OverrideMethodsHandler", "collectMethodsToGenerate"));
        }
        Set<CallableMemberDescriptor> superMethods = OverrideMethodsHandler.collectSuperMethods(descriptor2);
        for (DeclarationDescriptor member : descriptor2.getDefaultType().getMemberScope().getAllDescriptors()) {
            CallableMemberDescriptor callable;
            if (!(member instanceof CallableMemberDescriptor) || (callable = (CallableMemberDescriptor)member).getKind() != CallableMemberDescriptor.Kind.DECLARATION) continue;
            superMethods.removeAll(callable.getOverriddenDescriptors());
        }
        HashSet<CallableMemberDescriptor> result2 = new HashSet<CallableMemberDescriptor>();
        for (CallableMemberDescriptor superMethod : superMethods) {
            if (!superMethod.getModality().isOverridable() || CallResolverUtil.isOrOverridesSynthesized(superMethod)) continue;
            result2.add(superMethod);
        }
        return result2;
    }

    @NotNull
    private static Set<CallableMemberDescriptor> collectSuperMethods(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/idea/codeInsight/OverrideMethodsHandler", "collectSuperMethods"));
        }
        LinkedHashSet<CallableMemberDescriptor> inheritedFunctions = new LinkedHashSet<CallableMemberDescriptor>();
        for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
            for (DeclarationDescriptor descriptor2 : supertype.getMemberScope().getAllDescriptors()) {
                if (!(descriptor2 instanceof CallableMemberDescriptor)) continue;
                inheritedFunctions.add((CallableMemberDescriptor)descriptor2);
            }
        }
        Set<CallableMemberDescriptor> filteredMembers = OverrideResolver.filterOutOverridden(inheritedFunctions);
        LinkedHashMultimap factoredMembers = LinkedHashMultimap.create();
        for (CallableMemberDescriptor one : filteredMembers) {
            if (factoredMembers.values().contains(one)) continue;
            for (CallableMemberDescriptor another : filteredMembers) {
                factoredMembers.put((Object)one, (Object)one);
                if (OverridingUtil.DEFAULT.isOverridableBy(one, another).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE && OverridingUtil.DEFAULT.isOverridableBy(another, one).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                factoredMembers.put((Object)one, (Object)another);
            }
        }
        Set set = factoredMembers.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/OverrideMethodsHandler", "collectSuperMethods"));
        }
        return set;
    }

    @Override
    protected String getChooserTitle() {
        return "Override Members";
    }

    @Override
    protected String getNoMethodsFoundHint() {
        return "No methods to override have been found";
    }
}

