/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.completion.CompletionPackage$CompletionUtils$b257cb03;
import org.jetbrains.kotlin.idea.completion.handlers.BaseDeclarationInsertHandler;
import org.jetbrains.kotlin.idea.core.completion.DeclarationDescriptorLookupObject;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNameReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0000\u0004)A2j\u001c;mS:\u001cE.Y:t\u0013:\u001cXM\u001d;IC:$G.\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*Q1m\\7qY\u0016$\u0018n\u001c8\u000b\u0011!\fg\u000e\u001a7feNTADQ1tK\u0012+7\r\\1sCRLwN\\%og\u0016\u0014H\u000fS1oI2,'O\u0003\u0007iC:$G.Z%og\u0016\u0014HOC\u0004d_:$X\r\u001f;\u000b!%s7/\u001a:uS>t7i\u001c8uKb$(bA2p[*A\u0011N\u001c;fY2L'NC\u0006d_\u0012,\u0017J\\:jO\"$(\u0002B5uK6TQ\u0002T8pWV\u0004X\t\\3nK:$(B\u00027p_.,\bO\u0003\u0003V]&$(\"F9vC2Lg-[3e\u001d\u0006lW\rV8J]N,'\u000f\u001e\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMd\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\r!)\u0001c\u0002\r\u0001\u0015\t\u00012B\u0003\u0003\t\u0011Aa!\u0002\u0002\u0005\n!5QA\u0001\u0003\u0006\u0011\u000b)1\u0001b\u0003\t\u000b1\u0001QA\u0001\u0003\u0006\u0011!)1\u0001\"\u0004\t\u00101\u0001Q!\u0001E\u0002\u000b\r!y\u0001#\u0005\r\u0001\u0015\u0011A1\u0002\u0005\u0006\u000b\t!i\u0001c\u0004\u0006\u0007\u0011=\u00012\u0003\u0007\u0001\u000b\u0005A!\"\u0002\u0002\u0005\u0015!UQA\u0001C\u000b\u0011'!\u0001-\u0001\u0007\u00043\t)\u0011\u0001c\u0002.:\u0011Y\u0001\u0004BO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!1\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001bB\u0007\u0003\u000b\u0005Aq\u0001UB\u0001C\t)\u0011\u0001\u0003\u0005R\u0007\u001d!A!C\u0001\u0005\u00015\t\u0001\u0012C\u0007\u0002\u0011%i3\u0003B\u0001\u0019\u0013u5A\u0001\u0001\u0005\b\u001b\t)\u0011\u0001C\u0004Q\u0007\u0001\t#!B\u0001\t\u0014E\u001bQ\u0001B\u0005\n\u0003!YQ\"\u0001\u0005\nk\u0001\u0001"})
public final class KotlinClassInsertHandler
extends BaseDeclarationInsertHandler {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final KotlinClassInsertHandler INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinClassInsertHandler.class);
        new KotlinClassInsertHandler();
    }

    @Override
    public void handleInsert(@JetValueParameter(name="context") @NotNull InsertionContext context2, @JetValueParameter(name="item") @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        super.handleInsert(context2, item);
        PsiFile file = context2.getFile();
        if (file instanceof JetFile && !CompletionPackage$CompletionUtils$b257cb03.isAfterDot(context2)) {
            JetNameReferenceExpression nameRef;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
            psiDocumentManager.commitAllDocuments();
            int startOffset = context2.getStartOffset();
            Document document = context2.getDocument();
            String qualifiedName = this.qualifiedNameToInsert(item);
            PsiElement token = ((JetFile)file).findElementAt(startOffset);
            PsiElement psiElement = token.getParent();
            if (!(psiElement instanceof JetNameReferenceExpression)) {
                psiElement = null;
            }
            if ((nameRef = (JetNameReferenceExpression)psiElement) != null) {
                ClassDescriptor target;
                BindingContext bindingContext2 = ResolvePackage.getResolutionFacade(nameRef).analyze(nameRef, BodyResolveMode.PARTIAL);
                ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, nameRef);
                if (classDescriptor == null) {
                    Object v = bindingContext2.get(BindingContext.REFERENCE_TARGET, nameRef);
                    if (!(v instanceof ClassDescriptor)) {
                        v = null;
                    }
                    classDescriptor = target = (ClassDescriptor)v;
                }
                if (target != null && Intrinsics.areEqual((Object)IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName(target), (Object)qualifiedName)) {
                    return;
                }
            }
            String tempPrefix = nameRef != null ? " " : "$;val v:";
            String tempSuffix = ".xxx";
            document.replaceString(startOffset, context2.getTailOffset(), (CharSequence)(tempPrefix + qualifiedName + tempSuffix));
            psiDocumentManager.commitAllDocuments();
            int classNameStart = startOffset + tempPrefix.length();
            int classNameEnd = classNameStart + qualifiedName.length();
            RangeMarker rangeMarker = document.createRangeMarker(classNameStart, classNameEnd);
            RangeMarker wholeRangeMarker = document.createRangeMarker(startOffset, classNameEnd + tempSuffix.length());
            ShortenReferences shortenReferences = ShortenReferences.Companion.getDEFAULT();
            JetFile jetFile = (JetFile)file;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetFile, (String)"file");
            shortenReferences.process(jetFile, classNameStart, classNameEnd);
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            if (rangeMarker.isValid() && wholeRangeMarker.isValid()) {
                document.deleteString(wholeRangeMarker.getStartOffset(), rangeMarker.getStartOffset());
                document.deleteString(rangeMarker.getEndOffset(), wholeRangeMarker.getEndOffset());
            }
        }
    }

    private final String qualifiedNameToInsert(@JetValueParameter(name="item") LookupElement item) {
        String string;
        Object lookupObject = item.getObject();
        Object object = lookupObject;
        if (object instanceof DeclarationDescriptorLookupObject) {
            DeclarationDescriptor declarationDescriptor = ((DeclarationDescriptorLookupObject)lookupObject).getDescriptor();
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            String string2 = IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName((ClassDescriptor)declarationDescriptor);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeDescriptorRenderers.S\u2026iptor as ClassDescriptor)");
        } else if (object instanceof PsiClass) {
            string = ((PsiClass)lookupObject).getQualifiedName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            string = (String)((Object)KotlinPackage.error((Object)("Unknown object in LookupElement with KotlinClassInsertHandler: " + lookupObject)));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when (lookupObject) {\n  \u2026$lookupObject\")\n        }");
        return string;
    }

    KotlinClassInsertHandler() {
        INSTANCE$ = this;
    }
}

