/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.module.impl.scopes.LibraryScopeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class DebuggerPackage$PositionManagerLibraryClassFileSearcher$be40b06b {
    static final Logger LOG = Logger.getInstance((String)"org.jetbrains.kotlin.idea.debugger");

    public static final Logger getLOG() {
        return LOG;
    }

    @Nullable
    public static final String findPackagePartInternalNameForLibraryFile(@JetValueParameter(name="topLevelDeclaration") @NotNull JetDeclaration topLevelDeclaration) {
        Collection destination;
        Iterable $receiver;
        Iterable $receiver2;
        Collection<VariableDescriptor> collection;
        Intrinsics.checkParameterIsNotNull((Object)topLevelDeclaration, (String)"topLevelDeclaration");
        String packagePartFile = (String)KotlinPackage.singleOrNull(DebuggerPackage$PositionManagerLibraryClassFileSearcher$be40b06b.findPackagePartFileNamesForElement(topLevelDeclaration));
        if (packagePartFile != null) {
            return packagePartFile;
        }
        DeclarationDescriptor descriptor2 = ResolvePackage.resolveToDescriptor(topLevelDeclaration);
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return null;
        }
        FqName packageFqName = topLevelDeclaration.getContainingJetFile().getPackageFqName();
        ModuleDescriptor moduleDescriptor = DescriptorUtilPackage.getModule(descriptor2);
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        PackageViewDescriptor packageDescriptor = moduleDescriptor.getPackage(fqName2);
        if (packageDescriptor == null) {
            DebuggerPackage$PositionManagerLibraryClassFileSearcher$be40b06b.reportError(topLevelDeclaration, (CallableDescriptor)descriptor2);
            return null;
        }
        String descFromSourceText = DebuggerPackage$PositionManagerLibraryClassFileSearcher$be40b06b.render(descriptor2);
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof FunctionDescriptor) {
            JetScope jetScope = packageDescriptor.getMemberScope();
            Name name2 = ((FunctionDescriptor)descriptor2).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"descriptor.getName()");
            collection = jetScope.getFunctions(name2);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            JetScope jetScope = packageDescriptor.getMemberScope();
            Name name3 = ((PropertyDescriptor)descriptor2).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"descriptor.getName()");
            collection = jetScope.getProperties(name3);
        } else {
            DebuggerPackage$PositionManagerLibraryClassFileSearcher$be40b06b.reportError(topLevelDeclaration, (CallableDescriptor)descriptor2);
            collection = KotlinPackage.listOf();
        }
        Collection<VariableDescriptor> descriptors = collection;
        Iterable iterable = descriptors;
        void var9_9 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element : $receiver) {
            if (!(element instanceof DeserializedCallableMemberDescriptor)) continue;
            destination.add(element);
        }
        $receiver2 = (List)destination;
        $receiver = $receiver2;
        destination = new ArrayList();
        for (Object element : $receiver) {
            DeserializedCallableMemberDescriptor it = (DeserializedCallableMemberDescriptor)element;
            if (!Intrinsics.areEqual((Object)DebuggerPackage$PositionManagerLibraryClassFileSearcher$be40b06b.render(it), (Object)descFromSourceText)) continue;
            destination.add(element);
        }
        DeserializedCallableMemberDescriptor deserializedDescriptor = (DeserializedCallableMemberDescriptor)KotlinPackage.singleOrNull((List)((List)destination));
        if (deserializedDescriptor == null) {
            DebuggerPackage$PositionManagerLibraryClassFileSearcher$be40b06b.reportError(topLevelDeclaration, (CallableDescriptor)descriptor2);
            return null;
        }
        ProtoBuf.Callable proto = deserializedDescriptor.getProto();
        if (proto.hasExtension(JvmProtoBuf.implClassName)) {
            NameResolver nameResolver = deserializedDescriptor.getNameResolver();
            Object object = proto.getExtension(JvmProtoBuf.implClassName);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Name name4 = nameResolver.getName(((Number)object).intValue());
            return JvmClassName.byFqNameWithoutInnerClasses(packageFqName.child(name4)).getInternalName();
        }
        return null;
    }

    @NotNull
    public static final List<String> findPackagePartFileNamesForElement(@JetValueParameter(name="elementAt") @NotNull JetElement elementAt) {
        LibraryScopeBase libraryScopeBase;
        Intrinsics.checkParameterIsNotNull((Object)elementAt, (String)"elementAt");
        Project project = elementAt.getProject();
        JetFile file = elementAt.getContainingJetFile();
        String packagePartName = PackagePartClassUtils.getPackagePartFqName(file).shortName().asString();
        String packagePartNameWoHash = KotlinPackage.substring((String)packagePartName, (int)0, (int)(KotlinPackage.lastIndexOf$default((String)packagePartName, (String)"$", (int)0, (boolean)false, (int)6) + 1));
        OrderEntry libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)file.getVirtualFile(), (Project)project);
        if (libraryEntry instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)libraryEntry).getLibrary();
            if (library == null) {
                VirtualFile virtualFile = file.getVirtualFile();
                throw (Throwable)((Object)new AssertionError((Object)("Cannot find library for file " + (virtualFile != null ? virtualFile.getPath() : null))));
            }
            libraryScopeBase = (LibraryScopeBase)new LibraryScope(project, library);
        } else {
            OrderEntry orderEntry = libraryEntry;
            if (orderEntry == null) {
                throw new TypeCastException("com.intellij.openapi.roots.OrderEntry! cannot be cast to com.intellij.openapi.roots.JdkOrderEntry");
            }
            libraryScopeBase = (LibraryScopeBase)new JdkScope(project, (JdkOrderEntry)orderEntry);
        }
        LibraryScopeBase scope2 = libraryScopeBase;
        Sequence packagePartFiles2 = KotlinPackage.map((Sequence)KotlinPackage.flatMap((Sequence)KotlinPackage.filter((Sequence)KotlinPackage.sequence((Object[])FilenameIndex.getAllFilenames((Project)project)), (Function1)((Function1)new Function1<String, Boolean>(packagePartNameWoHash){
            final /* synthetic */ String $packagePartNameWoHash;

            public final boolean invoke(@JetValueParameter(name="it") String it) {
                return KotlinPackage.startsWith$default((String)it, (String)this.$packagePartNameWoHash, (boolean)false, (int)2) && KotlinPackage.endsWith$default((String)it, (String)".class", (boolean)false, (int)2) && !KotlinPackage.contains$default((String)KotlinPackage.substringAfter$default((String)it, (String)this.$packagePartNameWoHash, null, (int)2), (CharSequence)"$", (boolean)false, (int)2);
            }
            {
                this.$packagePartNameWoHash = string;
                super(1);
            }
        })), (Function1)((Function1)new Function1<String, Sequence<? extends VirtualFile>>(project, scope2){
            final /* synthetic */ Project $project;
            final /* synthetic */ LibraryScopeBase $scope;

            @NotNull
            public final Sequence<VirtualFile> invoke(@JetValueParameter(name="it") String it) {
                return KotlinPackage.sequence((Iterable)FilenameIndex.getVirtualFilesByName((Project)this.$project, (String)it, (GlobalSearchScope)((GlobalSearchScope)this.$scope)));
            }
            {
                this.$project = project;
                this.$scope = libraryScopeBase;
                super(1);
            }
        })), (Function1)((Function1)new Function1<VirtualFile, String>(file){
            final /* synthetic */ JetFile $file;

            @NotNull
            public final String invoke(@JetValueParameter(name="it") VirtualFile it) {
                FqName packageFqName = this.$file.getPackageFqName();
                return packageFqName.isRoot() ? it.getNameWithoutExtension() : packageFqName.asString() + "." + it.getNameWithoutExtension();
            }
            {
                this.$file = jetFile;
                super(1);
            }
        }));
        return KotlinPackage.toList((Sequence)packagePartFiles2);
    }

    @NotNull
    public static final String render(@JetValueParameter(name="desc") @NotNull DeclarationDescriptor desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.render(desc);
    }

    public static final void reportError(@JetValueParameter(name="element") @NotNull JetElement element, @JetValueParameter(name="descriptor", type="?") @Nullable CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        LOG.error("Couldn't calculate class name for element in library scope:\n" + PsiUtilPackage.getElementTextWithContext((PsiElement)element) + (descriptor2 != null ? "\n" + "descriptor = " + DebuggerPackage$PositionManagerLibraryClassFileSearcher$be40b06b.render(descriptor2) : ""));
    }
}

