/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.SuspendContext;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.request.EventRequest;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.JavaResolveExtension;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilPackage;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.org.objectweb.asm.Type;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class EvaluatePackage$KotlinEvaluationBuilder$b91469b6 {
    @NotNull
    static final String RECEIVER_NAME = "$receiver";
    @NotNull
    static final String THIS_NAME = "this";
    @NotNull
    static final Logger logger;
    @NotNull
    static final String template = "\npackage packageForDebugger\n\n!IMPORT_LIST!\n\n!FUNCTION!\n";
    @NotNull
    static final String packageInternalName;

    @NotNull
    public static final String getRECEIVER_NAME() {
        return RECEIVER_NAME;
    }

    @NotNull
    public static final String getTHIS_NAME() {
        return THIS_NAME;
    }

    @NotNull
    public static final Logger getLogger() {
        return logger;
    }

    @NotNull
    public static final String getTemplate() {
        return template;
    }

    @NotNull
    public static final String getPackageInternalName() {
        return packageInternalName;
    }

    @NotNull
    public static final JetFile createFileForDebugger(@JetValueParameter(name="codeFragment") @NotNull JetCodeFragment codeFragment, @JetValueParameter(name="extractedFunction") @NotNull JetNamedFunction extractedFunction) {
        JetFile jetFile;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
            Intrinsics.checkParameterIsNotNull((Object)extractedFunction, (String)"extractedFunction");
            String fileText = KotlinPackage.replace$default((String)template, (String)"!IMPORT_LIST!", (String)KotlinPackage.joinToString$default((Object[])KotlinPackage.split((String)codeFragment.importsToString(), (String)JetCodeFragment.Companion.getIMPORT_SEPARATOR()), (String)"\n", null, null, (int)0, null, null, (int)62), (boolean)false, (int)4);
            String extractedFunctionText = extractedFunction.getText();
            KotlinPackage.assert((extractedFunctionText != null ? 1 : 0) != 0, (Object)"Text of extracted function shouldn't be null");
            String string = extractedFunction.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            fileText = KotlinPackage.replace$default((String)fileText, (String)"!FUNCTION!", (String)string, (boolean)false, (int)4);
            jetFile = EvaluatePackage$KotlinEvaluationBuilder$b91469b6.createJetFile((PsiElement)codeFragment, "debugFile.kt", fileText);
            CodeFragmentUtilPackage.setSuppressDiagnosticsInDebugMode(jetFile, true);
            List<JetDeclaration> list = jetFile.getDeclarations();
            JetDeclaration jetDeclaration = list.get(0);
            if (jetDeclaration == null) {
                throw new TypeCastException("org.jetbrains.kotlin.psi.JetDeclaration! cannot be cast to org.jetbrains.kotlin.psi.JetNamedFunction");
            }
            JetNamedFunction function2 = (JetNamedFunction)jetDeclaration;
            JetTypeReference jetTypeReference = function2.getReceiverTypeReference();
            if (jetTypeReference != null) {
                JetTypeReference jetTypeReference2 = extractedFunction.getReceiverTypeReference();
                CodeFragmentUtilPackage.setDebugTypeInfo(jetTypeReference, jetTypeReference2 != null ? CodeFragmentUtilPackage.getDebugTypeInfo(jetTypeReference2) : null);
            }
            Iterable iterable = function2.getValueParameters();
            Iterable iterable2 = extractedFunction.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"extractedFunction.getValueParameters()");
            for (Pair pair2 : KotlinPackage.zip((Iterable)iterable, (Iterable)iterable2)) {
                JetParameter newParam = (JetParameter)pair2.component1();
                JetParameter oldParam = (JetParameter)pair2.component2();
                JetTypeReference jetTypeReference3 = newParam.getTypeReference();
                if (jetTypeReference3 == null) continue;
                JetTypeReference jetTypeReference4 = oldParam.getTypeReference();
                CodeFragmentUtilPackage.setDebugTypeInfo(jetTypeReference3, jetTypeReference4 != null ? CodeFragmentUtilPackage.getDebugTypeInfo(jetTypeReference4) : null);
            }
            JetTypeReference jetTypeReference5 = function2.getTypeReference();
            if (jetTypeReference5 == null) break block4;
            JetTypeReference jetTypeReference6 = extractedFunction.getTypeReference();
            CodeFragmentUtilPackage.setDebugTypeInfo(jetTypeReference5, jetTypeReference6 != null ? CodeFragmentUtilPackage.getDebugTypeInfo(jetTypeReference6) : null);
        }
        return jetFile;
    }

    @NotNull
    public static final JetFile createFlexibleTypesFile(@JetValueParameter(name="$receiver") PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)RECEIVER_NAME);
        return EvaluatePackage$KotlinEvaluationBuilder$b91469b6.createJetFile($receiver, "FLEXIBLE_TYPES.kt", "\n" + "                package " + Flexibility.Companion.getFLEXIBLE_TYPE_CLASSIFIER().getPackageFqName() + "\n" + "                public class " + Flexibility.Companion.getFLEXIBLE_TYPE_CLASSIFIER().getRelativeClassName() + "<L, U>" + "\n" + "            ");
    }

    @NotNull
    public static final JetFile createJetFile(@JetValueParameter(name="$receiver") PsiElement $receiver, @JetValueParameter(name="fileName") @NotNull String fileName, @JetValueParameter(name="fileText") @NotNull String fileText) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)RECEIVER_NAME);
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)fileText, (String)"fileText");
        LightVirtualFile virtualFile = new LightVirtualFile(fileName, (Language)JetLanguage.INSTANCE, (CharSequence)fileText);
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)$receiver.getProject());
        if (psiFileFactory == null) {
            throw new TypeCastException("com.intellij.psi.PsiFileFactory! cannot be cast to com.intellij.psi.impl.PsiFileFactoryImpl");
        }
        PsiFile psiFile = ((PsiFileFactoryImpl)psiFileFactory).trySetupPsiForFile(virtualFile, (Language)JetLanguage.INSTANCE, true, false);
        if (psiFile == null) {
            throw new TypeCastException("com.intellij.psi.PsiFile! cannot be cast to org.jetbrains.kotlin.psi.JetFile");
        }
        JetFile jetFile = (JetFile)psiFile;
        PsiPackage.setAnalysisContext(jetFile, $receiver);
        return jetFile;
    }

    public static final int getInvokePolicy(@JetValueParameter(name="$receiver") SuspendContext $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)RECEIVER_NAME);
        return $receiver.getSuspendPolicy() == EventRequest.SUSPEND_EVENT_THREAD ? ObjectReference.INVOKE_SINGLE_THREADED : 0;
    }

    @Nullable
    public static final ClassDescriptor getClassDescriptor(@JetValueParameter(name="$receiver") Type $receiver, @JetValueParameter(name="project") @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)RECEIVER_NAME);
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (AsmUtil.isPrimitive($receiver)) {
            return null;
        }
        FqName jvmName = JvmClassName.byInternalName($receiver.getInternalName()).getFqNameForClassNameWithoutDollars();
        Collection<ClassDescriptor> platformClasses = JavaToKotlinClassMap.INSTANCE.mapPlatformClass(jvmName);
        if (KotlinPackage.isNotEmpty(platformClasses)) {
            return (ClassDescriptor)KotlinPackage.first((Iterable)platformClasses);
        }
        return (ClassDescriptor)ApplicationPackage.runReadAction((Function0)new Function0<ClassDescriptor>(project, jvmName){
            final /* synthetic */ Project $project;
            final /* synthetic */ FqName $jvmName;

            @Nullable
            public final ClassDescriptor invoke() {
                ClassDescriptor classDescriptor;
                PsiClass[] classes2 = JavaPsiFacade.getInstance((Project)this.$project).findClasses(this.$jvmName.asString(), GlobalSearchScope.allScope((Project)this.$project));
                if (KotlinPackage.isEmpty((Object[])classes2)) {
                    classDescriptor = null;
                } else {
                    PsiClass clazz = (PsiClass)KotlinPackage.first((Object[])classes2);
                    PsiElement psiElement = (PsiElement)clazz;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"clazz");
                    classDescriptor = JavaResolveExtension.INSTANCE$.getResolver(this.$project, psiElement).resolveClass(new JavaClassImpl(clazz));
                }
                return classDescriptor;
            }
            {
                this.$project = project;
                this.$jvmName = fqName2;
                super(0);
            }
        });
    }

    static {
        RECEIVER_NAME = RECEIVER_NAME;
        THIS_NAME = THIS_NAME;
        logger = Logger.getInstance(KotlinEvaluator.class);
        template = template;
        packageInternalName = PackageClassUtils.getPackageClassInternalName(new FqName("packageForDebugger"));
    }
}

