/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VirtualMachine;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.Eval4jPackage;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.jdi.JdiPackage;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatePackage$KotlinEvaluationBuilder$b91469b6;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0001\f)aaI]1nKZK7/\u001b;pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002\u00033fEV<w-\u001a:\u000b\u0011\u00154\u0018\r\\;bi\u0016T1!\u00118z\u0015\u0019a\u0014N\\5u})91m\u001c8uKb$(\"F#wC2,\u0018\r^5p]\u000e{g\u000e^3yi&k\u0007\u000f\u001c\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\r\u0015tw-\u001b8f\u0015))g/\u00197vCRLwN\u001c\u0006\u0006MJ\fW.\u001a\u0006\u000b'R\f7m\u001b$sC6,'bA:v]*\u0019!\u000eZ5\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bB8qK:\f\u0007/\u001b\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016TAAZ1jY*9Q.Z:tC\u001e,'BB*ue&twM\u0003\u0006tQ>,H\u000e\u001a$bS2TqAQ8pY\u0016\fgNC\u0003WC2,XM\u0003\u0004fm\u0006dGG\u001b\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\"\u00074j]\u0012\u001c\u0015\r\u001d;ve\u0016$Gj\\2bYZ\u000b'/[1cY\u0016TAA\\1nK*9\u0011m]7UsB,'\u0002\u0002+za\u0016T\u0011b\u001c2kK\u000e$x/\u001a2\u000b\u0007\u0005\u001cXNC\u0005dQ\u0016\u001c7\u000eV=qK*\tb-\u001b8e\u0019>\u001c\u0017\r\u001c,be&\f'\r\\3\u000b9\u0019Lg\u000e\u001a'pG\u0006dg+\u0019:jC\ndWMR8s\u0019>\u001c\u0017\r\u001c$v]*Aa-\u001b8e)\"L7OC\u0005gS:$g+\u00197vK*qa-Y5m\u0013\u001atu\u000e\u001e$pk:$'\u0002F4fi\u000e\u000b\u0007\u000f^;sK\u00124\u0015.\u001a7e\u001d\u0006lWM\u0003\u0005hKR4\u0015.\u001a7e\u0015\u0015ywO\\3s\u0015M9W\r\u001e,bYV,\u0017JZ*iCJ,GMV1s\u0015\u00151\u0018\r\\;f\u00151)\u0007\u0010]3di\u0016$G+\u001f9f\u00159I7OR;oGRLwN\u001c+za\u0016TA\u0001^=qK*!\u0012n\u001d,bYV,wJZ\"peJ,7\r\u001e+za\u0016Tqb\u001d5pk2$7\t[3dWRK\b/\u001a\u0006\fSN\u001c\u0006.\u0019:fIZ\u000b'O\u0003\u0006jgN+(m\u00197bgNTab];qKJ\u001cE.Y:t\u001d\u0006lWM~\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0002\u0011\u0017)!\u0001\"\u0003\t\r\u0015\u0011A!\u0002E\u0003\u000b\t!Y\u0001#\u0004\u0006\u0005\u00111\u0001bB\u0003\u0004\t\u001bAQ\u0001\u0004\u0001\u0006\u0005\u00115\u0001\"B\u0003\u0003\t\u0013A\t\"\u0002\u0002\u0005\u0011!IQa\u0001C\t\u0011!a\u0001!\u0002\u0002\u0005\u0012!AQA\u0001\u0003\u0006\u0011+)!\u0001\u0002\u0006\t\u0014\u0015\u0019AQ\u0003\u0005\u000b\u0019\u0001)!\u0001\"\u0006\t\u0015\u0015\u0019Aq\u0001E\r\u0019\u0001)1\u0001b\u0002\t\u001c1\u0001QA\u0001C\u0001\u0011;)1\u0001B\u0007\t\u001d1\u0001QA\u0001\u0003\u000e\u00119)\u0011\u0001C\b\u0006\u0005\u0011u\u0001rD\u0003\u0003\t=AI\"\u0002\u0002\u0005\u0002!\u0005QA\u0001\u0003\u0011\u0011I)!\u0001\"\t\t&\u0015\u0019A!\u0005E\u0012\u0019\u0001)!\u0001B\t\t$\u0015\u0019A\u0011\u0003E\u0012\u0019\u0001)!\u0001\"\u0005\t$\u0011\u0001AbA\r\u0003\u000b\u0005AA!\f\u0007\u0005C\u0012Az!I\u0002\u0006\u0003!IA\u0012A+\u0004\t\u0015\u0019AqB\u0005\u0002\u0011'i\u0003\u0003B1\u00051'\ts!B\u0001\t\u0017AYQcA\u0003\u0002\u0011-a\t!V\u0002\u0005\u000b\r!\u0019\"C\u0001\t\u00185nB!\u0001M\f;\u001b!\u0001\u0001\u0003\u0007\u000e\u0005\u0015\t\u0001\u0002\u0004)\u0004\u0001u5A\u0001\u0001\u0005\u000e\u001b\t)\u0011\u0001#\u0007Q\u0007\u0003\t3!B\u0001\t\u001c1\u0005\u0011kA\u0004\u0005\u0018%\t\u0001BD\u0007\u0002\u0011?i\u0011\u0001\"\u0001.Q\u0011\t\u0001\u0004EO\u0007\t\u0001A\t#\u0004\u0002\u0006\u0003!a\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"E\u0007\u0004\u000b\u0005A\u0019\u0003$\u0001Q\u0007\u0003ij\u0001\u0002\u0001\t'5\u0011Q!\u0001E\r!\u000e\t\u0011eA\u0003\u0002\u00117a\t!U\u0002\n\tAI\u0011\u0001\u0003\b\u000e\u0003!}Q\"\u0001\u0005\u0013\u001b\u0005!\t!\f\u0015\u0005\u0003a\u001dRT\u0002\u0003\u0001\u0011Ci!!B\u0001\t\u0019A\u001b\u0001!h\u0004\u0005\u0001!\tRbA\u0003\u0002\u0011Ga\t\u0001UB\u0001;\u001b!\u0001\u0001C\n\u000e\u0005\u0015\t\u0001\u0012\u0004)\u0004\u0003\u0005\u001aQ!\u0001E\u000e\u0019\u0003\t6!\u0003C\u0014\u0013\u0005Aa\"D\u0001\t 5\t\u0001BE\u0007\u0002\t\u0003i\u0003\u0006B\u0001\u0019)u5A\u0001\u0001E\u0011\u001b\t)\u0011\u0001\u0003\u0007Q\u0007\u0001iz\u0001\u0002\u0001\t#5\u0019Q!\u0001E\u0012\u0019\u0003\u00016\u0011AO\u0007\t\u0001A1#\u0004\u0002\u0006\u0003!e\u0001kA\u0001\"\u0007\u0015\t\u00012\u0004G\u0001#\u000eIA\u0001F\u0005\u0002\u00119i\u0011\u0001c\b\u000e\u0003!\u0011R\"\u0001C\u0001[U!\u0011\u0001'\u000b\u001e\u0010\u0011\u0001\u0001\"E\u0007\u0004\u000b\u0005A\u0019\u0003$\u0001Q\u0007\u0001\t3!B\u0001\t\u001c1\u0005\u0011kA\u0003\u0005*%\t\u0001BD\u0007\u0002\u0011Ii\u001b\u0007B\u0002\u0019+u5A\u0001\u0001E\u0011\u001b\t)\u0011\u0001\u0003\u0007Q\u0007\u0001iz\u0001\u0002\u0001\t#5\u0019Q!\u0001E\u0012\u0019\u0003\u00016\u0011AO\u0007\t\u0001A1#\u0004\u0002\u0006\u0003!e\u0001kA\u0001\u001e\u000e\u0011\u0001\u00012F\u0007\u0003\u000b\u0005AI\u0002UB\u0002C\r)\u0011\u0001c\u0007\r\u0002E\u001b1\u0002B\u000b\n\u0003!qQ\"\u0001E\u0010\u001b\u0005A!#D\u0001\u0005\u00025\tA\u0011A\u0017\u0014\t\u0005Ab#(\u0004\u0005\u0001!\u0005RBA\u0003\u0002\u00111\u00016\u0001A\u0011\u0003\u000b\u0005AA\"U\u0002\u0006\tYI\u0011\u0001c\b\u000e\u0003!}Q6\r\u0003\u00021[ij\u0001\u0002\u0001\t/5\u0011Q!\u0001E\u000e!\u000e\u0001QT\u0002\u0003\u0001\u0011Ci!!B\u0001\t\u0019A\u001b\t!h\u0004\u0005\u0001!\tRbA\u0003\u0002\u0011Ga\t\u0001U\u0002\u0002;\u001b!\u0001\u0001C\n\u000e\u0005\u0015\t\u0001\u0012\u0004)\u0004\u0004\u0005\u001aQ!\u0001E\u000e\u0019\u0003\t6a\u0003C\u0017\u0013\u0005Aa\"D\u0001\t\u001d5\t\u0001rD\u0007\u0002\u0011Ii\u0011\u0001\"\u0001.Q\u0011\t\u0001tFO\u0007\t\u0001A\u0001$\u0004\u0002\u0006\u0003!m\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012G\u0007\u0004\u000b\u0005A\u0019\u0003$\u0001Q\u0007\u0003ij\u0001\u0002\u0001\t'5\u0011Q!\u0001E\r!\u000e\t\u0011eA\u0003\u0002\u00117a\t!U\u0002\n\t_I\u0011\u0001\u0003\b\u000e\u0003!qQ\"\u0001\u0005\u0013\u001b\u0005!\t!\f\u000b\u0005\u0003aIRt\u0002\u0003\u0001\u0011gi1!B\u0001\t$1\u0005\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\u0012D)\u0004\u000b\u0011I\u0012\"\u0001C\u0001\u001b\u0005A!#L\u0014\u0005\u0003aQRT\u0002\u0003\u0001\u0011ai!!B\u0001\t\u001cA\u001b\u0001!h\u0004\u0005\u0001!\tRbA\u0003\u0002\u0011Ga\t\u0001UB\u0001;\u001b!\u0001\u0001#\u000e\u000e\u0005\u0015\t\u0001\u0012\u0004)\u0004\u0003\u0005\u0012Q!\u0001E\r#\u000eIAAG\u0005\u0002\t\u0003i\u0011\u0001\u0003\b\u000e\u0003!\u0011R\"\u0001C\u0001[;!\u0011!\u0006\u0002\u0006\u0003!m\u0001dG\u0011\u0003\u000b\u0005AI\"U\u0002\u0006\tmI\u0011\u0001\"\u0001\u000e\u0003!qQ&\u0007\u0003\u0002+\r)\u0011\u0001#\n\r\u0002a]RT\u0002\u0003\u0001\u0011qi!!B\u0001\t\u0019A\u001b\t!\t\u0002\u0006\u0003!e\u0011kA\u0004\u00058%\tA\u0011A\u0007\u0002\u0011Mi\u0011\u0001c\b6*\u0015\u001dBa9\u0001\u0019\tu5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001C\u0004Q\u0007\u0001\t#!B\u0001\t\u0007E\u001bQ\u0001\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001E\b"})
public final class FrameVisitor {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Project project;
    private final StackFrame frame;

    static {
        $kotlinClass = Reflection.createKotlinClass(FrameVisitor.class);
    }

    @Nullable
    public final Value findValue(@JetValueParameter(name="name") @NotNull String name2, @JetValueParameter(name="asmType", type="?") @Nullable Type asmType, @JetValueParameter(name="checkType") boolean checkType2, @JetValueParameter(name="failIfNotFound") boolean failIfNotFound) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (this.frame == null) {
            return null;
        }
        try {
            String string = name2;
            if (Intrinsics.areEqual((Object)string, (Object)EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getTHIS_NAME())) {
                Value thisValue = this.findThis(asmType);
                if (thisValue != null) {
                    return thisValue;
                }
            } else {
                Value localVariable;
                Value value2 = localVariable = this.isFunctionType(asmType) ? this.findLocalVariableForLocalFun(name2, asmType, checkType2) : this.findLocalVariable(name2, asmType, checkType2);
                if (localVariable != null) {
                    return localVariable;
                }
                String capturedValName = this.getCapturedFieldName(name2);
                Value capturedVal = this.findCapturedLocalVariable(capturedValName, asmType, checkType2);
                if (capturedVal != null) {
                    return capturedVal;
                }
            }
            return this.fail("Cannot find local variable: name = " + name2 + (checkType2 ? ", type = " + String.valueOf(asmType) : ""), failIfNotFound);
        }
        catch (InvalidStackFrameException e) {
            Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((String)("Local variable " + name2 + " is unavailable in current frame"));
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ilable in current frame\")");
            throw throwable;
        }
    }

    private final Value fail(@JetValueParameter(name="message") String message, @JetValueParameter(name="shouldFail") boolean shouldFail) {
        if (shouldFail) {
            Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((String)message);
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026valuateException(message)");
            throw throwable;
        }
        return null;
    }

    private final Value findThis(@JetValueParameter(name="asmType", type="?") Type asmType) {
        ObjectValue eval4jValue;
        ObjectReference thisObject;
        StackFrame stackFrame = this.frame;
        if (stackFrame == null) {
            Intrinsics.throwNpe();
        }
        if ((thisObject = stackFrame.thisObject()) != null && this.isValueOfCorrectType(eval4jValue = JdiPackage.asValue(thisObject), asmType, true)) {
            return eval4jValue;
        }
        Value receiver = this.findValue(EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getRECEIVER_NAME(), asmType, true, false);
        if (receiver != null) {
            return receiver;
        }
        Value this0 = this.findValue(AsmUtil.CAPTURED_THIS_FIELD, asmType, true, false);
        if (this0 != null) {
            return this0;
        }
        Value $this = this.findValue("$this", asmType, false, false);
        if ($this != null) {
            return $this;
        }
        return null;
    }

    private final Value findLocalVariableForLocalFun(@JetValueParameter(name="name") String name2, @JetValueParameter(name="asmType", type="?") Type asmType, @JetValueParameter(name="checkType") boolean checkType2) {
        return this.findLocalVariable(name2 + "$", asmType, checkType2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFunctionType(@JetValueParameter(name="type", type="?") Type type2) {
        Type type3 = type2;
        if (!Intrinsics.areEqual((Object)(type3 != null ? Integer.valueOf(type3.getSort()) : null), (Object)Type.OBJECT)) return false;
        Type type4 = type2;
        if (type4 == null) {
            Intrinsics.throwNpe();
        }
        if (!KotlinPackage.startsWith$default((String)type4.getInternalName(), (String)InlineCodegenUtil.NUMBERED_FUNCTION_PREFIX, (boolean)false, (int)2)) return false;
        return true;
    }

    private final Value findLocalVariable(@JetValueParameter(name="name") String name2, @JetValueParameter(name="asmType", type="?") Type asmType, @JetValueParameter(name="checkType") boolean checkType2) {
        LocalVariable localVariable;
        StackFrame stackFrame = this.frame;
        if (stackFrame == null) {
            Intrinsics.throwNpe();
        }
        if ((localVariable = stackFrame.visibleVariableByName(name2)) == null) {
            return null;
        }
        Value eval4jValue = JdiPackage.asValue(this.frame.getValue(localVariable));
        Value sharedVarValue = this.getValueIfSharedVar(eval4jValue, asmType, checkType2);
        if (sharedVarValue != null) {
            return sharedVarValue;
        }
        if (this.isValueOfCorrectType(eval4jValue, asmType, checkType2)) {
            return eval4jValue;
        }
        return null;
    }

    private final Value findCapturedLocalVariable(@JetValueParameter(name="name") String name2, @JetValueParameter(name="asmType", type="?") Type asmType, @JetValueParameter(name="checkType") boolean checkType2) {
        Mirror mirror = this.frame;
        if (mirror == null || (mirror = mirror.thisObject()) == null) {
            return null;
        }
        Mirror thisObject = mirror;
        Value thisObj = JdiPackage.asValue((ObjectReference)thisObject);
        Value capturedVal = null;
        while (capturedVal == null && thisObj != null) {
            capturedVal = this.getField(thisObj, name2, asmType, checkType2);
            if (capturedVal != null) continue;
            thisObj = this.getField(thisObj, AsmUtil.CAPTURED_THIS_FIELD, null, false);
        }
        if (capturedVal != null) {
            Value sharedVarValue = this.getValueIfSharedVar(capturedVal, asmType, checkType2);
            if (sharedVarValue != null) {
                return sharedVarValue;
            }
            return capturedVal;
        }
        return null;
    }

    private final boolean isValueOfCorrectType(@JetValueParameter(name="value") Value value2, @JetValueParameter(name="asmType", type="?") Type asmType, @JetValueParameter(name="shouldCheckType") boolean shouldCheckType) {
        if (!shouldCheckType || asmType == null || Intrinsics.areEqual((Object)value2.getAsmType(), (Object)asmType)) {
            return true;
        }
        if (this.project == null) {
            return false;
        }
        Object object = Eval4jPackage.obj$default(value2, null, 1);
        if (!(object instanceof ObjectReference)) {
            object = null;
        }
        ObjectReference objectReference = (ObjectReference)object;
        com.sun.jdi.Type type2 = objectReference != null ? objectReference.referenceType() : null;
        String string = asmType.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"asmType.getClassName()");
        if (this.isSubclass(type2, string)) {
            return true;
        }
        ClassDescriptor thisDesc = EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getClassDescriptor(value2.getAsmType(), this.project);
        ClassDescriptor expDesc = EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getClassDescriptor(asmType, this.project);
        return thisDesc != null && expDesc != null && (Boolean)ApplicationPackage.runReadAction((Function0)new Function0<Boolean>(thisDesc, expDesc){
            final /* synthetic */ ClassDescriptor $thisDesc;
            final /* synthetic */ ClassDescriptor $expDesc;

            public final boolean invoke() {
                return DescriptorUtils.isSubclass(this.$thisDesc, this.$expDesc);
            }
            {
                this.$thisDesc = classDescriptor;
                this.$expDesc = classDescriptor2;
                super(0);
            }
        }) != false;
    }

    private final Value getField(@JetValueParameter(name="owner") Value owner, @JetValueParameter(name="name") String name2, @JetValueParameter(name="asmType", type="?") Type asmType, @JetValueParameter(name="checkType") boolean checkType2) {
        try {
            StackFrame stackFrame = this.frame;
            if (stackFrame == null) {
                Intrinsics.throwNpe();
            }
            VirtualMachine virtualMachine = stackFrame.virtualMachine();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"frame!!.virtualMachine()");
            com.sun.jdi.Value obj = JdiPackage.asJdiValue(owner, virtualMachine, owner.getAsmType());
            if (!(obj instanceof ObjectReference)) {
                return null;
            }
            ReferenceType _class = ((ObjectReference)obj).referenceType();
            Field field = _class.fieldByName(name2);
            if (field == null) {
                return null;
            }
            Value fieldValue = JdiPackage.asValue(((ObjectReference)obj).getValue(field));
            if (this.isValueOfCorrectType(fieldValue, asmType, checkType2)) {
                return fieldValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private final boolean isSharedVar(@JetValueParameter(name="$receiver") Value $receiver) {
        return $receiver.getAsmType().getSort() == Type.OBJECT && KotlinPackage.startsWith$default((String)$receiver.getAsmType().getInternalName(), (String)AsmTypes.REF_TYPE_PREFIX, (boolean)false, (int)2);
    }

    private final Value getValueIfSharedVar(@JetValueParameter(name="value") Value value2, @JetValueParameter(name="expectedType", type="?") Type expectedType, @JetValueParameter(name="checkType") boolean checkType2) {
        if (!this.isSharedVar(value2)) {
            return null;
        }
        Value sharedVarValue = this.getField(value2, "element", expectedType, checkType2);
        if (sharedVarValue != null && this.isValueOfCorrectType(sharedVarValue, expectedType, checkType2)) {
            return sharedVarValue;
        }
        return null;
    }

    private final String getCapturedFieldName(@JetValueParameter(name="name") String name2) {
        String string = name2;
        return Intrinsics.areEqual((Object)string, (Object)EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getRECEIVER_NAME()) ? AsmUtil.CAPTURED_RECEIVER_FIELD : (Intrinsics.areEqual((Object)string, (Object)EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getTHIS_NAME()) ? AsmUtil.CAPTURED_THIS_FIELD : (Intrinsics.areEqual((Object)string, (Object)AsmUtil.CAPTURED_RECEIVER_FIELD) ? name2 : (Intrinsics.areEqual((Object)string, (Object)AsmUtil.CAPTURED_THIS_FIELD) ? name2 : "$" + name2)));
    }

    private final boolean isSubclass(@JetValueParameter(name="$receiver", type="?") com.sun.jdi.Type $receiver, @JetValueParameter(name="superClassName") String superClassName) {
        boolean bl;
        block4: {
            if (!($receiver instanceof ClassType)) {
                return false;
            }
            Iterable $receiver2 = ((ClassType)$receiver).allInterfaces();
            for (Object element : $receiver2) {
                InterfaceType it = (InterfaceType)element;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)superClassName)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        for (ClassType superClass = ((ClassType)$receiver).superclass(); superClass != null; superClass = superClass.superclass()) {
            if (!Intrinsics.areEqual((Object)superClass.name(), (Object)superClassName)) continue;
            return true;
        }
        return false;
    }

    public FrameVisitor(@JetValueParameter(name="context") @NotNull EvaluationContextImpl context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.project = context2.getDebugProcess().getProject();
        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
        this.frame = stackFrameProxyImpl != null ? stackFrameProxyImpl.getStackFrame() : null;
    }
}

