/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatePackage$KotlinEvaluationBuilder$b91469b6;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentPackage$attachmentUtils$60c1fc5d;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"b\u0004)92j\u001c;mS:,e/\u00197vCRLwN\u001c\"vS2$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015!!WMY;hO\u0016\u0014(\u0002C3wC2,\u0018\r^3\u000b!\u00153\u0018\r\\;bi>\u0014()^5mI\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'N\u0003\u0004f]\u001eLg.\u001a\u0006\u000bKZ\fG.^1uS>t'BC3yaJ,7o]5p]*)!-^5mI*a1m\u001c3f\rJ\fw-\\3oi*Q\u0001k]5FY\u0016lWM\u001c;\u000b\u0007A\u001c\u0018N\u0003\u0005q_NLG/[8o\u00159\u0019v.\u001e:dKB{7/\u001b;j_:T1#\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_J$\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0003\t\tA1!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0011A\u0001\u0002E\u0003\u000b\t!I\u0001C\u0003\u0006\u0005\u0011)\u00012B\u0003\u0003\t\u0017Aa!B\u0002\u0005\r!\u001dA\u0002A\u0003\u0003\t\u0011A\u0001\"B\u0002\u0005\u000f!=A\u0002A\u0003\u0004\t\u0013A\u0011\u0002\u0004\u0001\u0006\u0007\u00111\u00012\u0003\u0007\u0001\u000b\t!a\u0001c\u0005\u0006\u0005\u00119\u0001rB\u0003\u0003\t\u0013A\u0011\u0002\u00021\u0002\u0019\rI\"!B\u0001\t\u000e5nBa\u0003M\u0007;\u001b!\u0001\u0001C\u0004\u000e\u0005\u0015\t\u0001r\u0002)\u0004\u0001u=A\u0001\u0001E\t\u001b\r)\u0011\u0001\u0003\u0005\r\u0002A\u001b\t!\t\u0002\u0006\u0003!E\u0011kA\u0004\u0005\u000e%\t\u0001\"C\u0007\u0002\u0011'i\u0011\u0001\u0003\u00066\u0001\u0001"})
public final class KotlinEvaluationBuilder
implements EvaluatorBuilder {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final KotlinEvaluationBuilder INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinEvaluationBuilder.class);
        new KotlinEvaluationBuilder();
    }

    @NotNull
    public ExpressionEvaluator build(@JetValueParameter(name="codeFragment") @NotNull PsiElement codeFragment, @JetValueParameter(name="position", type="?") @Nullable SourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        if (!(codeFragment instanceof JetCodeFragment) || position == null) {
            EvaluatorBuilder evaluatorBuilder = EvaluatorBuilderImpl.getInstance();
            if (evaluatorBuilder == null) {
                Intrinsics.throwNpe();
            }
            ExpressionEvaluator expressionEvaluator = evaluatorBuilder.build(codeFragment, position);
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionEvaluator, (String)"EvaluatorBuilderImpl.get\u2026d(codeFragment, position)");
            return expressionEvaluator;
        }
        PsiFile file = position.getFile();
        if (!(file instanceof JetFile)) {
            Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((String)"Couldn't evaluate kotlin expression in non-kotlin context");
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026n in non-kotlin context\")");
            throw throwable;
        }
        if (position.getLine() < 0) {
            Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((String)("Couldn't evaluate kotlin expression at " + position));
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026expression at $position\")");
            throw throwable;
        }
        if (!(((JetCodeFragment)codeFragment).getContext() instanceof JetElement)) {
            Attachment[] attachments = new Attachment[]{AttachmentPackage$attachmentUtils$60c1fc5d.attachmentByPsiFile(position.getFile()), AttachmentPackage$attachmentUtils$60c1fc5d.attachmentByPsiFile((PsiFile)codeFragment), new Attachment("breakpoint.info", "line: " + position.getLine())};
            PsiElement psiElement = ((JetCodeFragment)codeFragment).getContext();
            EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getLogger().error("Trying to evaluate " + ((JetCodeFragment)codeFragment).getClass() + " with context " + (psiElement != null ? psiElement.getClass() : null), new Attachment[]{AttachmentPackage$attachmentUtils$60c1fc5d.mergeAttachments(attachments)});
            Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((String)"Couldn't evaluate kotlin expression in this context");
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ression in this context\")");
            throw throwable;
        }
        return (ExpressionEvaluator)new ExpressionEvaluatorImpl((Evaluator)new KotlinEvaluator((JetCodeFragment)codeFragment, position));
    }

    KotlinEvaluationBuilder() {
        INSTANCE$ = this;
    }
}

