/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ExceptionUtil;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.BreakpointRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.data;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval4jPackage;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiPackage;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.Progress;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatePackage$KotlinEvaluationBuilder$b91469b6;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatePackage$extractFunctionForDebuggerUtil$7b2f6a27;
import org.jetbrains.kotlin.idea.debugger.evaluate.FrameVisitor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluateExpressionCache;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion$extractAndCompile$;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorPackage$compilingEvaluator$0a9f45bb;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentPackage$attachmentUtils$60c1fc5d;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilPackage;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"I\u0006)y1j\u001c;mS:,e/\u00197vCR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0011\u0011,'-^4hKJT\u0001\"\u001a<bYV\fG/\u001a\u0006\n\u000bZ\fG.^1u_JT1aY8n\u0015!Ig\u000e^3mY&T'BB3oO&tWM\u0003\u0006fm\u0006dW/\u0019;j_:T!\"\u001a=qe\u0016\u001c8/[8o\u0015\u0019a\u0014N\\5u})a1m\u001c3f\rJ\fw-\\3oi*y!*\u001a;D_\u0012,gI]1h[\u0016tGOC\u0002qg&Tab]8ve\u000e,\u0007k\\:ji&|gN\u0003\bT_V\u00148-\u001a)pg&$\u0018n\u001c8\u000b\u001f\u001d,GoQ8eK\u001a\u0013\u0018mZ7f]RT\u0011cZ3u'>,(oY3Q_NLG/[8o\u0015\u001d\u0019wN\u001c;fqRTQ#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u00136\u0004HNC\u0002B]fTAA[1wC*!A.\u00198h\u0015\u0019y%M[3di*Yq-\u001a;N_\u0012Lg-[3s\u0015!iu\u000eZ5gS\u0016\u0014(\"C\"p[B\fg.[8o]\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0005\u000b\t!9\u0001#\u0003\u0006\u0005\u0011!\u0001RA\u0003\u0003\t\u0013AQ!\u0002\u0002\u0005\u000b!-QA\u0001C\u0006\u0011\u0019)1\u0001\u0002\u0004\t\b1\u0001QA\u0001\u0003\u0002\u0011!)1\u0001B\u0004\t\u00101\u0001Qa\u0001C\u0005\u0011%a\u0001!\u0002\u0002\u0005\u000f!=QA\u0001C\u0005\u0011%)1\u0001b\u0003\t\u00171\u0001Q!\u0001E\u0002\u000b\r!!\u0002c\u0006\r\u0001\u0015\t\u0001\u0002D\u0003\u0003\t-AI\"\u0002\u0002\u0005\u0018!iQA\u0001C\u0006\u0011-)1\u0001\u0002\u0004\t\u001d1\u0001QA\u0001\u0003\u0007\u00119!\u0001\u0001D\u0002\u0011\u001ee\u0011Q!\u0001E\u00079;is\u0002\u00021\u00051\u001d\t#!B\u0001\t\u0010U\u001b\u0001\"B\u0002\u0005\u000f%\t\u0001\u0012C\u0007\u0004\t'I\u0011\u0001#\u0005.\u001f\u0011\u0001G\u0001'\u0005\"\u0005\u0015\t\u0001\u0002C+\u0004\u0011\u0015\u0019A\u0011C\u0005\u0002\u0011%i1\u0001\u0002\u0006\n\u0003!IQ\u0006\u0006\u0003\f1\rij\u0001\u0002\u0001\t\u00165\u0011Q!\u0001E\n!\u000e\u0001\u0011eA\u0003\u0002\u0011+a\t!U\u0002\u0006\t\rI\u0011\u0001\u0003\u0007\u000e\u0003!eQV\u0003\u0003\f17\t3!B\u0001\t\u001b1\u0005\u0011kA\u0002\u0005\u001c%\t\u00012D\u001b\u001f\u000bu!1\u001d\u0001M\u0007;\u001b!\u0001\u0001C\u0004\u000e\u0005\u0015\t\u0001r\u0002)\u0004\u0001u5A\u0001\u0001E\t\u001b\t)\u0011\u0001\u0003\u0005Q\u0007\u0003\t#!B\u0001\t\u0007E\u001bq\u0001\"\u0004\n\u0003\u0011\u0001Q\"\u0001E\t\u001b\u0005A\u0011\u0002"})
public final class KotlinEvaluator
implements Evaluator {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final JetCodeFragment codeFragment;
    @NotNull
    private final SourcePosition sourcePosition;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinEvaluator.class);
        OBJECT$ = Companion = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$init$10();
    }

    @Nullable
    public Object evaluate(@JetValueParameter(name="context") @NotNull EvaluationContextImpl context2) {
        Object isCompiledDataFromCache;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (KotlinPackage.isEmpty((String)this.codeFragment.getText())) {
            return context2.getDebugProcess().getVirtualMachineProxy().mirrorOf();
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        try {
            KotlinEvaluateExpressionCache.CompiledDataDescriptor compiledData2 = KotlinEvaluateExpressionCache.Companion.getOrCreateCompiledData(this.codeFragment, this.sourcePosition, context2, (Function2<? super JetCodeFragment, ? super SourcePosition, ? extends KotlinEvaluateExpressionCache.CompiledDataDescriptor>)((Function2)new Function2<JetCodeFragment, SourcePosition, KotlinEvaluateExpressionCache.CompiledDataDescriptor>((Ref.BooleanRef)isCompiledDataFromCache, context2){
                final /* synthetic */ Ref.BooleanRef $isCompiledDataFromCache;
                final /* synthetic */ EvaluationContextImpl $context;

                @NotNull
                public final KotlinEvaluateExpressionCache.CompiledDataDescriptor invoke(@JetValueParameter(name="fragment") @NotNull JetCodeFragment fragment, @JetValueParameter(name="position") @NotNull SourcePosition position) {
                    Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
                    Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
                    this.$isCompiledDataFromCache.element = false;
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$extractAndCompile$1(KotlinEvaluator.Companion, fragment, position, this.$context);
                }
                {
                    this.$isCompiledDataFromCache = booleanRef;
                    this.$context = evaluationContextImpl;
                    super(2);
                }
            }));
            InterpreterResult result2 = KotlinEvaluator.Companion.runEval4j(context2, compiledData2);
            VirtualMachine virtualMachine = context2.getDebugProcess().getVirtualMachineProxy().getVirtualMachine();
            if (isCompiledDataFromCache.element && result2 instanceof ExceptionThrown && Intrinsics.areEqual((Object)((Object)((ExceptionThrown)result2).getKind()), (Object)((Object)ExceptionThrown.ExceptionKind.BROKEN_CODE))) {
                InterpreterResult interpreterResult = KotlinEvaluator.Companion.runEval4j(context2, KotlinEvaluator.Companion.extractAndCompile(this.codeFragment, this.sourcePosition, context2));
                VirtualMachine virtualMachine2 = virtualMachine;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine2, (String)"virtualMachine");
                return KotlinEvaluator.Companion.toJdiValue(interpreterResult, virtualMachine2);
            }
            VirtualMachine virtualMachine3 = virtualMachine;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine3, (String)"virtualMachine");
            return KotlinEvaluator.Companion.toJdiValue(result2, virtualMachine3);
        }
        catch (EvaluateException e) {
            throw (Throwable)e;
        }
        catch (ProcessCanceledException e) {
            KotlinEvaluator.Companion.exception(e);
        }
        catch (VMDisconnectedException e) {
            String string = DebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DebuggerBundle.message(\"error.vm.disconnected\")");
            KotlinEvaluator.Companion.exception(string);
        }
        catch (Exception e) {
            Attachment[] attachments = new Attachment[]{AttachmentPackage$attachmentUtils$60c1fc5d.attachmentByPsiFile(this.sourcePosition.getFile()), AttachmentPackage$attachmentUtils$60c1fc5d.attachmentByPsiFile((PsiFile)this.codeFragment), new Attachment("breakpoint.info", "line: " + this.sourcePosition.getLine())};
            EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getLogger().error((Object)LogMessageEx.createEvent((String)"Couldn't evaluate expression", (String)ExceptionUtil.getThrowableText((Throwable)e), (Attachment[])new Attachment[]{AttachmentPackage$attachmentUtils$60c1fc5d.mergeAttachments(attachments)}));
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            KotlinEvaluator.Companion.exception("An exception occurs during Evaluate Expression Action " + cause);
        }
        isCompiledDataFromCache = null;
        return Unit.INSTANCE$;
    }

    @Nullable
    public Modifier getModifier() {
        return null;
    }

    @NotNull
    public final JetCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public KotlinEvaluator(@JetValueParameter(name="codeFragment") @NotNull JetCodeFragment codeFragment, @JetValueParameter(name="sourcePosition") @NotNull SourcePosition sourcePosition) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition;
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"G\u0014)I1i\\7qC:LwN\u001c\u0006\u0010\u0017>$H.\u001b8Fm\u0006dW/\u0019;pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002\u00033fEV<w-\u001a:\u000b\u0011\u00154\u0018\r\\;bi\u0016T1!\u00118z\u0015i\u0011w\u000e_(s+:\u0014w\u000e_!sOVlWM\u001c;JM:+W\rZ3e\u0015\u0011)g/\u00197\u000b\u000f)#\u0015*\u0012<bY*1QM^1mi)T1A\u001b3j\u00155\t'oZ;nK:$h+\u00197vK*)a+\u00197vK*i\u0001/\u0019:b[\u0016$XM\u001d+za\u0016TA\u0001V=qK*IqN\u00196fGR<XM\u0019\u0006\u0004CNl'BF2sK\u0006$Xm\u00117bgN4\u0015\u000e\\3GC\u000e$xN]=\u000b\u0019\r|G-\u001a$sC\u001elWM\u001c;\u000b\u001f)+GoQ8eK\u001a\u0013\u0018mZ7f]RT1\u0001]:j\u0015E)\u0007\u0010\u001e:bGR,GMR;oGRLwN\u001c\u0006\u0011\u0015\u0016$h*Y7fI\u001a+hn\u0019;j_:TqaY8oi\u0016DHOC\u000bFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRLU\u000e\u001d7\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u0019)gnZ5oK*QQM^1mk\u0006$\u0018n\u001c8\u000b\u0015A\f'/Y7fi\u0016\u00148O\u0003\u000bQCJ\fW.\u001a;feN$Um]2sSB$xN\u001d\u0006\u001e\u0017>$H.\u001b8Fm\u0006dW/\u0019;f\u000bb\u0004(/Z:tS>t7)Y2iK*\u00012\t\\1tg\u001aKG.\u001a$bGR|'/\u001f\u0006\bG>$WmZ3o\u0015IZu\u000e\u001e7j]\u00163\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\\\"bG\",G\u0005U1sC6,G/\u001a:t\t\u0016\u001c8M]5qi>\u0014(\"C3yG\u0016\u0004H/[8o\u0015\ri7o\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\u000f9{G\u000f[5oO*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\tY{\u0017\u000e\u001a\u0006\u0002K*IA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0012Kb$(/Y2u\u0003:$7i\\7qS2,'BD:pkJ\u001cW\rU8tSRLwN\u001c\u0006\u000f'>,(oY3Q_NLG/[8o\u0015Y\u0019u.\u001c9jY\u0016$G)\u0019;b\t\u0016\u001c8M]5qi>\u0014(\u0002N&pi2Lg.\u0012<bYV\fG/Z#yaJ,7o]5p]\u000e\u000b7\r[3%\u0007>l\u0007/\u001b7fI\u0012\u000bG/\u0019#fg\u000e\u0014\u0018\u000e\u001d;pe*aq-\u001a;DY\u0006\u001c8OT1nK*Aa-\u001b7f\u001d\u0006lWMC\u0005sk:,e/\u001975U*a1m\\7qS2,G\rR1uC*\t\u0012J\u001c;feB\u0014X\r^3s%\u0016\u001cX\u000f\u001c;\u000b\u000f)+GOR5mK*q1\r[3dW\u001a{'/\u0012:s_J\u001c(BF1oC2L(0Z%oY&tWMR;oGRLwN\\:\u000b\u000f\t{w\u000e\\3b]*1R\t\u001f;f]\u0012,G-\u00118bYf\u001c\u0018n\u001d*fgVdGO\u0003\u0019L_Rd\u0017N\\#wC2,\u0018\r^8sI\r{W\u000e]1oS>tG%\u0012=uK:$W\rZ!oC2L8/[:SKN,H\u000e\u001e\u0006\u0016O\u0016$\u0018I]4v[\u0016tGo\u001d$pe\u00163\u0018\r\u001c\u001bk\u00159\u0001\u0018M]1nKR,'OT1nKNTA\u0001T5ti*q\u0001/\u0019:b[\u0016$XM\u001d+za\u0016\u001c(\"B!se\u0006L(\u0002B;uS2T\u0001#\u0012=ue\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u000b\u0017I,g-Y2u_JLgn\u001a\u0006\nS:$(o\u001c3vG\u0016T\u0001#\u001a=ue\u0006\u001cG/[8o\u000b:<\u0017N\\3\u000b1\u001d,G\u000fU1sC6,G/\u001a:t\r>\u0014H)\u001a2vO\u001e,'O\u0003\u0007CS:$\u0017N\\4Ue\u0006\u001cWMC\u0004sKN|GN^3\u000b'I,7m\u001c:e\u0003:|g._7pkN$\u0016\u0010]3\u000b\u001bQL\b/\u001a*fM\u0016\u0014XM\\2f\u0015AQU\r\u001e+za\u0016\u0014VMZ3sK:\u001cWMC\tm_\u000e\fGNV1sS\u0006\u0014G.\u001a(b[\u0016TqA^5tSR|'O\u0003\u0007Ge\u0006lWMV5tSR|'O\u0003\u0003V]&$(B\u0003;p\u0015\u0012Lg+\u00197vK*\u0011a/\u001c\u0006\u000f-&\u0014H/^1m\u001b\u0006\u001c\u0007.\u001b8f\u0015\r\u0019XO\u001cN\u0005\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0011AA\u0001E\u0004\u000b\r!)\u0001#\u0001\r\u0001\u0015\u0019Aa\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011!\u0001\u0002\u0002\u0007\u0001\u000b\t!\t\u0001\u0003\u0004\u0006\u0005\u0011)\u0001RB\u0003\u0004\t\u0017AY\u0001\u0004\u0001\u0006\u0007\u0011)\u0001r\u0002\u0007\u0001\u000b\t!\t\u0001C\u0001\u0006\u0005\u00119\u0001\"C\u0003\u0003\t\u001fA\u0019\"B\u0002\u0005\u0011!EA\u0002A\u0003\u0003\t\u0015Ay!\u0002\u0002\u0005\f!-QA\u0001\u0003\t\u0011#)!\u0001B\u0001\t\u0018\u0015\u0019AQ\u0003\u0005\f\u0019\u0001)1\u0001\"\u0006\t\u001a1\u0001Q!\u0001\u0005\u000f\u000b\t!A\u0002#\b\u0006\u0005\u0011e\u0001bA\u0003\u0003\t5Aq\"\u0002\u0002\u0005\u001c!}Qa\u0001\u0003\u000f\u00117a\u0001!B\u0002\u0005\u0006!\tB\u0002A\u0003\u0004\t=A\t\u0003\u0004\u0001\u0006\u0005\u0011\t\u0001BE\u0003\u0004\tAA\u0019\u0003\u0004\u0001\u0006\u0005\u0011\u0001\u00022E\u0003\u0003\t+A1\"\u0002\u0002\u0005\u0016!eQA\u0001\u0003\u000f\u00117)!\u0001\"\u0002\t&\u0015\u0019A\u0001\u0002\u0005\u0015\u0019\u0001)1\u0001\u0002\u0003\t*1\u0001Q!\u0001\u0005\u0016\u000b\t!I\u0003c\u000b\u0006\u0005\u0011)\u0002BF\u0003\u0003\tUAA#B\u0002\u0005\t!9B\u0002A\u0003\u0003\tUAq#B\u0002\u0005\u001b!EB\u0002A\u0003\u0004\t=A\u0011\u0004\u0004\u0001\u0006\u0005\u0011\u0015\u00012G\u0003\u0003\t5A\t$B\u0002\u0005\u000b!aB\u0002A\u0003\u0003\t\u0015AA$B\u0002\u0005\u0016!eB\u0002A\u0003\u0004\t\u0011Aa\u0004\u0004\u0001\u0006\u0007\u0011\u001d\u0001R\b\u0007\u0001\u000b\t!)\u0001C\u0010\u0006\u0005\u0011U\u0001\u0012H\u0003\u0004\t\u0011A\t\u0005\u0004\u0001\u0006\u0007\u0011!\u00012\t\u0007\u0001\u000b\t!I\u0003\u0003\u0012\u0006\u0005\u0011q\u0002\u0012I\u0003\u0003\t\u0007A1%\u0002\u0002\u0005?!\u001dSA\u0001C \u0011\u0011*1\u0001\u0002\u0011\tF1\u0001QA\u0001\u0003!\u0011\u000b*!\u0001B\u0001\tL\u0015\u0019A1\t\u0005&\u0019\u0001)1\u0001\"\u0006\tO1\u0001Qa\u0001C\u0003\u0011#b\u0001!B\u0002\u0005\t!IC\u0002A\u0003\u0003\t\u0007BQ%\u0002\u0002\u0005\u0016!9SA\u0001C\u0003\u0011#*!\u0001\u0002\u0007\tW\u0015\u0011A1\nE\u0007\u000b\r!a\u0005#\u0016\r\u0001\u0015\u0019AA\nE\b\u0019\u0001)!\u0001\u0002\u0014\t\u0010\u0015\u0011AA\nE+\t\r\u000fArA\r\u0003\u000b\u0005AI\u0001(\u0010.M\u0011\t\u0001\u0014BO\u0007\t\u0001AQ!\u0004\u0002\u0006\u0003!1\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001bB\u0007\u0003\u000b\u0005Ai\u0001UB\u0001;\u001b!\u0001\u0001\u0003\u0005\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0003\u0005\u0012Q!\u0001E\u0007#\u000eIA\u0011B\u0005\u0002\u0011%i\u0011\u0001c\u0005\u000e\u0003!IQ\"\u0001\u0005\u000b[?\"\u0011\u0001\u0007\u0006\u001e\u000e\u0011\u0001\u0001RC\u0007\u0003\u000b\u0005A1\u0002U\u0002\u0001;\u001b!\u0001\u0001\u0003\u0007\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0002u5A\u0001\u0001\u0005\u000e\u001b\t)\u0011\u0001#\bQ\u0007\u0005ij\u0001\u0002\u0001\t!5\u0011Q!\u0001E\u0010!\u000e\r\u0011EA\u0003\u0002\u0011C\t6a\u0003\u0003\u000b\u0013\u0005A\u0011#D\u0001\t$5\t\u0001BE\u0007\u0002\u0011Ki\u0011\u0001C\n.'\u0011\t\u0001dEO\u0007\t\u0001A9#\u0004\u0002\u0006\u0003!\u001d\u0002k\u0001\u0001\"\u0005\u0015\t\u0001\u0002F)\u0004\u000b\u0011\u0019\u0012\"\u0001E\u0016\u001b\u0005Aa#L\n\u0005\u0003a\u0019RT\u0002\u0003\u0001\u0011[i!!B\u0001\t.A\u001b\u0001!\t\u0002\u0006\u0003!!\u0012kA\u0003\u0005'%\t\u00012F\u0007\u0002\u0011]ic\u0005B\u0001\u00190u5A\u0001\u0001E\u000b\u001b\t)\u0011\u0001C\u0006Q\u0007\u0001ij\u0001\u0002\u0001\t15\u0011Q!\u0001E\u0018!\u000e\u0005QT\u0002\u0003\u0001\u00115i!!B\u0001\t\u001eA\u001b\u0011!\t\u0002\u0006\u0003!A\u0012kA\u0005\u00050%\t\u0001\u0012G\u0007\u0002\u0011Gi\u0011\u0001C\r\u000e\u0003!\u0015Rf\u0005\u0003\u00021iij\u0001\u0002\u0001\t65\u0011Q!\u0001E\u0014!\u000e\u0001\u0011EA\u0003\u0002\u0011O\t6!\u0002\u0003\u001b\u0013\u0005Aa#D\u0001\t-5fB!\u0001\r\u001c;\u001b!\u0001\u0001C\u0007\u000e\u0005\u0015\t\u0001R\u0004)\u0004\u0001u5A\u0001\u0001E\u001c\u001b\t)\u0011\u0001\u0003\rQ\u0007\u0003\t#!B\u0001\t4E\u001bq\u0001B\u000e\n\u0003!QR\"\u0001E\u0013\u001b\u0005A\t$\f\r\u0005\u0003U\u0011Q!\u0001E\u001b1uij\u0001\u0002\u0001\t<5\u0011Q!\u0001\u0005\u001c!\u000e\u0005\u0011EA\u0003\u0002\u0011o\t6a\u0002\u0003\u001e\u0013\u0005AA$D\u0001\t:5\tA\u0011AW/\t\u0005)\"!B\u0001\t\u001ea}RT\u0003\u0003\u0001\u0011\u0001ja!B\u0001\t;%\u0019\u0011BA\u0003\u0002\u0011O\u00016\u0011AO\u000b\t\u0001A\u0011%\u0004\u0004\u0006\u0003!m\u0012bA\u0005\u0003\u000b\u0005A\t\u0002U\u0002\u0002C\u0019)\u0011\u0001C\u000f\n\u0007%\u0011Q!\u0001E\u0007#\u000eQAqH\u0005\u0002\u0011{i\u0011\u0001#\n\u000e\u0003!uRB\u0001\u0005\u000b\u0019\u0003ik\u0002B\u0001\u0016\u0005\u0015\t\u0001\u0012\tM%C\t)\u0011\u0001c\bR\u0007\u0015!I%C\u0001\t'5\t\u0001\"I\u0017,\t\u0005)\"!B\u0001\tEa1ST\u0002\u0003\u0001\u0011\u001bj!!B\u0001\tFA\u001b\t!(\u0004\u0005\u0001!=SBA\u0003\u0002\u0011O\u00016!AO\u0007\t\u0001A\u0001&\u0004\u0002\u0006\u0003!\u0019\u0003ka\u0001\"\u0005\u0015\t\u0001rI)\u0004\u0017\u00111\u0013\"\u0001\u0003\u0001\u001b\u0005AA%D\u0001\tJ5\t\u0001BF\u0007\u0002\u0011\u0015j\u0013\u0004B\u0001\u0016\u0005\u0015\t\u00012\u0007M*;\u001b!\u0001\u0001\u0003\u0016\u000e\u0005\u0015\t\u0001R\n)\u0004\u0002\u0005\u001aQ!\u0001\u0005(\u0019\u0003\t6a\u0002C*\u0013\u0005Ay%D\u0001\t55\t\u0001\u0002K\u001b\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        /*
         * WARNING - void declaration
         */
        private final KotlinEvaluateExpressionCache.CompiledDataDescriptor extractAndCompile(@JetValueParameter(name="codeFragment") JetCodeFragment codeFragment, @JetValueParameter(name="sourcePosition") SourcePosition sourcePosition, @JetValueParameter(name="context") EvaluationContextImpl context2) {
            List list;
            void destination;
            void $receiver;
            Iterable $receiver2;
            this.checkForErrors(codeFragment, false);
            PsiFile psiFile = sourcePosition.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"sourcePosition.getFile()");
            ExtractionResult extractionResult = EvaluatePackage$extractFunctionForDebuggerUtil$7b2f6a27.getFunctionForExtractedFragment(codeFragment, psiFile, sourcePosition.getLine());
            if (extractionResult == null) {
                throw (Throwable)new IllegalStateException("Code fragment cannot be extracted to function");
            }
            KotlinEvaluateExpressionCache.ParametersDescriptor parametersDescriptor = this.getParametersForDebugger(extractionResult);
            JetNamedDeclaration jetNamedDeclaration = extractionResult.getDeclaration();
            if (jetNamedDeclaration == null) {
                throw new TypeCastException("org.jetbrains.kotlin.psi.JetNamedDeclaration cannot be cast to org.jetbrains.kotlin.psi.JetNamedFunction");
            }
            JetNamedFunction extractedFunction = (JetNamedFunction)jetNamedDeclaration;
            ClassFileFactory classFileFactory = this.createClassFileFactory(codeFragment, extractedFunction, context2, parametersDescriptor);
            Iterable iterable = classFileFactory.asList();
            void var10_9 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element : $receiver) {
                OutputFile it = (OutputFile)element;
                if (!(Intrinsics.areEqual((Object)it.getRelativePath(), (Object)(EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getPackageInternalName() + ".class")) ^ true)) continue;
                destination.add(element);
            }
            $receiver2 = (List)destination;
            ArrayList sortedList = KotlinPackage.toArrayList((Iterable)$receiver2);
            Object sortBy2 = new Comparator<T>(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(Companion$extractAndCompile$$inlined$sortBy$1.class);
                }

                public int compare(T a, T b) {
                    OutputFile it = (OutputFile)a;
                    Comparable comparable = Integer.valueOf(it.getRelativePath().length());
                    it = (OutputFile)b;
                    Comparable comparable2 = comparable;
                    Integer n = it.getRelativePath().length();
                    return KotlinPackage.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            Collections.sort(sortedList, sortBy2);
            List outputFiles = sortedList;
            String funName = extractedFunction.getName();
            if (funName == null) {
                throw (Throwable)new IllegalStateException("Extracted function should have a name: " + extractedFunction.getText());
            }
            if (outputFiles.size() < 2) {
                list = KotlinPackage.emptyList();
            } else {
                void destination2;
                void $receiver3;
                void $receiver4;
                Object element;
                sortBy2 = outputFiles.subList(1, outputFiles.size());
                Iterator iterator2 = $receiver4;
                element = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver4, (int)10));
                for (Object item : $receiver3) {
                    void it;
                    OutputFile outputFile = (OutputFile)item;
                    void var17_17 = destination2;
                    Pair pair2 = KotlinPackage.to((Object)Companion.getClassName(it.getRelativePath()), (Object)it.asByteArray());
                    var17_17.add(pair2);
                }
                list = (List)destination2;
            }
            List additionalFiles = list;
            return new KotlinEvaluateExpressionCache.CompiledDataDescriptor(((OutputFile)KotlinPackage.first((List)outputFiles)).asByteArray(), additionalFiles, sourcePosition, funName, parametersDescriptor);
        }

        private final String getClassName(@JetValueParameter(name="fileName") String fileName) {
            return KotlinPackage.replace$default((String)KotlinPackage.substringBeforeLast$default((String)fileName, (String)".class", null, (int)2), (String)"/", (String)".", (boolean)false, (int)4);
        }

        /*
         * WARNING - void declaration
         */
        private final InterpreterResult runEval4j(@JetValueParameter(name="context") EvaluationContextImpl context2, @JetValueParameter(name="compiledData") KotlinEvaluateExpressionCache.CompiledDataDescriptor compiledData2) {
            void resultValue;
            VirtualMachine virtualMachine = context2.getDebugProcess().getVirtualMachineProxy().getVirtualMachine();
            if (KotlinPackage.isNotEmpty((Collection)compiledData2.getAdditionalClasses())) {
                CompilingEvaluatorPackage$compilingEvaluator$0a9f45bb.loadClasses(context2, (Collection<? extends Pair<? extends String, ? extends byte[]>>)compiledData2.getAdditionalClasses());
            }
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            new ClassReader(compiledData2.getBytecodes()).accept(new ClassVisitor(compiledData2, context2, virtualMachine, (Ref.ObjectRef)resultValue, Opcodes.ASM5){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ KotlinEvaluateExpressionCache.CompiledDataDescriptor $compiledData;
                final /* synthetic */ EvaluationContextImpl $context;
                final /* synthetic */ VirtualMachine $virtualMachine;
                final /* synthetic */ Ref.ObjectRef $resultValue;

                static {
                    $kotlinClass = Reflection.createKotlinClass(runEval4j.1.class);
                }

                @Nullable
                public MethodVisitor visitMethod(@JetValueParameter(name="access") int access, @JetValueParameter(name="name") @NotNull String name2, @JetValueParameter(name="desc") @NotNull String desc, @JetValueParameter(name="signature", type="?") @Nullable String signature, @JetValueParameter(name="exceptions", type="?") @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    if (Intrinsics.areEqual((Object)name2, (Object)this.$compiledData.getFunName())) {
                        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
                        List<String> list = this.$compiledData.getParameters().getParameterNames();
                        Intrinsics.checkExpressionValueIsNotNull((Object)argumentTypes, (String)"argumentTypes");
                        List<Value> args = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$getArgumentsForEval4j$2(KotlinEvaluator.Companion, this.$context, list, argumentTypes);
                        return (MethodVisitor)new MethodNode(this, args, argumentTypes, Opcodes.ASM5, access, name2, desc, signature, exceptions){
                            public static final /* synthetic */ KClass $kotlinClass;
                            final /* synthetic */ runEval4j.1 this$0;
                            final /* synthetic */ List $args;
                            final /* synthetic */ Type[] $argumentTypes;

                            static {
                                $kotlinClass = Reflection.createKotlinClass(runEval4j.visitMethod.1.class);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void visitEnd() {
                                Unit unit;
                                List list;
                                void destination;
                                void $receiver;
                                Iterable $receiver2;
                                Unit unit2;
                                Object it;
                                T element2;
                                List<BreakpointRequest> breakpoints;
                                List<BreakpointRequest> list2 = breakpoints = this.this$0.$virtualMachine.eventRequestManager().breakpointRequests();
                                if (list2 != null) {
                                    Iterable $receiver3 = list2;
                                    for (T element2 : $receiver3) {
                                        it = (BreakpointRequest)element2;
                                        it.disable();
                                    }
                                    unit2 = Unit.INSTANCE$;
                                } else {
                                    unit2 = null;
                                }
                                VirtualMachine virtualMachine = this.this$0.$virtualMachine;
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"virtualMachine");
                                ClassLoaderReference classLoaderReference = this.this$0.$context.getClassLoader();
                                ThreadReferenceProxyImpl threadReferenceProxyImpl = this.this$0.$context.getSuspendContext().getThread();
                                ThreadReference threadReference = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
                                if (threadReference == null) {
                                    Intrinsics.throwNpe();
                                }
                                JDIEval eval = new JDIEval(virtualMachine, classLoaderReference, threadReference, EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getInvokePolicy((SuspendContext)this.this$0.$context.getSuspendContext()));
                                Ref.ObjectRef objectRef = this.this$0.$resultValue;
                                MethodNode methodNode = this;
                                MethodNode methodNode2 = this;
                                Iterable iterable = this.$args;
                                Object[] objectArray = this.$argumentTypes;
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"argumentTypes");
                                Iterable iterable2 = KotlinPackage.zip((Iterable)iterable, (Object[])objectArray);
                                MethodNode methodNode3 = methodNode2;
                                MethodNode methodNode4 = methodNode;
                                Ref.ObjectRef objectRef2 = objectRef;
                                element2 = $receiver2;
                                it = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                                for (T item : $receiver) {
                                    void it2;
                                    Pair pair2 = (Pair)item;
                                    list = destination;
                                    Value value2 = (Value)it2.getFirst();
                                    Type type2 = (Type)it2.getSecond();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"it.second");
                                    Value value3 = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$boxOrUnboxArgumentIfNeeded$3(KotlinEvaluator.Companion, eval, value2, type2);
                                    list.add(value3);
                                }
                                list = (List)destination;
                                objectRef2.element = Eval4jPackage.interpreterLoop$default(methodNode4, JdiPackage.makeInitialFrame(methodNode3, list), eval, null, 8);
                                List<BreakpointRequest> list3 = breakpoints;
                                if (list3 != null) {
                                    $receiver2 = list3;
                                    for (T element3 : $receiver2) {
                                        BreakpointRequest it3 = (BreakpointRequest)element3;
                                        it3.enable();
                                    }
                                    unit = Unit.INSTANCE$;
                                } else {
                                    unit = null;
                                }
                            }
                            {
                                this.this$0 = $outer;
                                this.$args = $captured_local_variable$1;
                                this.$argumentTypes = $captured_local_variable$2;
                                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
                            }
                        };
                    }
                    return super.visitMethod(access, name2, desc, signature, exceptions);
                }
                {
                    this.$compiledData = $captured_local_variable$0;
                    this.$context = $captured_local_variable$1;
                    this.$virtualMachine = $captured_local_variable$2;
                    this.$resultValue = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }, 0);
            InterpreterResult interpreterResult = (InterpreterResult)resultValue.element;
            if (interpreterResult == null) {
                throw (Throwable)new IllegalStateException("resultValue is null: cannot find method " + compiledData2.getFunName());
            }
            return interpreterResult;
        }

        private final Value boxOrUnboxArgumentIfNeeded(@JetValueParameter(name="eval") JDIEval eval, @JetValueParameter(name="argumentValue") Value argumentValue, @JetValueParameter(name="parameterType") Type parameterType) {
            Type argumentType = argumentValue.getAsmType();
            if (AsmUtil.isPrimitive(parameterType) && !AsmUtil.isPrimitive(argumentType)) {
                try {
                    Type unboxedType = AsmUtil.unboxType(argumentType);
                    if (Intrinsics.areEqual((Object)parameterType, (Object)unboxedType)) {
                        return eval.unboxType(argumentValue, parameterType);
                    }
                }
                catch (UnsupportedOperationException ignored) {
                    // empty catch block
                }
            }
            if (!AsmUtil.isPrimitive(parameterType) && AsmUtil.isPrimitive(argumentType) && Intrinsics.areEqual((Object)parameterType, (Object)AsmUtil.boxType(argumentType))) {
                return eval.boxType(argumentValue);
            }
            return argumentValue;
        }

        private final com.sun.jdi.Value toJdiValue(@JetValueParameter(name="$receiver") InterpreterResult $receiver, @JetValueParameter(name="vm") VirtualMachine vm) {
            Value value2;
            InterpreterResult interpreterResult = $receiver;
            if (interpreterResult instanceof ValueReturned) {
                value2 = ((ValueReturned)$receiver).getResult();
            } else if (interpreterResult instanceof ExceptionThrown) {
                Void void_;
                if (Intrinsics.areEqual((Object)((Object)((ExceptionThrown)$receiver).getKind()), (Object)((Object)ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE))) {
                    Object v = ((AbstractValue)((ExceptionThrown)$receiver).getException()).getValue();
                    if (v == null) {
                        throw new TypeCastException("kotlin.Any? cannot be cast to com.sun.jdi.ObjectReference");
                    }
                    void_ = this.exception(new InvocationException((ObjectReference)v));
                } else {
                    void_ = this.exception(((ExceptionThrown)$receiver).getException().toString());
                }
                value2 = (Value)((Object)void_);
            } else if (interpreterResult instanceof AbnormalTermination) {
                value2 = (Value)((Object)this.exception(((AbnormalTermination)$receiver).getMessage()));
            } else {
                throw (Throwable)new IllegalStateException("Unknown result value produced by eval4j");
            }
            Value jdiValue = value2;
            return JdiPackage.asJdiValue(jdiValue, vm, jdiValue.getAsmType());
        }

        private final KotlinEvaluateExpressionCache.ParametersDescriptor getParametersForDebugger(@JetValueParameter(name="$receiver") ExtractionResult $receiver) {
            return (KotlinEvaluateExpressionCache.ParametersDescriptor)ApplicationPackage.runReadAction((Function0)new Function0<KotlinEvaluateExpressionCache.ParametersDescriptor>($receiver){
                final /* synthetic */ ExtractionResult receiver$0;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final KotlinEvaluateExpressionCache.ParametersDescriptor invoke() {
                    void var1_1;
                    KotlinEvaluateExpressionCache.ParametersDescriptor parameters2 = new KotlinEvaluateExpressionCache.ParametersDescriptor();
                    Parameter receiver = this.receiver$0.getConfig().getDescriptor().getReceiverParameter();
                    if (receiver != null) {
                        parameters2.add(EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getTHIS_NAME(), receiver.getParameterType(true));
                    }
                    for (Parameter param : this.receiver$0.getConfig().getDescriptor().getParameters()) {
                        String paramName = KotlinPackage.contains$default((String)param.getArgumentText(), (CharSequence)"@", (boolean)false, (int)2) ? KotlinPackage.substringBefore$default((String)param.getArgumentText(), (String)"@", null, (int)2) : (KotlinPackage.startsWith$default((String)param.getArgumentText(), (String)"::", (boolean)false, (int)2) ? KotlinPackage.substring((String)param.getArgumentText(), (int)2) : param.getArgumentText());
                        parameters2.add(paramName, param.getParameterType(true));
                    }
                    return var1_1;
                }
                {
                    this.receiver$0 = extractionResult;
                    super(0);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final List<Value> getArgumentsForEval4j(@JetValueParameter(name="$receiver") EvaluationContextImpl $receiver, @JetValueParameter(name="parameterNames") List<? extends String> parameterNames2, @JetValueParameter(name="parameterTypes") Type[] parameterTypes) {
            void destination;
            void $receiver2;
            void $receiver3;
            FrameVisitor frameVisitor = new FrameVisitor($receiver);
            Iterable iterable = KotlinPackage.zip((Iterable)parameterNames2, (Object[])parameterTypes);
            void var6_6 = $receiver3;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
            for (Object item : $receiver2) {
                Value value2;
                void it;
                Pair pair2 = (Pair)item;
                void var11_11 = destination;
                if (frameVisitor.findValue((String)it.getFirst(), (Type)it.getSecond(), false, true) == null) {
                    Intrinsics.throwNpe();
                }
                var11_11.add(value2);
            }
            return (List)destination;
        }

        private final ClassFileFactory createClassFileFactory(@JetValueParameter(name="codeFragment") JetCodeFragment codeFragment, @JetValueParameter(name="extractedFunction") JetNamedFunction extractedFunction, @JetValueParameter(name="context") EvaluationContextImpl context2, @JetValueParameter(name="parameters") KotlinEvaluateExpressionCache.ParametersDescriptor parameters2) {
            ClassFileFactory classFileFactory = (ClassFileFactory)ApplicationPackage.runReadAction((Function0)new Function0<ClassFileFactory>(codeFragment, extractedFunction, context2, parameters2){
                final /* synthetic */ JetCodeFragment $codeFragment;
                final /* synthetic */ JetNamedFunction $extractedFunction;
                final /* synthetic */ EvaluationContextImpl $context;
                final /* synthetic */ KotlinEvaluateExpressionCache.ParametersDescriptor $parameters;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ClassFileFactory invoke() {
                    Unit unit;
                    void files;
                    void bindingContext2;
                    void moduleDescriptor;
                    JetFile jetFile = EvaluatePackage$KotlinEvaluationBuilder$b91469b6.createFileForDebugger(this.$codeFragment, this.$extractedFunction);
                    ExtendedAnalysisResult extendedAnalysisResult = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$checkForErrors$6(KotlinEvaluator.Companion, jetFile, true);
                    BindingContext bindingContext3 = extendedAnalysisResult.component1();
                    ModuleDescriptor moduleDescriptor2 = extendedAnalysisResult.component2();
                    List<JetFile> list = extendedAnalysisResult.component3();
                    extendedAnalysisResult = null;
                    GenerationState.GenerateClassFilter generateClassFilter2 = new GenerationState.GenerateClassFilter(jetFile){
                        public static final /* synthetic */ KClass $kotlinClass;
                        final /* synthetic */ JetFile $jetFile;

                        static {
                            $kotlinClass = Reflection.createKotlinClass(createClassFileFactory.generateClassFilter.1.class);
                        }

                        public boolean shouldGeneratePackagePart(@JetValueParameter(name="file") @NotNull JetFile file) {
                            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                            return Intrinsics.areEqual((Object)file, (Object)this.$jetFile);
                        }

                        public boolean shouldAnnotateClass(@JetValueParameter(name="classOrObject") @NotNull JetClassOrObject classOrObject) {
                            Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                            return true;
                        }

                        public boolean shouldGenerateClass(@JetValueParameter(name="classOrObject") @NotNull JetClassOrObject classOrObject) {
                            Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                            return Intrinsics.areEqual((Object)classOrObject.getContainingJetFile(), (Object)this.$jetFile);
                        }

                        public boolean shouldGenerateScript(@JetValueParameter(name="script") @NotNull JetScript script) {
                            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                            return false;
                        }
                        {
                            this.$jetFile = $captured_local_variable$0;
                        }
                    };
                    GenerationState state = new GenerationState(jetFile.getProject(), ClassBuilderFactories.BINARIES, Progress.DEAF, (ModuleDescriptor)moduleDescriptor, (BindingContext)bindingContext2, (List<JetFile>)files, true, true, generateClassFilter2, false, false, null, null, DiagnosticSink.DO_NOTHING, null);
                    FrameVisitor frameVisitor = new FrameVisitor(this.$context);
                    JetTypeReference jetTypeReference = this.$extractedFunction.getReceiverTypeReference();
                    if (jetTypeReference != null) {
                        void $receiver;
                        JetTypeReference jetTypeReference2 = jetTypeReference;
                        JetTypeReference it = (JetTypeReference)$receiver;
                        org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$recordAnonymousType$7(KotlinEvaluator.Companion, state.getBindingTrace(), it, EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getTHIS_NAME(), frameVisitor);
                        unit = Unit.INSTANCE$;
                    } else {
                        unit = null;
                    }
                    List<JetParameter> valueParameters = this.$extractedFunction.getValueParameters();
                    int paramIndex = 0;
                    Iterator<Pair<? extends String, ? extends JetType>> iterator2 = this.$parameters.iterator();
                    while (iterator2.hasNext()) {
                        JetParameter valueParameter;
                        JetTypeReference paramRef;
                        void callText;
                        Pair<? extends String, ? extends JetType> param;
                        Pair<? extends String, ? extends JetType> pair2 = param = iterator2.next();
                        String string = (String)pair2.component1();
                        JetType jetType = (JetType)pair2.component2();
                        pair2 = null;
                        if (KotlinPackage.contains$default((String)callText, (CharSequence)EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getTHIS_NAME(), (boolean)false, (int)2)) continue;
                        if ((paramRef = (valueParameter = valueParameters.get(paramIndex++)).getTypeReference()) == null) {
                            EvaluatePackage$KotlinEvaluationBuilder$b91469b6.getLogger().error("Each parameter for extracted function should have a type reference", new Attachment[]{new Attachment("codeFragment.txt", this.$codeFragment.getText()), new Attachment("extractedFunction.txt", this.$extractedFunction.getText())});
                            org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$exception$8(KotlinEvaluator.Companion, "An exception occurs during Evaluate Expression Action");
                        }
                        org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$recordAnonymousType$7(KotlinEvaluator.Companion, state.getBindingTrace(), paramRef, (String)callText, frameVisitor);
                    }
                    KotlinCodegenFacade.compileCorrectFiles(state, CompilationErrorHandler.THROW_EXCEPTION);
                    return state.getFactory();
                }
                {
                    this.$codeFragment = jetCodeFragment;
                    this.$extractedFunction = jetNamedFunction;
                    this.$context = evaluationContextImpl;
                    this.$parameters = parametersDescriptor;
                    super(0);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)classFileFactory, (String)"runReadAction {\n        \u2026etFactory()\n            }");
            return classFileFactory;
        }

        private final void recordAnonymousType(@JetValueParameter(name="$receiver") BindingTrace $receiver, @JetValueParameter(name="typeReference") JetTypeReference typeReference, @JetValueParameter(name="localVariableName") String localVariableName, @JetValueParameter(name="visitor") FrameVisitor visitor2) {
            ClassifierDescriptor declarationDescriptor;
            JetType paramAnonymousType = CodeFragmentUtilPackage.getDebugTypeInfo(typeReference);
            if (paramAnonymousType != null && (declarationDescriptor = paramAnonymousType.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                Value localVariable = visitor2.findValue(localVariableName, null, false, false);
                if (localVariable == null) {
                    this.exception("Couldn't find local variable this in current frame to get classType for anonymous type " + paramAnonymousType + "}");
                }
                $receiver.record(CodegenBinding.ASM_TYPE, declarationDescriptor, localVariable.getAsmType());
            }
        }

        private final Void exception(@JetValueParameter(name="msg") String msg) {
            Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((String)msg);
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.createEvaluateException(msg)");
            throw throwable;
        }

        private final Void exception(@JetValueParameter(name="e") Throwable e) {
            String message = e.getMessage();
            if (message != null) {
                Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((String)message, (Throwable)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026uateException(message, e)");
                throw throwable;
            }
            Throwable throwable = (Throwable)EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.createEvaluateException(e)");
            throw throwable;
        }

        private final ExtendedAnalysisResult checkForErrors(@JetValueParameter(name="$receiver") JetFile $receiver, @JetValueParameter(name="analyzeInlineFunctions") boolean analyzeInlineFunctions) {
            return (ExtendedAnalysisResult)ApplicationPackage.runReadAction((Function0)new Function0<ExtendedAnalysisResult>($receiver, analyzeInlineFunctions){
                final /* synthetic */ JetFile receiver$0;
                final /* synthetic */ boolean $analyzeInlineFunctions;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ExtendedAnalysisResult invoke() {
                    ExtendedAnalysisResult extendedAnalysisResult;
                    Object it;
                    Object v4;
                    Object $receiver;
                    BindingContext bindingContext2;
                    AnalysisResult analysisResult;
                    ResolutionFacade resolutionFacade;
                    block7: {
                        try {
                            AnalyzingUtils.checkForSyntacticErrors((PsiElement)this.receiver$0);
                        }
                        catch (IllegalArgumentException e) {
                            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)e.getMessage());
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026Exception(e.getMessage())");
                            throw throwable;
                        }
                        Project project = this.receiver$0.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"getProject()");
                        resolutionFacade = KotlinCacheService.Companion.getInstance(project).getResolutionFacade(KotlinPackage.listOf((Object[])new JetFile[]{this.receiver$0, EvaluatePackage$KotlinEvaluationBuilder$b91469b6.createFlexibleTypesFile((PsiElement)this.receiver$0)}));
                        Collection collection = Collections.singletonList(this.receiver$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"Collections.singletonList(this)");
                        analysisResult = resolutionFacade.analyzeFullyAndGetResult(collection);
                        if (analysisResult.isError()) {
                            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((Throwable)analysisResult.getError());
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ion(analysisResult.error)");
                            throw throwable;
                        }
                        bindingContext2 = analysisResult.getBindingContext();
                        Iterable iterable = bindingContext2.getDiagnostics();
                        Iterator<T> iterator2 = $receiver.iterator();
                        while (iterator2.hasNext()) {
                            T element = iterator2.next();
                            Diagnostic it2 = (Diagnostic)element;
                            if (!Intrinsics.areEqual((Object)((Object)it2.getSeverity()), (Object)((Object)Severity.ERROR))) continue;
                            v4 = element;
                            break block7;
                        }
                        v4 = null;
                    }
                    Diagnostic diagnostic = v4;
                    if (diagnostic != null) {
                        $receiver = diagnostic;
                        it = $receiver;
                        Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)DefaultErrorMessages.render((Diagnostic)it));
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ErrorMessages.render(it))");
                        throw throwable;
                    }
                    if (this.$analyzeInlineFunctions) {
                        void files;
                        void newBindingContext;
                        Pair<BindingContext, List<JetFile>> pair2 = DebuggerUtils.analyzeInlinedFunctions(resolutionFacade, bindingContext2, this.receiver$0, false);
                        $receiver = (BindingContext)pair2.component1();
                        it = (List)pair2.component2();
                        pair2 = null;
                        void v7 = newBindingContext;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"newBindingContext");
                        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
                        void v9 = files;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"files");
                        extendedAnalysisResult = new ExtendedAnalysisResult((BindingContext)v7, moduleDescriptor, (List<? extends JetFile>)v9);
                    } else {
                        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
                        List<JetFile> list = Collections.singletonList(this.receiver$0);
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.singletonList(this)");
                        extendedAnalysisResult = new ExtendedAnalysisResult(bindingContext2, moduleDescriptor, list);
                    }
                    return extendedAnalysisResult;
                }
                {
                    this.receiver$0 = jetFile;
                    this.$analyzeInlineFunctions = bl;
                    super(0);
                }
            });
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ List<Value> access$getArgumentsForEval4j$2(@JetValueParameter(name="$this", type="?") Companion $this, @JetValueParameter(name="$receiver") EvaluationContextImpl $receiver, @JetValueParameter(name="parameterNames") @NotNull List<? extends String> parameterNames2, @JetValueParameter(name="parameterTypes") @NotNull Type[] parameterTypes) {
            return $this.getArgumentsForEval4j($receiver, parameterNames2, parameterTypes);
        }

        @NotNull
        public static final /* synthetic */ Value access$boxOrUnboxArgumentIfNeeded$3(@JetValueParameter(name="$this", type="?") Companion $this, @JetValueParameter(name="eval") @NotNull JDIEval eval, @JetValueParameter(name="argumentValue") @NotNull Value argumentValue, @JetValueParameter(name="parameterType") @NotNull Type parameterType) {
            return $this.boxOrUnboxArgumentIfNeeded(eval, argumentValue, parameterType);
        }

        @NotNull
        public static final /* synthetic */ ExtendedAnalysisResult access$checkForErrors$6(@JetValueParameter(name="$this", type="?") Companion $this, @JetValueParameter(name="$receiver") JetFile $receiver, @JetValueParameter(name="analyzeInlineFunctions") boolean analyzeInlineFunctions) {
            return $this.checkForErrors($receiver, analyzeInlineFunctions);
        }

        public static final /* synthetic */ void access$recordAnonymousType$7(@JetValueParameter(name="$this", type="?") Companion $this, @JetValueParameter(name="$receiver") BindingTrace $receiver, @JetValueParameter(name="typeReference") @NotNull JetTypeReference typeReference, @JetValueParameter(name="localVariableName") @NotNull String localVariableName, @JetValueParameter(name="visitor") @NotNull FrameVisitor visitor2) {
            $this.recordAnonymousType($receiver, typeReference, localVariableName, visitor2);
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$10() {
            return new Companion();
        }

        @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0003\b)1R\t\u001f;f]\u0012,G-\u00118bYf\u001c\u0018n\u001d*fgVdGOC\u0005D_6\u0004\u0018M\\5p]*y1j\u001c;mS:,e/\u00197vCR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0011\u0011,'-^4hKJT\u0001\"\u001a<bYV\fG/\u001a\u0006\u0004\u0003:L(B\u0002\u001fj]&$hH\u0003\bcS:$\u0017N\\4D_:$X\r\u001f;\u000b\u001d\tKg\u000eZ5oO\u000e{g\u000e^3yi*9!/Z:pYZ,'\u0002E7pIVdW\rR3tGJL\u0007\u000f^8s\u0015Aiu\u000eZ;mK\u0012+7o\u0019:jaR|'OC\u0006eKN\u001c'/\u001b9u_J\u001c(\"\u00024jY\u0016\u001c(\u0002\u0002'jgRTqAS3u\r&dWMC\u0002qg&TAA[1wC*!Q\u000f^5m\u0015E9W\r\u001e\"j]\u0012LgnZ\"p]R,\u0007\u0010\u001e\u0006\tO\u0016$h)\u001b7fg*\u0019r-\u001a;N_\u0012,H.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*Q1m\\7q_:,g\u000e^\u0019\u000b\u0015\r|W\u000e]8oK:$(G\u0003\u0006d_6\u0004xN\\3oiNRAaY8qs*\u00014j\u001c;mS:,e/\u00197vCR|'\u000fJ\"p[B\fg.[8oI\u0015CH/\u001a8eK\u0012\fe.\u00197zg&\u001c(+Z:vYRT\u001aA\u0003\u0002\u0011\u0007)!\u0001\u0002\u0001\t\u0005\u0015\u0011A\u0011\u0001E\u0003\u000b\t!\u0011\u0001C\u0002\u0006\u0005\u0011\r\u0001rA\u0003\u0003\t\tAA!B\u0002\u0005\u0006!\tA\u0002A\u0003\u0004\t\rA\t\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u0001\u0002\u0001\u0007\u0001\u000b\u0005A)!B\u0002\u0005\n!%A\u0002A\u0003\u0003\t\u0005Ai!B\u0002\u0005\f!1A\u0002A\u0003\u0003\t\u0005A\u0001\"B\u0002\u0005\u000e!=A\u0002A\u0003\u0004\t\u0013A\u0011\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001BC\u0003\u0004\t!A\u0019\u0002\u0004\u0001\u0006\u0005\u0011-\u0001BB\u0003\u0003\t\u001bAy!B\u0001\t\u0016\u0015\u0011AA\u0003\u0005\f\u000b\t!)\u0002C\u0005\u0006\u0005\u0011\u0015\u0001b\u0004C\u0002\u0019\u0011I\"!B\u0001\t\u000b5zA\u0001\u0019\u0003\u0019\f\u0005\u0012Q!\u0001\u0005\u0007+\u000eAQa\u0001C\u0006\u0013\u0005A\u0011\"D\u0002\u0005\u0018%\t\u0001\"C\u0017\u0014\t\u0001$\u0001\u0014C\u0011\u0007\u000b\u0005Ay!C\u0002\n\u0005\u0015\t\u0001\u0012C+\u0004\u0011\u0015\u0019A\u0011C\u0005\u0002\u0011-i1\u0001\u0002\u0007\n\u0003!YQf\u0004\u0003a\ta9\u0011EA\u0003\u0002\u0011\u001d)6\u0001C\u0003\u0004\t\u001dI\u0011\u0001c\u0005\u000e\u0007\u0011e\u0011\"\u0001E\n[)!\u0001i\u0001\r\u000eC\t)\u0011\u0001\u0003\u0004R\u0007\r!Q\"C\u0001\t\u00135RA\u0001Q\u0002\u0019\u001c\u0005\u0012Q!\u0001\u0005\b#\u000e\u0019A1D\u0005\u0002\u0011'ic\u0002\u0002!\u000419\tc!B\u0001\t\u0010%\u0019\u0011BA\u0003\u0002\u0011#\t6a\u0001\u0003\u000f\u0013\u0005A1\",\u0016\u0005\u0007\u000eAj\"(\u0004\u0005\u0003!-QBA\u0003\u0002\u0011\u0019\u00016\u0001AO\u0007\t\u0005Aq!\u0004\u0002\u0006\u0003!9\u0001k!\u0001\u001e\u0016\u0011\t\u0001\u0012C\u0007\u0007\u000b\u0005Ay!C\u0002\n\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0003\u0005\u0012Q!\u0001\u0005\u0005#\u000eIAQD\u0005\u0002\u0011/i\u0011\u0001C\u0005\u000e\u0003!MQ\"\u0001\u0005\fk/*)\u0006Br\u00011\u0015ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001\u0005\u0007!\u000e\u0001QT\u0002\u0003\u0001\u0011\u001di!!B\u0001\t\u000fA\u001b\t!(\u0006\u0005\u0001!EQBB\u0003\u0002\u0011\u001fI1!\u0003\u0002\u0006\u0003!E\u0001kA\u0001\"\u0005\u0015\t\u0001\u0002B)\u0004\u0013\u0011)\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0011\"D\u0001\t\u00145\t\u0001b\u0003"})
        @data
        private static final class ExtendedAnalysisResult {
            public static final /* synthetic */ KClass $kotlinClass;
            @NotNull
            private final BindingContext bindingContext;
            @NotNull
            private final ModuleDescriptor moduleDescriptor;
            @NotNull
            private final List<? extends JetFile> files;

            static {
                $kotlinClass = Reflection.createKotlinClass(ExtendedAnalysisResult.class);
            }

            @NotNull
            public final BindingContext getBindingContext() {
                return this.bindingContext;
            }

            @NotNull
            public final ModuleDescriptor getModuleDescriptor() {
                return this.moduleDescriptor;
            }

            @NotNull
            public final List<JetFile> getFiles() {
                return this.files;
            }

            public ExtendedAnalysisResult(@JetValueParameter(name="bindingContext") @NotNull BindingContext bindingContext2, @JetValueParameter(name="moduleDescriptor") @NotNull ModuleDescriptor moduleDescriptor, @JetValueParameter(name="files") @NotNull List<? extends JetFile> files) {
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                this.bindingContext = bindingContext2;
                this.moduleDescriptor = moduleDescriptor;
                this.files = files;
            }

            @NotNull
            public final BindingContext component1() {
                return this.bindingContext;
            }

            @NotNull
            public final ModuleDescriptor component2() {
                return this.moduleDescriptor;
            }

            @NotNull
            public final List<JetFile> component3() {
                return this.files;
            }

            @NotNull
            public final ExtendedAnalysisResult copy(@JetValueParameter(name="bindingContext") @NotNull BindingContext bindingContext2, @JetValueParameter(name="moduleDescriptor") @NotNull ModuleDescriptor moduleDescriptor, @JetValueParameter(name="files") @NotNull List<? extends JetFile> files) {
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                return new ExtendedAnalysisResult(bindingContext2, moduleDescriptor, files);
            }

            @NotNull
            public static /* synthetic */ ExtendedAnalysisResult copy$default(ExtendedAnalysisResult extendedAnalysisResult, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor, List list, int n) {
                if ((n & 1) != 0) {
                    bindingContext2 = extendedAnalysisResult.bindingContext;
                }
                if ((n & 2) != 0) {
                    moduleDescriptor = extendedAnalysisResult.moduleDescriptor;
                }
                if ((n & 4) != 0) {
                    list = extendedAnalysisResult.files;
                }
                return extendedAnalysisResult.copy(bindingContext2, moduleDescriptor, list);
            }

            public String toString() {
                return "ExtendedAnalysisResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ")";
            }

            public int hashCode() {
                BindingContext bindingContext2 = this.bindingContext;
                ModuleDescriptor moduleDescriptor = this.moduleDescriptor;
                List<? extends JetFile> list = this.files;
                return ((bindingContext2 != null ? bindingContext2.hashCode() : 0) * 31 + (moduleDescriptor != null ? moduleDescriptor.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ExtendedAnalysisResult)) break block3;
                        ExtendedAnalysisResult extendedAnalysisResult = (ExtendedAnalysisResult)object;
                        if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)extendedAnalysisResult.bindingContext) || !Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)extendedAnalysisResult.moduleDescriptor) || !Intrinsics.areEqual(this.files, extendedAnalysisResult.files)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

