/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jdi.ClassLoaderReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.CompilingEvaluatorUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.ClassBytes;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class CompilingEvaluatorPackage$compilingEvaluator$0a9f45bb {
    @NotNull
    static final List<? extends ClassBytes> LAMBDA_SUPERCLASSES = KotlinPackage.listOf((Object[])new ClassBytes[]{new ClassBytes("kotlin.jvm.internal.FunctionImpl"), new ClassBytes("kotlin.jvm.internal.Lambda")});

    public static final void loadClasses(@JetValueParameter(name="evaluationContext") @NotNull EvaluationContextImpl evaluationContext, @JetValueParameter(name="classes") @NotNull Collection<? extends Pair<? extends String, ? extends byte[]>> classes2) {
        ClassLoaderReference classLoader;
        Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        DebugProcessImpl process2 = evaluationContext.getDebugProcess();
        try {
            ClassLoaderReference classLoaderReference = CompilingEvaluatorUtils.getClassLoader((EvaluationContext)evaluationContext, (DebugProcess)process2);
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoaderReference, (String)"CompilingEvaluatorUtils.\u2026aluationContext, process)");
            classLoader = classLoaderReference;
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error creating evaluation class loader: " + e, (Throwable)e);
        }
        String version = process2.getVirtualMachineProxy().version();
        JavaSdkVersion sdkVersion = JdkVersionUtil.getVersion((String)version);
        if (!SystemInfo.isJavaVersionAtLeast((String)sdkVersion.getDescription())) {
            throw (Throwable)new EvaluateException("Unable to compile for target level " + sdkVersion.getDescription() + ". Need to run IDEA on java version at least " + sdkVersion.getDescription() + ", currently running on " + SystemInfo.JAVA_RUNTIME_VERSION);
        }
        try {
            EvaluationContext evaluationContext2 = (EvaluationContext)evaluationContext;
            DebugProcess debugProcess = (DebugProcess)process2;
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcess, (String)"process");
            CompilingEvaluatorPackage$compilingEvaluator$0a9f45bb.defineClasses(classes2, evaluationContext2, debugProcess, classLoader);
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error during classes definition " + e, (Throwable)e);
        }
        evaluationContext.setClassLoader(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    public static final void defineClasses(@JetValueParameter(name="classes") @NotNull Collection<? extends Pair<? extends String, ? extends byte[]>> classes2, @JetValueParameter(name="context") @NotNull EvaluationContext context2, @JetValueParameter(name="process") @NotNull DebugProcess process2, @JetValueParameter(name="classLoader") @NotNull ClassLoaderReference classLoader) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        Iterable iterable2 = LAMBDA_SUPERCLASSES;
        Iterator iterator2 = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            ClassBytes classBytes = (ClassBytes)item;
            void var11_10 = destination;
            Pair pair2 = KotlinPackage.to((Object)it.getName(), (Object)it.getBytes());
            var11_10.add(pair2);
        }
        List lambdaSuperclasses = (List)destination;
        for (Iterable iterable2 : KotlinPackage.plus((Iterable)lambdaSuperclasses, (Iterable)classes2)) {
            String className = (String)iterable2.component1();
            byte[] bytes2 = (byte[])iterable2.component2();
            CompilingEvaluatorUtils.defineClass(className, bytes2, context2, process2, classLoader);
        }
    }

    @NotNull
    public static final List<ClassBytes> getLAMBDA_SUPERCLASSES() {
        return LAMBDA_SUPERCLASSES;
    }
}

