/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorsPackage;
import org.jetbrains.kotlin.di.InjectorForLazyResolve;
import org.jetbrains.kotlin.idea.decompiler.navigation.MemberMatching;
import org.jetbrains.kotlin.idea.stubindex.JetFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.types.DynamicTypesSettings;

public class JetSourceNavigationHelper {
    private static boolean forceResolve = false;

    private JetSourceNavigationHelper() {
    }

    @Nullable
    public static JetClassOrObject getSourceClassOrObject(@NotNull JetClassOrObject decompiledClassOrObject) {
        if (decompiledClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledClassOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getSourceClassOrObject"));
        }
        return JetSourceNavigationHelper.getSourceForNamedClassOrObject(decompiledClassOrObject);
    }

    @NotNull
    private static GlobalSearchScope createLibrarySourcesScope(@NotNull JetNamedDeclaration decompiledDeclaration) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createLibrarySourcesScope"));
        }
        JetFile containingFile2 = decompiledDeclaration.getContainingJetFile();
        VirtualFile libraryFile = containingFile2.getVirtualFile();
        if (libraryFile == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createLibrarySourcesScope"));
            }
            return globalSearchScope;
        }
        Project project = decompiledDeclaration.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (!projectFileIndex.isInLibraryClasses(libraryFile)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createLibrarySourcesScope"));
            }
            return globalSearchScope;
        }
        LinkedHashSet sourceRootSet = Sets.newLinkedHashSet();
        for (OrderEntry entry : projectFileIndex.getOrderEntriesForFile(libraryFile)) {
            if (!(entry instanceof LibraryOrSdkOrderEntry)) continue;
            KotlinPackage.addAll((Collection)sourceRootSet, (Object[])entry.getFiles(OrderRootType.SOURCES));
        }
        LibrarySourcesScope librarySourcesScope = new LibrarySourcesScope(project, sourceRootSet);
        if (librarySourcesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createLibrarySourcesScope"));
        }
        return librarySourcesScope;
    }

    private static List<JetFile> getContainingFiles(@NotNull Iterable<JetNamedDeclaration> declarations2) {
        if (declarations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getContainingFiles"));
        }
        HashSet result2 = Sets.newHashSet();
        for (JetNamedDeclaration declaration : declarations2) {
            PsiFile containingFile2 = declaration.getContainingFile();
            if (!(containingFile2 instanceof JetFile)) continue;
            result2.add((JetFile)containingFile2);
        }
        return Lists.newArrayList((Iterable)result2);
    }

    private static boolean haveRenamesInImports(@NotNull List<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "haveRenamesInImports"));
        }
        for (JetFile file : files) {
            for (JetImportDirective importDirective : file.getImportDirectives()) {
                if (importDirective.getAliasName() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static JetNamedDeclaration findSpecialProperty(@NotNull Name memberName, @NotNull JetClass containingClass) {
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "findSpecialProperty"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "findSpecialProperty"));
        }
        List<JetParameter> constructorParameters = containingClass.getPrimaryConstructorParameters();
        for (JetParameter constructorParameter : constructorParameters) {
            if (!memberName.equals(constructorParameter.getNameAsName()) || !constructorParameter.hasValOrVarNode()) continue;
            return constructorParameter;
        }
        if (containingClass.hasModifier(JetTokens.ENUM_KEYWORD)) {
            for (JetEnumEntry enumEntry : ContainerUtil.findAll(containingClass.getDeclarations(), JetEnumEntry.class)) {
                if (!memberName.equals(enumEntry.getNameAsName())) continue;
                return enumEntry;
            }
        }
        return null;
    }

    @Nullable
    private static JetNamedDeclaration getSourcePropertyOrFunction(@NotNull JetNamedDeclaration decompiledDeclaration) {
        Collection<JetNamedDeclaration> candidates;
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getSourcePropertyOrFunction"));
        }
        String memberNameAsString = decompiledDeclaration.getName();
        assert (memberNameAsString != null);
        Name memberName = Name.identifier(memberNameAsString);
        PsiElement decompiledContainer = decompiledDeclaration.getParent();
        if (decompiledContainer instanceof JetFile) {
            candidates = JetSourceNavigationHelper.getInitialTopLevelCandidates(decompiledDeclaration);
        } else if (decompiledContainer instanceof JetClassBody) {
            JetClassOrObject decompiledClassOrObject = (JetClassOrObject)decompiledContainer.getParent();
            JetClassOrObject sourceClassOrObject = JetSourceNavigationHelper.getSourceClassOrObject(decompiledClassOrObject);
            Collection<Object> collection = candidates = sourceClassOrObject == null ? Collections.emptyList() : JetSourceNavigationHelper.getInitialMemberCandidates(sourceClassOrObject, memberName, decompiledDeclaration.getClass());
            if (candidates.isEmpty() && decompiledDeclaration instanceof JetProperty && sourceClassOrObject instanceof JetClass) {
                return JetSourceNavigationHelper.findSpecialProperty(memberName, (JetClass)sourceClassOrObject);
            }
        } else {
            throw new IllegalStateException("Unexpected container of decompiled declaration: " + decompiledContainer.getClass().getSimpleName());
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (!forceResolve) {
            if ((candidates = JetSourceNavigationHelper.filterByReceiverPresenceAndParametersCount(decompiledDeclaration, candidates)).size() <= 1) {
                return candidates.isEmpty() ? null : candidates.iterator().next();
            }
            if (!JetSourceNavigationHelper.haveRenamesInImports(JetSourceNavigationHelper.getContainingFiles(candidates)) && (candidates = JetSourceNavigationHelper.filterByReceiverAndParameterTypes(decompiledDeclaration, candidates)).size() <= 1) {
                return candidates.isEmpty() ? null : candidates.iterator().next();
            }
        }
        KotlinCodeAnalyzer analyzer = JetSourceNavigationHelper.createAnalyzer(candidates, decompiledDeclaration.getProject());
        for (JetNamedDeclaration candidate : candidates) {
            CallableDescriptor candidateDescriptor = (CallableDescriptor)analyzer.resolveToDescriptor(candidate);
            if (!MemberMatching.receiversMatch(decompiledDeclaration, candidateDescriptor) || !MemberMatching.valueParametersTypesMatch(decompiledDeclaration, candidateDescriptor) || !MemberMatching.typeParametersMatch((JetTypeParameterListOwner)decompiledDeclaration, candidateDescriptor.getTypeParameters())) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    private static KotlinCodeAnalyzer createAnalyzer(@NotNull Collection<JetNamedDeclaration> candidates, @NotNull Project project) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createAnalyzer"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createAnalyzer"));
        }
        MutableModuleContext newModuleContext = ContextPackage.ContextForNewModule(project, Name.special("<library module>"), DescriptorsPackage.ModuleParameters(TopDownAnalyzerFacadeForJVM.DEFAULT_IMPORTS, PlatformToKotlinClassMap.EMPTY));
        newModuleContext.setDependencies(newModuleContext.getModule(), KotlinBuiltIns.getInstance().getBuiltInsModule());
        FileBasedDeclarationProviderFactory providerFactory = new FileBasedDeclarationProviderFactory(newModuleContext.getStorageManager(), JetSourceNavigationHelper.getContainingFiles(candidates));
        ResolveSession resolveSession = new InjectorForLazyResolve(newModuleContext, providerFactory, new BindingTraceContext(), AdditionalCheckerProvider.DefaultProvider.INSTANCE$, new DynamicTypesSettings()).getResolveSession();
        newModuleContext.initializeModuleContents(resolveSession.getPackageFragmentProvider());
        ResolveSession resolveSession2 = resolveSession;
        if (resolveSession2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "createAnalyzer"));
        }
        return resolveSession2;
    }

    @Nullable
    private static JetClassOrObject getSourceForNamedClassOrObject(@NotNull JetClassOrObject decompiledClassOrObject) {
        if (decompiledClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledClassOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getSourceForNamedClassOrObject"));
        }
        FqName classFqName = decompiledClassOrObject.getFqName();
        assert (classFqName != null);
        GlobalSearchScope librarySourcesScope = JetSourceNavigationHelper.createLibrarySourcesScope(decompiledClassOrObject);
        if (librarySourcesScope == GlobalSearchScope.EMPTY_SCOPE) {
            return null;
        }
        Collection<JetClassOrObject> classes2 = JetFullClassNameIndex.getInstance().get(classFqName.asString(), decompiledClassOrObject.getProject(), librarySourcesScope);
        if (classes2.isEmpty()) {
            return null;
        }
        return classes2.iterator().next();
    }

    @NotNull
    private static Collection<JetNamedDeclaration> getInitialTopLevelCandidates(@NotNull JetNamedDeclaration decompiledDeclaration) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialTopLevelCandidates"));
        }
        FqName memberFqName = decompiledDeclaration.getFqName();
        assert (memberFqName != null);
        GlobalSearchScope librarySourcesScope = JetSourceNavigationHelper.createLibrarySourcesScope(decompiledDeclaration);
        if (librarySourcesScope == GlobalSearchScope.EMPTY_SCOPE) {
            List<JetNamedDeclaration> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialTopLevelCandidates"));
            }
            return list;
        }
        StringStubIndexExtension<? extends JetNamedDeclaration> index2 = JetSourceNavigationHelper.getIndexForTopLevelPropertyOrFunction(decompiledDeclaration);
        Collection collection = index2.get((Object)memberFqName.asString(), decompiledDeclaration.getProject(), librarySourcesScope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialTopLevelCandidates"));
        }
        return collection;
    }

    private static StringStubIndexExtension<? extends JetNamedDeclaration> getIndexForTopLevelPropertyOrFunction(@NotNull JetNamedDeclaration decompiledDeclaration) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getIndexForTopLevelPropertyOrFunction"));
        }
        if (decompiledDeclaration instanceof JetNamedFunction) {
            return JetTopLevelFunctionFqnNameIndex.getInstance();
        }
        if (decompiledDeclaration instanceof JetProperty) {
            return JetTopLevelPropertyFqnNameIndex.getInstance();
        }
        throw new IllegalArgumentException("Neither function nor declaration: " + decompiledDeclaration.getClass().getName());
    }

    @NotNull
    private static List<JetNamedDeclaration> getInitialMemberCandidates(@NotNull JetClassOrObject sourceClassOrObject, final @NotNull Name name2, @NotNull Class<JetNamedDeclaration> declarationClass) {
        if (sourceClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceClassOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialMemberCandidates"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialMemberCandidates"));
        }
        if (declarationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationClass", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialMemberCandidates"));
        }
        List allByClass = ContainerUtil.findAll(sourceClassOrObject.getDeclarations(), declarationClass);
        List list = ContainerUtil.filter((Collection)allByClass, (Condition)new Condition<JetNamedDeclaration>(){

            public boolean value(JetNamedDeclaration declaration) {
                return name2.equals(declaration.getNameAsSafeName());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getInitialMemberCandidates"));
        }
        return list;
    }

    @NotNull
    private static List<JetNamedDeclaration> filterByReceiverPresenceAndParametersCount(final @NotNull JetNamedDeclaration decompiledDeclaration, @NotNull Collection<JetNamedDeclaration> candidates) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverPresenceAndParametersCount"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverPresenceAndParametersCount"));
        }
        List list = ContainerUtil.filter(candidates, (Condition)new Condition<JetNamedDeclaration>(){

            public boolean value(JetNamedDeclaration candidate) {
                return MemberMatching.sameReceiverPresenceAndParametersCount(candidate, decompiledDeclaration);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverPresenceAndParametersCount"));
        }
        return list;
    }

    @NotNull
    private static List<JetNamedDeclaration> filterByReceiverAndParameterTypes(final @NotNull JetNamedDeclaration decompiledDeclaration, @NotNull Collection<JetNamedDeclaration> candidates) {
        if (decompiledDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledDeclaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverAndParameterTypes"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverAndParameterTypes"));
        }
        List list = ContainerUtil.filter(candidates, (Condition)new Condition<JetNamedDeclaration>(){

            public boolean value(JetNamedDeclaration candidate) {
                return MemberMatching.receiverAndParametersShortTypesMatch(candidate, decompiledDeclaration);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "filterByReceiverAndParameterTypes"));
        }
        return list;
    }

    @Nullable
    public static JetNamedDeclaration getSourceProperty(@NotNull JetProperty decompiledProperty) {
        if (decompiledProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledProperty", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getSourceProperty"));
        }
        return JetSourceNavigationHelper.getSourcePropertyOrFunction(decompiledProperty);
    }

    @Nullable
    public static JetNamedDeclaration getSourceFunction(@NotNull JetNamedFunction decompiledFunction) {
        if (decompiledFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledFunction", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getSourceFunction"));
        }
        return JetSourceNavigationHelper.getSourcePropertyOrFunction(decompiledFunction);
    }

    public static void setForceResolve(boolean forceResolve) {
        JetSourceNavigationHelper.forceResolve = forceResolve;
    }

    @Nullable
    public static PsiClass getOriginalPsiClassOrCreateLightClass(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getOriginalPsiClassOrCreateLightClass"));
        }
        if (LightClassUtil.belongsToKotlinBuiltIns(classOrObject.getContainingJetFile())) {
            Name className = classOrObject.getNameAsName();
            assert (className != null) : "Class from BuiltIns should have a name";
            ClassDescriptor classDescriptor = KotlinBuiltIns.getInstance().getBuiltInClassByName(className);
            ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtils.getFqName(classDescriptor));
            if (javaClassId != null) {
                return JavaPsiFacade.getInstance((Project)classOrObject.getProject()).findClass(javaClassId.asSingleFqName().asString(), GlobalSearchScope.allScope((Project)classOrObject.getProject()));
            }
        }
        return LightClassUtil.getPsiClass(classOrObject);
    }

    @Nullable
    public static PsiClass getOriginalClass(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "getOriginalClass"));
        }
        String internalName = PsiCodegenPredictor.getPredefinedJvmInternalName(classOrObject);
        if (internalName == null) {
            return null;
        }
        String fqName2 = JvmClassName.byInternalName(internalName).getFqNameForClassNameWithoutDollars().asString();
        JetFile file = classOrObject.getContainingJetFile();
        VirtualFile vFile = file.getVirtualFile();
        Project project = file.getProject();
        final ProjectFileIndex idx = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return null;
        }
        THashSet orderEntries = new THashSet((Collection)idx.getOrderEntriesForFile(vFile));
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName2, new GlobalSearchScope(project, (Set)orderEntries){
            final /* synthetic */ Set val$orderEntries;
            {
                this.val$orderEntries = set;
                super(x0);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$4", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$4", "compare"));
                }
                return 0;
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$4", "contains"));
                }
                List entries = idx.getOrderEntriesForFile(file);
                for (OrderEntry entry : entries) {
                    if (!this.val$orderEntries.contains(entry)) continue;
                    return true;
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$4", "isSearchInModuleContent"));
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        });
    }

    @NotNull
    public static JetDeclaration replaceBySourceDeclarationIfPresent(@NotNull JetDeclaration original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "replaceBySourceDeclarationIfPresent"));
        }
        JetDeclaration sourceElement = original.accept(new SourceForDecompiledExtractingVisitor(), null);
        JetDeclaration jetDeclaration = sourceElement != null ? sourceElement : original;
        if (jetDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper", "replaceBySourceDeclarationIfPresent"));
        }
        return jetDeclaration;
    }

    private static class LibrarySourcesScope
    extends GlobalSearchScope {
        private final Set<VirtualFile> sources;
        private final ProjectFileIndex fileIndex;

        public LibrarySourcesScope(Project project, Set<VirtualFile> sources) {
            super(project);
            this.fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            this.sources = sources;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$LibrarySourcesScope", "contains"));
            }
            if (this.fileIndex.isInLibrarySource(file)) {
                return this.sources.contains(this.fileIndex.getSourceRootForFile(file));
            }
            return false;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$LibrarySourcesScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$LibrarySourcesScope", "compare"));
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$LibrarySourcesScope", "isSearchInModuleContent"));
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }

    private static class SourceForDecompiledExtractingVisitor
    extends JetVisitor<JetDeclaration, Void> {
        private SourceForDecompiledExtractingVisitor() {
        }

        @Override
        public JetDeclaration visitNamedFunction(@NotNull JetNamedFunction function2, Void data2) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceForDecompiledExtractingVisitor", "visitNamedFunction"));
            }
            return JetSourceNavigationHelper.getSourceFunction(function2);
        }

        @Override
        public JetDeclaration visitProperty(@NotNull JetProperty property, Void data2) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceForDecompiledExtractingVisitor", "visitProperty"));
            }
            return JetSourceNavigationHelper.getSourceProperty(property);
        }

        @Override
        public JetDeclaration visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, Void data2) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceForDecompiledExtractingVisitor", "visitObjectDeclaration"));
            }
            return JetSourceNavigationHelper.getSourceClassOrObject(declaration);
        }

        @Override
        public JetDeclaration visitClass(@NotNull JetClass klass, Void data2) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceForDecompiledExtractingVisitor", "visitClass"));
            }
            return JetSourceNavigationHelper.getSourceClassOrObject(klass);
        }

        @Override
        public JetDeclaration visitParameter(@NotNull JetParameter parameter, Void data2) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/decompiler/navigation/JetSourceNavigationHelper$SourceForDecompiledExtractingVisitor", "visitParameter"));
            }
            JetCallableDeclaration callableDeclaration = (JetCallableDeclaration)parameter.getParent().getParent();
            List<JetParameter> parameters2 = callableDeclaration.getValueParameters();
            int index2 = parameters2.indexOf(parameter);
            JetCallableDeclaration sourceCallable = (JetCallableDeclaration)callableDeclaration.accept(this, null);
            if (sourceCallable == null) {
                return null;
            }
            List<JetParameter> sourceParameters = sourceCallable.getValueParameters();
            if (sourceParameters.size() != parameters2.size()) {
                return null;
            }
            return sourceParameters.get(index2);
        }
    }
}

