/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDynamicType;
import org.jetbrains.kotlin.psi.JetFunctionType;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeConstraint;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.types.JetType;

public class MemberMatching {
    @Nullable
    private static JetTypeReference getReceiverType(@NotNull JetNamedDeclaration propertyOrFunction) {
        if (propertyOrFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyOrFunction", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "getReceiverType"));
        }
        if (propertyOrFunction instanceof JetNamedFunction) {
            return ((JetNamedFunction)propertyOrFunction).getReceiverTypeReference();
        }
        if (propertyOrFunction instanceof JetProperty) {
            return ((JetProperty)propertyOrFunction).getReceiverTypeReference();
        }
        throw new IllegalArgumentException("Neither function nor declaration: " + propertyOrFunction.getClass().getName());
    }

    @NotNull
    private static List<JetParameter> getValueParameters(@NotNull JetNamedDeclaration propertyOrFunction) {
        if (propertyOrFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyOrFunction", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "getValueParameters"));
        }
        if (propertyOrFunction instanceof JetNamedFunction) {
            List<JetParameter> list = ((JetNamedFunction)propertyOrFunction).getValueParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "getValueParameters"));
            }
            return list;
        }
        if (propertyOrFunction instanceof JetProperty) {
            List<JetParameter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "getValueParameters"));
            }
            return list;
        }
        throw new IllegalArgumentException("Neither function nor declaration: " + propertyOrFunction.getClass().getName());
    }

    private static String getTypeShortName(@NotNull JetTypeReference typeReference) {
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "getTypeShortName"));
        }
        JetTypeElement typeElement = typeReference.getTypeElement();
        assert (typeElement != null);
        return typeElement.accept(new JetVisitor<String, Void>(){

            @Override
            public String visitDeclaration(@NotNull JetDeclaration declaration, Void data2) {
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching$1", "visitDeclaration"));
                }
                throw new IllegalStateException("This visitor shouldn't be invoked for " + declaration.getClass());
            }

            @Override
            public String visitUserType(@NotNull JetUserType type2, Void data2) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching$1", "visitUserType"));
                }
                JetSimpleNameExpression referenceExpression = type2.getReferenceExpression();
                assert (referenceExpression != null);
                return referenceExpression.getReferencedName();
            }

            @Override
            public String visitFunctionType(@NotNull JetFunctionType type2, Void data2) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching$1", "visitFunctionType"));
                }
                KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
                int parameterCount = type2.getParameters().size();
                if (type2.getReceiverTypeReference() == null) {
                    return builtIns.getFunction(parameterCount).getName().asString();
                }
                return builtIns.getExtensionFunction(parameterCount).getName().asString();
            }

            @Override
            public String visitNullableType(@NotNull JetNullableType nullableType, Void data2) {
                if (nullableType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullableType", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching$1", "visitNullableType"));
                }
                JetTypeElement innerType = nullableType.getInnerType();
                assert (innerType != null) : "No inner type: " + nullableType;
                return innerType.accept(this, null);
            }

            @Override
            public String visitDynamicType(@NotNull JetDynamicType type2, Void data2) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching$1", "visitDynamicType"));
                }
                return "dynamic";
            }
        }, null);
    }

    private static boolean typesHaveSameShortName(@NotNull JetTypeReference a, @NotNull JetTypeReference b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "typesHaveSameShortName"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "typesHaveSameShortName"));
        }
        return MemberMatching.getTypeShortName(a).equals(MemberMatching.getTypeShortName(b));
    }

    static boolean sameReceiverPresenceAndParametersCount(@NotNull JetNamedDeclaration a, @NotNull JetNamedDeclaration b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "sameReceiverPresenceAndParametersCount"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "sameReceiverPresenceAndParametersCount"));
        }
        boolean sameReceiverPresence = MemberMatching.getReceiverType(a) == null == (MemberMatching.getReceiverType(b) == null);
        boolean sameParametersCount = MemberMatching.getValueParameters(a).size() == MemberMatching.getValueParameters(b).size();
        return sameReceiverPresence && sameParametersCount;
    }

    static boolean receiverAndParametersShortTypesMatch(@NotNull JetNamedDeclaration a, @NotNull JetNamedDeclaration b) {
        JetTypeReference bReceiver;
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "receiverAndParametersShortTypesMatch"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "receiverAndParametersShortTypesMatch"));
        }
        JetTypeReference aReceiver = MemberMatching.getReceiverType(a);
        if (aReceiver == null != ((bReceiver = MemberMatching.getReceiverType(b)) == null)) {
            return false;
        }
        if (aReceiver != null && !MemberMatching.typesHaveSameShortName(aReceiver, bReceiver)) {
            return false;
        }
        List<JetParameter> aParameters = MemberMatching.getValueParameters(a);
        List<JetParameter> bParameters = MemberMatching.getValueParameters(b);
        if (aParameters.size() != bParameters.size()) {
            return false;
        }
        for (int i = 0; i < aParameters.size(); ++i) {
            JetTypeReference aType = aParameters.get(i).getTypeReference();
            JetTypeReference bType = bParameters.get(i).getTypeReference();
            assert (aType != null);
            assert (bType != null);
            if (MemberMatching.typesHaveSameShortName(aType, bType)) continue;
            return false;
        }
        return true;
    }

    static boolean receiversMatch(@NotNull JetNamedDeclaration declaration, @NotNull CallableDescriptor descriptor2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "receiversMatch"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "receiversMatch"));
        }
        JetTypeReference declarationReceiver = MemberMatching.getReceiverType(declaration);
        ReceiverParameterDescriptor descriptorReceiver = descriptor2.getExtensionReceiverParameter();
        if (declarationReceiver == null && descriptorReceiver == null) {
            return true;
        }
        if (declarationReceiver != null && descriptorReceiver != null) {
            return declarationReceiver.getText().equals(DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(descriptorReceiver.getType()));
        }
        return false;
    }

    static boolean valueParametersTypesMatch(@NotNull JetNamedDeclaration declaration, @NotNull CallableDescriptor descriptor2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "valueParametersTypesMatch"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "valueParametersTypesMatch"));
        }
        List<JetParameter> declarationParameters = MemberMatching.getValueParameters(declaration);
        List<ValueParameterDescriptor> descriptorParameters = descriptor2.getValueParameters();
        if (descriptorParameters.size() != declarationParameters.size()) {
            return false;
        }
        for (int i = 0; i < descriptorParameters.size(); ++i) {
            JetType typeToRender;
            boolean varargInDescriptor;
            ValueParameterDescriptor descriptorParameter = descriptorParameters.get(i);
            JetParameter declarationParameter = declarationParameters.get(i);
            JetTypeReference typeReference = declarationParameter.getTypeReference();
            if (typeReference == null) {
                return false;
            }
            JetModifierList modifierList = declarationParameter.getModifierList();
            boolean varargInDeclaration = modifierList != null && modifierList.hasModifier(JetTokens.VARARG_KEYWORD);
            boolean bl = varargInDescriptor = descriptorParameter.getVarargElementType() != null;
            if (varargInDeclaration != varargInDescriptor) {
                return false;
            }
            String declarationTypeText = typeReference.getText();
            JetType jetType = typeToRender = varargInDeclaration ? descriptorParameter.getVarargElementType() : descriptorParameter.getType();
            assert (typeToRender != null);
            String descriptorParameterText = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(typeToRender);
            if (declarationTypeText.equals(descriptorParameterText)) continue;
            return false;
        }
        return true;
    }

    static boolean typeParametersMatch(@NotNull JetTypeParameterListOwner typeParameterListOwner, @NotNull List<TypeParameterDescriptor> typeParameterDescriptors2) {
        if (typeParameterListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterListOwner", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "typeParametersMatch"));
        }
        if (typeParameterDescriptors2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptors", "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching", "typeParametersMatch"));
        }
        List<JetTypeParameter> decompiledParameters = typeParameterListOwner.getTypeParameters();
        if (decompiledParameters.size() != typeParameterDescriptors2.size()) {
            return false;
        }
        HashMultimap decompiledParameterToBounds = HashMultimap.create();
        for (JetTypeParameter parameter : decompiledParameters) {
            JetTypeReference extendsBound = parameter.getExtendsBound();
            if (extendsBound == null) continue;
            decompiledParameterToBounds.put((Object)parameter.getNameAsName(), (Object)extendsBound.getText());
        }
        for (JetTypeConstraint typeConstraint : typeParameterListOwner.getTypeConstraints()) {
            JetSimpleNameExpression typeParameterName = typeConstraint.getSubjectTypeParameterName();
            assert (typeParameterName != null);
            JetTypeReference bound = typeConstraint.getBoundTypeReference();
            assert (bound != null);
            decompiledParameterToBounds.put((Object)typeParameterName.getReferencedNameAsName(), (Object)bound.getText());
        }
        for (int i = 0; i < decompiledParameters.size(); ++i) {
            HashSet decompiledUpperBounds;
            JetTypeParameter decompiledParameter = decompiledParameters.get(i);
            TypeParameterDescriptor descriptor2 = typeParameterDescriptors2.get(i);
            Name name2 = decompiledParameter.getNameAsName();
            assert (name2 != null);
            if (!name2.equals(descriptor2.getName())) {
                return false;
            }
            HashSet descriptorUpperBounds = Sets.newHashSet((Iterable)ContainerUtil.map(descriptor2.getUpperBounds(), (Function)new Function<JetType, String>(){

                public String fun(JetType type2) {
                    return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2);
                }
            }));
            HashSet hashSet = decompiledUpperBounds = decompiledParameterToBounds.get((Object)descriptor2.getName()).isEmpty() ? Sets.newHashSet((Object[])new String[]{DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(KotlinBuiltIns.getInstance().getDefaultBound())}) : Sets.newHashSet((Iterable)decompiledParameterToBounds.get((Object)descriptor2.getName()));
            if (((Object)descriptorUpperBounds).equals(decompiledUpperBounds)) continue;
            return false;
        }
        return true;
    }

    private MemberMatching() {
    }
}

