/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.impl.compiled.ClassFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import java.io.ByteArrayInputStream;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.AnnotationLoaderForKotlinJavaScriptStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.DecompilerPackage$DecompiledUtils$e48171b5;
import org.jetbrains.kotlin.idea.decompiler.navigation.JsMetaFileUtils;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.StubBuilderPackage$clsStubBuilding$36e65c17;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedKotlinJavaScriptDataFinder;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedKotlinJavaScriptMetaFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.js.JsPackage;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"?\b)Y2j\u001c;mS:T\u0015M^1TGJL\u0007\u000f^*uk\n\u0014U/\u001b7eKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017M\u0003\u0006eK\u000e|W\u000e]5mKJT1b\u001d;vE\n+\u0018\u000e\u001c3fe*q1\t\\:TiV\u0014')^5mI\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0002qg&T\u0001bY8na&dW\r\u001a\u0006\u0007y%t\u0017\u000e\u001e \u000b\u001b\t,\u0018\u000e\u001c3GS2,7\u000b^;c\u0015\u001d\u0019wN\u001c;f]RT1BR5mK\u000e{g\u000e^3oi*!Q\u000f^5m\u0015!Ig\u000eZ3yS:<'b\u0003)tS\u001aKG.Z*uk\nTQa\u001d;vENT1d\u0019:fCR,7\u000b^;c\u0005VLG\u000eZ3s\u0007>l\u0007o\u001c8f]R\u001c(\u0002\u00024jY\u0016T1BV5siV\fGNR5mK*9q\u000e]3oCBL'b\u0001<gg*i\u0001/Y2lC\u001e,g)\u001d(b[\u0016TaAR9OC6,'\u0002\u00028b[\u0016TAB\\1nKJ+7o\u001c7wKJTABT1nKJ+7o\u001c7wKJTQb]3sS\u0006d\u0017N_1uS>t'b\u00043fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b1\rc7o\u0015;vE\n+\u0018\u000e\u001c3fe\u000e{W\u000e]8oK:$8OC\be_\n+\u0018\u000e\u001c3GS2,7\u000b^;c\u0015\u001dQU\r\u001e$jY\u0016TabZ3u'R,(MV3sg&|gNC\u0002J]RT\u0011bQ8na\u0006t\u0017n\u001c8g\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)!\u0001\u0002\u0002\t\u0007\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0003\t\u0011AQ!\u0002\u0002\u0005\n!-Qa\u0001\u0003\u0006\u0011\u000fa\u0001!\u0002\u0002\u0005\t!AQA\u0001\u0003\u0007\u0011#)1\u0001\"\u0004\t\u00101\u0001QA\u0001C\u0005\u0011')1\u0001b\u0004\t\u00131\u0001QA\u0001C\b\u0011%)!\u0001\"\u0004\t\u0010\u0015\u0011A\u0001\u0002E\f\u000b\t!\u0019\u0002\u0003\u0007\u0006\u0007\u0011Q\u0001b\u0003\u0007\u0001\u000b\t!\u0011\u0001c\u0007\u0006\u0007\u0011Y\u0001\"\u0004\u0007\u0001\u000b\t!\u0011\u0001C\b\u0006\u0005\u0011a\u0001rD\u0003\u0004\t3Ai\u0002\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0005\u0007\u0001\u000b\t!)\u0001\u0003\t\u0006\u0005\u0011Q\u0001bC\u0003\u0003\t-AQ\"\u0002\u0002\u0005\u001a!uQA\u0001\u0003\u0002\u0011\u0015)1\u0001\u0002\t\t#1\u0001Q!\u0001E\u0002\u000b\r!\u0011\u0003\u0003\n\r\u0001\u0011YAb\u0001I\u00133\t)\u0011\u0001c\u0003\u001d&52Ba\u0003M\u0007;\u001b!\u0001\u0001C\u0004\u000e\u0005\u0015\t\u0001b\u0002)\u0004\u0001\u0005*Q!\u0001\u0005\t\u0013\u0005!\u0019\u0001$\u0001R\u0007\u0015!i!C\u0001\t\u00125\t\u0001\"C\u0017'\t\u0005A\"\"(\u0004\u0005\u0001!UQBA\u0003\u0002\u0011+\u00016\u0001AO\u0007\t\u0001AI\"\u0004\u0002\u0006\u0003!]\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001BD\u0007\u0003\u000b\u0005AQ\u0002U\u0002\u0002C\t)\u0011\u0001c\u0007R\u0007%!!\"C\u0001\t\u001d5\t\u0001RD\u0007\u0002\u0011=i\u0011\u0001c\b.1\u0011\u0001\u0001\u0014EO\u0007\t\u0001A)\"\u0004\u0002\u0006\u0003!U\u0001k\u0001\u0001\"\u000f\u0015\t\u0001\u0002C\u0005\u0004\u0013\t)\u0011\u0001#\t\r\u0002E\u001bQ\u0001\"\t\n\u0003!EQ\"\u0001E\u000f['!1\u0002g\t\"\u0005\u0015\t\u00012E)\u0004\u0007\u0011\r\u0012\"\u0001C\u0003k-)!\u0002Br\u00011\u0019\t#!B\u0001\t\u0007E\u001b1\u0001\u0002\u0004\n\u0003\u0011\u0001\u0001"})
public class KotlinJavaScriptStubBuilder
extends ClsStubBuilder {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final Logger LOG;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinJavaScriptStubBuilder.class);
        OBJECT$ = Companion = org.jetbrains.kotlin.idea.decompiler.stubBuilder.KotlinJavaScriptStubBuilder$Companion.access$init$0();
        LOG = Logger.getInstance(KotlinJavaScriptStubBuilder.class);
    }

    public int getStubVersion() {
        return ClassFileStubBuilder.STUB_VERSION + 1;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@JetValueParameter(name="content") @NotNull FileContent content) {
        VirtualFile file;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        VirtualFile virtualFile = file = content.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
        if (DecompilerPackage$DecompiledUtils$e48171b5.isKotlinJavaScriptInternalCompiledFile(virtualFile)) {
            return null;
        }
        VirtualFile virtualFile2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        return this.doBuildFileStub(virtualFile2);
    }

    @Nullable
    public final PsiFileStub<JetFile> doBuildFileStub(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        NameResolver nameResolver;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        FqName packageFqName = JsMetaFileUtils.INSTANCE$.getPackageFqName(file);
        byte[] content = file.contentsToByteArray(false);
        boolean isPackageHeader = JsMetaFileUtils.INSTANCE$.isPackageHeader(file);
        VirtualFile moduleDirectory = JsMetaFileUtils.INSTANCE$.getModuleDirectory(file);
        String stringsFileName = KotlinJavascriptSerializedResourcePaths.INSTANCE$.getStringTableFilePath(packageFqName);
        VirtualFile stringsFile = moduleDirectory.findFileByRelativePath(stringsFileName);
        KotlinPackage.assert((stringsFile != null ? 1 : 0) != 0, (Object)("strings file not found: " + stringsFileName));
        VirtualFile virtualFile = stringsFile;
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        NameResolver nameResolver2 = nameResolver = NameResolver.read(new ByteArrayInputStream(virtualFile.contentsToByteArray(false)));
        Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver2, (String)"nameResolver");
        ClsStubBuilderComponents components = this.createStubBuilderComponents(file, packageFqName, nameResolver2);
        if (isPackageHeader) {
            NameResolver nameResolver3 = nameResolver;
            Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver3, (String)"nameResolver");
            PackageData packageData = JsPackage.toPackageData(content, nameResolver3);
            NameResolver nameResolver4 = packageData.getNameResolver();
            Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver4, (String)"packageData.getNameResolver()");
            ClsStubBuilderContext context2 = components.createContext(nameResolver4, packageFqName);
            ProtoBuf.Package package_ = packageData.getPackageProto();
            Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"packageData.getPackageProto()");
            return StubBuilderPackage$clsStubBuilding$36e65c17.createPackageFacadeFileStub(package_, packageFqName, context2);
        }
        NameResolver nameResolver5 = nameResolver;
        Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver5, (String)"nameResolver");
        ClassData classData = JsPackage.toClassData(content, nameResolver5);
        NameResolver nameResolver6 = classData.getNameResolver();
        Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver6, (String)"classData.getNameResolver()");
        ClsStubBuilderContext context3 = components.createContext(nameResolver6, packageFqName);
        ClassId classId = JsMetaFileUtils.INSTANCE$.getClassId(file);
        ProtoBuf.Class clazz = classData.getClassProto();
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"classData.getClassProto()");
        return StubBuilderPackage$clsStubBuilding$36e65c17.createTopLevelClassStub(classId, clazz, context3);
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(@JetValueParameter(name="file") VirtualFile file, @JetValueParameter(name="packageFqName") FqName packageFqName, @JetValueParameter(name="nameResolver") NameResolver nameResolver) {
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        DirectoryBasedKotlinJavaScriptMetaFileFinder metaFileFinder = new DirectoryBasedKotlinJavaScriptMetaFileFinder(virtualFile, packageFqName, nameResolver);
        Logger logger = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        DirectoryBasedKotlinJavaScriptDataFinder classDataFinder = new DirectoryBasedKotlinJavaScriptDataFinder(metaFileFinder, logger);
        AnnotationLoaderForKotlinJavaScriptStubBuilder annotationLoader = new AnnotationLoaderForKotlinJavaScriptStubBuilder();
        return new ClsStubBuilderComponents(classDataFinder, annotationLoader);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"M\u0004)I1i\\7qC:LwN\u001c\u0006\u001c\u0017>$H.\u001b8KCZ\f7k\u0019:jaR\u001cF/\u001e2Ck&dG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*QA-Z2p[BLG.\u001a:\u000b\u0017M$XO\u0019\"vS2$WM\u001d\u0006\u0004\u0003:L(b\u0001'P\u000f*1Aj\\4hKJT1aY8n\u0015!Ig\u000e^3mY&T'bB8qK:\f\u0007/\u001b\u0006\u000bI&\fwM\\8ti&\u001c'b\u0002(pi:+H\u000e\u001c\u0006\fC:tw\u000e^1uS>t7OC\fl_Rd\u0017N\u001c\u0018km6t\u0003\u000b\\1uM>\u0014X\u000eV=qK*1q-\u001a;M\u001f\u001e\u0003(B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!\u0002\u0002\u0005\u0005!\u001dQa\u0001C\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0007!\u0001A\u0002A\u0003\u0002\u0011\t)1\u0001\u0002\u0003\t\t1\u0001Q!\u0001E\u0006\u000b\t!Q\u0001\u0003\u0004\u0006\u0005\u0011-\u0001RB\u0003\u0003\t\u0019Aq!B\u0002\u0005\u000e!)A\u0002A\u0003\u0003\t\u0003A\u0001\"B\u0002\u0005\u0010!=A\u0002A\u0003\u0003\t\u001bAQ\u0001Bb\u0002\u0019\u000fI\"!B\u0001\t\n5RB\u0001\u0019\u0003\u0019\n\u0005bQ!\u0001\u0005\b!#)Z!B\u0001\t\u000f1\u0005\u0011kA\u0001\u0005\u0011E\u001b\u0011\u0001\u0002\u0005V\u0007%)A\u0001\"\u0003\n\u0003!EA\u0012A\u0007\u0004\t%I\u0011\u0001#\u00056\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$0() {
            return new Companion();
        }
    }
}

