/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.textBuilder;

import com.intellij.openapi.vfs.VirtualFile;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DeserializerForDecompiler;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.FqName;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class TextBuilderPackage$DeserializerForDecompiler$0a7c4e0c {
    @NotNull
    public static final DeserializerForDecompiler DeserializerForDecompiler(@JetValueParameter(name="classFile") @NotNull VirtualFile classFile) {
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        KotlinJvmBinaryClass kotlinClass = KotlinBinaryClassCache.getKotlinBinaryClass(classFile);
        boolean value2 = kotlinClass != null;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value2) {
            String message = "Decompiled data factory shouldn't be called on an unsupported file: " + classFile;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass = kotlinClass;
        if (kotlinJvmBinaryClass == null) {
            Intrinsics.throwNpe();
        }
        FqName packageFqName = kotlinJvmBinaryClass.getClassId().getPackageFqName();
        VirtualFile virtualFile = classFile.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        return new DeserializerForDecompiler(virtualFile, fqName2);
    }
}

