/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.handlers;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.findUsages.FindUsagesPackage;
import org.jetbrains.kotlin.idea.findUsages.KotlinCallableFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinFindUsagesHandlerFactory;
import org.jetbrains.kotlin.idea.findUsages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.KotlinFindFunctionUsagesDialog;
import org.jetbrains.kotlin.idea.findUsages.dialogs.KotlinFindPropertyUsagesDialog;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinFindUsagesHandler;
import org.jetbrains.kotlin.idea.search.declarationsSearch.DeclarationsSearchPackage;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearch;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchHelper;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchRequest;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;

public abstract class KotlinFindMemberUsagesHandler<T extends JetNamedDeclaration>
extends KotlinFindUsagesHandler<T> {
    protected KotlinFindMemberUsagesHandler(@NotNull T declaration, @NotNull Collection<? extends PsiElement> elementsToSearch, @NotNull KotlinFindUsagesHandlerFactory factory2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "<init>"));
        }
        if (elementsToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToSearch", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "<init>"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "<init>"));
        }
        super(declaration, elementsToSearch, factory2);
    }

    protected abstract UsagesSearchHelper<T> getSearchHelper(KotlinCallableFindUsagesOptions var1);

    private static Iterable<PsiMethod> getLightMethods(JetNamedDeclaration element) {
        if (element instanceof JetNamedFunction || element instanceof JetSecondaryConstructor) {
            PsiMethod method = LightClassUtil.getLightClassMethod((JetFunction)element);
            return method != null ? Collections.singletonList(method) : Collections.emptyList();
        }
        if (element instanceof JetProperty) {
            return LightClassUtil.getLightClassPropertyMethods((JetProperty)element);
        }
        if (element instanceof JetParameter) {
            return LightClassUtil.getLightClassPropertyMethods((JetParameter)element);
        }
        return null;
    }

    @Override
    protected boolean searchReferences(final @NotNull PsiElement element, final @NotNull Processor<UsageInfo> processor, final @NotNull FindUsagesOptions options) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "searchReferences"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "searchReferences"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "searchReferences"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                PsiMethod psiMethod;
                KotlinCallableFindUsagesOptions kotlinOptions = (KotlinCallableFindUsagesOptions)options;
                UsagesSearchRequest request = KotlinFindMemberUsagesHandler.this.getSearchHelper(kotlinOptions).newRequest(FindUsagesPackage.toSearchTarget(options, (JetNamedDeclaration)element, true));
                final CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
                for (PsiReference ref : UsagesSearch.INSTANCE$.search(request)) {
                    KotlinFindUsagesHandler.processUsage((Processor<UsageInfo>)uniqueProcessor, ref);
                }
                Object object = element instanceof PsiMethod ? (PsiMethod)element : (psiMethod = element instanceof JetSecondaryConstructor ? LightClassUtil.getLightClassMethod((JetFunction)element) : null);
                if (psiMethod != null) {
                    for (PsiReference ref : MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)options.searchScope, (boolean)true)) {
                        KotlinFindUsagesHandler.processUsage((Processor<UsageInfo>)uniqueProcessor, ref.getElement());
                    }
                }
                if (kotlinOptions.getSearchOverrides()) {
                    DeclarationsSearchPackage.searchOverriders(new HierarchySearchRequest<PsiElement>(element, options.searchScope, true)).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiMethod>(){

                        public boolean execute(@NotNull PsiMethod method) {
                            if (method == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$1$1", "execute"));
                            }
                            return KotlinFindUsagesHandler.processUsage((Processor<UsageInfo>)uniqueProcessor, method.getNavigationElement());
                        }
                    }));
                }
                return true;
            }
        });
    }

    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "isSearchForTextOccurencesAvailable"));
        }
        return !isSingleFile;
    }

    @NotNull
    public static KotlinFindMemberUsagesHandler<? extends JetNamedDeclaration> getInstance(@NotNull JetNamedDeclaration declaration, @NotNull Collection<? extends PsiElement> elementsToSearch, @NotNull KotlinFindUsagesHandlerFactory factory2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "getInstance"));
        }
        if (elementsToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToSearch", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "getInstance"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "getInstance"));
        }
        KotlinFindMemberUsagesHandler kotlinFindMemberUsagesHandler = declaration instanceof JetFunction ? new Function((JetFunction)declaration, elementsToSearch, factory2) : new Property(declaration, elementsToSearch, factory2);
        if (kotlinFindMemberUsagesHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "getInstance"));
        }
        return kotlinFindMemberUsagesHandler;
    }

    @NotNull
    public static KotlinFindMemberUsagesHandler<? extends JetNamedDeclaration> getInstance(@NotNull JetNamedDeclaration declaration, @NotNull KotlinFindUsagesHandlerFactory factory2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "getInstance"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "getInstance"));
        }
        KotlinFindMemberUsagesHandler<JetNamedDeclaration> kotlinFindMemberUsagesHandler = KotlinFindMemberUsagesHandler.getInstance(declaration, Collections.emptyList(), factory2);
        if (kotlinFindMemberUsagesHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler", "getInstance"));
        }
        return kotlinFindMemberUsagesHandler;
    }

    private static class Property
    extends KotlinFindMemberUsagesHandler<JetNamedDeclaration> {
        public Property(@NotNull JetNamedDeclaration declaration, @NotNull Collection<? extends PsiElement> elementsToSearch, @NotNull KotlinFindUsagesHandlerFactory factory2) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Property", "<init>"));
            }
            if (elementsToSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToSearch", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Property", "<init>"));
            }
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Property", "<init>"));
            }
            super(declaration, elementsToSearch, factory2);
        }

        @Override
        protected UsagesSearchHelper<JetNamedDeclaration> getSearchHelper(KotlinCallableFindUsagesOptions options) {
            return FindUsagesPackage.toHelper((KotlinPropertyFindUsagesOptions)options);
        }

        @NotNull
        public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
            KotlinPropertyFindUsagesOptions kotlinPropertyFindUsagesOptions = this.getFactory().getFindPropertyOptions();
            if (kotlinPropertyFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Property", "getFindUsagesOptions"));
            }
            return kotlinPropertyFindUsagesOptions;
        }

        @NotNull
        public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
            KotlinFindPropertyUsagesDialog kotlinFindPropertyUsagesDialog = new KotlinFindPropertyUsagesDialog((PsiElement)this.getElement(), this.getProject(), this.getFactory().getFindPropertyOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
            if (kotlinFindPropertyUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Property", "getFindUsagesDialog"));
            }
            return kotlinFindPropertyUsagesDialog;
        }
    }

    private static class Function
    extends KotlinFindMemberUsagesHandler<JetFunction> {
        public Function(@NotNull JetFunction declaration, @NotNull Collection<? extends PsiElement> elementsToSearch, @NotNull KotlinFindUsagesHandlerFactory factory2) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Function", "<init>"));
            }
            if (elementsToSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToSearch", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Function", "<init>"));
            }
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Function", "<init>"));
            }
            super(declaration, elementsToSearch, factory2);
        }

        @Override
        protected UsagesSearchHelper<JetFunction> getSearchHelper(KotlinCallableFindUsagesOptions options) {
            return FindUsagesPackage.toHelper((KotlinFunctionFindUsagesOptions)options);
        }

        @NotNull
        public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
            KotlinFunctionFindUsagesOptions kotlinFunctionFindUsagesOptions = this.getFactory().getFindFunctionOptions();
            if (kotlinFunctionFindUsagesOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Function", "getFindUsagesOptions"));
            }
            return kotlinFunctionFindUsagesOptions;
        }

        @NotNull
        public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
            KotlinFunctionFindUsagesOptions options = this.getFactory().getFindFunctionOptions();
            Iterator lightMethods = KotlinFindMemberUsagesHandler.getLightMethods((JetNamedDeclaration)this.getElement()).iterator();
            if (lightMethods.hasNext()) {
                KotlinFindFunctionUsagesDialog kotlinFindFunctionUsagesDialog = new KotlinFindFunctionUsagesDialog((PsiMethod)lightMethods.next(), this.getProject(), options, toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
                if (kotlinFindFunctionUsagesDialog == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Function", "getFindUsagesDialog"));
                }
                return kotlinFindFunctionUsagesDialog;
            }
            AbstractFindUsagesDialog abstractFindUsagesDialog = super.getFindUsagesDialog(isSingleFile, toShowInNewTab, mustOpenInNewTab);
            if (abstractFindUsagesDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindMemberUsagesHandler$Function", "getFindUsagesDialog"));
            }
            return abstractFindUsagesDialog;
        }
    }
}

