/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.idea.core.formatter.JetCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;
import org.jetbrains.kotlin.idea.formatter.NodeAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.idea.formatter.SyntheticKotlinBlock;
import org.jetbrains.kotlin.idea.formatter.WrappingStrategy;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetDeclaration;

public class JetBlock
extends AbstractBlock {
    private static final int KDOC_COMMENT_INDENT = 1;
    private final NodeAlignmentStrategy myAlignmentStrategy;
    private final Indent myIndent;
    private final CodeStyleSettings mySettings;
    private final KotlinSpacingBuilder mySpacingBuilder;
    private List<Block> mySubBlocks;
    private static final TokenSet BINARY_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{JetNodeTypes.BINARY_EXPRESSION, JetNodeTypes.BINARY_WITH_TYPE, JetNodeTypes.IS_EXPRESSION});
    private static final TokenSet QUALIFIED_OPERATION = TokenSet.create((IElementType[])new IElementType[]{JetTokens.DOT, JetTokens.SAFE_ACCESS});
    private static final TokenSet ALIGN_FOR_BINARY_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{JetTokens.MUL, JetTokens.DIV, JetTokens.PERC, JetTokens.PLUS, JetTokens.MINUS, JetTokens.ELVIS, JetTokens.LT, JetTokens.GT, JetTokens.LTEQ, JetTokens.GTEQ, JetTokens.ANDAND, JetTokens.OROR});
    private static final TokenSet CODE_BLOCKS = TokenSet.create((IElementType[])new IElementType[]{JetNodeTypes.BLOCK, JetNodeTypes.CLASS_BODY, JetNodeTypes.FUNCTION_LITERAL});
    private static final TokenSet KDOC_CONTENT = TokenSet.create((IElementType[])new IElementType[]{KDocTokens.KDOC, KDocElementTypes.KDOC_SECTION, KDocElementTypes.KDOC_TAG});
    private static final NodeIndentStrategy[] INDENT_RULES = new NodeIndentStrategy[]{NodeIndentStrategy.strategy("No indent for braces in blocks").in(JetNodeTypes.BLOCK, JetNodeTypes.CLASS_BODY, JetNodeTypes.FUNCTION_LITERAL).forType(JetTokens.RBRACE, JetTokens.LBRACE).set(Indent.getNoneIndent()), NodeIndentStrategy.strategy("Indent for block content").in(JetNodeTypes.BLOCK, JetNodeTypes.CLASS_BODY, JetNodeTypes.FUNCTION_LITERAL).notForType(JetTokens.RBRACE, JetTokens.LBRACE, JetNodeTypes.BLOCK).set(Indent.getNormalIndent((boolean)false)), NodeIndentStrategy.strategy("Indent for property accessors").in(JetNodeTypes.PROPERTY, new IElementType[0]).forType(JetNodeTypes.PROPERTY_ACCESSOR, new IElementType[0]).set(Indent.getNormalIndent()), NodeIndentStrategy.strategy("For a single statement in 'for'").in(JetNodeTypes.BODY, new IElementType[0]).notForType(JetNodeTypes.BLOCK, new IElementType[0]).set(Indent.getNormalIndent()), NodeIndentStrategy.strategy("For the entry in when").forType(JetNodeTypes.WHEN_ENTRY, new IElementType[0]).set(Indent.getNormalIndent()), NodeIndentStrategy.strategy("For single statement in THEN and ELSE").in(JetNodeTypes.THEN, JetNodeTypes.ELSE).notForType(JetNodeTypes.BLOCK, new IElementType[0]).set(Indent.getNormalIndent()), NodeIndentStrategy.strategy("Indent for parts").in(JetNodeTypes.PROPERTY, JetNodeTypes.FUN, JetNodeTypes.MULTI_VARIABLE_DECLARATION).notForType(JetNodeTypes.BLOCK, JetTokens.FUN_KEYWORD, JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD).set(Indent.getContinuationWithoutFirstIndent()), NodeIndentStrategy.strategy("Chained calls").in(JetNodeTypes.DOT_QUALIFIED_EXPRESSION, JetNodeTypes.SAFE_ACCESS_EXPRESSION).set(Indent.getContinuationWithoutFirstIndent((boolean)false)), NodeIndentStrategy.strategy("Delegation list").in(JetNodeTypes.DELEGATION_SPECIFIER_LIST, JetNodeTypes.INITIALIZER_LIST).set(Indent.getContinuationIndent((boolean)false)), NodeIndentStrategy.strategy("Indices").in(JetNodeTypes.INDICES, new IElementType[0]).set(Indent.getContinuationIndent((boolean)false)), NodeIndentStrategy.strategy("Binary expressions").in(BINARY_EXPRESSIONS).set(Indent.getContinuationWithoutFirstIndent((boolean)false)), NodeIndentStrategy.strategy("Parenthesized expression").in(JetNodeTypes.PARENTHESIZED, new IElementType[0]).set(Indent.getContinuationWithoutFirstIndent((boolean)false)), NodeIndentStrategy.strategy("KDoc comment indent").in(KDOC_CONTENT).forType(KDocTokens.LEADING_ASTERISK, KDocTokens.END).set(Indent.getSpaceIndent((int)1)), NodeIndentStrategy.strategy("Block in when entry").in(JetNodeTypes.WHEN_ENTRY, new IElementType[0]).notForType(JetNodeTypes.BLOCK, JetNodeTypes.WHEN_CONDITION_EXPRESSION, JetNodeTypes.WHEN_CONDITION_IN_RANGE, JetNodeTypes.WHEN_CONDITION_IS_PATTERN, JetTokens.ELSE_KEYWORD, JetTokens.ARROW).set(Indent.getNormalIndent())};

    public JetBlock(@NotNull ASTNode node2, @NotNull NodeAlignmentStrategy alignmentStrategy, Indent indent, Wrap wrap, CodeStyleSettings settings, KotlinSpacingBuilder spacingBuilder) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/idea/formatter/JetBlock", "<init>"));
        }
        if (alignmentStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alignmentStrategy", "org/jetbrains/kotlin/idea/formatter/JetBlock", "<init>"));
        }
        super(node2, wrap, alignmentStrategy.getAlignment(node2));
        this.myAlignmentStrategy = alignmentStrategy;
        this.myIndent = indent;
        this.mySettings = settings;
        this.mySpacingBuilder = spacingBuilder;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    protected List<Block> buildChildren() {
        if (this.mySubBlocks == null) {
            int operationBlockIndex;
            List nodeSubBlocks = this.buildSubBlocks();
            if ((this.getNode().getElementType() == JetNodeTypes.DOT_QUALIFIED_EXPRESSION || this.getNode().getElementType() == JetNodeTypes.SAFE_ACCESS_EXPRESSION) && (operationBlockIndex = JetBlock.findNodeBlockIndex(nodeSubBlocks, QUALIFIED_OPERATION)) != -1) {
                Block operationBlock = nodeSubBlocks.get(operationBlockIndex);
                SyntheticKotlinBlock operationSynteticBlock = new SyntheticKotlinBlock(((ASTBlock)operationBlock).getNode(), nodeSubBlocks.subList(operationBlockIndex, nodeSubBlocks.size()), null, operationBlock.getIndent(), null, this.mySpacingBuilder);
                nodeSubBlocks = (List)ContainerUtil.addAll((Collection)ContainerUtil.newArrayList(nodeSubBlocks.subList(0, operationBlockIndex)), (Object[])new SyntheticKotlinBlock[]{operationSynteticBlock});
            }
            this.mySubBlocks = nodeSubBlocks;
        }
        return this.mySubBlocks;
    }

    private List<Block> buildSubBlocks() {
        ArrayList<Block> blocks2 = new ArrayList<Block>();
        NodeAlignmentStrategy childrenAlignmentStrategy = this.getChildrenAlignmentStrategy();
        WrappingStrategy wrappingStrategy = this.getWrappingStrategy();
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType childType = child.getElementType();
            if (child.getTextRange().getLength() == 0 || childType == TokenType.WHITE_SPACE) continue;
            blocks2.add(this.buildSubBlock(child, childrenAlignmentStrategy, wrappingStrategy));
        }
        return Collections.unmodifiableList(blocks2);
    }

    @NotNull
    private Block buildSubBlock(@NotNull ASTNode child, NodeAlignmentStrategy alignmentStrategy, @NotNull WrappingStrategy wrappingStrategy) {
        ASTNode operationNode;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/idea/formatter/JetBlock", "buildSubBlock"));
        }
        if (wrappingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappingStrategy", "org/jetbrains/kotlin/idea/formatter/JetBlock", "buildSubBlock"));
        }
        Wrap wrap = wrappingStrategy.getWrap(child.getElementType());
        if (child.getElementType() == JetNodeTypes.OPERATION_REFERENCE && (operationNode = child.getFirstChildNode()) != null) {
            JetBlock jetBlock = new JetBlock(operationNode, alignmentStrategy, JetBlock.createChildIndent(child), wrap, this.mySettings, this.mySpacingBuilder);
            if (jetBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "buildSubBlock"));
            }
            return jetBlock;
        }
        JetBlock jetBlock = new JetBlock(child, alignmentStrategy, JetBlock.createChildIndent(child), wrap, this.mySettings, this.mySpacingBuilder);
        if (jetBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "buildSubBlock"));
        }
        return jetBlock;
    }

    private static ASTNode getPrevWithoutWhitespace(ASTNode node2) {
        for (node2 = node2.getTreePrev(); node2 != null && node2.getElementType() == TokenType.WHITE_SPACE; node2 = node2.getTreePrev()) {
        }
        return node2;
    }

    private static ASTNode getPrevWithoutWhitespaceAndComments(ASTNode node2) {
        for (node2 = node2.getTreePrev(); node2 != null && (node2.getElementType() == TokenType.WHITE_SPACE || JetTokens.COMMENTS.contains(node2.getElementType())); node2 = node2.getTreePrev()) {
        }
        return node2;
    }

    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getSpacing"));
        }
        return this.mySpacingBuilder.getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        IElementType type2 = this.getNode().getElementType();
        if (CODE_BLOCKS.contains(type2) || type2 == JetNodeTypes.WHEN || type2 == JetNodeTypes.IF || type2 == JetNodeTypes.FOR || type2 == JetNodeTypes.WHILE || type2 == JetNodeTypes.DO_WHILE) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == JetNodeTypes.TRY) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == JetNodeTypes.DOT_QUALIFIED_EXPRESSION || type2 == JetNodeTypes.SAFE_ACCESS_EXPRESSION) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == JetNodeTypes.VALUE_PARAMETER_LIST || type2 == JetNodeTypes.VALUE_ARGUMENT_LIST) {
            if (newChildIndex != 1 && newChildIndex != 0 && newChildIndex < this.getSubBlocks().size()) {
                Block block = (Block)this.getSubBlocks().get(newChildIndex);
                ChildAttributes childAttributes = new ChildAttributes(block.getIndent(), block.getAlignment());
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = new ChildAttributes(Indent.getContinuationIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == JetTokens.DOC_COMMENT) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (type2 == JetNodeTypes.PARENTHESIZED) {
            ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        List blocks2 = this.getSubBlocks();
        if (newChildIndex != 0) {
            boolean isIncomplete;
            boolean bl = isIncomplete = newChildIndex < blocks2.size() ? ((Block)blocks2.get(newChildIndex - 1)).isIncomplete() : this.isIncomplete();
            if (isIncomplete) {
                ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    @NotNull
    private static WrappingStrategy getWrappingStrategyForItemList(int wrapType, final @NotNull IElementType itemType) {
        if (itemType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemType", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getWrappingStrategyForItemList"));
        }
        final Wrap itemWrap = Wrap.createWrap((int)wrapType, (boolean)false);
        WrappingStrategy wrappingStrategy = new WrappingStrategy(){

            @Override
            @Nullable
            public Wrap getWrap(@NotNull IElementType childElementType) {
                if (childElementType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childElementType", "org/jetbrains/kotlin/idea/formatter/JetBlock$1", "getWrap"));
                }
                return childElementType == itemType ? itemWrap : null;
            }
        };
        if (wrappingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getWrappingStrategyForItemList"));
        }
        return wrappingStrategy;
    }

    @NotNull
    private WrappingStrategy getWrappingStrategy() {
        IElementType parentElementType;
        CommonCodeStyleSettings commonSettings = this.mySettings.getCommonSettings((Language)JetLanguage.INSTANCE);
        IElementType elementType = this.myNode.getElementType();
        if (elementType == JetNodeTypes.VALUE_ARGUMENT_LIST) {
            WrappingStrategy wrappingStrategy = JetBlock.getWrappingStrategyForItemList(commonSettings.CALL_PARAMETERS_WRAP, JetNodeTypes.VALUE_ARGUMENT);
            if (wrappingStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getWrappingStrategy"));
            }
            return wrappingStrategy;
        }
        if (elementType == JetNodeTypes.VALUE_PARAMETER_LIST && ((parentElementType = this.myNode.getTreeParent().getElementType()) == JetNodeTypes.FUN || parentElementType == JetNodeTypes.CLASS)) {
            WrappingStrategy wrappingStrategy = JetBlock.getWrappingStrategyForItemList(commonSettings.METHOD_PARAMETERS_WRAP, JetNodeTypes.VALUE_PARAMETER);
            if (wrappingStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getWrappingStrategy"));
            }
            return wrappingStrategy;
        }
        WrappingStrategy.NoWrapping noWrapping = WrappingStrategy.NoWrapping.INSTANCE$;
        if (noWrapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/formatter/JetBlock", "getWrappingStrategy"));
        }
        return noWrapping;
    }

    private NodeAlignmentStrategy getChildrenAlignmentStrategy() {
        final CommonCodeStyleSettings jetCommonSettings = this.mySettings.getCommonSettings((Language)JetLanguage.INSTANCE);
        JetCodeStyleSettings jetSettings = (JetCodeStyleSettings)this.mySettings.getCustomSettings(JetCodeStyleSettings.class);
        IElementType parentType = this.myNode.getElementType();
        if (parentType == JetNodeTypes.VALUE_PARAMETER_LIST) {
            return JetBlock.getAlignmentForChildInParenthesis(jetCommonSettings.ALIGN_MULTILINE_PARAMETERS, JetNodeTypes.VALUE_PARAMETER, JetTokens.COMMA, jetCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS, JetTokens.LPAR, JetTokens.RPAR);
        }
        if (parentType == JetNodeTypes.VALUE_ARGUMENT_LIST) {
            return JetBlock.getAlignmentForChildInParenthesis(jetCommonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS, JetNodeTypes.VALUE_ARGUMENT, JetTokens.COMMA, jetCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS, JetTokens.LPAR, JetTokens.RPAR);
        }
        if (parentType == JetNodeTypes.WHEN) {
            return JetBlock.getAlignmentForCaseBranch(jetSettings.ALIGN_IN_COLUMNS_CASE_BRANCH);
        }
        if (parentType == JetNodeTypes.WHEN_ENTRY) {
            return this.myAlignmentStrategy;
        }
        if (BINARY_EXPRESSIONS.contains(parentType) && ALIGN_FOR_BINARY_OPERATIONS.contains(JetBlock.getOperationType(this.getNode()))) {
            return NodeAlignmentStrategy.fromTypes(AlignmentStrategy.wrap((Alignment)JetBlock.createAlignment(jetCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION, this.getAlignment()), (IElementType[])new IElementType[0]));
        }
        if (parentType == JetNodeTypes.DELEGATION_SPECIFIER_LIST || parentType == JetNodeTypes.INITIALIZER_LIST) {
            return NodeAlignmentStrategy.fromTypes(AlignmentStrategy.wrap((Alignment)JetBlock.createAlignment(jetCommonSettings.ALIGN_MULTILINE_EXTENDS_LIST, this.getAlignment()), (IElementType[])new IElementType[0]));
        }
        if (parentType == JetNodeTypes.PARENTHESIZED) {
            return new NodeAlignmentStrategy(){
                Alignment bracketsAlignment;
                {
                    this.bracketsAlignment = jetCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION ? Alignment.createAlignment() : null;
                }

                @Override
                @Nullable
                public Alignment getAlignment(@NotNull ASTNode childNode) {
                    if (childNode == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "org/jetbrains/kotlin/idea/formatter/JetBlock$2", "getAlignment"));
                    }
                    IElementType childNodeType = childNode.getElementType();
                    ASTNode prev2 = JetBlock.getPrevWithoutWhitespace(childNode);
                    if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                        return this.bracketsAlignment;
                    }
                    if (childNodeType == JetTokens.LPAR || childNodeType == JetTokens.RPAR) {
                        return this.bracketsAlignment;
                    }
                    return null;
                }
            };
        }
        return NodeAlignmentStrategy.getNullStrategy();
    }

    private static NodeAlignmentStrategy getAlignmentForChildInParenthesis(boolean shouldAlignChild, final IElementType parameter, final IElementType delimiter, boolean shouldAlignParenthesis, final IElementType openBracket, final IElementType closeBracket) {
        final Alignment parameterAlignment = shouldAlignChild ? Alignment.createAlignment() : null;
        final Alignment bracketsAlignment = shouldAlignParenthesis ? Alignment.createAlignment() : null;
        return new NodeAlignmentStrategy(){

            @Override
            public Alignment getAlignment(@NotNull ASTNode node2) {
                if (node2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/idea/formatter/JetBlock$3", "getAlignment"));
                }
                IElementType childNodeType = node2.getElementType();
                ASTNode prev2 = JetBlock.getPrevWithoutWhitespace(node2);
                if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                    return parameterAlignment;
                }
                if (childNodeType == openBracket || childNodeType == closeBracket) {
                    return bracketsAlignment;
                }
                if (childNodeType == parameter || childNodeType == delimiter) {
                    return parameterAlignment;
                }
                return null;
            }
        };
    }

    private static NodeAlignmentStrategy getAlignmentForCaseBranch(boolean shouldAlignInColumns) {
        if (shouldAlignInColumns) {
            return NodeAlignmentStrategy.fromTypes((AlignmentStrategy)AlignmentStrategy.createAlignmentPerTypeStrategy(Arrays.asList(new IElementType[]{JetTokens.ARROW}), (IElementType)JetNodeTypes.WHEN_ENTRY, (boolean)true));
        }
        return NodeAlignmentStrategy.getNullStrategy();
    }

    @Nullable
    protected static Indent createChildIndent(@NotNull ASTNode child) {
        ASTNode prev2;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/idea/formatter/JetBlock", "createChildIndent"));
        }
        ASTNode childParent = child.getTreeParent();
        IElementType childType = child.getElementType();
        if (childParent != null && childParent.getTreeParent() != null && childParent.getElementType() == JetNodeTypes.BLOCK && childParent.getTreeParent().getElementType() == JetNodeTypes.SCRIPT) {
            return Indent.getNoneIndent();
        }
        if (childParent != null && childParent.getPsi() instanceof JetDeclaration && (prev2 = JetBlock.getPrevWithoutWhitespace(child)) != null && JetTokens.COMMENTS.contains(prev2.getElementType()) && JetBlock.getPrevWithoutWhitespaceAndComments(prev2) == null) {
            return Indent.getNoneIndent();
        }
        for (NodeIndentStrategy strategy : INDENT_RULES) {
            Indent indent = strategy.getIndent(child);
            if (indent == null) continue;
            return indent;
        }
        if (childParent != null) {
            IElementType parentType = childParent.getElementType();
            if (parentType == JetNodeTypes.VALUE_PARAMETER_LIST || parentType == JetNodeTypes.VALUE_ARGUMENT_LIST) {
                ASTNode prev3 = JetBlock.getPrevWithoutWhitespace(child);
                if (childType == JetTokens.RPAR && (prev3 == null || prev3.getElementType() != TokenType.ERROR_ELEMENT)) {
                    return Indent.getNoneIndent();
                }
                return Indent.getContinuationWithoutFirstIndent();
            }
            if (parentType == JetNodeTypes.TYPE_PARAMETER_LIST || parentType == JetNodeTypes.TYPE_ARGUMENT_LIST) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    @Nullable
    private static Alignment createAlignment(boolean alignOption, @Nullable Alignment defaultAlignment) {
        return alignOption ? JetBlock.createAlignmentOrDefault(null, defaultAlignment) : defaultAlignment;
    }

    @Nullable
    private static Alignment createAlignmentOrDefault(@Nullable Alignment base, @Nullable Alignment defaultAlignment) {
        if (defaultAlignment == null) {
            return base == null ? Alignment.createAlignment() : Alignment.createChildAlignment((Alignment)base);
        }
        return defaultAlignment;
    }

    private static int findNodeBlockIndex(List<Block> blocks2, final TokenSet tokenSet) {
        return ContainerUtil.indexOf(blocks2, (Condition)new Condition<Block>(){

            public boolean value(Block block) {
                if (!(block instanceof ASTBlock)) {
                    return false;
                }
                ASTNode node2 = ((ASTBlock)block).getNode();
                return node2 != null && tokenSet.contains(node2.getElementType());
            }
        });
    }

    @Nullable
    private static IElementType getOperationType(ASTNode node2) {
        ASTNode operationNode = node2.findChildByType((IElementType)JetNodeTypes.OPERATION_REFERENCE);
        return operationNode != null ? operationNode.getFirstChildNode().getElementType() : null;
    }
}

