/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetIcons;
import org.jetbrains.kotlin.idea.framework.KotlinJavaScriptLibraryDetectionUtil;

public class KotlinJavaScriptLibraryPresentationProvider
extends LibraryPresentationProvider<LibraryVersionProperties> {
    public static final LibraryKind KOTLIN_JAVASCRIPT_HEADER_KIND = LibraryKind.create((String)"kotlin-js-header");

    public static KotlinJavaScriptLibraryPresentationProvider getInstance() {
        return (KotlinJavaScriptLibraryPresentationProvider)((Object)LibraryPresentationProvider.EP_NAME.findExtension(KotlinJavaScriptLibraryPresentationProvider.class));
    }

    protected KotlinJavaScriptLibraryPresentationProvider() {
        super(KOTLIN_JAVASCRIPT_HEADER_KIND);
    }

    @Nullable
    public Icon getIcon() {
        return JetIcons.SMALL_LOGO_13;
    }

    @Nullable
    public LibraryVersionProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/KotlinJavaScriptLibraryPresentationProvider", "detect"));
        }
        return KotlinJavaScriptLibraryDetectionUtil.isKotlinJavaScriptLibrary(classesRoots) ? new LibraryVersionProperties(null) : null;
    }
}

