/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.highlighter.DeclarationKindDetector;
import org.jetbrains.kotlin.idea.quickfix.AnnotationHostKind;
import org.jetbrains.kotlin.idea.quickfix.KotlinSuppressIntentionAction;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetExpression;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class HighlighterPackage$KotlinSuppressableWarningProblemGroup$9e8452c5 {
    @NotNull
    public static final List<SuppressIntentionAction> createSuppressWarningActions(@JetValueParameter(name="element") @NotNull PsiElement element, @JetValueParameter(name="diagnosticFactory") @NotNull DiagnosticFactory<?> diagnosticFactory) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(diagnosticFactory, (String)"diagnosticFactory");
        if (Intrinsics.areEqual((Object)((Object)diagnosticFactory.getSeverity()), (Object)((Object)Severity.WARNING)) ^ true) {
            List<SuppressIntentionAction> list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            return list;
        }
        ArrayList actions = KotlinPackage.arrayListOf((Object[])new SuppressIntentionAction[0]);
        PsiElement current = element;
        boolean suppressAtStatementAllowed = true;
        while (current != null) {
            if (current instanceof JetDeclaration) {
                PsiElement psiElement = current;
                if (psiElement == null) {
                    throw new TypeCastException("com.intellij.psi.PsiElement? cannot be cast to org.jetbrains.kotlin.psi.JetDeclaration");
                }
                JetDeclaration declaration = (JetDeclaration)psiElement;
                AnnotationHostKind kind2 = DeclarationKindDetector.INSTANCE$.detect(declaration);
                if (kind2 != null) {
                    actions.add(new KotlinSuppressIntentionAction(declaration, diagnosticFactory, kind2));
                }
                suppressAtStatementAllowed = false;
            } else if (current instanceof JetExpression && suppressAtStatementAllowed) {
                PsiElement psiElement = current;
                if (psiElement == null) {
                    throw new TypeCastException("com.intellij.psi.PsiElement? cannot be cast to com.intellij.psi.PsiElement");
                }
                if (psiElement.getParent() instanceof JetBlockExpression) {
                    PsiElement psiElement2 = current;
                    if (psiElement2 == null) {
                        throw new TypeCastException("com.intellij.psi.PsiElement? cannot be cast to org.jetbrains.kotlin.psi.JetExpression");
                    }
                    JetExpression expression2 = (JetExpression)psiElement2;
                    actions.add(new KotlinSuppressIntentionAction(expression2, diagnosticFactory, new AnnotationHostKind("statement", "", true)));
                    suppressAtStatementAllowed = false;
                }
            }
            PsiElement psiElement = current;
            current = psiElement != null ? psiElement.getParent() : null;
        }
        return actions;
    }
}

