/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeHighlighting.Pass;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.highlighter.markers.MarkersPackage$JavaPsiUtils$7b293977;
import org.jetbrains.kotlin.idea.highlighter.markers.MarkersPackage$KotlinLineMarkerProvider$248b1ea4;
import org.jetbrains.kotlin.idea.highlighter.markers.MarkersPackage$OverridenFunctionMarker$2adff636;
import org.jetbrains.kotlin.idea.highlighter.markers.MarkersPackage$OverridenPropertyMarker$321c78d9;
import org.jetbrains.kotlin.idea.highlighter.markers.MarkersPackage$SuperDeclarationMarker$fead876b;
import org.jetbrains.kotlin.idea.highlighter.markers.ResolveWithParentsResult;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerNavigationHandler;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerTooltip;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class MarkersPackage$KotlinLineMarkerProvider$248b1ea4 {
    @NotNull
    static final Icon OVERRIDING_MARK;
    @NotNull
    static final Icon IMPLEMENTING_MARK;
    @NotNull
    static final Icon OVERRIDDEN_MARK;
    @NotNull
    static final Icon IMPLEMENTED_MARK;
    @NotNull
    static final MarkerType SUBCLASSED_CLASS;
    @NotNull
    static final MarkerType OVERRIDDEN_FUNCTION;
    @NotNull
    static final MarkerType OVERRIDDEN_PROPERTY;

    @NotNull
    public static final Icon getOVERRIDING_MARK() {
        return OVERRIDING_MARK;
    }

    @NotNull
    public static final Icon getIMPLEMENTING_MARK() {
        return IMPLEMENTING_MARK;
    }

    @NotNull
    public static final Icon getOVERRIDDEN_MARK() {
        return OVERRIDDEN_MARK;
    }

    @NotNull
    public static final Icon getIMPLEMENTED_MARK() {
        return IMPLEMENTED_MARK;
    }

    @NotNull
    public static final MarkerType getSUBCLASSED_CLASS() {
        return SUBCLASSED_CLASS;
    }

    @NotNull
    public static final MarkerType getOVERRIDDEN_FUNCTION() {
        return OVERRIDDEN_FUNCTION;
    }

    @NotNull
    public static final MarkerType getOVERRIDDEN_PROPERTY() {
        return OVERRIDDEN_PROPERTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isImplementsAndNotOverrides(@JetValueParameter(name="descriptor") @NotNull CallableMemberDescriptor descriptor2, @JetValueParameter(name="overriddenMembers") @NotNull Collection<? extends CallableMemberDescriptor> overriddenMembers) {
        Object element;
        CallableMemberDescriptor it;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(overriddenMembers, (String)"overriddenMembers");
        if (!(Intrinsics.areEqual((Object)((Object)descriptor2.getModality()), (Object)((Object)Modality.ABSTRACT)) ^ true)) return false;
        Iterable $receiver = overriddenMembers;
        Iterator iterator2 = $receiver.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (Intrinsics.areEqual((Object)((Object)(it = (CallableMemberDescriptor)(element = iterator2.next())).getModality()), (Object)((Object)Modality.ABSTRACT)));
        return false;
    }

    public static final void collectSuperDeclarationMarkers(@JetValueParameter(name="declaration") @NotNull JetDeclaration declaration, @JetValueParameter(name="result") @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        KotlinPackage.assert$default((declaration instanceof JetNamedFunction || declaration instanceof JetProperty ? 1 : 0) != 0, null, (int)2);
        if (!declaration.hasModifier(JetTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        ResolveWithParentsResult resolveWithParents = MarkersPackage$SuperDeclarationMarker$fead876b.resolveDeclarationWithParents(declaration);
        if (resolveWithParents.getOverriddenDescriptors().isEmpty()) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor = resolveWithParents.getDescriptor();
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        boolean bl = MarkersPackage$KotlinLineMarkerProvider$248b1ea4.isImplementsAndNotOverrides(callableMemberDescriptor, resolveWithParents.getOverriddenDescriptors());
        LineMarkerInfo marker = new LineMarkerInfo((PsiElement)declaration, declaration.getTextOffset(), bl ? IMPLEMENTING_MARK : OVERRIDING_MARK, Pass.UPDATE_OVERRIDEN_MARKERS, (Function)SuperDeclarationMarkerTooltip.INSTANCE$, (GutterIconNavigationHandler)new SuperDeclarationMarkerNavigationHandler());
        result2.add(marker);
    }

    public static final void collectInheritedClassMarker(@JetValueParameter(name="element") @NotNull JetClass element, @JetValueParameter(name="result") @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        boolean isTrait = element.isInterface();
        if (!(isTrait || element.hasModifier(JetTokens.OPEN_KEYWORD) || element.hasModifier(JetTokens.ABSTRACT_KEYWORD))) {
            return;
        }
        PsiClass psiClass = LightClassUtil.getPsiClass(element);
        if (psiClass == null) {
            return;
        }
        PsiClass lightClass = psiClass;
        if (ClassInheritorsSearch.search((PsiClass)lightClass, (boolean)false).findFirst() == null) {
            return;
        }
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement == null) {
            psiElement = element;
        }
        PsiElement anchor2 = psiElement;
        result2.add(new LineMarkerInfo(anchor2, anchor2.getTextOffset(), isTrait ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, Pass.UPDATE_OVERRIDEN_MARKERS, SUBCLASSED_CLASS.getTooltip(), SUBCLASSED_CLASS.getNavigationHandler()));
    }

    public static final void collectOverriddenPropertyAccessors(@JetValueParameter(name="properties") @NotNull Collection<? extends JetProperty> properties2, @JetValueParameter(name="result") @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull(properties2, (String)"properties");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        HashMap<PsiMethod, JetProperty> mappingToJava = new HashMap<PsiMethod, JetProperty>();
        for (JetProperty jetProperty : properties2) {
            if (!PsiUtilPackage.isOverridable(jetProperty)) continue;
            LightClassUtil.PropertyAccessorsPsiMethods accessorsPsiMethods = LightClassUtil.getLightClassPropertyMethods(jetProperty);
            for (PsiMethod psiMethod : accessorsPsiMethods) {
                mappingToJava.put(psiMethod, jetProperty);
            }
        }
        Collection collection = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"mappingToJava.keySet()");
        Set<PsiClass> set = MarkersPackage$JavaPsiUtils$7b293977.collectContainingClasses(collection);
        for (JetProperty property : MarkersPackage$OverridenFunctionMarker$2adff636.getOverriddenDeclarations((Map)mappingToJava, set)) {
            ProgressManager.checkCanceled();
            PsiElement psiElement = property.getNameIdentifier();
            if (psiElement == null) {
                psiElement = property;
            }
            PsiElement anchor2 = psiElement;
            int n = anchor2.getTextOffset();
            JetNamedDeclaration jetNamedDeclaration = property;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetNamedDeclaration, (String)"property");
            result2.add(new LineMarkerInfo(anchor2, n, MarkersPackage$OverridenPropertyMarker$321c78d9.isImplemented(jetNamedDeclaration) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, Pass.UPDATE_OVERRIDEN_MARKERS, OVERRIDDEN_PROPERTY.getTooltip(), OVERRIDDEN_PROPERTY.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
        }
    }

    public static final void collectOverriddenFunctions(@JetValueParameter(name="functions") @NotNull Collection<? extends JetNamedFunction> functions2, @JetValueParameter(name="result") @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull(functions2, (String)"functions");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        HashMap<PsiMethod, JetNamedFunction> mappingToJava = new HashMap<PsiMethod, JetNamedFunction>();
        for (JetNamedFunction jetNamedFunction : functions2) {
            PsiMethod method;
            if (!PsiUtilPackage.isOverridable(jetNamedFunction) || (method = LightClassUtil.getLightClassMethod(jetNamedFunction)) == null) continue;
            mappingToJava.put(method, jetNamedFunction);
        }
        Collection collection = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"mappingToJava.keySet()");
        Set<PsiClass> set = MarkersPackage$JavaPsiUtils$7b293977.collectContainingClasses(collection);
        for (JetNamedFunction function3 : MarkersPackage$OverridenFunctionMarker$2adff636.getOverriddenDeclarations((Map)mappingToJava, set)) {
            ProgressManager.checkCanceled();
            PsiElement psiElement = function3.getNameIdentifier();
            if (psiElement == null) {
                psiElement = function3;
            }
            PsiElement anchor2 = psiElement;
            int n = anchor2.getTextOffset();
            JetNamedDeclaration jetNamedDeclaration = function3;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetNamedDeclaration, (String)"function");
            result2.add(new LineMarkerInfo(anchor2, n, MarkersPackage$OverridenPropertyMarker$321c78d9.isImplemented(jetNamedDeclaration) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, Pass.UPDATE_OVERRIDEN_MARKERS, OVERRIDDEN_FUNCTION.getTooltip(), OVERRIDDEN_FUNCTION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
        }
    }

    static {
        Icon icon = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Gutter.OverridingMethod");
        OVERRIDING_MARK = icon;
        Icon icon2 = AllIcons.Gutter.ImplementingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Gutter.ImplementingMethod");
        IMPLEMENTING_MARK = icon2;
        Icon icon3 = AllIcons.Gutter.OverridenMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Gutter.OverridenMethod");
        OVERRIDDEN_MARK = icon3;
        Icon icon4 = AllIcons.Gutter.ImplementedMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.Gutter.ImplementedMethod");
        IMPLEMENTED_MARK = icon4;
        SUBCLASSED_CLASS = new MarkerType((Function)SUBCLASSED_CLASS.1.INSTANCE$, new LineMarkerNavigator(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(SUBCLASSED_CLASS.2.class);
            }

            public void browse(@JetValueParameter(name="e", type="?") @Nullable MouseEvent e, @JetValueParameter(name="element", type="?") @Nullable PsiElement element) {
                Unit unit;
                PsiClass psiClass = MarkersPackage$JavaPsiUtils$7b293977.getPsiClass(element);
                if (psiClass != null) {
                    PsiClass $receiver = psiClass;
                    PsiClass it = $receiver;
                    MarkerType.navigateToSubclassedClass((MouseEvent)e, (PsiClass)it);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }
        });
        OVERRIDDEN_FUNCTION = new MarkerType((Function)OVERRIDDEN_FUNCTION.1.INSTANCE$, new LineMarkerNavigator(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(OVERRIDDEN_FUNCTION.2.class);
            }

            public void browse(@JetValueParameter(name="e", type="?") @Nullable MouseEvent e, @JetValueParameter(name="element", type="?") @Nullable PsiElement element) {
                Unit unit;
                PsiMethod psiMethod = MarkersPackage$JavaPsiUtils$7b293977.getPsiMethod(element);
                if (psiMethod != null) {
                    PsiMethod $receiver = psiMethod;
                    PsiMethod it = $receiver;
                    MarkersPackage$OverridenFunctionMarker$2adff636.navigateToOverriddenMethod(e, it);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }
        });
        OVERRIDDEN_PROPERTY = new MarkerType((Function)OVERRIDDEN_PROPERTY.1.INSTANCE$, new LineMarkerNavigator(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(OVERRIDDEN_PROPERTY.2.class);
            }

            public void browse(@JetValueParameter(name="e", type="?") @Nullable MouseEvent e, @JetValueParameter(name="element", type="?") @Nullable PsiElement element) {
                Unit unit;
                PsiElement psiElement = element;
                if (psiElement != null) {
                    PsiElement $receiver = psiElement;
                    PsiElement it = $receiver;
                    PsiElement psiElement2 = it.getParent();
                    if (psiElement2 == null) {
                        throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetProperty");
                    }
                    MarkersPackage$OverridenPropertyMarker$321c78d9.navigateToPropertyOverriddenDeclarations(e, (JetProperty)psiElement2);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }
        });
    }
}

