/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.IntentionsPackage$Utils$25a22166;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingIntention;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0005\u0006)\u0011\u0012\t\u001a3Ce\u0006\u001cWm]%oi\u0016tG/[8o\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T!\"\u001b8uK:$\u0018n\u001c8t\u0015eQU\r^*fY\u001a$\u0016M]4fi&tw-\u00138uK:$\u0018n\u001c8\u000b\u001b)+G/\u0012=qe\u0016\u001c8/[8o\u0015\r\u00018/\u001b\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000f\u0005\u0004\b\u000f\\=U_*9Q\r\\3nK:$(BB3eSR|'O\u0003\u0004FI&$xN\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*!QK\\5u\u00159I7/\u00119qY&\u001c\u0017M\u00197f)>T1bY1sKR|eMZ:fi*\u0019\u0011J\u001c;\u000b\u000f\t{w\u000e\\3b]*\u0019r-\u001a;UCJ<W\r^#yaJ,7o]5p]*i1-\u0019:fi2{7-\u0019;j_:\u0004\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\n!=QA\u0001\u0003\u0006\u0011!)!\u0001b\u0003\t\r\u0015\u0019AA\u0002E\u0007\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u00119\u0001\u0012\u0003\u0007\u0001\u000b\t!9\u0001c\u0002\u0006\u0005\u00111\u0001RB\u0003\u0004\t\u001dA!\u0002\u0004\u0001\u0006\u0007\u00119\u0001R\u0003\u0007\u0001\t\ra)!\u0007\u0004\u0006\u0003!\u0019\u0011bA\u0005\u0003\u000b\u0005AA!,\u000f\u0005\u0017a)QT\u0002\u0003\u0001\u0011\u0017i!!B\u0001\t\tA\u001b\u0001!(\u0004\u0005\u0001!1QBA\u0003\u0002\u0011\u001b\u00016\u0011A\u0011\u0003\u000b\u0005Ay!U\u0002\b\t\u0015I\u0011\u0001\u0002\u0001\u000e\u0003!AQ\"\u0001E\t[s!1\u0002G\u0005\u001e\u000e\u0011\u0001\u00012B\u0007\u0003\u000b\u0005AA\u0001U\u0002\u0001;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0002\u0005\u0012Q!\u0001E\n#\u000e9A!C\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0005\u000e\u0003\u0011\u0015Q&\u0007\u0003\u0002+\t)\u0011\u0001\u0003\u0003\u0019\u0017u5A\u0001\u0001E\f\u001b\t)\u0011\u0001C\u0005Q\u0007\u0003\t3!B\u0001\t\t1\u0005\u0011kA\u0004\u0005\u0017%\t\u0001\u0002C\u0007\u0002\u0011!i\u0011\u0001\"\u00026\u0017\u0015QAa9\u0001\u0019\n\u0005\u0012Q!\u0001E\u0003#\u000e\u0019A\u0011B\u0005\u0002\t\u0001\u0001"})
public final class AddBracesIntention
extends JetSelfTargetingIntention<JetExpression> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(AddBracesIntention.class);
    }

    @Override
    public boolean isApplicableTo(@JetValueParameter(name="element") @NotNull JetExpression element, @JetValueParameter(name="caretOffset") int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        JetExpression jetExpression = this.getTargetExpression(element, caretOffset);
        if (jetExpression == null) {
            return false;
        }
        JetExpression expression2 = jetExpression;
        if (expression2 instanceof JetBlockExpression) {
            return false;
        }
        PsiElement psiElement = expression2.getParent();
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetContainerNode");
        }
        String string = IntentionsPackage$Utils$25a22166.description((JetContainerNode)psiElement);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String description = string;
        this.setText("Add braces to '" + description + "' statement");
        return true;
    }

    @Override
    public void applyTo(@JetValueParameter(name="element") @NotNull JetExpression element, @JetValueParameter(name="editor") @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JetExpression jetExpression = this.getTargetExpression(element, editor.getCaretModel().getOffset());
        if (jetExpression == null) {
            Intrinsics.throwNpe();
        }
        JetExpression expression2 = jetExpression;
        PsiElement psiElement = element.getNextSibling();
        if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)";")) {
            PsiElement psiElement2 = element.getNextSibling();
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            psiElement2.delete();
        }
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)element);
        expression2.replace((PsiElement)psiFactory.createSingleStatementBlock(expression2));
        if (element instanceof JetDoWhileExpression) {
            Unit unit;
            PsiElement psiElement3;
            JetExpression jetExpression2 = ((JetDoWhileExpression)element).getBody();
            if (jetExpression2 == null) {
                Intrinsics.throwNpe();
            }
            if (!((psiElement3 = jetExpression2.getParent().getNextSibling()) instanceof PsiWhiteSpace)) {
                psiElement3 = null;
            }
            PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement3;
            if (psiWhiteSpace != null) {
                psiWhiteSpace.delete();
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
        }
    }

    private final JetExpression getTargetExpression(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="caretLocation") int caretLocation) {
        JetExpression jetExpression = $receiver;
        if (jetExpression instanceof JetIfExpression) {
            JetExpression jetExpression2 = ((JetIfExpression)$receiver).getThen();
            if (jetExpression2 == null) {
                return null;
            }
            JetExpression thenExpr = jetExpression2;
            JetExpression elseExpr = ((JetIfExpression)$receiver).getElse();
            if (elseExpr != null) {
                PsiElement psiElement = ((JetIfExpression)$receiver).getElseKeyword();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                if (caretLocation >= PsiUtilPackage.getStartOffset(psiElement)) {
                    return elseExpr;
                }
            }
            return thenExpr;
        }
        if (jetExpression instanceof JetWhileExpression) {
            return ((JetWhileExpression)$receiver).getBody();
        }
        if (jetExpression instanceof JetDoWhileExpression) {
            return ((JetDoWhileExpression)$receiver).getBody();
        }
        if (jetExpression instanceof JetForExpression) {
            return ((JetForExpression)$receiver).getBody();
        }
        return null;
    }

    public AddBracesIntention() {
        super(JetExpression.class, "Add braces", null, false, 12, null);
    }
}

