/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.dialects.commonmark.CommonMarkMarkerProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"q\u0006)a1\nR8d%\u0016tG-\u001a:fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002B6e_\u000eT1!\u00118z\u00159i\u0017M]6e_^tGk\u001c%u[2T\u0001\"\\1sW\u0012|wO\u001c\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0006sK:$WM]&E_\u000eT!\u0002Z8d\u0007>lW.\u001a8u\u0015\u001dYEi\\2UC\u001eT1\u0001]:j\u0015\u0011IW\u000e\u001d7\u000b\u001bI,g\u000eZ3s'\u0016,\u0017\t\\:p\u0015-YEi\\2TK\u000e$\u0018n\u001c8\u000b\u0005Q|'\"D*ue&twMQ;jY\u0012,'O\u0003\u0003V]&$(\"\u0003:f]\u0012,'\u000fV1h\u0015\r!\u0018m\u001a\u0006\u0006i&$H.\u001a\u0006\u000ee\u0016tG-\u001a:UC\u001ed\u0015n\u001d;\u000b\tQ\fwm\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0003vi&d'B\u00035u[2,5oY1qK*aQ*\u0019:lI><hNT8eK*1Ao\u001c%u[2T\u0011d\u0013#pGJ+g\u000eZ3sKJ$S*\u0019:lI><hNT8eK*)a/[:ji*1\u0011m\u0019;j_:T\u0011BR;oGRLwN\u001c\u001a\u000b\u0013\u0019+hn\u0019;j_:\u0004$b\u00016w[*Ia-\u001e8di&|gn\u001di\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\r!1\u0001#\u0003\r\u0001\u0015\t\u0001\"B\u0003\u0003\t\u0013AY!\u0002\u0002\u0005\u000b!%QA\u0001\u0003\u0002\u0011\u000b)!\u0001\u0002\u0004\t\u0010\u0015\u0011AQ\u0002\u0005\t\u000b\r!q\u0001C\u0004\r\u0001\u0015\u0011Aa\u0002\u0005\b\u000b\r!q\u0001C\u0005\r\u0001\u0015\u0019A!\u0002\u0005\u000b\u0019\u0001)1\u0001B\u0002\t\u00161\u0001QA\u0001\u0003\b\u0011%)!\u0001B\u0003\t\u0015\u0015\u0019Aa\u0001E\u000e\u0019\u0001)!\u0001\"\u0003\t\u001d\u0015\u0011Aq\u0003E\u000e\u000b\r!)\u0001C\b\r\u0001\u0015\u0011AA\u0001\u0005\u0011\u000b\r!1\u0001c\t\r\u0001\u0015\u0019Aa\u0001\u0005\u0013\u0019\u0001)!\u0001B\u0002\t&\u0015\u0011AQ\u0004\u0005\u0014\u000b\t!q\u0002c\t\u0005A\u0006a)!\u0007\u0002\u0006\u0003!\u001dAdD\u0017\u0014\t\u0001A:!(\u0004\u0005\u0001!!QBA\u0003\u0002\u0011\u0011\u00016\u0001A\u0011\u0003\u000b\u0005AA!U\u0002\u0006\t\u000fI\u0011\u0001c\u0003\u000e\u0003!-Qf\u0005\u0003\u00011\u0019ij\u0001\u0002\u0001\t\u000e5\u0011Q!\u0001E\b!\u000e\u0001\u0011EA\u0003\u0002\u0011\u0011\t6!\u0002\u0003\u0007\u0013\u0005AY!D\u0001\t\u00115fB!\u0001M\t;\u001b!\u0001\u0001#\u0004\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0001u5A\u0001\u0001E\n\u001b\t)\u0011\u0001C\u0005Q\u0007\u0003\t#!B\u0001\t\u0014E\u001bq\u0001\"\u0005\n\u0003\u0011\u0001Q\"\u0001\u0005\u000b\u001b\u0005A)\"L\u0014\u0005\u0003aYQt\u0002\u0003\u0001\u0011/i1!B\u0001\t\u00101\u0005\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0002D\u0007\u0003\u000b\u0005AA\u0001UB\u0001;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0003\u0005\u0012Q!\u0001E\n#\u000eIAaC\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0005\u000e\u0003!-Q\"\u0001E\u000b[)\"\u0011\u0001'\u0007\u001e\u0016\u0011\u0001\u0001\"D\u0007\u0007\u000b\u0005A1\"C\u0002\n\u0005\u0015\t\u0001r\u0002)\u0004\u0001u5A\u0001\u0001\u0005\r\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0003ij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005\n!\u000e\t\u0011EA\u0003\u0002\u0011'\t6!\u0003C\r\u0013\u0005!\u0001!D\u0001\t\u00195\t\u00012B\u0007\u0002\u0011+ik\u0002\u0002\u0001\u0016\u0005\u0015\t\u0001\u0002\u0002M\u000fC\t)\u0011\u0001\u0003\u0003R\u0007\u0015!i\"C\u0001\t\f5\t\u00012BW\u000f\t\r)\"!B\u0001\t\u001aa}\u0011EA\u0003\u0002\u0011\u0011\t6!\u0002C\u0010\u0013\u0005AY!D\u0001\t\u001b5BC\u0001A\u000b\u0003\u000b\u0005AI\u0002'\t\u001e.\u0011\u0001\u0001\"E\u0007\u0013\u000b\u0005AY\"C\u0002\n\u0005\u0015\t\u0001\u0012D\u0005\b\u0013\u0019)\u0011\u0001\u0003\b\n\u0007%\u0011Q!\u0001E\n\u0013\rI!!B\u0001\t\u0014A\u001b\t!\t\u0002\u0006\u0003!M\u0011kA\u0004\u0005\"%\tA\u0001A\u0007\u0002\u00115i\u0011\u0001c\b6\u0001\u0001"})
public final class KDocRenderer {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final KDocRenderer INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KDocRenderer.class);
        new KDocRenderer();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderKDoc(@JetValueParameter(name="docComment") @NotNull KDocTag docComment) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)docComment), (String)"docComment");
        String content = docComment.getContent();
        StringBuilder result2 = new StringBuilder("<p>");
        result2.append(this.markdownToHtml(content));
        if (docComment instanceof KDocSection) {
            void destination;
            void $receiver;
            Iterable destination2;
            Iterable $receiver2;
            void $receiver3;
            result2.append("\n");
            Iterable iterable = ((KDocSection)docComment).findTagsByName("param");
            void var6_5 = $receiver3;
            Collection collection = new ArrayList();
            for (Object element : $receiver2) {
                KDocTag it = (KDocTag)((Object)element);
                if (!(it.getSubjectName() != null)) continue;
                destination2.add(element);
            }
            List paramTags = (List)destination2;
            this.renderTagList(paramTags, "Parameters", result2);
            this.renderTag(((KDocSection)docComment).findTagByName("return"), "Returns", result2);
            $receiver2 = KotlinPackage.union((Iterable)((KDocSection)docComment).findTagsByName("exception"), (Iterable)((KDocSection)docComment).findTagsByName("throws"));
            destination2 = $receiver2;
            Collection collection2 = new ArrayList();
            for (Object element : $receiver) {
                KDocTag it = (KDocTag)((Object)element);
                if (!(it.getSubjectName() != null)) continue;
                destination.add(element);
            }
            List throwsTags = (List)destination;
            this.renderTagList(throwsTags, "Throws", result2);
            this.renderTag(((KDocSection)docComment).findTagByName("author"), "Author", result2);
            this.renderTag(((KDocSection)docComment).findTagByName("since"), "Since", result2);
            this.renderSeeAlso((KDocSection)docComment, result2);
        }
        result2.append("</p>");
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSeeAlso(@JetValueParameter(name="docComment") KDocSection docComment, @JetValueParameter(name="to") StringBuilder to) {
        void $receiver;
        List<KDocTag> seeTags = docComment.findTagsByName("see");
        if (seeTags.isEmpty()) {
            return;
        }
        to.append("<DD><DL>");
        to.append("<DT><b>").append("See Also:").append("</b>");
        to.append("<DD>");
        Iterable iterable = seeTags;
        int index2 = 0;
        for (Object item : $receiver) {
            void tag;
            int n = index2++;
            KDocTag kDocTag = (KDocTag)((Object)item);
            int index3 = n;
            DocumentationManagerUtil.createHyperlink((StringBuilder)to, (String)tag.getSubjectName(), (String)tag.getSubjectName(), (boolean)false);
            if (index3 >= seeTags.size() - 1) continue;
            to.append(", ");
        }
        to.append("</DD></DL></DD>");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTagList(@JetValueParameter(name="tags") List<? extends KDocTag> tags, @JetValueParameter(name="title") String title, @JetValueParameter(name="to") StringBuilder to) {
        void $receiver;
        if (tags.isEmpty()) {
            return;
        }
        to.append("<dl><dt><b>" + title + ":</b></dt>");
        Iterable iterable = tags;
        for (Object element : $receiver) {
            KDocTag it = (KDocTag)((Object)element);
            to.append("<dd><code>" + it.getSubjectName() + "</code> - " + INSTANCE$.markdownToHtml(KotlinPackage.trimLeading((String)it.getContent())) + "</dd>");
        }
        to.append("</dl>\n");
    }

    private final void renderTag(@JetValueParameter(name="tag", type="?") KDocTag tag, @JetValueParameter(name="title") String title, @JetValueParameter(name="to") StringBuilder to) {
        if (tag != null) {
            to.append("<dl><dt><b>" + title + ":</b></dt>");
            to.append("<dd>" + this.markdownToHtml(tag.getContent()) + "</dd>");
            to.append("</dl>\n");
        }
    }

    @NotNull
    public final String markdownToHtml(@JetValueParameter(name="markdown") @NotNull String markdown) {
        Collection destination;
        MarkdownNode it;
        Iterable $receiver;
        Iterable $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)markdown, (String)"markdown");
        ASTNode markdownTree = new MarkdownParser((MarkerProcessorFactory)CommonMarkMarkerProcessor.Factory.INSTANCE$).buildMarkdownTreeFromString(markdown);
        MarkdownNode markdownNode = new MarkdownNode(markdownTree, null, markdown);
        Iterable iterable = markdownNode.getChildren();
        void var6_5 = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            it = (MarkdownNode)element;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.Companion.getPARAGRAPH())) continue;
            destination.add(element);
        }
        MarkdownNode maybeSingleParagraph = (MarkdownNode)KotlinPackage.singleOrNull((List)((List)destination));
        if (maybeSingleParagraph != null) {
            $receiver2 = maybeSingleParagraph.getChildren();
            $receiver = $receiver2;
            destination = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                it = (MarkdownNode)item;
                Collection collection2 = destination;
                String string = INSTANCE$.toHtml(it);
                collection2.add(string);
            }
            return KotlinPackage.join$default((Iterable)((List)destination), (String)"", null, null, (int)0, null, (int)30);
        }
        return this.toHtml(markdownNode);
    }

    public final void visit(@JetValueParameter(name="$receiver") MarkdownNode $receiver, @JetValueParameter(name="action") @NotNull Function2<? super MarkdownNode, ? super Function0<? extends Unit>, ? extends Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        action.invoke((Object)$receiver, (Object)new Function0<Unit>($receiver, action){
            final /* synthetic */ MarkdownNode receiver$0;
            final /* synthetic */ Function2 $action;

            public final void invoke() {
                for (MarkdownNode child : this.receiver$0.getChildren()) {
                    KDocRenderer.INSTANCE$.visit(child, (Function2<? super MarkdownNode, ? super Function0<? extends Unit>, ? extends Unit>)this.$action);
                }
            }
            {
                this.receiver$0 = markdownNode;
                this.$action = function2;
                super(0);
            }
        });
    }

    @NotNull
    public final String toHtml(@JetValueParameter(name="$receiver") MarkdownNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder sb = new StringBuilder();
        this.visit($receiver, (Function2<? super MarkdownNode, ? super Function0<? extends Unit>, ? extends Unit>)((Function2)new Function2<MarkdownNode, Function0<? extends Unit>, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;

            public final void invoke(@JetValueParameter(name="node") @NotNull MarkdownNode node2, @JetValueParameter(name="processChildren") @NotNull Function0<? extends Unit> processChildren) {
                Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
                Intrinsics.checkParameterIsNotNull(processChildren, (String)"processChildren");
                IElementType nodeType = node2.getType();
                String nodeText = node2.getText();
                IElementType iElementType = nodeType;
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getUNORDERED_LIST())) {
                    KotlinPackage.appendln((StringBuilder)this.$sb, (String)"<ul>");
                    processChildren.invoke();
                    KotlinPackage.appendln((StringBuilder)this.$sb, (String)"</ul>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getORDERED_LIST())) {
                    KotlinPackage.appendln((StringBuilder)this.$sb, (String)"<ol>");
                    processChildren.invoke();
                    KotlinPackage.appendln((StringBuilder)this.$sb, (String)"</ol>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getLIST_ITEM())) {
                    this.$sb.append("<li>");
                    processChildren.invoke();
                    KotlinPackage.appendln((StringBuilder)this.$sb, (String)"</li>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getEMPH())) {
                    this.$sb.append("<em>");
                    processChildren.invoke();
                    this.$sb.append("</em>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getSTRONG())) {
                    this.$sb.append("<strong>");
                    processChildren.invoke();
                    this.$sb.append("</strong>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getATX_1())) {
                    this.$sb.append("<h1>");
                    processChildren.invoke();
                    this.$sb.append("</h1>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getATX_2())) {
                    this.$sb.append("<h2>");
                    processChildren.invoke();
                    this.$sb.append("</h2>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getATX_3())) {
                    this.$sb.append("<h3>");
                    processChildren.invoke();
                    this.$sb.append("</h3>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getATX_4())) {
                    this.$sb.append("<h4>");
                    processChildren.invoke();
                    this.$sb.append("</h4>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getATX_5())) {
                    this.$sb.append("<h5>");
                    processChildren.invoke();
                    this.$sb.append("</h5>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getATX_6())) {
                    this.$sb.append("<h6>");
                    processChildren.invoke();
                    this.$sb.append("</h6>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getBLOCK_QUOTE())) {
                    this.$sb.append("<blockquote>");
                    processChildren.invoke();
                    this.$sb.append("</blockquote>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getPARAGRAPH())) {
                    this.$sb.append("<p>");
                    processChildren.invoke();
                    KotlinPackage.appendln((StringBuilder)this.$sb, (String)"</p>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getCODE_SPAN())) {
                    this.$sb.append("<code>");
                    processChildren.invoke();
                    this.$sb.append("</code>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getCODE_BLOCK())) {
                    this.$sb.append("<pre><code>");
                    processChildren.invoke();
                    this.$sb.append("</code><pre>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getSHORT_REFERENCE_LINK()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getFULL_REFERENCE_LINK())) {
                    String label;
                    MarkdownNode markdownNode = node2.child(MarkdownElementTypes.Companion.getLINK_LABEL());
                    String string = markdownNode != null && (markdownNode = markdownNode.child(MarkdownTokenTypes.Companion.getTEXT())) != null ? markdownNode.getText() : (label = null);
                    if (label != null) {
                        Object object = node2.child(MarkdownElementTypes.Companion.getLINK_TEXT());
                        if (object == null || (object = ((MarkdownNode)object).child(MarkdownTokenTypes.Companion.getTEXT())) == null || (object = ((MarkdownNode)object).getText()) == null) {
                            object = label;
                        }
                        Object linkText = object;
                        DocumentationManagerUtil.createHyperlink((StringBuilder)this.$sb, (String)label, (String)linkText, (boolean)true);
                    } else {
                        this.$sb.append(node2.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getINLINE_LINK())) {
                    String destination;
                    MarkdownNode markdownNode = node2.child(MarkdownElementTypes.Companion.getLINK_TEXT());
                    String label = markdownNode != null && (markdownNode = markdownNode.child(MarkdownTokenTypes.Companion.getTEXT())) != null ? markdownNode.getText() : null;
                    MarkdownNode markdownNode2 = node2.child(MarkdownElementTypes.Companion.getLINK_DESTINATION());
                    String string = destination = markdownNode2 != null ? markdownNode2.getText() : null;
                    if (label != null && destination != null) {
                        this.$sb.append("a href=" + "\"" + destination + "\"" + ">" + KDocRenderer.INSTANCE$.htmlEscape(label) + "</a>");
                    } else {
                        this.$sb.append(node2.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getTEXT()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getWHITE_SPACE()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getCOLON()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getDOUBLE_QUOTE()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getLPAREN()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getRPAREN()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getLBRACKET()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getRBRACKET())) {
                    this.$sb.append(nodeText);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getGT())) {
                    this.$sb.append("&gt;");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getLT())) {
                    this.$sb.append("&lt;");
                } else {
                    processChildren.invoke();
                }
            }
            {
                this.$sb = stringBuilder;
                super(2);
            }
        }));
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final String htmlEscape(@JetValueParameter(name="$receiver") String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinPackage.replace$default((String)KotlinPackage.replace$default((String)KotlinPackage.replace$default((String)$receiver, (String)"&", (String)"&amp;", (boolean)false, (int)4), (String)"<", (String)"&lt;", (boolean)false, (int)4), (String)">", (String)"&gt;", (boolean)false, (int)4);
    }

    KDocRenderer() {
        INSTANCE$ = this;
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"_\u0006)aQ*\u0019:lI><hNT8eK*a1\nR8d%\u0016tG-\u001a:fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002B6e_\u000eT1!\u00118z\u0015\u0019a\u0014N\\5u})!an\u001c3f\u0015\u001d\t5\u000b\u0016(pI\u0016T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\t[\u0006\u00148\u000eZ8x]*\u0019\u0011m\u001d;\u000b\rA\f'/\u001a8u\u0015\u0019\u0019FO]5oO*I2\nR8d%\u0016tG-\u001a:fe\u0012j\u0015M]6e_^tgj\u001c3f\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\tG\"LG\u000e\u001a:f]*!A*[:u\u0015\u0011)H/\u001b7\u000b\u0017\u001d,Go\u00115jY\u0012\u0014XM\u001c\u0006\nK:$wJ\u001a4tKRT1!\u00138u\u001519W\r^#oI>3gm]3u\u0015-9W\r^'be.$wn\u001e8\u000b\u000f\u001d,GOT8eK*Iq-\u001a;QCJ,g\u000e\u001e\u0006\fgR\f'\u000f^(gMN,GO\u0003\bhKR\u001cF/\u0019:u\u001f\u001a47/\u001a;\u000b\tQ,\u0007\u0010\u001e\u0006\bO\u0016$H+\u001a=u\u0015\u0011!\u0018\u0010]3\u000b\u0019%+E.Z7f]R$\u0016\u0010]3\u000b\u000f\u001d,G\u000fV=qK*)1\r[5mI\u0002\u000e!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001C\u0004\u0011\u000fa\u0001!\u0002\u0002\u0005\u0001!-QA\u0001C\u0005\u0011\u0019)!\u0001B\u0003\t\u000e\u0015\u0019A1\u0002\u0005\u0006\u0019\u0001)1\u0001b\u0002\t\u00101\u0001QA\u0001C\u0006\u0011\u0015)!\u0001\u0002\u0002\t\u0011\u0015\t\u0001\u0012C\u0003\u0003\t!A\u0011\"\u0002\u0002\u0005\u0012!=Qa\u0001C\u0004\u0011)a\u0001!\u0002\u0002\u0005\u0011!UQA\u0001\u0003\u000b\u0011))1\u0001b\u0002\t\u00191\u0001Qa\u0001\u0003\u0006\u0011Ea\u0001!\u0002\u0002\u0005\u000b!\tB\u0001\u0001\u0007\u00043\t)\u0011\u0001\u0003\u0003.'\u0011\u0001G\u0001g\u0005\"\r\u0015\t\u00012C\u0005\u0004\u0013\t)\u0011\u0001C\u0002V\u0007!)1\u0001b\u0005\n\u0003!UQb\u0001\u0003\f\u0013\u0005A)\"\f\u0007\u0005A\u0012A:\"\t\u0002\u0006\u0003!YA\u0005I+\u0004\t5\u0019A\u0011D\u0005\u0002\t\u000bis\u0002\u00021\u00051\u0019\t#!B\u0001\t\u000eU\u001b\u0001\"B\u0002\u0005\r%\t\u0001\"C\u0007\u0004\t5I\u0011\u0001C\u0005.\u001f\u0011\u0001G\u0001'\u0003\"\u0005\u0015\t\u0001BB+\u0004\u0011\u0015\u0019A\u0011B\u0005\u0002\u0011\u001di1\u0001b\u0007\n\u0003!9Q\u0006\u0005\u0003a\ta9\u0011eA\u0003\u0002\u0011\ra\t!V\u0002\t\u000b\r!q!C\u0001\t\u00105\u0019AAD\u0005\u0002\u0011\u001fiC\u0002\u00021\u00051;\t#!B\u0001\t\u0017\u0011\u0002Sk\u0001\u0003\u000e\u0007\u0011y\u0011\"\u0001C\u0003[1!\u0001\r\u0002M\u0010C\t)\u0011\u0001#\u0004%AU\u001bA!D\u0002\u0005!%\t\u0001\"C\u0017\r\t\u0001$\u0001\u0014E\u0011\u0003\u000b\u0005A9\u0002\n\u0011V\u0007\u0011i1\u0001b\t\n\u0003!aQ\u0006\u0006\u0003\u00011Iij\u0001\u0002\u0001\t\"5\u0011Q!\u0001E\f!\u000e\u0001\u0011eA\u0003\u0002\u0011\ra\t!U\u0002\u0006\tII\u0011\u0001c\u0004\u000e\u0003!aQ\u0017KC(\t\r\b\u0001\u0004BO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!1\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005A1\u0001$\u0001Q\u0007\u0003ij\u0001\u0002\u0001\t\r5\u0011Q!\u0001E\u0007!\u000e\t\u0011EA\u0003\u0002\u0011\r\t6!\u0003\u0003\u0005\u0013\u0005!\u0001!D\u0001\t\u000f5\t\u0001rB\u0007\u0002\u0011%\u0001"})
    public static final class MarkdownNode {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final List<? extends MarkdownNode> children;
        @NotNull
        private final ASTNode node;
        @Nullable
        private final MarkdownNode parent;
        @NotNull
        private final String markdown;

        static {
            $kotlinClass = Reflection.createKotlinClass(MarkdownNode.class);
        }

        @NotNull
        public final List<MarkdownNode> getChildren() {
            return this.children;
        }

        public final int getEndOffset() {
            return this.node.getEndOffset();
        }

        public final int getStartOffset() {
            return this.node.getStartOffset();
        }

        @NotNull
        public final IElementType getType() {
            return this.node.getType();
        }

        @NotNull
        public final String getText() {
            return KotlinPackage.substring((String)this.markdown, (int)this.getStartOffset(), (int)this.getEndOffset());
        }

        @Nullable
        public final MarkdownNode child(@JetValueParameter(name="type") @NotNull IElementType type2) {
            Object v0;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                Iterable $receiver = this.children;
                for (Object element : $receiver) {
                    MarkdownNode it = (MarkdownNode)element;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)type2)) continue;
                    v0 = element;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final ASTNode getNode() {
            return this.node;
        }

        @Nullable
        public final MarkdownNode getParent() {
            return this.parent;
        }

        @NotNull
        public final String getMarkdown() {
            return this.markdown;
        }

        /*
         * WARNING - void declaration
         */
        public MarkdownNode(@JetValueParameter(name="node") @NotNull ASTNode node2, @JetValueParameter(name="parent", type="?") @Nullable MarkdownNode parent, @JetValueParameter(name="markdown") @NotNull String markdown) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)markdown, (String)"markdown");
            this.node = node2;
            this.parent = parent;
            this.markdown = markdown;
            Iterable iterable = this.node.getChildren();
            MarkdownNode markdownNode = this;
            void var5_6 = $receiver2;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                ASTNode aSTNode = (ASTNode)item;
                list = destination;
                MarkdownNode markdownNode2 = new MarkdownNode((ASTNode)it, this, this.getMarkdown());
                list.add(markdownNode2);
            }
            markdownNode.children = list = (List)destination;
        }
    }
}

