/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetDotQualifiedExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;

public abstract class JetTemplateContextType
extends TemplateContextType {
    protected JetTemplateContextType(@NotNull @NonNls String id, @NotNull String presentableName, @Nullable java.lang.Class<? extends TemplateContextType> baseContextType) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/kotlin/idea/liveTemplates/JetTemplateContextType", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "org/jetbrains/kotlin/idea/liveTemplates/JetTemplateContextType", "<init>"));
        }
        super(id, presentableName, baseContextType);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/liveTemplates/JetTemplateContextType", "isInContext"));
        }
        if (PsiUtilBase.getLanguageAtOffset((PsiFile)file, (int)offset).isKindOf((Language)JetLanguage.INSTANCE)) {
            IElementType elementType;
            PsiElement element = file.findElementAt(offset);
            if (element == null) {
                element = file.findElementAt(offset - 1);
            }
            if (element instanceof PsiWhiteSpace) {
                return false;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                return this.isCommentInContext();
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, JetPackageDirective.class) != null || PsiTreeUtil.getParentOfType((PsiElement)element, JetImportDirective.class) != null) {
                return false;
            }
            if (element instanceof LeafPsiElement && (elementType = ((LeafPsiElement)element).getElementType()) == JetTokens.IDENTIFIER) {
                if (element.getParent() instanceof JetReferenceExpression) {
                    PsiElement parentOfParent = element.getParent().getParent();
                    JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JetQualifiedExpression.class);
                    if (qualifiedExpression != null && qualifiedExpression.getSelectorExpression() == parentOfParent) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected boolean isCommentInContext() {
        return false;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    public static class Comment
    extends JetTemplateContextType {
        public Comment() {
            super("KOTLIN_COMMENT", "Comment", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/JetTemplateContextType$Comment", "isInContext"));
            }
            return false;
        }

        @Override
        protected boolean isCommentInContext() {
            return true;
        }
    }

    public static class Expression
    extends JetTemplateContextType {
        public Expression() {
            super("KOTLIN_EXPRESSION", "Expression", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/JetTemplateContextType$Expression", "isInContext"));
            }
            return element.getParent() instanceof JetExpression && !(element.getParent() instanceof JetConstantExpression) && !(element.getParent().getParent() instanceof JetDotQualifiedExpression) && !(element.getParent() instanceof JetParameter);
        }
    }

    public static class Statement
    extends JetTemplateContextType {
        public Statement() {
            super("KOTLIN_STATEMENT", "Statement", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/JetTemplateContextType$Statement", "isInContext"));
            }
            PsiElement parentStatement = PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)new Condition<PsiElement>(){

                public boolean value(PsiElement element) {
                    return element instanceof JetExpression && element.getParent() instanceof JetBlockExpression;
                }
            });
            if (parentStatement == null) {
                return false;
            }
            return element.getTextOffset() == parentStatement.getTextOffset();
        }
    }

    public static class Class
    extends JetTemplateContextType {
        public Class() {
            super("KOTLIN_CLASS", "Class", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/JetTemplateContextType$Class", "isInContext"));
            }
            PsiElement e = element;
            while (e != null && !(e instanceof JetClassOrObject)) {
                if (e instanceof JetModifierList) {
                    if ((e = e.getParent()) == null) continue;
                    e = e.getParent();
                    continue;
                }
                if (e instanceof JetProperty || e instanceof JetNamedFunction) {
                    return false;
                }
                e = e.getParent();
            }
            return e != null;
        }
    }

    public static class TopLevel
    extends JetTemplateContextType {
        public TopLevel() {
            super("KOTLIN_TOPLEVEL", "Top-level", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/JetTemplateContextType$TopLevel", "isInContext"));
            }
            PsiElement e = element;
            while (e != null) {
                if (e instanceof JetModifierList) {
                    if ((e = e.getParent()) == null) continue;
                    e = e.getParent();
                    continue;
                }
                if (e instanceof JetProperty || e instanceof JetNamedFunction || e instanceof JetClassOrObject) {
                    return false;
                }
                e = e.getParent();
            }
            return true;
        }
    }

    public static class Generic
    extends JetTemplateContextType {
        public Generic() {
            super("KOTLIN", "Kotlin", EverywhereContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/JetTemplateContextType$Generic", "isInContext"));
            }
            return true;
        }

        @Override
        protected boolean isCommentInContext() {
            return true;
        }
    }
}

