/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.project.Project;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.stubindex.JetProbablyNothingFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetProbablyNothingPropertyShortNameIndex;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.ElementResolver;
import org.jetbrains.kotlin.resolve.lazy.ProbablyNothingCallableNames;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.storage.LazyResolveStorageManager;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;

public class ResolveElementCache
extends ElementResolver {
    private final Project project;
    private final CachedValue<MemoizedFunctionToNotNull<JetElement, BindingContext>> additionalResolveCache;

    public ResolveElementCache(ResolveSession resolveSession, Project project) {
        super(resolveSession);
        this.project = project;
        this.additionalResolveCache = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<MemoizedFunctionToNotNull<JetElement, BindingContext>>(){

            @Nullable
            public CachedValueProvider.Result<MemoizedFunctionToNotNull<JetElement, BindingContext>> compute() {
                ResolveSession resolveSession = ResolveElementCache.this.getResolveSession();
                LazyResolveStorageManager manager = resolveSession.getStorageManager();
                MemoizedFunctionToNotNull<JetElement, BindingContext> elementsCacheFunction = manager.createSoftlyRetainedMemoizedFunction(new Function1<JetElement, BindingContext>(){

                    public BindingContext invoke(JetElement jetElement) {
                        return ResolveElementCache.this.performElementAdditionalResolve(jetElement, jetElement, BodyResolveMode.FULL);
                    }
                });
                return CachedValueProvider.Result.create(elementsCacheFunction, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, resolveSession.getExceptionTracker()});
            }
        }, false);
    }

    @Override
    @NotNull
    public BindingContext getElementAdditionalResolve(@NotNull JetElement jetElement) {
        if (jetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetElement", "org/jetbrains/kotlin/idea/project/ResolveElementCache", "getElementAdditionalResolve"));
        }
        BindingContext bindingContext2 = (BindingContext)((MemoizedFunctionToNotNull)this.additionalResolveCache.getValue()).invoke(jetElement);
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/ResolveElementCache", "getElementAdditionalResolve"));
        }
        return bindingContext2;
    }

    @Override
    public boolean hasElementAdditionalResolveCached(@NotNull JetElement jetElement) {
        if (jetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetElement", "org/jetbrains/kotlin/idea/project/ResolveElementCache", "hasElementAdditionalResolveCached"));
        }
        if (!this.additionalResolveCache.hasUpToDateValue()) {
            return false;
        }
        return ((MemoizedFunctionToNotNull)this.additionalResolveCache.getValue()).isComputed(jetElement);
    }

    @Override
    @NotNull
    public AdditionalCheckerProvider getAdditionalCheckerProvider(@NotNull JetFile jetFile) {
        if (jetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetFile", "org/jetbrains/kotlin/idea/project/ResolveElementCache", "getAdditionalCheckerProvider"));
        }
        AdditionalCheckerProvider additionalCheckerProvider = TargetPlatformDetector.getPlatform(jetFile).getAdditionalCheckerProvider();
        if (additionalCheckerProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/ResolveElementCache", "getAdditionalCheckerProvider"));
        }
        return additionalCheckerProvider;
    }

    @Override
    @NotNull
    protected ProbablyNothingCallableNames probablyNothingCallableNames() {
        ProbablyNothingCallableNames probablyNothingCallableNames = new ProbablyNothingCallableNames(){

            @Override
            @NotNull
            public Collection<String> functionNames() {
                Collection collection = JetProbablyNothingFunctionShortNameIndex.getInstance().getAllKeys(ResolveElementCache.this.project);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/ResolveElementCache$2", "functionNames"));
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<String> propertyNames() {
                Collection collection = JetProbablyNothingPropertyShortNameIndex.getInstance().getAllKeys(ResolveElementCache.this.project);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/ResolveElementCache$2", "propertyNames"));
                }
                return collection;
            }
        };
        if (probablyNothingCallableNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/ResolveElementCache", "probablyNothingCallableNames"));
        }
        return probablyNothingCallableNames;
    }
}

