/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.core.refactoring.JetNameSuggester;
import org.jetbrains.kotlin.idea.core.refactoring.JetNameValidator;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionParametersFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionLiteralSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveFunctionParametersFix;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetValVar;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetValueArgumentName;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public abstract class ChangeFunctionSignatureFix
extends JetIntentionAction<PsiElement> {
    protected final PsiElement context;
    protected final FunctionDescriptor functionDescriptor;

    public ChangeFunctionSignatureFix(@NotNull PsiElement context2, @NotNull FunctionDescriptor functionDescriptor) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix", "<init>"));
        }
        super(context2);
        this.context = context2;
        this.functionDescriptor = functionDescriptor;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.signature.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        Collection<PsiElement> declarations2 = DescriptorToSourceUtilsIde.INSTANCE$.getAllDeclarations(project, this.functionDescriptor);
        if (declarations2.isEmpty()) {
            return false;
        }
        for (PsiElement declaration : declarations2) {
            if (declaration.isValid() && QuickFixUtil.canModifyElement(declaration)) continue;
            return false;
        }
        return true;
    }

    protected static String getNewArgumentName(ValueArgument argument, JetNameValidator validator2) {
        JetValueArgumentName argumentName = argument.getArgumentName();
        JetExpression expression2 = argument.getArgumentExpression();
        if (argumentName != null) {
            return validator2.validateName(argumentName.getName());
        }
        if (expression2 != null) {
            return JetNameSuggester.suggestNames(expression2, validator2, "param")[0];
        }
        return validator2.validateName("param");
    }

    protected static JetParameterInfo getNewParameterInfo(FunctionDescriptor functionDescriptor, BindingContext bindingContext2, ValueArgument argument, JetNameValidator validator2) {
        String name2 = ChangeFunctionSignatureFix.getNewArgumentName(argument, validator2);
        JetExpression expression2 = argument.getArgumentExpression();
        JetType type2 = expression2 != null ? bindingContext2.getType(expression2) : null;
        type2 = type2 != null ? type2 : KotlinBuiltIns.getInstance().getNullableAnyType();
        JetParameterInfo parameterInfo = new JetParameterInfo(functionDescriptor, -1, name2, type2, null, null, JetValVar.None, null);
        parameterInfo.setCurrentTypeText(IdeDescriptorRenderers.SOURCE_CODE.renderType(type2));
        return parameterInfo;
    }

    private static boolean hasTypeMismatches(List<ValueParameterDescriptor> parameters2, List<? extends ValueArgument> arguments2, BindingContext bindingContext2) {
        for (int i = 0; i < parameters2.size(); ++i) {
            assert (i < arguments2.size());
            JetExpression argumentExpression = arguments2.get(i).getArgumentExpression();
            JetType argumentType = argumentExpression != null ? bindingContext2.getType(argumentExpression) : null;
            JetType parameterType = parameters2.get(i).getType();
            if (argumentType != null && JetTypeChecker.DEFAULT.isSubtypeOf(argumentType, parameterType)) continue;
            return true;
        }
        return false;
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public ChangeFunctionSignatureFix createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$1", "createAction"));
                }
                JetCallElement callElement2 = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)diagnostic.getPsiElement(), JetCallElement.class);
                CallableDescriptor descriptor2 = (CallableDescriptor)((DiagnosticWithParameters1)DiagnosticFactory.cast(diagnostic, Errors.TOO_MANY_ARGUMENTS, Errors.NO_VALUE_FOR_PARAMETER)).getA();
                if (callElement2 != null) {
                    return ChangeFunctionSignatureFix.createFix(callElement2, (PsiElement)callElement2, descriptor2);
                }
                return null;
            }
        };
    }

    public static JetSingleIntentionActionFactory createFactoryForParametersNumberMismatch() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public ChangeFunctionSignatureFix createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$2", "createAction"));
                }
                DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.cast(diagnostic);
                JetFunction functionLiteral = (JetFunction)diagnosticWithParameters.getPsiElement();
                BindingContext bindingContext2 = ResolvePackage.analyzeFully(functionLiteral.getContainingJetFile());
                DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral);
                if (descriptor2 instanceof FunctionDescriptor && functionLiteral instanceof JetFunctionLiteral) {
                    return new ChangeFunctionLiteralSignatureFix((JetFunctionLiteral)functionLiteral, (FunctionDescriptor)descriptor2, (List)diagnosticWithParameters.getB());
                }
                return null;
            }
        };
    }

    public static JetSingleIntentionActionFactory createFactoryForUnusedParameter() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public ChangeFunctionSignatureFix createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$3", "createAction"));
                }
                Object descriptor2 = ((DiagnosticWithParameters1)Errors.UNUSED_PARAMETER.cast(diagnostic)).getA();
                if (descriptor2 instanceof ValueParameterDescriptor) {
                    return ChangeFunctionSignatureFix.createFix(null, diagnostic.getPsiElement(), (CallableDescriptor)descriptor2);
                }
                return null;
            }
        };
    }

    @Nullable
    private static ChangeFunctionSignatureFix createFix(JetCallElement callElement2, PsiElement context2, CallableDescriptor descriptor2) {
        DeclarationDescriptor containingDescriptor;
        FunctionDescriptor functionDescriptor = null;
        if (descriptor2 instanceof FunctionDescriptor) {
            functionDescriptor = (FunctionDescriptor)descriptor2;
        } else if (descriptor2 instanceof ValueParameterDescriptor && (containingDescriptor = descriptor2.getContainingDeclaration()) instanceof FunctionDescriptor) {
            functionDescriptor = (FunctionDescriptor)containingDescriptor;
        }
        if (functionDescriptor == null) {
            return null;
        }
        if (functionDescriptor.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return null;
        }
        BindingContext bindingContext2 = ResolvePackage.analyzeFully((JetFile)context2.getContainingFile());
        if (descriptor2 instanceof ValueParameterDescriptor) {
            return new RemoveFunctionParametersFix(context2, functionDescriptor, (ValueParameterDescriptor)descriptor2);
        }
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        List<? extends ValueArgument> arguments2 = callElement2.getValueArguments();
        if (arguments2.size() > parameters2.size()) {
            boolean hasTypeMismatches = ChangeFunctionSignatureFix.hasTypeMismatches(parameters2, arguments2, bindingContext2);
            return new AddFunctionParametersFix(callElement2, functionDescriptor, hasTypeMismatches);
        }
        return null;
    }
}

