/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.types.JetType;

public class ChangeParameterTypeFix
extends JetIntentionAction<JetParameter> {
    private final JetType type;
    private final String containingDeclarationName;
    private final boolean isPrimaryConstructorParameter;

    public ChangeParameterTypeFix(@NotNull JetParameter element, @NotNull JetType type2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeParameterTypeFix", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/quickfix/ChangeParameterTypeFix", "<init>"));
        }
        super(element);
        this.type = type2;
        JetNamedDeclaration declaration = (JetNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, JetNamedDeclaration.class);
        this.isPrimaryConstructorParameter = declaration instanceof JetClass;
        FqName declarationFQName = declaration == null ? null : declaration.getFqName();
        this.containingDeclarationName = declarationFQName == null ? declaration.getName() : declarationFQName.asString();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeParameterTypeFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && this.containingDeclarationName != null;
    }

    @NotNull
    public String getText() {
        String renderedType = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type);
        String string = this.isPrimaryConstructorParameter ? JetBundle.message("change.primary.constructor.parameter.type", ((JetParameter)this.element).getName(), this.containingDeclarationName, renderedType) : JetBundle.message("change.function.parameter.type", ((JetParameter)this.element).getName(), this.containingDeclarationName, renderedType);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeParameterTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeParameterTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeParameterTypeFix", "invoke"));
        }
        JetTypeReference newTypeRef = PsiPackage.JetPsiFactory((PsiElement)file).createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type));
        newTypeRef = ((JetParameter)this.element).setTypeReference(newTypeRef);
        assert (newTypeRef != null);
        ShortenReferences.DEFAULT.process(newTypeRef);
    }
}

