/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetFile;

public abstract class JetIntentionAction<T extends PsiElement>
implements IntentionAction {
    @NotNull
    protected T element;

    public JetIntentionAction(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/JetIntentionAction", "<init>"));
        }
        this.element = element;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/JetIntentionAction", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/JetIntentionAction", "isAvailable"));
        }
        return this.element.isValid() && (file.getManager().isInProject((PsiElement)file) || file instanceof JetCodeFragment) && file instanceof JetFile;
    }

    @Deprecated
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/JetIntentionAction", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/JetIntentionAction", "invoke"));
        }
        if (file instanceof JetFile && FileModificationService.getInstance().prepareFileForWrite(this.element.getContainingFile())) {
            this.invoke(project, editor, (JetFile)file);
        }
    }

    protected abstract void invoke(@NotNull Project var1, @Nullable Editor var2, @NotNull JetFile var3) throws IncorrectOperationException;

    public boolean startInWriteAction() {
        return true;
    }
}

