/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.CastExpressionFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionActionsFactory;
import org.jetbrains.kotlin.idea.util.UtilPackage;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.JetScopeUtils;
import org.jetbrains.kotlin.types.JetType;

public class QuickFixFactoryForTypeMismatchError
extends JetIntentionActionsFactory {
    private static final Logger LOG = Logger.getInstance(QuickFixFactoryForTypeMismatchError.class);

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        JetFunction declaration;
        ResolvedCall<? extends CallableDescriptor> resolvedCall;
        PsiElement expressionParent;
        JetCallableDeclaration function2;
        JetType typeToInsert;
        JetScope scope2;
        JetProperty property;
        JetType expressionType;
        JetType expectedType;
        AbstractDiagnostic diagnosticWithParameters;
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
        }
        LinkedList<IntentionAction> actions = new LinkedList<IntentionAction>();
        BindingContext context2 = ResolvePackage.analyzeFully((JetFile)diagnostic.getPsiFile());
        PsiElement diagnosticElement = diagnostic.getPsiElement();
        if (!(diagnosticElement instanceof JetExpression)) {
            LOG.error("Unexpected element: " + diagnosticElement.getText());
            List<IntentionAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
            }
            return list;
        }
        JetExpression expression2 = (JetExpression)diagnosticElement;
        if (diagnostic.getFactory() == Errors.TYPE_MISMATCH) {
            diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast(diagnostic);
            expectedType = (JetType)((DiagnosticWithParameters2)diagnosticWithParameters).getA();
            expressionType = (JetType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
        } else if (diagnostic.getFactory() == Errors.NULL_FOR_NONNULL_TYPE) {
            diagnosticWithParameters = (DiagnosticWithParameters1)Errors.NULL_FOR_NONNULL_TYPE.cast(diagnostic);
            expectedType = (JetType)((DiagnosticWithParameters1)diagnosticWithParameters).getA();
            expressionType = UtilPackage.makeNullable(expectedType);
        } else if (diagnostic.getFactory() == Errors.CONSTANT_EXPECTED_TYPE_MISMATCH) {
            diagnosticWithParameters = (DiagnosticWithParameters2)Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
            expectedType = (JetType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
            expressionType = context2.getType(expression2);
            if (expressionType == null) {
                LOG.error("No type inferred: " + expression2.getText());
                List<IntentionAction> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
                }
                return list;
            }
        } else {
            LOG.error("Unexpected diagnostic: " + DefaultErrorMessages.render(diagnostic));
            List<IntentionAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
            }
            return list;
        }
        if (!(expression2 instanceof JetBinaryExpressionWithTypeRHS) && !(expression2.getParent() instanceof JetBinaryExpressionWithTypeRHS)) {
            actions.add(new CastExpressionFix(expression2, expectedType));
        }
        if ((property = (JetProperty)PsiTreeUtil.getParentOfType((PsiElement)expression2, JetProperty.class)) != null) {
            JetPropertyAccessor getter = property.getGetter();
            JetExpression initializer = property.getInitializer();
            if (QuickFixUtil.canEvaluateTo(initializer, expression2) || getter != null && QuickFixUtil.canFunctionOrGetterReturnExpression(property.getGetter(), expression2)) {
                scope2 = JetScopeUtils.getResolutionScope(property, context2);
                typeToInsert = UtilPackage.approximateWithResolvableType(expressionType, scope2, false);
                actions.add(new ChangeVariableTypeFix(property, typeToInsert));
            }
        }
        JetCallableDeclaration jetCallableDeclaration = function2 = (expressionParent = expression2.getParent()) instanceof JetReturnExpression ? BindingContextUtilPackage.getTargetFunction((JetReturnExpression)expressionParent, context2) : (JetCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression2, JetFunction.class, (boolean)true);
        if (function2 instanceof JetFunction && QuickFixUtil.canFunctionOrGetterReturnExpression(function2, expression2)) {
            scope2 = JetScopeUtils.getResolutionScope(function2, context2);
            typeToInsert = UtilPackage.approximateWithResolvableType(expressionType, scope2, false);
            actions.add(new ChangeFunctionReturnTypeFix((JetFunction)function2, typeToInsert));
        }
        if (expression2 instanceof JetOperationExpression && (resolvedCall = CallUtilPackage.getResolvedCall(expression2, context2)) != null && (declaration = QuickFixFactoryForTypeMismatchError.getFunctionDeclaration(resolvedCall)) != null) {
            actions.add(new ChangeFunctionReturnTypeFix(declaration, expectedType));
        }
        if (expression2 instanceof JetCallExpression && (resolvedCall = CallUtilPackage.getResolvedCall(expression2, context2)) != null && (declaration = QuickFixFactoryForTypeMismatchError.getFunctionDeclaration(resolvedCall)) != null) {
            actions.add(new ChangeFunctionReturnTypeFix(declaration, expectedType));
        }
        if ((resolvedCall = CallUtilPackage.getParentResolvedCall(expression2, context2, true)) != null) {
            JetIfExpression parentIf = QuickFixUtil.getParentIfForBranch(expression2);
            JetExpression argumentExpression = parentIf != null ? parentIf : expression2;
            ValueArgument valueArgument = CallUtilPackage.getValueArgumentForExpression(resolvedCall.getCall(), argumentExpression);
            if (valueArgument != null) {
                JetType valueArgumentType;
                JetParameter correspondingParameter = QuickFixUtil.getParameterDeclarationForValueArgument(resolvedCall, valueArgument);
                JetType jetType = valueArgumentType = diagnostic.getFactory() == Errors.NULL_FOR_NONNULL_TYPE ? expressionType : context2.getType(valueArgument.getArgumentExpression());
                if (correspondingParameter != null && valueArgumentType != null) {
                    JetCallableDeclaration callable = (JetCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)correspondingParameter, JetCallableDeclaration.class, (boolean)true);
                    JetScope scope3 = callable != null ? JetScopeUtils.getResolutionScope(callable, context2) : null;
                    JetType typeToInsert2 = UtilPackage.approximateWithResolvableType(valueArgumentType, scope3, true);
                    actions.add(new ChangeParameterTypeFix(correspondingParameter, typeToInsert2));
                }
            }
        }
        LinkedList<IntentionAction> linkedList = actions;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "doCreateActions"));
        }
        return linkedList;
    }

    @Nullable
    private static JetFunction getFunctionDeclaration(@NotNull ResolvedCall<?> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError", "getFunctionDeclaration"));
        }
        PsiElement result2 = QuickFixUtil.safeGetDeclaration(resolvedCall.getResultingDescriptor());
        if (result2 instanceof JetFunction) {
            return (JetFunction)result2;
        }
        return null;
    }
}

