/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.references.JetSimpleReference;
import org.jetbrains.kotlin.idea.references.ReferencesPackage;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

public class JetInvokeFunctionReference
extends JetSimpleReference<JetCallExpression>
implements MultiRangeReference {
    public JetInvokeFunctionReference(@NotNull JetCallExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/references/JetInvokeFunctionReference", "<init>"));
        }
        super(expression2);
    }

    public TextRange getRangeInElement() {
        return ((JetCallExpression)this.getElement()).getTextRange().shiftRight(-((JetCallExpression)this.getElement()).getTextOffset());
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> getTargetDescriptors(@NotNull BindingContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/references/JetInvokeFunctionReference", "getTargetDescriptors"));
        }
        Call call = CallUtilPackage.getCall((JetElement)this.getElement(), context2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(call, context2);
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            Set<DeclarationDescriptor> set = Collections.singleton(((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall().getCandidateDescriptor());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/JetInvokeFunctionReference", "getTargetDescriptors"));
            }
            return set;
        }
        if (call != null && resolvedCall != null && call.getCallType() == Call.CallType.INVOKE) {
            Set<DeclarationDescriptor> set = Collections.singleton(resolvedCall.getCandidateDescriptor());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/JetInvokeFunctionReference", "getTargetDescriptors"));
            }
            return set;
        }
        List<DeclarationDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/JetInvokeFunctionReference", "getTargetDescriptors"));
        }
        return list;
    }

    public List<TextRange> getRanges() {
        ArrayList<TextRange> list = new ArrayList<TextRange>();
        JetValueArgumentList valueArgumentList = ((JetCallExpression)this.getExpression()).getValueArgumentList();
        if (valueArgumentList != null) {
            if (valueArgumentList.getArguments().size() > 0) {
                ASTNode rPar;
                ASTNode valueArgumentListNode = valueArgumentList.getNode();
                ASTNode lPar = valueArgumentListNode.findChildByType((IElementType)JetTokens.LPAR);
                if (lPar != null) {
                    list.add(this.getRange(lPar));
                }
                if ((rPar = valueArgumentListNode.findChildByType((IElementType)JetTokens.RPAR)) != null) {
                    list.add(this.getRange(rPar));
                }
            } else {
                list.add(this.getRange(valueArgumentList.getNode()));
            }
        }
        List<JetFunctionLiteralArgument> functionLiteralArguments = ((JetCallExpression)this.getExpression()).getFunctionLiteralArguments();
        for (JetFunctionLiteralArgument functionLiteralArgument : functionLiteralArguments) {
            JetFunctionLiteralExpression functionLiteralExpression = functionLiteralArgument.getFunctionLiteral();
            list.add(this.getRange(functionLiteralExpression.getLeftCurlyBrace()));
            ASTNode rightCurlyBrace = functionLiteralExpression.getRightCurlyBrace();
            if (rightCurlyBrace == null) continue;
            list.add(this.getRange(rightCurlyBrace));
        }
        return list;
    }

    private TextRange getRange(ASTNode node2) {
        TextRange textRange = node2.getTextRange();
        return textRange.shiftRight(-((JetCallExpression)this.getExpression()).getTextOffset());
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@Nullable String newElementName) {
        return ReferencesPackage.renameImplicitConventionalCall(this, newElementName);
    }
}

