/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.NotNullFunction;
import java.util.List;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.run.JetRunConfiguration;
import org.jetbrains.kotlin.idea.run.JetRunConfigurationType;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclarationContainer;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;

public class JetRunConfigurationProducer
extends RuntimeConfigurationProducer
implements Cloneable {
    @Nullable
    private PsiElement mySourceElement;

    public JetRunConfigurationProducer() {
        super((ConfigurationType)JetRunConfigurationType.getInstance());
    }

    @Nullable
    public PsiElement getSourceElement() {
        return this.mySourceElement;
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(@NotNull Location location, ConfigurationContext configurationContext) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/idea/run/JetRunConfigurationProducer", "createConfigurationByElement"));
        }
        JetDeclarationContainer container2 = JetRunConfigurationProducer.getEntryPointContainer(location);
        if (container2 == null) {
            return null;
        }
        this.mySourceElement = (PsiElement)container2;
        FqName startClassFQName = JetRunConfigurationProducer.getStartClassFqName(container2);
        if (startClassFQName == null) {
            return null;
        }
        Module module = location.getModule();
        assert (module != null);
        return this.createConfigurationByQName(module, configurationContext, startClassFQName);
    }

    @Nullable
    private static FqName getStartClassFqName(@Nullable JetDeclarationContainer container2) {
        if (container2 == null) {
            return null;
        }
        if (container2 instanceof JetFile) {
            return PackageClassUtils.getPackageClassFqName(((JetFile)container2).getPackageFqName());
        }
        if (container2 instanceof JetClassOrObject) {
            JetClassOrObject classOrObject = (JetClassOrObject)container2;
            if (classOrObject instanceof JetObjectDeclaration && ((JetObjectDeclaration)classOrObject).isCompanion()) {
                classOrObject = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)classOrObject, JetClass.class);
            }
            return classOrObject != null ? classOrObject.getFqName() : null;
        }
        throw new IllegalArgumentException("Invalid entry-point container: " + ((PsiElement)container2).getText());
    }

    @Nullable
    private static JetDeclarationContainer getEntryPointContainer(@NotNull Location location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/idea/run/JetRunConfigurationProducer", "getEntryPointContainer"));
        }
        if (DumbService.getInstance((Project)location.getProject()).isDumb()) {
            return null;
        }
        Module module = location.getModule();
        if (module == null) {
            return null;
        }
        if (ProjectStructureUtil.isJsKotlinModule(module)) {
            return null;
        }
        PsiElement locationElement = location.getPsiElement();
        PsiFile psiFile = locationElement.getContainingFile();
        if (!(psiFile instanceof JetFile) || !ProjectRootsUtil.isInProjectOrLibSource((PsiElement)psiFile)) {
            return null;
        }
        JetFile jetFile = (JetFile)psiFile;
        final ResolutionFacade resolutionFacade = ResolvePackage.getResolutionFacade(jetFile);
        MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(new NotNullFunction<JetNamedFunction, FunctionDescriptor>(){

            @NotNull
            public FunctionDescriptor fun(JetNamedFunction function2) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)resolutionFacade.resolveToDescriptor(function2);
                if (functionDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfigurationProducer$1", "fun"));
                }
                return functionDescriptor;
            }
        });
        JetDeclarationContainer currentElement = (JetDeclarationContainer)PsiTreeUtil.getNonStrictParentOfType((PsiElement)locationElement, (Class[])new Class[]{JetClassOrObject.class, JetFile.class});
        while (currentElement != null) {
            JetDeclarationContainer entryPointContainer = currentElement;
            if (entryPointContainer instanceof JetClass) {
                entryPointContainer = (JetDeclarationContainer)KotlinPackage.singleOrNull(((JetClass)currentElement).getCompanionObjects());
            }
            if (entryPointContainer != null && mainFunctionDetector.hasMain(entryPointContainer.getDeclarations())) {
                return entryPointContainer;
            }
            currentElement = (JetDeclarationContainer)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)currentElement), (Class[])new Class[]{JetClassOrObject.class, JetFile.class});
        }
        return null;
    }

    @NotNull
    private RunnerAndConfigurationSettings createConfigurationByQName(@NotNull Module module, ConfigurationContext context2, @NotNull FqName fqName2) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/run/JetRunConfigurationProducer", "createConfigurationByQName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/idea/run/JetRunConfigurationProducer", "createConfigurationByQName"));
        }
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(module.getProject(), context2);
        JetRunConfiguration configuration = (JetRunConfiguration)settings.getConfiguration();
        configuration.setModule(module);
        configuration.setName(StringUtil.trimEnd((String)fqName2.asString(), (String)("." + PackageClassUtils.getPackageClassName(fqName2))));
        configuration.setRunClass(fqName2.asString());
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfigurationProducer", "createConfigurationByQName"));
        }
        return runnerAndConfigurationSettings;
    }

    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context2) {
        if (existingConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingConfigurations", "org/jetbrains/kotlin/idea/run/JetRunConfigurationProducer", "findExistingByElement"));
        }
        FqName startClassFQName = JetRunConfigurationProducer.getStartClassFqName(JetRunConfigurationProducer.getEntryPointContainer(location));
        if (startClassFQName == null) {
            return null;
        }
        for (RunnerAndConfigurationSettings existingConfiguration : existingConfigurations) {
            JetRunConfiguration jetConfiguration;
            if (!(existingConfiguration.getType() instanceof JetRunConfigurationType) || !Comparing.equal((String)(jetConfiguration = (JetRunConfiguration)existingConfiguration.getConfiguration()).getRunClass(), (String)startClassFQName.asString()) || !Comparing.equal((Object)location.getModule(), (Object)jetConfiguration.getConfigurationModule().getModule())) continue;
            return existingConfiguration;
        }
        return null;
    }

    public int compareTo(Object o) {
        return -1;
    }
}

