/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import com.google.common.collect.ImmutableList;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.ModuleParameters;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.di.InjectorForTopDownAnalyzerForJs;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;

public final class TopDownAnalyzerFacadeForJS {
    public static final List<ImportPath> DEFAULT_IMPORTS = ImmutableList.of((Object)new ImportPath("java.lang.*"), (Object)new ImportPath("kotlin.*"), (Object)new ImportPath("kotlin.js.*"));
    public static ModuleParameters JS_MODULE_PARAMETERS = new ModuleParameters(){

        @Override
        @NotNull
        public List<ImportPath> getDefaultImports() {
            List<ImportPath> list = DEFAULT_IMPORTS;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS$1", "getDefaultImports"));
            }
            return list;
        }

        @Override
        @NotNull
        public PlatformToKotlinClassMap getPlatformToKotlinClassMap() {
            PlatformToKotlinClassMap platformToKotlinClassMap = PlatformToKotlinClassMap.EMPTY;
            if (platformToKotlinClassMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS$1", "getPlatformToKotlinClassMap"));
            }
            return platformToKotlinClassMap;
        }
    };

    private TopDownAnalyzerFacadeForJS() {
    }

    @NotNull
    public static JsAnalysisResult analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Config config2) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        BindingTraceContext trace = new BindingTraceContext();
        MutableModuleContext newModuleContext = ContextPackage.ContextForNewModule(config2.getProject(), Name.special("<" + config2.getModuleId() + ">"), JS_MODULE_PARAMETERS);
        newModuleContext.setDependencies(TopDownAnalyzerFacadeForJS.computeDependencies(newModuleContext.getModule(), config2));
        JsAnalysisResult jsAnalysisResult = TopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(files, trace, newModuleContext, config2);
        if (jsAnalysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        return jsAnalysisResult;
    }

    @NotNull
    private static List<ModuleDescriptorImpl> computeDependencies(ModuleDescriptorImpl module, @NotNull Config config2) {
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "computeDependencies"));
        }
        ArrayList<ModuleDescriptorImpl> allDependencies = new ArrayList<ModuleDescriptorImpl>();
        allDependencies.add(module);
        allDependencies.addAll(config2.getModuleDescriptors());
        allDependencies.add(KotlinBuiltIns.getInstance().getBuiltInsModule());
        ArrayList<ModuleDescriptorImpl> arrayList = allDependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "computeDependencies"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull Config config2) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (moduleContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContext", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        Collection<JetFile> allFiles2 = Config.withJsLibAdded(files, config2);
        InjectorForTopDownAnalyzerForJs injector = new InjectorForTopDownAnalyzerForJs(moduleContext, trace, new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), allFiles2));
        injector.getLazyTopDownAnalyzerForTopLevel().analyzeFiles(TopDownAnalysisMode.TopLevelDeclarations, files, Collections.emptyList());
        JsAnalysisResult jsAnalysisResult = JsAnalysisResult.success(trace, moduleContext.getModule());
        JsAnalysisResult jsAnalysisResult2 = jsAnalysisResult;
        if (jsAnalysisResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        return jsAnalysisResult2;
        finally {
            injector.destroy();
        }
    }

    public static void checkForErrors(@NotNull Collection<JetFile> allFiles2, @NotNull BindingContext bindingContext2) {
        if (allFiles2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFiles", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        AnalyzingUtils.throwExceptionOnErrors(bindingContext2);
        for (JetFile file : allFiles2) {
            AnalyzingUtils.checkForSyntacticErrors((PsiElement)file);
        }
    }
}

