/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\"\n)A!*\u001a;DY\u0006\u001c8OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\r\u00018/\u001b\u0006\u0011\u0015\u0016$8\t\\1tg>\u0013xJ\u00196fGRTa\u0001P5oSRt$\u0002\u00028pI\u0016Tq!Q*U\u001d>$WMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0005Y\u0006twM\u0003\u0003tiV\u0014'bD&pi2Lgn\u00117bgN\u001cF/\u001e2\u000b\u000bM$XOY:\u000b\u0003IS1!\u00118z\u0015\u0005!%BB1dG\u0016\u0004HOC\u0004wSNLGo\u001c:\u000b\u0015)+GOV5tSR|'O\u0003\u0003eCR\f'\u0002\u00026bm\u0006Taa\u00142kK\u000e$(\u0002I2sK\u0006$X\r\u0015:j[\u0006\u0014\u0018pQ8ogR\u0014Xo\u0019;pe&3\u0017IY:f]RTQCS3u!JLW.\u0019:z\u0007>t7\u000f\u001e:vGR|'OC\u0017de\u0016\fG/\u001a)sS6\f'/_\"p]N$(/^2u_J\u0004\u0016M]1nKR,'\u000fT5ti&3\u0017IY:f]RT\u0001CS3u!\u0006\u0014\u0018-\\3uKJd\u0015n\u001d;\u000b5\u001d,Go\u00117bgN|%/\u00138uKJ4\u0017mY3LKf<xN\u001d3\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGO\u0003\u0005hKR\u001cu\u000e\\8o\u0015M9W\r^\"p[B\fg.[8o\u001f\nTWm\u0019;t\u0015\u0011a\u0015n\u001d;\u000b))+Go\u00142kK\u000e$H)Z2mCJ\fG/[8o\u0015\u0011)H/\u001b7\u000b\u001b\u001d,G\u000f\u0015:pa\u0016\u0014H/[3t\u0015-QU\r\u001e)s_B,'\u000f^=\u000b!\u001d,G/U;bY&4\u0017.\u001a3OC6,'BB*ue&twMC\u0004hKR\u001cF/\u001e2\u000b\r%\u001cXI\\;n\u0015\u001d\u0011un\u001c7fC:Ta\"[:FcVLg/\u00197f]R$vNC\u0004b]>$\b.\u001a:\u000b\u000f%\u001c\u0018J\u001c8fe*Y\u0011n]%oi\u0016\u0014h-Y2fY\bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0004\t\u0007A)\u0001\u0004\u0001\u0006\u0003!%QA\u0001\u0003\u0004\u0011\u0015)!\u0001b\u0002\t\f\u0015\u0019A\u0001\u0002\u0005\u0005\u0019\u0001)!\u0001\u0002\u0003\t\t\u0015\u0011A1\u0001\u0005\b\u000b\r!Y\u0001#\u0004\r\u0001\u0015\u0011A1\u0002E\u0007\u000b\u0005A\u0019!B\u0002\u0005\u000f!AA\u0002A\u0003\u0004\t\u0007A!\u0002\u0004\u0001\u0006\u0003!YQA\u0001C\t\u0011\u0017)!\u0001B\u0005\t\u0018\u0015\u0011A1\u0001\u0005\u000b\u000b\r!\u0019\u0001#\u0007\r\u0001\u0015\u0011A1\u0001E\r\u000b\r!\u0019\u0001c\u0007\r\u0001\u0015\u0011A1\u0001E\u000e\u000b\t!9\u0001\u0003\u0002\u0006\u0007\u0011e\u0001R\u0004\u0007\u0001\u000b\t!I\u0002#\b\u0006\u0007\u00119\u0001\u0002\u0005\u0007\u0001\u000b\r!\u0019\u0001#\t\r\u0001\u0015\u0011A\u0011\u0003\u0005\u0012\u000b\t!q\u0002\u0003\t\u0006\u0007\u0011\r\u0001B\u0005\u0007\u0001\u000b\r!q\u0001C\n\r\u0001\u0015\u0011A!\u0003\u0005\u0014\u000b\r!q\u0001#\u000b\r\u0001\u0011YABA\r\u0003\u000b\u0005A)!,\u001c\u0005\u0017E1A\u0001\u0001E\b+\r)\u0011\u0001c\u0004\r\u0002E1A\u0011\u0001E\t+\r)\u0011\u0001c\u0004\r\u0002aIQ\u0014\u0005\u0003\u0001\u0011'iA\"B\u0001\t\u0011%!\u0011bA\u0003\u0003\t\u0003A\u0001!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001!\u000e\u0001Qt\u0002\u0003\u0001\u0011+i1!\u0002\u0002\u0005\u0002!\u0005\u0001k!\u0001\"\u0007\u0015\u0011A\u0011\u0001\u0005\u0001#\u000e9A!C\u0005\u0002\u0011'i\u0011\u0001\u0003\u0006\u000e\u0003!MQ6\u0003\u0003\u000411\t#!B\u0001\t\u0016E\u001b1\u0001\u0002\u0007\n\u0003!YQ6\u0003\u0003\u000415\t#!B\u0001\t\u0018E\u001b1\u0001B\u0007\n\u0003!aQV\u0003\u0003\u000419\t3!B\u0001\t\u001b1\u0005\u0011kA\u0002\u0005\u001d%\t\u00012DW\u000b\t\rAr\"I\u0002\u0006\u0003!iA\u0012A)\u0004\u0007\u0011y\u0011\"\u0001E\u000e[7!1\u0001g\b\"\r\u0015\t\u0001BD\u0005\u0004\u0013\t)\u0011\u0001#\bR\u0007\r!y\"C\u0001\t 5nAa\u0001M\u0012C\u0019)\u0011\u0001\u0003\b\n\u0007%\u0011Q!\u0001\u0005\u0011#\u000e\u0019A1E\u0005\u0002\u0011?i+\u0002B\u0001\u0019&\u0005\u001aQ!\u0001E\u0011\u0019\u0003\t6a\u0001C\u0013\u0013\u0005A\u0011#,\u0006\u0005\u0017a\u001d\u0012eA\u0003\u0002\u0011\u0019a\t!U\u0002\u0004\tOI\u0011\u0001#\u0004.\u0014\u0011\u0019\u0001\u0004F\u0011\u0003\u000b\u0005A\u0019#U\u0002\u0004\tQI\u0011\u0001\"\u0001.)\u0011Y\u0001$FO\b\t\u0001AY#D\u0002\u0006\u0003!iA\u0012\u0001)\u0004\u0001\u0005\u0012Q!\u0001E\u0012#\u000e)A!F\u0005\u0002\t\u0003i\u0011\u0001c\u0007.\u0014\u0011\u0019\u0001DF\u0011\u0003\u000b\u0005A\u0019#U\u0002\u0004\tYI\u0011\u0001\"\u0001.\u0014\u0011\u0019\u0001TF\u0011\u0003\u000b\u0005A\u0019#U\u0002\u0004\t[I\u0011\u0001\"\u0001:(\u0011\u0019\u000f\u0001G\u0002\u001e\u000e\u0011\u0001\u0001rA\u0007\u0003\u000b\u0005AI\u0001U\u0002\u0001C\t)\u0011\u0001\u0003\u0002R\u0007\u0015!1!C\u0001\u0005\u00015\t\u0001\"B]\u0014\t\r\b\u0001dAO\u0007\t\u0001Aa!\u0004\u0002\u0006\u0003!1\u0001k\u0001\u0001\"\u0005\u0015\t\u0001BA)\u0004\u000b\u0011\u0019\u0011\"\u0001\u0003\u0001\u001b\u0005Ai\u0001"})
public class JetClass
extends JetClassOrObject {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JetClass.class);
    }

    @Nullable
    public KotlinClassStub getStub() {
        StubElement stubElement = super.getStub();
        if (!(stubElement instanceof KotlinClassStub)) {
            stubElement = null;
        }
        return (KotlinClassStub)stubElement;
    }

    @Override
    public <R, D> R accept(@JetValueParameter(name="visitor") @NotNull JetVisitor<R, D> visitor2, @JetValueParameter(name="data") D data2) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitClass(this, data2);
    }

    @NotNull
    public final JetPrimaryConstructor createPrimaryConstructorIfAbsent() {
        JetPrimaryConstructor constructor2 = this.getPrimaryConstructor();
        if (constructor2 != null) {
            return constructor2;
        }
        PsiElement anchor2 = (PsiElement)this.getTypeParameterList();
        if (anchor2 == null) {
            anchor2 = this.getNameIdentifier();
        }
        if (anchor2 == null) {
            anchor2 = this.getLastChild();
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"getProject()");
        PsiElement psiElement = this.addAfter(new JetPsiFactory(project).createPrimaryConstructor(), anchor2);
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetPrimaryConstructor");
        }
        return (JetPrimaryConstructor)psiElement;
    }

    @NotNull
    public final JetParameterList createPrimaryConstructorParameterListIfAbsent() {
        JetPrimaryConstructor constructor2 = this.createPrimaryConstructorIfAbsent();
        JetParameterList parameterList2 = constructor2.getValueParameterList();
        if (parameterList2 != null) {
            return parameterList2;
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"getProject()");
        PsiElement psiElement = constructor2.add((PsiElement)new JetPsiFactory(project).createParameterList("()"));
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetParameterList");
        }
        return (JetParameterList)psiElement;
    }

    @Nullable
    public final PsiElement getColon() {
        return this.findChildByType(JetTokens.COLON);
    }

    @NotNull
    public final List<JetProperty> getProperties() {
        JetClassBody jetClassBody = this.getBody();
        return KotlinPackage.orEmpty(jetClassBody != null ? jetClassBody.getProperties() : null);
    }

    public final boolean isInterface() {
        KotlinClassStub kotlinClassStub = this.getStub();
        return kotlinClassStub != null ? kotlinClassStub.isInterface() : this.findChildByType(JetTokens.TRAIT_KEYWORD) != null || this.findChildByType(JetTokens.INTERFACE_KEYWORD) != null;
    }

    public final boolean isEnum() {
        return this.hasModifier(JetTokens.ENUM_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(JetTokens.INNER_KEYWORD);
    }

    public boolean isEquivalentTo(@JetValueParameter(name="another", type="?") @Nullable PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        if (another instanceof JetClass) {
            String fq1 = this.getQualifiedName();
            String fq2 = ((JetClass)another).getQualifiedName();
            return fq1 != null && fq2 != null && Intrinsics.areEqual((Object)fq1, (Object)fq2);
        }
        return false;
    }

    private final String getQualifiedName() {
        KotlinClassStub stub = this.getStub();
        if (stub != null) {
            FqName fqName2;
            FqName fqName3 = fqName2 = stub.getFqName();
            return fqName3 != null ? fqName3.asString() : null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        JetClassOrObject current = this;
        while (current != null) {
            parts.add(current.getName());
            current = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)current, JetClassOrObject.class);
        }
        PsiFile file = this.getContainingFile();
        if (!(file instanceof JetFile)) {
            return null;
        }
        String fileQualifiedName = ((JetFile)file).getPackageFqName().asString();
        if (!KotlinPackage.isEmpty((String)fileQualifiedName)) {
            parts.add(fileQualifiedName);
        }
        Collections.reverse((List)parts);
        return StringUtil.join((Collection)parts, (String)".");
    }

    @NotNull
    public final List<JetObjectDeclaration> getCompanionObjects() {
        JetClassBody jetClassBody = this.getBody();
        return KotlinPackage.orEmpty(jetClassBody != null ? jetClassBody.getAllCompanionObjects() : null);
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(TokenSet.create((IElementType[])new IElementType[]{JetTokens.CLASS_KEYWORD, JetTokens.INTERFACE_KEYWORD}));
    }

    public JetClass(@JetValueParameter(name="node") @NotNull ASTNode node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        super(node2);
    }

    public JetClass(@JetValueParameter(name="stub") @NotNull KotlinClassStub stub) {
        Intrinsics.checkParameterIsNotNull((Object)stub, (String)"stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        IStubElementType iStubElementType = JetStubElementTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iStubElementType, (String)"JetStubElementTypes.CLASS");
        super(kotlinClassOrObjectStub, iStubElementType);
    }
}

