/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetExpressionImplStub;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpressionImpl;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinNameReferenceExpressionStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetNameReferenceExpression
extends JetExpressionImplStub<KotlinNameReferenceExpressionStub>
implements JetSimpleNameExpression {
    private static final TokenSet NAME_REFERENCE_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER, JetTokens.FIELD_IDENTIFIER, JetTokens.THIS_KEYWORD, JetTokens.SUPER_KEYWORD});

    public JetNameReferenceExpression(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetNameReferenceExpression", "<init>"));
        }
        super(node2);
    }

    public JetNameReferenceExpression(@NotNull KotlinNameReferenceExpressionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetNameReferenceExpression", "<init>"));
        }
        super(stub, JetStubElementTypes.REFERENCE_EXPRESSION);
    }

    @Override
    @NotNull
    public String getReferencedName() {
        KotlinNameReferenceExpressionStub stub = (KotlinNameReferenceExpressionStub)this.getStub();
        if (stub != null) {
            String string = stub.getReferencedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNameReferenceExpression", "getReferencedName"));
            }
            return string;
        }
        String string = JetSimpleNameExpressionImpl.Helper.getReferencedNameImpl(this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNameReferenceExpression", "getReferencedName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Name getReferencedNameAsName() {
        Name name2 = JetSimpleNameExpressionImpl.Helper.getReferencedNameAsNameImpl(this);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNameReferenceExpression", "getReferencedNameAsName"));
        }
        return name2;
    }

    @Override
    @NotNull
    public PsiElement getReferencedNameElement() {
        PsiElement element = this.findChildByType(NAME_REFERENCE_EXPRESSIONS);
        if (element == null) {
            JetNameReferenceExpression jetNameReferenceExpression = this;
            if (jetNameReferenceExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNameReferenceExpression", "getReferencedNameElement"));
            }
            return jetNameReferenceExpression;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNameReferenceExpression", "getReferencedNameElement"));
        }
        return psiElement;
    }

    @Override
    @Nullable
    public PsiElement getIdentifier() {
        return this.findChildByType(JetTokens.IDENTIFIER);
    }

    @Override
    @NotNull
    public IElementType getReferencedNameElementType() {
        IElementType iElementType = JetSimpleNameExpressionImpl.Helper.getReferencedNameElementTypeImpl(this);
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNameReferenceExpression", "getReferencedNameElementType"));
        }
        return iElementType;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetNameReferenceExpression", "accept"));
        }
        return visitor2.visitSimpleNameExpression(this, data2);
    }
}

