/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Queue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstructorDelegationCall;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperClass;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.ConstructorHeaderCallChecker;
import org.jetbrains.kotlin.resolve.ControlFlowAnalyzer;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionAnalyzerExtension;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.ScriptBodyResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.JetScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.RedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;
import org.jetbrains.kotlin.util.Box;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BodyResolver {
    private ScriptBodyResolver scriptBodyResolverResolver;
    private ExpressionTypingServices expressionTypingServices;
    private CallResolver callResolver;
    private ObservableBindingTrace trace;
    private ControlFlowAnalyzer controlFlowAnalyzer;
    private DeclarationsChecker declarationsChecker;
    private AnnotationResolver annotationResolver;
    private DelegatedPropertyResolver delegatedPropertyResolver;
    private FunctionAnalyzerExtension functionAnalyzerExtension;
    private AdditionalCheckerProvider additionalCheckerProvider;
    private ValueParameterResolver valueParameterResolver;

    @Inject
    public void setScriptBodyResolverResolver(@NotNull ScriptBodyResolver scriptBodyResolverResolver) {
        if (scriptBodyResolverResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptBodyResolverResolver", "org/jetbrains/kotlin/resolve/BodyResolver", "setScriptBodyResolverResolver"));
        }
        this.scriptBodyResolverResolver = scriptBodyResolverResolver;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/BodyResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setCallResolver(@NotNull CallResolver callResolver) {
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/BodyResolver", "setCallResolver"));
        }
        this.callResolver = callResolver;
    }

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "setTrace"));
        }
        this.trace = new ObservableBindingTrace(trace);
    }

    @Inject
    public void setControlFlowAnalyzer(@NotNull ControlFlowAnalyzer controlFlowAnalyzer) {
        if (controlFlowAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlFlowAnalyzer", "org/jetbrains/kotlin/resolve/BodyResolver", "setControlFlowAnalyzer"));
        }
        this.controlFlowAnalyzer = controlFlowAnalyzer;
    }

    @Inject
    public void setDeclarationsChecker(@NotNull DeclarationsChecker declarationsChecker) {
        if (declarationsChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationsChecker", "org/jetbrains/kotlin/resolve/BodyResolver", "setDeclarationsChecker"));
        }
        this.declarationsChecker = declarationsChecker;
    }

    @Inject
    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/kotlin/resolve/BodyResolver", "setAnnotationResolver"));
        }
        this.annotationResolver = annotationResolver;
    }

    @Inject
    public void setDelegatedPropertyResolver(@NotNull DelegatedPropertyResolver delegatedPropertyResolver) {
        if (delegatedPropertyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedPropertyResolver", "org/jetbrains/kotlin/resolve/BodyResolver", "setDelegatedPropertyResolver"));
        }
        this.delegatedPropertyResolver = delegatedPropertyResolver;
    }

    @Inject
    public void setFunctionAnalyzerExtension(@NotNull FunctionAnalyzerExtension functionAnalyzerExtension) {
        if (functionAnalyzerExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionAnalyzerExtension", "org/jetbrains/kotlin/resolve/BodyResolver", "setFunctionAnalyzerExtension"));
        }
        this.functionAnalyzerExtension = functionAnalyzerExtension;
    }

    @Inject
    public void setAdditionalCheckerProvider(AdditionalCheckerProvider additionalCheckerProvider) {
        this.additionalCheckerProvider = additionalCheckerProvider;
    }

    @Inject
    public void setValueParameterResolver(ValueParameterResolver valueParameterResolver) {
        this.valueParameterResolver = valueParameterResolver;
    }

    private void resolveBehaviorDeclarationBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveBehaviorDeclarationBodies"));
        }
        this.resolveDelegationSpecifierLists(c);
        this.resolvePropertyDeclarationBodies(c);
        this.resolveAnonymousInitializers(c);
        this.resolvePrimaryConstructorParameters(c);
        this.resolveSecondaryConstructors(c);
        this.resolveFunctionBodies(c);
        this.scriptBodyResolverResolver.resolveScriptBodies(c);
        if (!c.getTopDownAnalysisMode().getIsLocalDeclarations()) {
            this.computeDeferredTypes();
        }
    }

    private void resolveSecondaryConstructors(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructors"));
        }
        for (Map.Entry<JetSecondaryConstructor, ConstructorDescriptor> entry : c.getSecondaryConstructors().entrySet()) {
            JetScope declaringScope = (JetScope)c.getDeclaringScopes().apply((Object)entry.getKey());
            assert (declaringScope != null) : "Declaring scope should be registered before body resolve";
            this.resolveSecondaryConstructorBody(c, this.trace, entry.getKey(), entry.getValue(), declaringScope);
        }
        if (c.getSecondaryConstructors().isEmpty()) {
            return;
        }
        HashSet visitedConstructors = Sets.newHashSet();
        for (Map.Entry<JetSecondaryConstructor, ConstructorDescriptor> entry : c.getSecondaryConstructors().entrySet()) {
            this.checkCyclicConstructorDelegationCall(entry.getValue(), visitedConstructors);
        }
    }

    public void resolveSecondaryConstructorBody(final @NotNull BodiesResolveContext c, final @NotNull BindingTrace trace, final @NotNull JetSecondaryConstructor constructor2, final @NotNull ConstructorDescriptor descriptor2, @NotNull JetScope declaringScope) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        if (declaringScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringScope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        AnnotationResolver.resolveAnnotationsArguments(descriptor2.getAnnotations());
        final ConstructorHeaderCallChecker callChecker = new ConstructorHeaderCallChecker(descriptor2, this.additionalCheckerProvider.getCallChecker());
        this.resolveFunctionBody(c, trace, constructor2, descriptor2, declaringScope, new Function1<JetScope, DataFlowInfo>(){

            public DataFlowInfo invoke(@NotNull JetScope headerInnerScope) {
                if (headerInnerScope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerInnerScope", "org/jetbrains/kotlin/resolve/BodyResolver$1", "invoke"));
                }
                return BodyResolver.this.resolveSecondaryConstructorDelegationCall(c, trace, headerInnerScope, constructor2, descriptor2, callChecker);
            }
        }, callChecker);
    }

    @Nullable
    private DataFlowInfo resolveSecondaryConstructorDelegationCall(@NotNull BodiesResolveContext c, @NotNull BindingTrace trace, @NotNull JetScope scope2, @NotNull JetSecondaryConstructor constructor2, @NotNull ConstructorDescriptor descriptor2, @NotNull CallChecker callChecker) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        if (callChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callChecker", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> results2 = this.callResolver.resolveConstructorDelegationCall(trace, scope2, c.getOuterDataFlowInfo(), descriptor2, constructor2.getDelegationCall(), callChecker);
        if (results2 != null && results2.isSingleResult()) {
            ResolvedCall<FunctionDescriptor> resolvedCall = results2.getResultingCall();
            BodyResolver.recordConstructorDelegationCall(trace, descriptor2, resolvedCall);
            return resolvedCall.getDataFlowInfoForArguments().getResultInfo();
        }
        return null;
    }

    private void checkCyclicConstructorDelegationCall(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull Set<ConstructorDescriptor> visitedConstructors) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "checkCyclicConstructorDelegationCall"));
        }
        if (visitedConstructors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedConstructors", "org/jetbrains/kotlin/resolve/BodyResolver", "checkCyclicConstructorDelegationCall"));
        }
        if (visitedConstructors.contains(constructorDescriptor)) {
            return;
        }
        HashSet visitedInCurrentChain = Sets.newHashSet();
        ConstructorDescriptor currentConstructorDescriptor = constructorDescriptor;
        while (true) {
            visitedInCurrentChain.add(currentConstructorDescriptor);
            ConstructorDescriptor delegatedConstructorDescriptor = this.getDelegatedConstructor(currentConstructorDescriptor);
            if (delegatedConstructorDescriptor == null || !constructorDescriptor.getContainingDeclaration().equals(delegatedConstructorDescriptor.getContainingDeclaration()) || delegatedConstructorDescriptor.isPrimary() || visitedConstructors.contains(delegatedConstructorDescriptor)) break;
            if (visitedInCurrentChain.contains(delegatedConstructorDescriptor)) {
                this.reportEachConstructorOnCycle(delegatedConstructorDescriptor);
                break;
            }
            currentConstructorDescriptor = delegatedConstructorDescriptor;
        }
        visitedConstructors.addAll(visitedInCurrentChain);
    }

    private void reportEachConstructorOnCycle(@NotNull ConstructorDescriptor startConstructor) {
        if (startConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startConstructor", "org/jetbrains/kotlin/resolve/BodyResolver", "reportEachConstructorOnCycle"));
        }
        ConstructorDescriptor currentConstructor = startConstructor;
        do {
            PsiElement constructorToReport;
            if ((constructorToReport = DescriptorToSourceUtils.descriptorToDeclaration(currentConstructor)) != null) {
                JetConstructorDelegationCall call = ((JetSecondaryConstructor)constructorToReport).getDelegationCall();
                assert (call.getCalleeExpression() != null) : "Callee expression of delegation call should not be null on cycle as there should be explicit 'this' calls";
                this.trace.report(Errors.CYCLIC_CONSTRUCTOR_DELEGATION_CALL.on(call.getCalleeExpression()));
            }
            currentConstructor = this.getDelegatedConstructor(currentConstructor);
            assert (currentConstructor != null) : "Delegated constructor should not be null in cycle";
        } while (startConstructor != currentConstructor);
    }

    @Nullable
    private ConstructorDescriptor getDelegatedConstructor(@NotNull ConstructorDescriptor constructor2) {
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/BodyResolver", "getDelegatedConstructor"));
        }
        ResolvedCall<ConstructorDescriptor> call = this.trace.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructor2);
        return call == null || !call.getStatus().isSuccess() ? null : call.getResultingDescriptor().getOriginal();
    }

    public void resolveBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveBodies"));
        }
        this.resolveBehaviorDeclarationBodies(c);
        this.controlFlowAnalyzer.process(c);
        this.declarationsChecker.process(c);
        this.functionAnalyzerExtension.process(c);
    }

    private void resolveDelegationSpecifierLists(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveDelegationSpecifierLists"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor2 = entry.getValue();
            this.resolveDelegationSpecifierList(c, classOrObject, descriptor2, descriptor2.getUnsubstitutedPrimaryConstructor(), descriptor2.getScopeForClassHeaderResolution(), descriptor2.getScopeForMemberDeclarationResolution());
        }
    }

    public void resolveDelegationSpecifierList(final @NotNull BodiesResolveContext c, @NotNull JetClassOrObject jetClass, final @NotNull ClassDescriptor descriptor2, final @Nullable ConstructorDescriptor primaryConstructor2, @NotNull JetScope scopeForSupertypeResolution, final @NotNull JetScope scopeForMemberResolution) {
        Set<TypeConstructor> parentEnum;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        if (scopeForSupertypeResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForSupertypeResolution", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        if (scopeForMemberResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForMemberResolution", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveDelegationSpecifierList"));
        }
        final JetScope scopeForConstructor = primaryConstructor2 == null ? null : FunctionDescriptorUtil.getFunctionInnerScope(scopeForSupertypeResolution, (FunctionDescriptor)primaryConstructor2, this.trace);
        final ExpressionTypingServices typeInferrer = this.expressionTypingServices;
        final LinkedHashMap supertypes2 = Maps.newLinkedHashMap();
        final ResolvedCall[] primaryConstructorDelegationCall = new ResolvedCall[1];
        JetVisitorVoid visitor2 = new JetVisitorVoid(){

            private void recordSupertype(JetTypeReference typeReference, JetType supertype) {
                if (supertype == null) {
                    return;
                }
                supertypes2.put(typeReference, supertype);
            }

            @Override
            public void visitDelegationByExpressionSpecifier(@NotNull JetDelegatorByExpressionSpecifier specifier) {
                JetExpression delegateExpression;
                ClassDescriptor classDescriptor;
                ClassifierDescriptor declarationDescriptor;
                if (specifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/resolve/BodyResolver$2", "visitDelegationByExpressionSpecifier"));
                }
                if (descriptor2.getKind() == ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_IN_TRAIT.on(specifier));
                }
                JetType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, specifier.getTypeReference());
                this.recordSupertype(specifier.getTypeReference(), supertype);
                if (supertype != null && (declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)declarationDescriptor).getKind() != ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_NOT_TO_TRAIT.on(specifier.getTypeReference()));
                }
                if ((delegateExpression = specifier.getDelegateExpression()) != null) {
                    JetScope scope2 = scopeForConstructor == null ? scopeForMemberResolution : scopeForConstructor;
                    JetType expectedType = supertype != null ? supertype : TypeUtils.NO_EXPECTED_TYPE;
                    typeInferrer.getType(scope2, delegateExpression, expectedType, c.getOuterDataFlowInfo(), BodyResolver.this.trace);
                }
                if (primaryConstructor2 == null) {
                    BodyResolver.this.trace.report(Errors.UNSUPPORTED.on((PsiElement)specifier, "Delegation without primary constructor is not supported"));
                }
            }

            @Override
            public void visitDelegationToSuperCallSpecifier(@NotNull JetDelegatorToSuperCall call) {
                JetTypeReference typeReference;
                JetElement elementToMark;
                if (call == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/BodyResolver$2", "visitDelegationToSuperCallSpecifier"));
                }
                JetValueArgumentList valueArgumentList = call.getValueArgumentList();
                JetElement jetElement = elementToMark = valueArgumentList == null ? call : valueArgumentList;
                if (descriptor2.getKind() == ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_IN_TRAIT.on((PsiElement)elementToMark));
                }
                if ((typeReference = call.getTypeReference()) == null) {
                    return;
                }
                if (primaryConstructor2 == null) {
                    if (descriptor2.getKind() != ClassKind.INTERFACE) {
                        BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR.on(call));
                    }
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> results2 = BodyResolver.this.callResolver.resolveFunctionCall(BodyResolver.this.trace, scopeForConstructor, CallMaker.makeCall(ReceiverValue.NO_RECEIVER, null, call), TypeUtils.NO_EXPECTED_TYPE, c.getOuterDataFlowInfo(), false);
                if (results2.isSuccess()) {
                    JetType supertype = results2.getResultingDescriptor().getReturnType();
                    this.recordSupertype(typeReference, supertype);
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
                    if (classDescriptor != null) {
                        primaryConstructorDelegationCall[0] = primaryConstructorDelegationCall[0] == null ? results2.getResultingCall() : null;
                    }
                    BodyResolver.this.trace.record(BindingContext.PROCESSED, call.getCalleeExpression(), true);
                    BodyResolver.this.trace.record(BindingContext.EXPRESSION_TYPE_INFO, call.getCalleeExpression(), TypeInfoFactoryPackage.noTypeInfo(results2.getResultingCall().getDataFlowInfoForArguments().getResultInfo()));
                } else {
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                }
            }

            @Override
            public void visitDelegationToSuperClassSpecifier(@NotNull JetDelegatorToSuperClass specifier) {
                if (specifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/resolve/BodyResolver$2", "visitDelegationToSuperClassSpecifier"));
                }
                JetTypeReference typeReference = specifier.getTypeReference();
                JetType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
                this.recordSupertype(typeReference, supertype);
                if (supertype == null) {
                    return;
                }
                ClassDescriptor superClass = TypeUtils.getClassDescriptor(supertype);
                if (superClass == null) {
                    return;
                }
                if (superClass.getKind().isSingleton()) {
                    return;
                }
                if (descriptor2.getKind() != ClassKind.INTERFACE && descriptor2.getUnsubstitutedPrimaryConstructor() != null && superClass.getKind() != ClassKind.INTERFACE && !superClass.getConstructors().isEmpty() && !ErrorUtils.isError(superClass)) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_NOT_INITIALIZED.on(specifier));
                }
            }

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/BodyResolver$2", "visitJetElement"));
                }
                throw new UnsupportedOperationException(element.getText() + " : " + element);
            }
        };
        for (JetDelegationSpecifier delegationSpecifier : jetClass.getDelegationSpecifiers()) {
            delegationSpecifier.accept(visitor2);
        }
        if (DescriptorUtils.isAnnotationClass(descriptor2) && jetClass.getDelegationSpecifierList() != null) {
            this.trace.report(Errors.SUPERTYPES_FOR_ANNOTATION_CLASS.on(jetClass.getDelegationSpecifierList()));
        }
        Set<TypeConstructor> set = parentEnum = jetClass instanceof JetEnumEntry ? Collections.singleton(((ClassDescriptor)descriptor2.getContainingDeclaration()).getTypeConstructor()) : Collections.emptySet();
        if (primaryConstructorDelegationCall[0] != null && primaryConstructor2 != null) {
            BodyResolver.recordConstructorDelegationCall(this.trace, primaryConstructor2, primaryConstructorDelegationCall[0]);
        }
        this.checkSupertypeList(descriptor2, supertypes2, parentEnum);
    }

    private static void recordConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull ConstructorDescriptor constructor2, @NotNull ResolvedCall<?> call) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "recordConstructorDelegationCall"));
        }
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/BodyResolver", "recordConstructorDelegationCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/BodyResolver", "recordConstructorDelegationCall"));
        }
        trace.record(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructor2, call);
    }

    private void checkSupertypeList(@NotNull ClassDescriptor supertypeOwner, @NotNull Map<JetTypeReference, JetType> supertypes2, @NotNull Set<TypeConstructor> allowedFinalSupertypes) {
        if (supertypeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypeOwner", "org/jetbrains/kotlin/resolve/BodyResolver", "checkSupertypeList"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/resolve/BodyResolver", "checkSupertypeList"));
        }
        if (allowedFinalSupertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedFinalSupertypes", "org/jetbrains/kotlin/resolve/BodyResolver", "checkSupertypeList"));
        }
        HashSet typeConstructors = Sets.newHashSet();
        boolean classAppeared = false;
        for (Map.Entry<JetTypeReference, JetType> entry : supertypes2.entrySet()) {
            TypeConstructor constructor2;
            JetTypeReference typeReference = entry.getKey();
            JetType supertype = entry.getValue();
            ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
            if (classDescriptor != null) {
                if (ErrorUtils.isError(classDescriptor)) continue;
                if (classDescriptor.getKind() != ClassKind.INTERFACE) {
                    if (supertypeOwner.getKind() == ClassKind.ENUM_CLASS) {
                        this.trace.report(Errors.CLASS_IN_SUPERTYPE_FOR_ENUM.on((PsiElement)typeReference));
                    } else if (supertypeOwner.getKind() == ClassKind.INTERFACE && !classAppeared && !TypesPackage.isDynamic(supertype)) {
                        this.trace.report(Errors.TRAIT_WITH_SUPERCLASS.on((PsiElement)typeReference));
                    }
                    if (classAppeared) {
                        this.trace.report(Errors.MANY_CLASSES_IN_SUPERTYPE_LIST.on(typeReference));
                    } else {
                        classAppeared = true;
                    }
                }
            } else {
                this.trace.report(Errors.SUPERTYPE_NOT_A_CLASS_OR_TRAIT.on(typeReference));
            }
            if (!typeConstructors.add(constructor2 = supertype.getConstructor())) {
                this.trace.report(Errors.SUPERTYPE_APPEARS_TWICE.on(typeReference));
            }
            if (DescriptorUtils.isSingleton(classDescriptor)) {
                this.trace.report(Errors.SINGLETON_IN_SUPERTYPE.on(typeReference));
                continue;
            }
            if (!constructor2.isFinal() || allowedFinalSupertypes.contains(constructor2)) continue;
            this.trace.report(Errors.FINAL_SUPERTYPE.on(typeReference));
        }
    }

    private void resolveAnonymousInitializers(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveAnonymousInitializers"));
        }
        for (Map.Entry<JetClassInitializer, ClassDescriptorWithResolutionScopes> entry : c.getAnonymousInitializers().entrySet()) {
            JetClassInitializer initializer = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor2 = entry.getValue();
            this.resolveAnonymousInitializer(c, initializer, descriptor2);
        }
    }

    public void resolveAnonymousInitializer(@NotNull BodiesResolveContext c, @NotNull JetClassInitializer anonymousInitializer, @NotNull ClassDescriptorWithResolutionScopes classDescriptor) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveAnonymousInitializer"));
        }
        if (anonymousInitializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousInitializer", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveAnonymousInitializer"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveAnonymousInitializer"));
        }
        JetScope scopeForInitializers = classDescriptor.getScopeForInitializerResolution();
        if (!classDescriptor.getConstructors().isEmpty()) {
            JetExpression body2 = anonymousInitializer.getBody();
            if (body2 != null) {
                this.expressionTypingServices.getType(scopeForInitializers, body2, TypeUtils.NO_EXPECTED_TYPE, c.getOuterDataFlowInfo(), this.trace);
            }
            this.processModifiersOnInitializer(anonymousInitializer, scopeForInitializers);
        } else {
            this.trace.report(Errors.ANONYMOUS_INITIALIZER_IN_TRAIT.on(anonymousInitializer));
            this.processModifiersOnInitializer(anonymousInitializer, scopeForInitializers);
        }
    }

    private void processModifiersOnInitializer(@NotNull JetModifierListOwner owner, @NotNull JetScope scope2) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/resolve/BodyResolver", "processModifiersOnInitializer"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/BodyResolver", "processModifiersOnInitializer"));
        }
        JetModifierList modifierList = owner.getModifierList();
        if (modifierList == null) {
            return;
        }
        this.annotationResolver.resolveAnnotationsWithArguments(scope2, modifierList, (BindingTrace)this.trace);
        ModifiersChecker.reportIllegalModifiers(modifierList, Arrays.asList(JetTokens.MODIFIER_KEYWORDS_ARRAY), this.trace);
    }

    private void resolvePrimaryConstructorParameters(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePrimaryConstructorParameters"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            JetClassOrObject klass = entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = entry.getValue();
            ConstructorDescriptor unsubstitutedPrimaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
            if (unsubstitutedPrimaryConstructor == null) continue;
            AnnotationResolver.resolveAnnotationsArguments(unsubstitutedPrimaryConstructor.getAnnotations());
            WritableScope parameterScope = BodyResolver.getPrimaryConstructorParametersScope(classDescriptor.getScopeForClassHeaderResolution(), unsubstitutedPrimaryConstructor);
            this.valueParameterResolver.resolveValueParameters(klass.getPrimaryConstructorParameters(), unsubstitutedPrimaryConstructor.getValueParameters(), parameterScope, c.getOuterDataFlowInfo(), this.trace);
        }
    }

    private static WritableScope getPrimaryConstructorParametersScope(JetScope originalScope, ConstructorDescriptor unsubstitutedPrimaryConstructor) {
        WritableScopeImpl parameterScope = new WritableScopeImpl(originalScope, unsubstitutedPrimaryConstructor, RedeclarationHandler.DO_NOTHING, "Scope with value parameters of a constructor");
        for (ValueParameterDescriptor valueParameterDescriptor : unsubstitutedPrimaryConstructor.getValueParameters()) {
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
        }
        parameterScope.changeLockLevel(WritableScope.LockLevel.READING);
        return parameterScope;
    }

    private void resolvePropertyDeclarationBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDeclarationBodies"));
        }
        HashSet processed = Sets.newHashSet();
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            if (!(entry.getKey() instanceof JetClass)) continue;
            JetClass jetClass = (JetClass)entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = entry.getValue();
            for (JetProperty property : jetClass.getProperties()) {
                JetExpression delegateExpression;
                PropertyDescriptor propertyDescriptor = c.getProperties().get(property);
                assert (propertyDescriptor != null);
                BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
                JetExpression initializer = property.getInitializer();
                JetScope propertyScope = this.getScopeForProperty(c, property);
                if (initializer != null) {
                    this.resolvePropertyInitializer(c, property, propertyDescriptor, initializer, propertyScope);
                }
                if ((delegateExpression = property.getDelegateExpression()) != null) {
                    assert (initializer == null) : "Initializer should be null for delegated property : " + property.getText();
                    this.resolvePropertyDelegate(c, property, propertyDescriptor, delegateExpression, classDescriptor.getScopeForMemberDeclarationResolution(), propertyScope);
                }
                AnnotationResolver.resolveAnnotationsArguments(propertyDescriptor.getAnnotations());
                this.resolvePropertyAccessors(c, property, propertyDescriptor);
                processed.add(property);
            }
        }
        for (Map.Entry<JetTypeParameterListOwnerStub, MemberDescriptor> entry : c.getProperties().entrySet()) {
            JetExpression delegateExpression;
            JetProperty property = (JetProperty)entry.getKey();
            if (processed.contains(property)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
            JetExpression initializer = property.getInitializer();
            JetScope propertyScope = this.getScopeForProperty(c, property);
            if (initializer != null) {
                this.resolvePropertyInitializer(c, property, propertyDescriptor, initializer, propertyScope);
            }
            if ((delegateExpression = property.getDelegateExpression()) != null) {
                assert (initializer == null) : "Initializer should be null for delegated property : " + property.getText();
                this.resolvePropertyDelegate(c, property, propertyDescriptor, delegateExpression, propertyScope, propertyScope);
            }
            AnnotationResolver.resolveAnnotationsArguments(propertyDescriptor.getAnnotations());
            this.resolvePropertyAccessors(c, property, propertyDescriptor);
        }
    }

    private JetScope makeScopeForPropertyAccessor(@NotNull BodiesResolveContext c, @NotNull JetPropertyAccessor accessor, @NotNull PropertyDescriptor descriptor2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "makeScopeForPropertyAccessor"));
        }
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/resolve/BodyResolver", "makeScopeForPropertyAccessor"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "makeScopeForPropertyAccessor"));
        }
        JetScope accessorDeclaringScope = (JetScope)c.getDeclaringScopes().apply((Object)accessor);
        assert (accessorDeclaringScope != null) : "Scope for accessor " + accessor.getText() + " should exists";
        return JetScopeUtils.makeScopeForPropertyAccessor(descriptor2, accessorDeclaringScope, this.trace);
    }

    public void resolvePropertyAccessors(@NotNull BodiesResolveContext c, @NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyAccessors"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyAccessors"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyAccessors"));
        }
        ObservableBindingTrace fieldAccessTrackingTrace = this.createFieldTrackingTrace(propertyDescriptor);
        JetPropertyAccessor getter = property.getGetter();
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        if (getter != null && getterDescriptor != null) {
            JetScope accessorScope = this.makeScopeForPropertyAccessor(c, getter, propertyDescriptor);
            AnnotationResolver.resolveAnnotationsArguments(getterDescriptor.getAnnotations());
            this.resolveFunctionBody(c, fieldAccessTrackingTrace, getter, getterDescriptor, accessorScope);
        }
        JetPropertyAccessor setter = property.getSetter();
        PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
        if (setter != null && setterDescriptor != null) {
            JetScope accessorScope = this.makeScopeForPropertyAccessor(c, setter, propertyDescriptor);
            AnnotationResolver.resolveAnnotationsArguments(setterDescriptor.getAnnotations());
            this.resolveFunctionBody(c, fieldAccessTrackingTrace, setter, setterDescriptor, accessorScope);
        }
    }

    private ObservableBindingTrace createFieldTrackingTrace(final PropertyDescriptor propertyDescriptor) {
        return new ObservableBindingTrace(this.trace).addHandler(BindingContext.REFERENCE_TARGET, new ObservableBindingTrace.RecordHandler<JetReferenceExpression, DeclarationDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<JetReferenceExpression, DeclarationDescriptor> slice, JetReferenceExpression expression2, DeclarationDescriptor descriptor2) {
                JetSimpleNameExpression simpleNameExpression;
                if (expression2 instanceof JetSimpleNameExpression && (simpleNameExpression = (JetSimpleNameExpression)expression2).getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER && descriptor2 == propertyDescriptor) {
                    BodyResolver.this.trace.record(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
                }
            }
        });
    }

    public void resolvePropertyDelegate(@NotNull BodiesResolveContext c, @NotNull JetProperty jetProperty, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetScope parentScopeForAccessor, @NotNull JetScope propertyScope) {
        JetPropertyAccessor setter;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (jetProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetProperty", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (parentScopeForAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScopeForAccessor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (propertyScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyScope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        JetPropertyAccessor getter = jetProperty.getGetter();
        if (getter != null && getter.hasBody()) {
            this.trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on(getter));
        }
        if ((setter = jetProperty.getSetter()) != null && setter.hasBody()) {
            this.trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on(setter));
        }
        JetScope propertyDeclarationInnerScope = JetScopeUtils.getPropertyDeclarationInnerScopeForInitializer(propertyDescriptor, propertyScope, propertyDescriptor.getTypeParameters(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, this.trace);
        JetScope accessorScope = JetScopeUtils.makeScopeForPropertyAccessor(propertyDescriptor, parentScopeForAccessor, this.trace);
        JetType delegateType = this.delegatedPropertyResolver.resolveDelegateExpression(delegateExpression, jetProperty, propertyDescriptor, propertyDeclarationInnerScope, accessorScope, this.trace, c.getOuterDataFlowInfo());
        this.delegatedPropertyResolver.resolveDelegatedPropertyGetMethod(propertyDescriptor, delegateExpression, delegateType, this.trace, accessorScope);
        if (jetProperty.isVar()) {
            this.delegatedPropertyResolver.resolveDelegatedPropertySetMethod(propertyDescriptor, delegateExpression, delegateType, this.trace, accessorScope);
        }
        this.delegatedPropertyResolver.resolveDelegatedPropertyPDMethod(propertyDescriptor, delegateExpression, delegateType, this.trace, accessorScope);
    }

    public void resolvePropertyInitializer(@NotNull BodiesResolveContext c, @NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression initializer, @NotNull JetScope scope2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        JetScope propertyDeclarationInnerScope = JetScopeUtils.getPropertyDeclarationInnerScopeForInitializer(propertyDescriptor, scope2, propertyDescriptor.getTypeParameters(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, this.trace);
        JetType expectedTypeForInitializer = property.getTypeReference() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        CompileTimeConstant<?> compileTimeInitializer = propertyDescriptor.getCompileTimeInitializer();
        if (compileTimeInitializer == null) {
            this.expressionTypingServices.getType(propertyDeclarationInnerScope, initializer, expectedTypeForInitializer, c.getOuterDataFlowInfo(), this.trace);
        }
    }

    @NotNull
    private JetScope getScopeForProperty(@NotNull BodiesResolveContext c, @NotNull JetProperty property) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "getScopeForProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/BodyResolver", "getScopeForProperty"));
        }
        JetScope scope2 = (JetScope)c.getDeclaringScopes().apply((Object)property);
        assert (scope2 != null) : "Scope for property " + property.getText() + " should exists";
        JetScope jetScope = scope2;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BodyResolver", "getScopeForProperty"));
        }
        return jetScope;
    }

    private void resolveFunctionBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBodies"));
        }
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : c.getFunctions().entrySet()) {
            JetNamedFunction declaration = entry.getKey();
            SimpleFunctionDescriptor descriptor2 = entry.getValue();
            BodyResolver.computeDeferredType(descriptor2.getReturnType());
            JetScope declaringScope = (JetScope)c.getDeclaringScopes().apply((Object)declaration);
            assert (declaringScope != null);
            this.resolveFunctionBody(c, this.trace, declaration, descriptor2, declaringScope);
            assert (descriptor2.getReturnType() != null);
        }
    }

    public void resolveFunctionBody(@NotNull BodiesResolveContext c, @NotNull BindingTrace trace, @NotNull JetDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull JetScope declaringScope) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (declaringScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringScope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        this.resolveFunctionBody(c, trace, function2, functionDescriptor, declaringScope, null, null);
    }

    public void resolveFunctionBody(@NotNull BodiesResolveContext c, @NotNull BindingTrace trace, @NotNull JetDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull JetScope scope2, @Nullable Function1<JetScope, DataFlowInfo> beforeBlockBody, @Nullable CallChecker callChecker) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        JetScope innerScope = FunctionDescriptorUtil.getFunctionInnerScope(scope2, functionDescriptor, trace);
        List<JetParameter> valueParameters = function2.getValueParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = functionDescriptor.getValueParameters();
        this.valueParameterResolver.resolveValueParameters(valueParameters, valueParameterDescriptors, ExpressionTypingContext.newContext(this.additionalCheckerProvider, trace, innerScope, c.getOuterDataFlowInfo(), TypeUtils.NO_EXPECTED_TYPE, callChecker));
        DataFlowInfo dataFlowInfo = null;
        if (beforeBlockBody != null) {
            dataFlowInfo = (DataFlowInfo)beforeBlockBody.invoke((Object)innerScope);
        }
        if (function2.hasBody()) {
            this.expressionTypingServices.checkFunctionReturnType(innerScope, function2, functionDescriptor, dataFlowInfo != null ? dataFlowInfo : c.getOuterDataFlowInfo(), null, trace);
        }
        assert (functionDescriptor.getReturnType() != null);
    }

    public void resolveConstructorParameterDefaultValuesAndAnnotations(@NotNull BodiesResolveContext c, @NotNull BindingTrace trace, @NotNull JetClass klass, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull JetScope declaringScope) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (declaringScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringScope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        List<JetParameter> valueParameters = klass.getPrimaryConstructorParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = constructorDescriptor.getValueParameters();
        WritableScope scope2 = BodyResolver.getPrimaryConstructorParametersScope(declaringScope, constructorDescriptor);
        this.valueParameterResolver.resolveValueParameters(valueParameters, valueParameterDescriptors, scope2, c.getOuterDataFlowInfo(), trace);
    }

    private static void computeDeferredType(JetType type2) {
        DeferredType deferredType;
        if (type2 instanceof DeferredType && !(deferredType = (DeferredType)type2).isComputed()) {
            deferredType.getDelegate();
        }
    }

    private void computeDeferredTypes() {
        Collection<Box<DeferredType>> deferredTypes = this.trace.getKeys(BindingContext.DEFERRED_TYPE);
        if (deferredTypes != null) {
            final Queue queue = new Queue(deferredTypes.size() + 1);
            this.trace.addHandler(BindingContext.DEFERRED_TYPE, new ObservableBindingTrace.RecordHandler<Box<DeferredType>, Boolean>(){

                @Override
                public void handleRecord(WritableSlice<Box<DeferredType>, Boolean> deferredTypeKeyDeferredTypeWritableSlice, Box<DeferredType> key, Boolean value2) {
                    queue.addLast((Object)key.getData());
                }
            });
            for (Box<DeferredType> deferredType : deferredTypes) {
                queue.addLast((Object)deferredType.getData());
            }
            while (!queue.isEmpty()) {
                DeferredType deferredType = (DeferredType)queue.pullFirst();
                if (deferredType.isComputed()) continue;
                try {
                    deferredType.getDelegate();
                }
                catch (ReenteringLazyValueComputationException e) {}
            }
        }
    }
}

