/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilPackage;

public class CompileTimeConstantUtils {
    private static final Set<String> ARRAY_CALL_NAMES = KotlinPackage.hashSetOf((Object[])new String[]{"kotlin.array", "kotlin.doubleArray", "kotlin.floatArray", "kotlin.longArray", "kotlin.intArray", "kotlin.charArray", "kotlin.shortArray", "kotlin.byteArray", "kotlin.booleanArray", "kotlin.arrayOf", "kotlin.doubleArrayOf", "kotlin.floatArrayOf", "kotlin.longArrayOf", "kotlin.intArrayOf", "kotlin.charArrayOf", "kotlin.shortArrayOf", "kotlin.byteArrayOf", "kotlin.booleanArrayOf"});

    public static void checkConstructorParametersType(@NotNull List<JetParameter> parameters2, @NotNull BindingTrace trace) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/resolve/CompileTimeConstantUtils", "checkConstructorParametersType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/CompileTimeConstantUtils", "checkConstructorParametersType"));
        }
        for (JetParameter parameter : parameters2) {
            VariableDescriptor parameterDescriptor = trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
            if (parameterDescriptor == null) continue;
            JetType parameterType = parameterDescriptor.getType();
            JetTypeReference typeReference = parameter.getTypeReference();
            if (typeReference == null) continue;
            if (parameterType.isMarkedNullable()) {
                trace.report(Errors.NULLABLE_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
                continue;
            }
            if (!CompileTimeConstantUtils.isAcceptableTypeForAnnotationParameter(parameterType)) {
                trace.report(Errors.INVALID_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
                continue;
            }
            if (!TypeUtilPackage.isJavaLangClassOrArray(parameterType)) continue;
            trace.report(Errors.JAVA_LANG_CLASS_PARAMETER_IN_ANNOTATION.on(typeReference));
        }
    }

    private static boolean isAcceptableTypeForAnnotationParameter(@NotNull JetType parameterType) {
        List<TypeProjection> arguments2;
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/kotlin/resolve/CompileTimeConstantUtils", "isAcceptableTypeForAnnotationParameter"));
        }
        ClassDescriptor typeDescriptor = TypeUtils.getClassDescriptor(parameterType);
        if (typeDescriptor == null) {
            return false;
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        if (DescriptorUtils.isEnumClass(typeDescriptor) || DescriptorUtils.isAnnotationClass(typeDescriptor) || DescriptorUtils.isJavaLangClass(typeDescriptor) || KotlinBuiltIns.isKClass(typeDescriptor) || KotlinBuiltIns.isPrimitiveArray(parameterType) || KotlinBuiltIns.isPrimitiveType(parameterType) || ((Object)builtIns.getStringType()).equals(parameterType)) {
            return true;
        }
        if (KotlinBuiltIns.isArray(parameterType) && (arguments2 = parameterType.getArguments()).size() == 1) {
            JetType arrayType = arguments2.get(0).getType();
            if (arrayType.isMarkedNullable()) {
                return false;
            }
            ClassDescriptor arrayTypeDescriptor = TypeUtils.getClassDescriptor(arrayType);
            if (arrayTypeDescriptor != null) {
                return DescriptorUtils.isEnumClass(arrayTypeDescriptor) || DescriptorUtils.isAnnotationClass(arrayTypeDescriptor) || DescriptorUtils.isJavaLangClass(arrayTypeDescriptor) || KotlinBuiltIns.isKClass(arrayTypeDescriptor) || ((Object)builtIns.getStringType()).equals(arrayType);
            }
        }
        return false;
    }

    @Nullable
    public static String getIntrinsicAnnotationArgument(@NotNull Annotated annotatedDescriptor) {
        if (annotatedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotatedDescriptor", "org/jetbrains/kotlin/resolve/CompileTimeConstantUtils", "getIntrinsicAnnotationArgument"));
        }
        AnnotationDescriptor intrinsicAnnotation = annotatedDescriptor.getAnnotations().findAnnotation(new FqName("kotlin.jvm.internal.Intrinsic"));
        if (intrinsicAnnotation == null) {
            return null;
        }
        Collection<CompileTimeConstant<?>> values2 = intrinsicAnnotation.getAllValueArguments().values();
        if (values2.isEmpty()) {
            return null;
        }
        Object value2 = values2.iterator().next().getValue();
        return value2 instanceof String ? (String)value2 : null;
    }

    public static boolean isArrayMethodCall(@NotNull ResolvedCall<?> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/CompileTimeConstantUtils", "isArrayMethodCall"));
        }
        return ARRAY_CALL_NAMES.contains(DescriptorUtils.getFqName(resolvedCall.getCandidateDescriptor()).asString());
    }

    public static boolean isJavaClassMethodCall(@NotNull ResolvedCall<?> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/CompileTimeConstantUtils", "isJavaClassMethodCall"));
        }
        return "kotlin.javaClass.function".equals(CompileTimeConstantUtils.getIntrinsicAnnotationArgument(resolvedCall.getResultingDescriptor().getOriginal()));
    }

    public static boolean canBeReducedToBooleanConstant(@Nullable JetExpression expression2, @NotNull BindingTrace trace, @Nullable Boolean expectedValue) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/CompileTimeConstantUtils", "canBeReducedToBooleanConstant"));
        }
        if (expression2 == null) {
            return false;
        }
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.evaluate(expression2, trace, KotlinBuiltIns.getInstance().getBooleanType());
        if (!(compileTimeConstant instanceof BooleanValue) || compileTimeConstant.usesVariableAsConstant()) {
            return false;
        }
        Boolean value2 = (Boolean)((BooleanValue)compileTimeConstant).getValue();
        return expectedValue == null || expectedValue.equals(value2);
    }

    private CompileTimeConstantUtils() {
    }
}

