/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Sequence;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage$BindingContextUtils$c4e72da8;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage$TypeInfoFactory$b2a88cc1;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class BindingContextUtilPackage$BindingContextUtils$c4e72da8 {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(@JetValueParameter(name="$receiver") JetReturnExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        JetSimpleNameExpression targetLabel = $receiver.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context2.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement != null) {
                PsiElement $receiver3 = psiElement;
                PsiElement it = $receiver3;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get(BindingContext.FUNCTION, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement it = (PsiElement)$receiver;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        BindingContext bindingContext2 = context2;
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetDeclarationWithBody.class, (boolean)false);
        DeclarationDescriptor declarationDescriptor = bindingContext2.get(readOnlySlice, psiElement);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (containingFunctionDescriptor == null) {
            return null;
        }
        return (FunctionDescriptor)KotlinPackage.firstOrNull((Sequence)KotlinPackage.dropWhile((Sequence)KotlinPackage.sequence((Object)containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE$), (Function1)getTargetFunctionDescriptor.3.INSTANCE$));
    }

    @Nullable
    public static final JetCallableDeclaration getTargetFunction(@JetValueParameter(name="$receiver") JetReturnExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        JetCallableDeclaration jetCallableDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        FunctionDescriptor functionDescriptor = BindingContextUtilPackage$BindingContextUtils$c4e72da8.getTargetFunctionDescriptor($receiver, context2);
        if (functionDescriptor != null) {
            FunctionDescriptor $receiver2 = functionDescriptor;
            FunctionDescriptor it = $receiver2;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it);
            if (!(psiElement instanceof JetCallableDeclaration)) {
                psiElement = null;
            }
            jetCallableDeclaration = (JetCallableDeclaration)psiElement;
        } else {
            jetCallableDeclaration = null;
        }
        return jetCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Object v = context2.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        return !BindingContextUtilPackage$BindingContextUtils$c4e72da8.isUsedAsExpression($receiver, context2);
    }

    public static final <C extends ResolutionContext<C>> void recordScopeAndDataFlowInfo(@JetValueParameter(name="$receiver") ResolutionContext<C> $receiver, @JetValueParameter(name="expression", type="?") @Nullable JetExpression expression2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (expression2 == null) {
            return;
        }
        $receiver.trace.record(BindingContext.RESOLUTION_SCOPE, expression2, $receiver.scope);
        JetTypeInfo typeInfo = (JetTypeInfo)$receiver.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual((Object)$receiver.dataFlowInfo, (Object)DataFlowInfo.EMPTY) ^ true) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, TypeInfoFactoryPackage$TypeInfoFactory$b2a88cc1.noTypeInfo(dataFlowInfo));
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfo(@JetValueParameter(name="$receiver") BindingContext $receiver, @JetValueParameter(name="expression", type="?") @Nullable JetExpression expression2) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                object = expression2;
                if (object == null) break block2;
                JetExpression $receiver2 = object;
                JetExpression it = $receiver2;
                JetTypeInfo jetTypeInfo = (JetTypeInfo)$receiver.get(BindingContext.EXPRESSION_TYPE_INFO, it);
                object = jetTypeInfo != null ? jetTypeInfo.getDataFlowInfo() : null;
                if (object != null) break block3;
            }
            object = DataFlowInfo.EMPTY;
        }
        return object;
    }

    public static final boolean isUnreachableCode(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Object v = context2.get(BindingContext.UNREACHABLE_CODE, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        DeclarationDescriptor targetDescriptor = $receiver instanceof JetReferenceExpression ? (DeclarationDescriptor)context2.get(BindingContext.REFERENCE_TARGET, $receiver) : (DeclarationDescriptor)null;
        Object object = targetDescriptor;
        if (object != null) {
            DeclarationDescriptor $receiver2 = object;
            DeclarationDescriptor it = $receiver2;
            object = KotlinPackage.listOf((Object)it);
            if (object != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        collection = KotlinPackage.orEmpty((Collection)((Collection)context2.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $receiver)));
        return collection;
    }
}

