/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetClassLiteralExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage$callUtil$40b2091c;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.JavaClassValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage$ConstantExpressionEvaluator$7cd19e02;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage$OperationsMapGenerated$7d19c65a;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatorContext;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"<\u001a)Y2i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015%\u0019wN\\:uC:$8O\u0003\u0005fm\u0006dW/\u0019;f\u0015)QU\r\u001e,jg&$xN\u001d\u0006\u0004aNL'bE\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(b\u0002&fiRK\b/\u001a\u0006\u0006if\u0004Xm\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000bQ\u0014\u0018mY3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b3M$(/\u001b8h\u000bb\u0004(/Z:tS>tWI^1mk\u0006$xN\u001d\u00068\u0007>t7\u000f^1oi\u0016C\bO]3tg&|g.\u0012<bYV\fGo\u001c:%gR\u0014\u0018N\\4FqB\u0014Xm]:j_:,e/\u00197vCR|'\u000fJ\u0019\u000b\u0011\u001d,G\u000f\u0016:bG\u0016TQcY1o\u0005\u0016,6/\u001a3J]\u0006sgn\u001c;bi&|gN\u0003\u0006fqB\u0014Xm]:j_:TQBS3u\u000bb\u0004(/Z:tS>t'b\u0002\"p_2,\u0017M\u001c\u0006\u001aGJ,\u0017\r^3D_6\u0004\u0018\u000e\\3US6,7i\u001c8ti\u0006tGOC\u0003wC2,XMC\u0002B]fTA\"\u001a=qK\u000e$X\r\u001a+za\u0016Ta![:QkJ,'BF;tKN4\u0016M]5bE2,\u0017i]\"p]N$\u0018M\u001c;\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0004PE*,7\r\u001e\u0006\u0018GJ,\u0017\r^3Pa\u0016\u0014\u0018\r^5p]\u0006\u0013x-^7f]RTa\"\u001a=qe\u0016\u001c8/[8o)f\u0004XMC\bd_6\u0004\u0018\u000e\\3US6,G+\u001f9f\u0015=\u0019u.\u001c9jY\u0016$\u0016.\\3UsB,'\"E(qKJ\fG/[8o\u0003J<W/\\3oi*i3i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_J$s\n]3sCRLwN\\!sOVlWM\u001c;\u000bQ\r\u0014X-\u0019;f\u001fB,'/\u0019;j_:\f%oZ;nK:$hi\u001c:GSJ\u001cH\u000fU1sC6,G/\u001a:\u000b\u0011\u0005\u0014x-^7f]RTQCU3t_24X\r\u001a,bYV,\u0017I]4v[\u0016tGOC\u0003dC2d7OC\u0003n_\u0012,GNC\u0005qCJ\fW.\u001a;fe*Ab+\u00197vKB\u000b'/Y7fi\u0016\u0014H)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006#GJ,\u0017\r^3Pa\u0016\u0014\u0018\r^5p]\u0006\u0013x-^7f]R4uN\u001d*fG\u0016Lg/\u001a:\u000b\u0019I,7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b\u0019I+7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b-\u00154\u0018\r\\;bi\u0016\u0014\u0015N\\1ss\u0006sGm\u00115fG.T\u0001B]3dK&4XM\u001d\u0006\u0005]\u0006lWM\u0003\u0004TiJLgn\u001a\u0006\u000fG\u0006dG.\u0012=qe\u0016\u001c8/[8o\u00151)g/\u00197vCR,7)\u00197m\u0015I\u0011XmY3jm\u0016\u0014X\t\u001f9sKN\u001c\u0018n\u001c8\u000b+\u00154\u0018\r\\;bi\u0016,f.\u0019:z\u0003:$7\t[3dW*\u0001\u0012n\u001d#jm&\u001c\u0018n\u001c8Csj+'o\u001c\u0006\u000fSN\u0004VO]3D_:\u001cH/\u00198u\u0015A\u0011Xm]8mm\u0016\f%oZ;nK:$8O\u0003\bwC2,X-\u0011:hk6,g\u000e^:\u000b\t1K7\u000f\u001e\u0006\u000e-\u0006dW/Z!sOVlWM\u001c;\u000b\tU$\u0018\u000e\u001c\u0006\u0016m&\u001c\u0018\u000e\u001e\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0015MQU\r\u001e\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0015\u00012\u0018n]5u\u0005&t\u0017M]=XSRDG+\u001f9f%\"\u001bV\t\u001f9sKN\u001c\u0018n\u001c8\u000b=)+GOQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8XSRDG+\u001f9f%\"\u001b&b\u0005<jg&$8)\u00197m\u000bb\u0004(/Z:tS>t'\"\u0005&fi\u000e\u000bG\u000e\\#yaJ,7o]5p]*Yb/[:ji\u000ec\u0017m]:MSR,'/\u00197FqB\u0014Xm]:j_:T\u0011DS3u\u00072\f7o\u001d'ji\u0016\u0014\u0018\r\\#yaJ,7o]5p]*9b/[:ji\u000e{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0016\u0015\u0016$8i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u0015=1\u0018n]5u\u0015\u0016$X\t\\3nK:$(bB3mK6,g\u000e\u001e\u0006\u000b\u0015\u0016$X\t\\3nK:$(B\u0006<jg&$H*\u00192fY\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u000b))+G\u000fT1cK2,G-\u0012=qe\u0016\u001c8/[8o\u0015q1\u0018n]5u!\u0006\u0014XM\u001c;iKNL'0\u001a3FqB\u0014Xm]:j_:T!DS3u!\u0006\u0014XM\u001c;iKNL'0\u001a3FqB\u0014Xm]:j_:T\u0001D^5tSR\fV/\u00197jM&,G-\u0012=qe\u0016\u001c8/[8o\u0015YQU\r^)vC2Lg-[3e\u000bb\u0004(/Z:tS>t'\"\u0007<jg&$8+[7qY\u0016t\u0015-\\3FqB\u0014Xm]:j_:TqCS3u'&l\u0007\u000f\\3OC6,W\t\u001f9sKN\u001c\u0018n\u001c8\u000b;YL7/\u001b;TiJLgn\u001a+f[Bd\u0017\r^3FqB\u0014Xm]:j_:T1DS3u'R\u0014\u0018N\\4UK6\u0004H.\u0019;f\u000bb\u0004(/Z:tS>t'\u0002\u0006<jg&$XK\\1ss\u0016C\bO]3tg&|gN\u0003\nKKR,f.\u0019:z\u000bb\u0004(/Z:tS>t'\"C\"p[B\fg.[8o!\u0010Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001QA\u0001\u0003\u0002\u0011\u0011)1\u0001b\u0002\t\b1\u0001Qa\u0001\u0003\u0003\u0011\u0013a\u0001!\u0002\u0002\u0005\u0003!-Qa\u0001\u0003\u0006\u0011\u0015a\u0001!B\u0002\u0005\u0004!9A\u0002A\u0003\u0003\t\u0007Aq!\u0002\u0002\t\u00111\tQA\u0001C\u0003\u0011!)1\u0001b\u0002\t\u00151\u0001Q!\u0001E\u0002\u000b\r!\t\u0002#\u0006\r\u0001\u0015\u0011Aq\u0001\u0005\u000b\u000b\r!\t\u0002\u0003\u0007\r\u0001\u0015\u0011AA\u0001E\u0005\u000b\u0005Aa\"\u0002\u0002\u0005\u0017!uQA\u0001C\f\u0011=)!\u0001B\u0003\t\u000b\u0015\u0019AQ\u0001\u0005\u0012\u0019\u0001)1\u0001B\u0002\t$1\u0001QA\u0001C\u0003\u0011I)!\u0001\"\u0002\t#\u0015\u0011A1\u0001\u0005\u0015\u000b\t!q\u0002#\u000b\u0006\u0007\u0011}\u0001r\u0005\u0007\u0001\u000b\t!\u0011\u0001\u0003\f\u0006\u0007\u0011\u0005\u00022\u0006\u0007\u0001\u000b\t!y\u0002c\n\u0006\u0005\u0011\u0005\u00022F\u0003\u0004\t?Ay\u0003\u0004\u0001\u0006\u0005\u0011}\u0001rF\u0003\u0004\t#A\u0019\u0004\u0004\u0001\u0006\u0005\u0011]\u00012G\u0003\u0004\t#Aa\u0004\u0004\u0001\u0006\u0007\u0011\u001d\u0001R\b\u0007\u0001\u000b\t!1\u0002C\u0010\u0006\u0005\u0011-\u0002BH\u0003\u0004\t\u000fA\u0001\u0005\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0002I\u0003\u0004\t\u000fA\u0011\u0005\u0004\u0001\u0006\u0005\u0011\u001d\u0001\"I\u0003\u0004\t\u000fA!\u0005\u0004\u0001\u0006\u0005\u0011\u001d\u0001BI\u0003\u0004\t\u000fA1\u0005\u0004\u0001\u0006\u0005\u0011\u001d\u0001bI\u0003\u0004\t\u000fAA\u0005\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0002J\u0003\u0004\t\u000fAY\u0005\u0004\u0001\u0006\u0005\u0011\u001d\u00012J\u0003\u0004\t\u000fAi\u0005\u0004\u0001\u0006\u0005\u0011\u001d\u0001RJ\u0003\u0004\t\u000fAy\u0005\u0004\u0001\u0006\u0005\u0011\u001d\u0001rJ\u0003\u0004\t\u000fA\t\u0006\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0012K\u0003\u0004\t\u000fA\u0019\u0006\u0004\u0001\u0006\u0005\u0011\u001d\u00012K\u0003\u0004\t\u000fA)\u0006\u0004\u0001\u0006\u0005\u0011\u001d\u0001RK\u0003\u0004\t\u000fA9\u0006\u0004\u0001\u0006\u0005\u0011\u001d\u0001r\u000b\u0003\u0004\u0019\r\u0001B&\u0007\u0007\u0006\u0003!!\u0011\"B\u0005\u0005\u000b\u0005AI!C\u0001\u0005\u0004%\u0019\u0011BA\u0003\u0002\u0011\u0017aB\u0006h\t.\u0017\u0011\tG\u0001g\u0004\"\u0005\u0015\t\u0001bB+\u0004\t\u0015\u0019AqB\u0005\u0002\u0011\u001fis\u0002\u00021\u00051\u001b\t#!B\u0001\t\rU\u001b\u0001\"B\u0002\u0005\u000e%\t\u0001RB\u0007\u0004\t#I\u0011\u0001#\u0004.'\u0011\t\u0001$CO\u0007\t\u0001A\u0019\"\u0004\u0002\u0006\u0003!A\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\"C)\u0004\u000b\u0011I\u0011\"\u0001C\u0001\u001b\u0005A\u0019\"\f \u0005\u0001aYQt\u0002\u0003\u0001\u0011/i1!B\u0001\t\u00151\u0005\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005AY\u0001$\u0001Q\u0007\u0003ij\u0001B\u0001\t\u001b5\u0011Q!\u0001\u0005\n!\u000e\tQT\u0002\u0003\u0002\u0011%i!!B\u0001\t\u0013A\u001b\u0019!(\u0004\u0005\u0003!mQBA\u0003\u0002\u0011%\u00016AA\u0011\u0006\u000b\u0005AI!C\u0001\u0005\u00041\u0005\u0011kA\u0007\u0005\u0017%\t\u0001RC\u0007\u0002\u00111i\u0011\u0001#\u0007\u000e\u0003\u0011\u0005Q\"\u0001C\u0001\u001b\u0005!\t!L\u0015\u0005\u0003a}QT\u0002\u0003\u0001\u0011'i!!B\u0001\t\u0011A\u001b\u0001!(\u0004\u0005\u0001!\u0001RBA\u0003\u0002\u0011\u0017\u00016\u0011AO\t\t\u0001A\t#\u0004\u0003\u0006\u0003!i\u0011\"\u0001C\u0002!\u000e\t\u0011eA\u0003\u0002\u00117a\t!U\u0002\n\t?I\u0011\u0001\u0003\b\u000e\u0003!MQ\"\u0001E\r\u001b\u0005Ai\"l\u000f\u0005\u0003a\u0015RT\u0002\u0003\u0001\u0011Mi!!B\u0001\t!A\u001b\u0001!(\u0004\u0005\u0001!)RBA\u0003\u0002\u0011E\u00016\u0011A\u0011\u0004\u000b\u0005AY\u0002$\u0001R\u0007\u001d!)#C\u0001\t\u001d5\t\u00012E\u0007\u0002\u0011Ii{\u0004B\u0001\u0019.uEA\u0001\u0001\u0005\u0018\u001b\u0011)\u0011\u0001#\n\n\u0003\u0011\r\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001C\r)\u0011\u0001c\u0007\r\u0002E\u001bq\u0001\"\f\n\u0003!qQ\"\u0001\u0005\u0014\u001b\u0005A\u0019\",\u0011\u0005\u0003a\u0019QT\u0002\u0003\u0001\u0011'i!!B\u0001\t\u0011A\u001b\u0001!h\u0004\u0005\u0001!eQbA\u0003\u0002\u0011\u0017a\t\u0001UB\u0001C\u0015)\u0011\u0001#\u0003\n\u0003\u0011\rA\u0012A)\u0004\u000f\u0011\u0019\u0011\"\u0001E\u000b\u001b\u0005A\u0019\"D\u0001\t\u001a5\u0006D!\u0001\r\u0019;\u001b!\u0001\u0001#\r\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0001u5A\u0001\u0001\u0005\u0016\u001b\t)\u0011\u0001c\u0007Q\u0007\u0003ij\u0001\u0002\u0001\t35\u0011Q!\u0001E\u0014!\u000e\tQT\u0002\u0003\u0001\u0011ii!!B\u0001\t\u0011A\u001b\u0019!I\u0002\u0006\u0003!QA\u0012A)\u0004\u0017\u0011A\u0012\"\u0001\u0005\r\u001b\u0005Aa\"D\u0001\t\u001d5\t\u0001\u0002F\u0007\u0002\u0011'i#\u0006B\u0001\u00196u5A\u0001\u0001\u0005\u001b\u001b\t)\u0011\u0001\u0003\u0005Q\u0007\u0001ij\u0001\u0002\u0001\t75\u0011Q!\u0001\u0005\t!\u000e\u0005Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\f1\u0005\u0001kA\u0001\"\u000b\u0015\t\u0001\u0012B\u0005\u0002\t\u0007a\t!U\u0002\n\tkI\u0011\u0001#\u0006\u000e\u0003!MQ\"\u0001E\n\u001b\u0005AI\"L\u0014\u0005\u0003a]RT\u0002\u0003\u0001\u0011ci!!B\u0001\t\u001cA\u001b\u0001!(\u0004\u0005\u0001!IRBA\u0003\u0002\u0011O\u00016\u0011AO\u0007\t\u0001A!$\u0004\u0002\u0006\u0003!A\u0001kA\u0001\"\u0007\u0015\t\u0001B\u0003G\u0001#\u000eIAqG\u0005\u0002\u00111i\u0011\u0001\u0003\b\u000e\u0003!!R\"\u0001E\n[w!\u0011\u0001\u0007\u000f\u001e\u000e\u0011\u0001\u0001\"G\u0007\u0003\u000b\u0005A9\u0003U\u0002\u0001;\u001f!\u0001\u0001C\u000b\u000e\u0007\u0015\t\u0001B\u0003G\u0001!\u000e\u0005\u0011EA\u0003\u0002\u0011%\t6a\u0002\u0003\u001d\u0013\u0005!\t!D\u0001\t)5\t\u0001\u0002D\u0017\u0014\t\u0005AJ$(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011!\u00016\u0001A\u0011\u0003\u000b\u0005A\u0011\"U\u0002\u0006\tsI\u0011\u0001\"\u0001\u000e\u0003!MQV\n\u0003\u00021ui*\u0002\u0002\u0001\t<51Q!\u0001E\u0015\u0013\rI!!B\u0001\t+A\u001b\u0001!(\u0004\u0005\u0001!eQBA\u0003\u0002\u0011\u0017\u00016\u0011A\u0011\t\u000b\u0005AI#C\u0003\n\t\u0015\t\u0001\u0012B\u0005\u0002\t\u0007\t6a\u0002\u0003\u001e\u0013\u0005Aa#D\u0001\t-5\t\u0001\u0012D\u0017\u0014\t\u0005AZ\"(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011!\u00016\u0001A\u0011\u0003\u000b\u0005A\u0011\"U\u0002\u0006\t7I\u0011\u0001\"\u0001\u000e\u0003!MQ\u0016\t\u0003\f1\u007fij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001E\u0017!\u000e\u0001Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\f1\u0005\u0001k!\u0001\"\u000b\u0015\t\u0001\u0012B\u0005\u0002\t\u0007a\t!U\u0002\b\t\u007fI\u0011\u0001#\u0006\u000e\u0003!9R\"\u0001E\r[\u0003\"1\u0002'\u0011\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005Ay\u0003U\u0002\u0001;\u001f!\u0001\u0001#\u0007\u000e\u0007\u0015\t\u00012\u0002G\u0001!\u000e\u0005\u0011%B\u0003\u0002\u0011\u0013I\u0011\u0001b\u0001\r\u0002E\u001bq\u0001\"\u0011\n\u0003!UQ\"\u0001\u0005\u0019\u001b\u0005AI\",\u0011\u0005\u0017a\rST\u0002\u0003\u0001\u0011'i!!B\u0001\t2A\u001b\u0001!h\u0004\u0005\u0001!eQbA\u0003\u0002\u0011\u0017a\t\u0001UB\u0001C\u0015)\u0011\u0001#\u0003\n\u0003\u0011\rA\u0012A)\u0004\u000f\u0011\r\u0013\"\u0001E\u000b\u001b\u0005A\u0011$D\u0001\t\u001a5\u0006Ca\u0003M#;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u00012\u0007)\u0004\u0001u=A\u0001\u0001E\r\u001b\r)\u0011\u0001c\u0003\r\u0002A\u001b\t!I\u0003\u0006\u0003!%\u0011\"\u0001C\u0002\u0019\u0003\t6a\u0002C#\u0013\u0005A)\"D\u0001\t55\t\u0001\u0012DW!\t-A:%(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011k\u00016\u0001AO\b\t\u0001AI\"D\u0002\u0006\u0003!-A\u0012\u0001)\u0004\u0002\u0005*Q!\u0001E\u0005\u0013\u0005!\u0019\u0001$\u0001R\u0007\u001d!9%C\u0001\t\u00165\t\u0001bG\u0007\u0002\u00113i\u000b\u0005B\u0006\u0019Ju5A\u0001\u0001\u0005&\u001b\t)\u0011\u0001c\u000eQ\u0007\u0001iz\u0001\u0002\u0001\t\u001a5\u0019Q!\u0001E\u0006\u0019\u0003\u00016\u0011A\u0011\u0006\u000b\u0005AI!C\u0001\u0005\u00041\u0005\u0011kA\u0004\u0005J%\t\u0001RC\u0007\u0002\u0011qi\u0011\u0001#\u0007.B\u0011Y\u0001DJO\u0007\t\u0001A\u0019\"\u0004\u0002\u0006\u0003!e\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005AY\u0001$\u0001Q\u0007\u0003\tS!B\u0001\t\n%\tA1\u0001G\u0001#\u000e9AAJ\u0005\u0002\u0011+i\u0011\u0001C\u000f\u000e\u0003!eQ\u0016\t\u0003\f1\u001djj\u0001\u0002\u0001\t\u00145\u0011Q!\u0001E\u001e!\u000e\u0001Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\f1\u0005\u0001k!\u0001\"\u000b\u0015\t\u0001\u0012B\u0005\u0002\t\u0007a\t!U\u0002\b\t\u001dJ\u0011\u0001#\u0006\u000e\u0003!qR\"\u0001E\r[\u0003\"1\u0002\u0007\u0015\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005Ai\u0004U\u0002\u0001;\u001f!\u0001\u0001#\u0007\u000e\u0007\u0015\t\u00012\u0002G\u0001!\u000e\u0005\u0011%B\u0003\u0002\u0011\u0013I\u0011\u0001b\u0001\r\u0002E\u001bq\u0001\u0002\u0015\n\u0003!UQ\"\u0001\u0005 \u001b\u0005AI\",\u0011\u0005\u0017aIST\u0002\u0003\u0001\u0011'i!!B\u0001\t@A\u001b\u0001!h\u0004\u0005\u0001!eQbA\u0003\u0002\u0011\u0017a\t\u0001UB\u0001C\u0015)\u0011\u0001#\u0003\n\u0003\u0011\rA\u0012A)\u0004\u000f\u0011I\u0013\"\u0001E\u000b\u001b\u0005A\u0001%D\u0001\t\u001a5\u0006Ca\u0003\r+;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\u0012\t)\u0004\u0001u=A\u0001\u0001E\r\u001b\r)\u0011\u0001c\u0003\r\u0002A\u001b\t!I\u0003\u0006\u0003!%\u0011\"\u0001C\u0002\u0019\u0003\t6a\u0002\u0003+\u0013\u0005A)\"D\u0001\tC5\t\u0001\u0012DW!\t-A2&(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011\u0007\u00026\u0001AO\b\t\u0001AI\"D\u0002\u0006\u0003!-A\u0012\u0001)\u0004\u0002\u0005*Q!\u0001E\u0005\u0013\u0005!\u0019\u0001$\u0001R\u0007\u001d!1&C\u0001\t\u00165\t\u0001BI\u0007\u0002\u00113)L#b\n\u0005C\u0004Ab!(\u0004\u0005\u0001!5QBA\u0003\u0002\u0011\u0019\u00016\u0001A\u0011\u0003\u000b\u0005A1!U\u0002\u0006\t\u0019I\u0011\u0001\u0002\u0001\u000e\u0003!5\u0001"})
public final class ConstantExpressionEvaluator
extends JetVisitor<CompileTimeConstant<?>, JetType> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    @NotNull
    private final BindingTrace trace;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(ConstantExpressionEvaluator.class);
        OBJECT$ = Companion = org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator$Companion.access$init$1();
    }

    private final CompileTimeConstant<?> evaluate(@JetValueParameter(name="expression") JetExpression expression2, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.getBindingContext()");
        CompileTimeConstant<?> recordedCompileTimeConstant = ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression2, bindingContext2);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        JetVisitor jetVisitor = this;
        JetType jetType = expectedType;
        if (jetType == null) {
            jetType = TypeUtils.NO_EXPECTED_TYPE;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression2.accept(jetVisitor, jetType);
        if (compileTimeConstant != null) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression2, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@JetValueParameter(name="expression") @NotNull JetConstantExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        String text = expression2.getText();
        if (text == null) {
            return null;
        }
        IElementType nodeElementType = expression2.getNode().getElementType();
        if (Intrinsics.areEqual((Object)nodeElementType, (Object)((Object)JetNodeTypes.NULL))) {
            return NullValue.NULL;
        }
        IElementType iElementType = nodeElementType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetNodeTypes.INTEGER_CONSTANT))) {
            object = EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.parseLong(text);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetNodeTypes.FLOAT_CONSTANT))) {
            object = EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.parseFloatingLiteral(text);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetNodeTypes.BOOLEAN_CONSTANT))) {
            object = EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.parseBoolean(text);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetNodeTypes.CHARACTER_CONSTANT))) {
            object = CompileTimeConstantChecker.parseChar(expression2);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression2);
        }
        Long result2 = object;
        if (result2 == null) {
            return null;
        }
        Function0<Boolean> isLongWithSuffix$ = new Function0<Boolean>(nodeElementType, text){
            final /* synthetic */ IElementType $nodeElementType;
            final /* synthetic */ String $text;

            public final boolean invoke() {
                return Intrinsics.areEqual((Object)this.$nodeElementType, (Object)((Object)JetNodeTypes.INTEGER_CONSTANT)) && EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.hasLongSuffix(this.$text);
            }
            {
                this.$nodeElementType = iElementType;
                this.$text = string;
                super(0);
            }
        };
        return this.createCompileTimeConstant(result2, expectedType, !isLongWithSuffix$.invoke(), true, false);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@JetValueParameter(name="expression") @NotNull JetParenthesizedExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression2);
        if (deparenthesizedExpression != null && Intrinsics.areEqual((Object)deparenthesizedExpression, (Object)expression2) ^ true) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@JetValueParameter(name="expression") @NotNull JetLabeledExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@JetValueParameter(name="expression") @NotNull JetStringTemplateExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        StringBuilder sb = new StringBuilder();
        boolean interupted = false;
        boolean canBeUsedInAnnotation = true;
        boolean usesVariableAsConstant = false;
        JetStringTemplateEntry[] jetStringTemplateEntryArray = expression2.getEntries();
        for (int i = 0; i < jetStringTemplateEntryArray.length; ++i) {
            JetStringTemplateEntry entry;
            JetStringTemplateEntry jetStringTemplateEntry = entry = jetStringTemplateEntryArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)jetStringTemplateEntry, (String)"entry");
            StringValue constant = this.stringExpressionEvaluator.evaluate(jetStringTemplateEntry);
            if (constant == null) {
                interupted = true;
                break;
            }
            if (!constant.canBeUsedInAnnotations()) {
                canBeUsedInAnnotation = false;
            }
            if (constant.usesVariableAsConstant()) {
                usesVariableAsConstant = true;
            }
            sb.append((String)constant.getValue());
        }
        return !interupted ? this.createCompileTimeConstant(sb.toString(), expectedType, true, canBeUsedInAnnotation, usesVariableAsConstant) : (CompileTimeConstant<?>)null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@JetValueParameter(name="expression") @NotNull JetBinaryExpressionWithTypeRHS expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetExpression jetExpression = expression2.getLeft();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression, (String)"expression.getLeft()");
        return this.evaluate(jetExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetExpression leftExpression = expression2.getLeft();
        if (leftExpression == null) {
            return null;
        }
        IElementType operationToken = expression2.getOperationToken();
        if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey((Object)operationToken)) {
            boolean bl;
            JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
            CompileTimeConstant<?> leftConstant = this.evaluate(leftExpression, booleanType);
            if (leftConstant == null) {
                return null;
            }
            JetExpression rightExpression = expression2.getRight();
            if (rightExpression == null) {
                return null;
            }
            CompileTimeConstant<?> rightConstant = this.evaluate(rightExpression, booleanType);
            if (rightConstant == null) {
                return null;
            }
            Object leftValue = leftConstant.getValue();
            Object rightValue = rightConstant.getValue();
            if (!(leftValue instanceof Boolean) || !(rightValue instanceof Boolean)) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.ANDAND))) {
                bl = ((Boolean)leftValue).booleanValue() && ((Boolean)rightValue).booleanValue();
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.OROR))) {
                bl = ((Boolean)leftValue).booleanValue() || ((Boolean)rightValue).booleanValue();
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            boolean usesVariableAsConstant = leftConstant.usesVariableAsConstant() || rightConstant.usesVariableAsConstant();
            return this.createCompileTimeConstant(result2, expectedType, true, true, usesVariableAsConstant);
        }
        JetExpression jetExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression, (String)"expression.getOperationReference()");
        return this.evaluateCall(jetExpression, leftExpression, expectedType);
    }

    /*
     * WARNING - void declaration
     */
    private final CompileTimeConstant<?> evaluateCall(@JetValueParameter(name="callExpression") JetExpression callExpression, @JetValueParameter(name="receiverExpression") JetExpression receiverExpression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        JetElement jetElement = callExpression;
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$40b2091c.getResolvedCall(jetElement, bindingContext2);
        if (resolvedCall == null) {
            return null;
        }
        Name resultingDescriptorName = resolvedCall.getResultingDescriptor().getName();
        OperationArgument argumentForReceiver = this.createOperationArgumentForReceiver(resolvedCall, receiverExpression);
        if (argumentForReceiver == null) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultingDescriptorName.asString()");
            Object result2 = this.evaluateUnaryAndCheck(argumentForReceiver, string, callExpression);
            if (result2 == null) {
                return null;
            }
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains((Object)resultingDescriptorName);
            return this.createCompileTimeConstant(result2, expectedType, !isNumberConversionMethod && isArgumentPure, canBeUsedInAnnotation, usesVariableAsConstant);
        }
        if (argumentsEntrySet.size() == 1) {
            void parameter;
            void argument;
            Map.Entry canBeUsedInAnnotation = (Map.Entry)KotlinPackage.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor result2 = (ValueParameterDescriptor)KotlinPackage.component1((Map.Entry)canBeUsedInAnnotation);
            ResolvedValueArgument isArgumentPure = (ResolvedValueArgument)KotlinPackage.component2((Map.Entry)canBeUsedInAnnotation);
            canBeUsedInAnnotation = null;
            void v3 = argument;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"argument");
            void v4 = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"parameter");
            OperationArgument argumentForParameter2 = this.createOperationArgumentForFirstParameter((ResolvedValueArgument)v3, (ValueParameterDescriptor)v4);
            if (argumentForParameter2 == null) {
                return null;
            }
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultingDescriptorName.asString()");
            if (this.isDivisionByZero(string, argumentForParameter2.getValue())) {
                PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)receiverExpression), JetExpression.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"PsiTreeUtil.getParentOfT\u2026rExpression, javaClass())");
                JetExpression parentExpression = (JetExpression)psiElement;
                this.trace.report(Errors.DIVISION_BY_ZERO.on((JetExpression)((PsiElement)parentExpression)));
                return ErrorValue.create("Division by zero");
            }
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resultingDescriptorName.asString()");
            Object result3 = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter2, string2, callExpression);
            if (result3 == null) {
                return null;
            }
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) && this.isPureConstant(argumentForParameter2.getExpression());
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) && this.canBeUsedInAnnotation(argumentForParameter2.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression()) || this.usesVariableAsConstant(argumentForParameter2.getExpression());
            EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation2, areArgumentsPure, usesVariableAsConstant);
            Name name2 = resultingDescriptorName;
            return Intrinsics.areEqual((Object)name2, (Object)OperatorConventions.COMPARE_TO) ? EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.createCompileTimeConstantForCompareTo(result3, callExpression, c) : (Intrinsics.areEqual((Object)name2, (Object)OperatorConventions.EQUALS) ? EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.createCompileTimeConstantForEquals(result3, callExpression, c) : this.createCompileTimeConstant(result3, expectedType, areArgumentsPure, canBeUsedInAnnotation2, usesVariableAsConstant));
        }
        return null;
    }

    private final boolean usesVariableAsConstant(@JetValueParameter(name="expression") JetExpression expression2) {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.getBindingContext()");
        CompileTimeConstant<?> compileTimeConstant = Companion.getConstant(expression2, bindingContext2);
        return compileTimeConstant != null ? compileTimeConstant.usesVariableAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(@JetValueParameter(name="expression") JetExpression expression2) {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.getBindingContext()");
        CompileTimeConstant<?> compileTimeConstant = Companion.getConstant(expression2, bindingContext2);
        return compileTimeConstant != null ? compileTimeConstant.canBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(@JetValueParameter(name="expression") JetExpression expression2) {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.getBindingContext()");
        CompileTimeConstant<?> compileTimeConstant = Companion.getConstant(expression2, bindingContext2);
        if (compileTimeConstant instanceof IntegerValueConstant) {
            return ((IntegerValueConstant)compileTimeConstant).isPure();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateUnaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="name") String name2, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        void check2;
        void function2;
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> functions2 = EvaluatePackage$OperationsMapGenerated$7d19c65a.getUnaryOperations().get(new UnaryOperationKey(receiver.getCtcType(), name2));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> pair2 = functions2;
        Function1 function1 = (Function1)pair2.component1();
        Function1 function12 = (Function1)pair2.component2();
        pair2 = null;
        Object result2 = function2.invoke(receiver.getValue());
        if (Intrinsics.areEqual((Object)check2, EvaluatePackage$OperationsMapGenerated$7d19c65a.getEmptyUnaryFun())) {
            return result2;
        }
        KotlinPackage.assert((boolean)EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.isIntegerType(receiver.getValue()), (Object)"Only integer constants should be checked for overflow");
        KotlinPackage.assert((boolean)Intrinsics.areEqual((Object)name2, (Object)"minus"), (Object)"Only negation should be checked for overflow");
        if (Intrinsics.areEqual((Object)receiver.getValue(), (Object)result2)) {
            void $receiver;
            PsiElement psiElement = (PsiElement)callExpression;
            DiagnosticFactory0<JetExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetExpression.class, (boolean)true);
            JetExpression jetExpression = (JetExpression)psiElement2;
            if (jetExpression == null) {
                jetExpression = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((JetExpression)((PsiElement)jetExpression)));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateBinaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="parameter") OperationArgument parameter, @JetValueParameter(name="name") String name2, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        void value2;
        void checker2;
        Object object;
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> functions2 = EvaluatePackage$OperationsMapGenerated$7d19c65a.getBinaryOperations().get(new BinaryOperationKey(receiver.getCtcType(), parameter.getCtcType(), name2));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair2 = functions2;
        Function2 function2 = (Function2)pair2.component1();
        Function2 function22 = (Function2)pair2.component2();
        pair2 = null;
        try {
            void function3;
            object = function3.invoke(receiver.getValue(), parameter.getValue());
        }
        catch (Exception e) {
            object = null;
        }
        Object actualResult = object;
        if (Intrinsics.areEqual((Object)checker2, EvaluatePackage$OperationsMapGenerated$7d19c65a.getEmptyBinaryFun())) {
            return actualResult;
        }
        boolean bl = EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.isIntegerType(receiver.getValue()) && EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.isIntegerType(parameter.getValue());
        if (KotlinPackage.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        evaluateBinaryAndCheck.2 toBigInteger$ = evaluateBinaryAndCheck.2.INSTANCE$;
        Object object2 = toBigInteger$.invoke(receiver.getValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"toBigInteger(receiver.value)");
        Object object3 = toBigInteger$.invoke(parameter.getValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"toBigInteger(parameter.value)");
        BigInteger resultInBigIntegers = (BigInteger)checker2.invoke(object2, object3);
        if (Intrinsics.areEqual((Object)toBigInteger$.invoke(actualResult), (Object)resultInBigIntegers) ^ true) {
            void $receiver;
            PsiElement psiElement = (PsiElement)callExpression;
            DiagnosticFactory0<JetExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetExpression.class, (boolean)true);
            JetExpression jetExpression = (JetExpression)psiElement2;
            if (jetExpression == null) {
                jetExpression = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((JetExpression)((PsiElement)jetExpression)));
        }
        return actualResult;
    }

    private final boolean isDivisionByZero(@JetValueParameter(name="name") String name2, @JetValueParameter(name="parameter", type="?") Object parameter) {
        Object object = OperatorConventions.BINARY_OPERATION_NAMES.get((Object)JetTokens.DIV);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)name2, (Object)((Name)object).asString())) {
            if (EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.isIntegerType(parameter)) {
                Object object2 = parameter;
                if (object2 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object2).longValue() == (long)0;
            }
            if (parameter instanceof Float || parameter instanceof Double) {
                Object object3 = parameter;
                if (object3 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object3).doubleValue() == 0.0;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@JetValueParameter(name="expression") @NotNull JetUnaryExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetExpression leftExpression = expression2.getBaseExpression();
        if (leftExpression == null) {
            return null;
        }
        JetExpression jetExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression, (String)"expression.getOperationReference()");
        return this.evaluateCall(jetExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@JetValueParameter(name="expression") @NotNull JetSimpleNameExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
        if (enumDescriptor != null && DescriptorUtils.isEnumEntry(enumDescriptor)) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return new EnumValue((ClassDescriptor)declarationDescriptor, false);
        }
        JetElement jetElement = expression2;
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$40b2091c.getResolvedCall(jetElement, bindingContext2);
        if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof VariableDescriptor) {
            Object object;
            CompileTimeConstant<?> compileTimeConstant = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            if (compileTimeConstant == null) {
                return null;
            }
            if (compileTimeConstant instanceof IntegerValueTypeConstant) {
                IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)compileTimeConstant;
                JetType jetType = expectedType;
                if (jetType == null) {
                    jetType = TypeUtils.NO_EXPECTED_TYPE;
                }
                object = integerValueTypeConstant.getValue(jetType);
            } else {
                object = compileTimeConstant.getValue();
            }
            Object value2 = object;
            VariableDescriptor variableDescriptor = (VariableDescriptor)callableDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor, (String)"callableDescriptor");
            return this.createCompileTimeConstant(value2, expectedType, false, Companion.isPropertyCompileTimeConstant(variableDescriptor), true);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@JetValueParameter(name="expression") @NotNull JetQualifiedExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetExpression selectorExpression = expression2.getSelectorExpression();
        if (selectorExpression instanceof JetCallExpression) {
            JetExpression receiverExpression;
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            JetExpression calleeExpression = ((JetCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof JetSimpleNameExpression)) {
                return null;
            }
            JetExpression jetExpression = receiverExpression = expression2.getReceiverExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression, (String)"receiverExpression");
            return this.evaluateCall(calleeExpression, jetExpression, expectedType);
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@JetValueParameter(name="expression") @NotNull JetCallExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetElement jetElement = expression2;
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> call = CallUtilPackage$callUtil$40b2091c.getResolvedCall(jetElement, bindingContext2);
        if (call == null) {
            return null;
        }
        CallableDescriptor resultingDescriptor = call.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayMethodCall(call)) {
            boolean bl;
            ArrayValue arrayValue;
            ArrayValue arrayValue2;
            List list;
            JetType jetType;
            boolean bl2;
            block10: {
                ArrayValue arrayValue3;
                void destination;
                void $receiver;
                Iterable $receiver2;
                JetType jetType2 = ((ValueParameterDescriptor)KotlinPackage.first(resultingDescriptor.getValueParameters())).getVarargElementType();
                if (jetType2 == null) {
                    Intrinsics.throwNpe();
                }
                JetType varargType = jetType2;
                Iterable iterable = call.getValueArguments().values();
                Iterator iterator2 = $receiver2;
                Collection collection = new ArrayList();
                for (Object element : $receiver) {
                    ResolvedValueArgument it = (ResolvedValueArgument)element;
                    List<ValueArgument> list2 = it.getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.getArguments()");
                    Iterable list3 = this.resolveArguments(list2, varargType);
                    KotlinPackage.addAll((Collection)destination, (Iterable)list3);
                }
                List arguments2 = (List)destination;
                JetType jetType3 = resultingDescriptor.getReturnType();
                if (jetType3 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver2 = arguments2;
                bl2 = true;
                jetType = jetType3;
                list = arguments2;
                arrayValue2 = arrayValue3;
                arrayValue = arrayValue3;
                for (Object element : $receiver2) {
                    CompileTimeConstant it = (CompileTimeConstant)element;
                    if (!it.usesVariableAsConstant()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            boolean bl3 = bl;
            arrayValue2(list, jetType, bl2, bl3);
            return arrayValue;
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"resultingDescriptor.getContainingDeclaration()");
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
                AnnotationDescriptorImpl descriptor2 = new AnnotationDescriptorImpl(classDescriptor2.getDefaultType(), AnnotationResolver.resolveAnnotationArguments(call, this.trace));
                return new AnnotationValue(descriptor2);
            }
        }
        if (CompileTimeConstantUtils.isJavaClassMethodCall(call)) {
            JetType jetType = resultingDescriptor.getReturnType();
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return new JavaClassValue(jetType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitClassLiteralExpression(@JetValueParameter(name="expression") @NotNull JetClassLiteralExpression expression2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetType jetType = this.trace.getType(expression2);
        if (jetType.isError()) {
            return null;
        }
        JetType jetType2 = jetType;
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"jetType");
        return new KClassValue(jetType2);
    }

    private final List<CompileTimeConstant<?>> resolveArguments(@JetValueParameter(name="valueArguments") List<? extends ValueArgument> valueArguments2, @JetValueParameter(name="expectedType") JetType expectedType) {
        ArrayList constants = KotlinPackage.arrayListOf((Object[])new CompileTimeConstant[0]);
        for (ValueArgument valueArgument : valueArguments2) {
            CompileTimeConstant<?> compileTimeConstant;
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || (compileTimeConstant = this.evaluate(argumentExpression, expectedType)) == null) continue;
            constants.add(compileTimeConstant);
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitJetElement(@JetValueParameter(name="element") @NotNull JetElement element, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(@JetValueParameter(name="resolvedCall") ResolvedCall<?> resolvedCall, @JetValueParameter(name="expression") JetExpression expression2) {
        JetType receiverExpressionType = EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.getReceiverExpressionType(resolvedCall);
        if (receiverExpressionType == null) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.getCompileTimeType(receiverExpressionType);
        if (receiverCompileTimeType == null) {
            return null;
        }
        return this.createOperationArgument(expression2, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(@JetValueParameter(name="argument") ResolvedValueArgument argument, @JetValueParameter(name="parameter") ValueParameterDescriptor parameter) {
        JetType jetType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"parameter.getType()");
        CompileTimeType<? extends Object> argumentCompileTimeType = EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.getCompileTimeType(jetType);
        if (argumentCompileTimeType == null) {
            return null;
        }
        List<ValueArgument> arguments2 = argument.getArguments();
        if (arguments2.size() != 1) {
            return null;
        }
        JetExpression argumentExpression = ((ValueArgument)KotlinPackage.first(arguments2)).getArgumentExpression();
        if (argumentExpression == null) {
            return null;
        }
        JetType jetType2 = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"parameter.getType()");
        return this.createOperationArgument(argumentExpression, jetType2, argumentCompileTimeType);
    }

    private final OperationArgument createOperationArgument(@JetValueParameter(name="expression") JetExpression expression2, @JetValueParameter(name="expressionType") JetType expressionType, @JetValueParameter(name="compileTimeType") CompileTimeType<?> compileTimeType) {
        CompileTimeConstant<?> evaluatedConstant = Companion.evaluate(expression2, this.trace, expressionType);
        if (evaluatedConstant == null) {
            return null;
        }
        if (evaluatedConstant instanceof IntegerValueTypeConstant) {
            Number evaluationResultWithNewType;
            Number number = evaluationResultWithNewType = ((IntegerValueTypeConstant)evaluatedConstant).getValue(expressionType);
            Intrinsics.checkExpressionValueIsNotNull((Object)number, (String)"evaluationResultWithNewType");
            return new OperationArgument(number, compileTimeType, expression2);
        }
        Object evaluationResult = evaluatedConstant.getValue();
        if (evaluationResult == null) {
            return null;
        }
        return new OperationArgument(evaluationResult, compileTimeType, expression2);
    }

    @Nullable
    public final CompileTimeConstant<?> createCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value2, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType, @JetValueParameter(name="isPure") boolean isPure, @JetValueParameter(name="canBeUsedInAnnotation") boolean canBeUsedInAnnotation, @JetValueParameter(name="usesVariableAsConstant") boolean usesVariableAsConstant) {
        JetType jetType;
        EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation, isPure, usesVariableAsConstant);
        if (isPure) {
            jetType = expectedType;
            if (jetType == null) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
        } else {
            jetType = null;
        }
        return EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.createCompileTimeConstant(value2, c, jetType);
    }

    @Nullable
    public static /* synthetic */ CompileTimeConstant createCompileTimeConstant$default(ConstantExpressionEvaluator constantExpressionEvaluator, Object object, JetType jetType, boolean bl, boolean bl2, boolean bl3, int n) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return constantExpressionEvaluator.createCompileTimeConstant(object, jetType, bl, bl2, bl3);
    }

    @NotNull
    public final BindingTrace getTrace() {
        return this.trace;
    }

    private ConstantExpressionEvaluator(@JetValueParameter(name="trace") BindingTrace trace) {
        this.trace = trace;
        this.stringExpressionEvaluator = new JetVisitor<StringValue, Void>(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ ConstantExpressionEvaluator this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(stringExpressionEvaluator.1.class);
            }

            @Nullable
            public final StringValue evaluate(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntry entry) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                return (StringValue)entry.accept(this, null);
            }

            @Nullable
            public StringValue visitStringTemplateEntryWithExpression(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntryWithExpression entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                JetExpression expression2 = entry.getExpression();
                if (expression2 == null) {
                    return null;
                }
                return EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.createStringConstant(ConstantExpressionEvaluator.access$evaluate$1(this.this$0, expression2, KotlinBuiltIns.getInstance().getStringType()));
            }

            @NotNull
            public StringValue visitLiteralStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetLiteralStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                return new StringValue(entry.getText(), true, false);
            }

            @NotNull
            public StringValue visitEscapeStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetEscapeStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                return new StringValue(entry.getUnescapedValue(), true, false);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator access$init$0(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        return new ConstantExpressionEvaluator(trace);
    }

    @platformStatic
    @Nullable
    public static final CompileTimeConstant<?> evaluate(@JetValueParameter(name="expression") @NotNull JetExpression expression2, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        return Companion.evaluate(expression2, trace, expectedType);
    }

    @platformStatic
    public static final boolean isPropertyCompileTimeConstant(@JetValueParameter(name="descriptor") @NotNull VariableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return Companion.isPropertyCompileTimeConstant(descriptor2);
    }

    @platformStatic
    @Nullable
    public static final CompileTimeConstant<?> getConstant(@JetValueParameter(name="expression") @NotNull JetExpression expression2, @JetValueParameter(name="bindingContext") @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        return Companion.getConstant(expression2, bindingContext2);
    }

    @platformStatic
    private static final CompileTimeConstant<?> getPossiblyErrorConstant(@JetValueParameter(name="expression") JetExpression expression2, @JetValueParameter(name="bindingContext") BindingContext bindingContext2) {
        return ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression2, bindingContext2);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"h\u0006)I1i\\7qC:LwN\u001c\u0006\u001c\u0007>t7\u000f^1oi\u0016C\bO]3tg&|g.\u0012<bYV\fGo\u001c:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TqA]3t_24XMC\u0005d_:\u001cH/\u00198ug*AQM^1mk\u0006$XMC\u0002B]fT!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*\u0019\u0001o]5\u000b\u000bQ\u0014\u0018mY3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b\u0019\u0015D\b/Z2uK\u0012$\u0016\u0010]3\u000b\u000f)+G\u000fV=qK*)A/\u001f9fg*\u00192i\\7qS2,G+[7f\u0007>t7\u000f^1oi*Yq-\u001a;D_:\u001cH/\u00198u\u00159\u0011\u0017N\u001c3j]\u001e\u001cuN\u001c;fqRTaBQ5oI&twmQ8oi\u0016DHO\u0003\rhKR\u0004vn]:jE2LXI\u001d:pe\u000e{gn\u001d;b]RTQ$[:Qe>\u0004XM\u001d;z\u0007>l\u0007/\u001b7f)&lWmQ8ogR\fg\u000e\u001e\u0006\u000bI\u0016\u001c8M]5qi>\u0014(B\u0005,be&\f'\r\\3EKN\u001c'/\u001b9u_JT1\u0002Z3tGJL\u0007\u000f^8sg*9!i\\8mK\u0006tG6\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0005\u0011\u0011\u0001rA\u0003\u0004\t\u000bA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0002\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\t!!A\u0002A\u0003\u0003\t\u0005AY!B\u0002\u0005\u000b!)A\u0002A\u0003\u0004\t\u0007Ai\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0002C\u0003\u0004\t\u001bAy\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001\u0012\u0003\u0007\u0001\u000b\t!!\u0001#\u0005\u0006\u0005\u0011)\u0001\"B\u0003\u0003\t\u0007Ai!\u0002\u0002\u0005\u000e!=Qa\u0001C\u0002\u0011)a\u0001!\u0002\u0002\u0005\u0004!QQA\u0001\u0003\u0002\u00113)1\u0001B\u0006\t\u00191\u0001Qa\u0001\u0003\u0005\u00115a\u0001!\u0002\u0002\u0005\u0017!aAaq\u0001\r\be\u0011Q!\u0001E\u0005[)\"9\u0001g\u0002\u001e\u000e\u0011\u0001\u0001\u0012B\u0007\u0003\u000b\u0005AY\u0001U\u0002\u0001;\u001b!\u0001\u0001\u0003\u0004\u000e\u0005\u0015\t\u0001B\u0002)\u0004\u0002u=A!\u0001\u0005\b\u001b\r)\u0011\u0001C\u0004\r\u0002A\u001b\u0011!I\u0003\u0006\u0003!=\u0011\"\u0001C\u0002\u0019\u0003\t6!\u0003C\u0004\u0013\u0005A\u0001\"D\u0001\t\u00125\t\u0001\"C\u0007\u0002\u0011'i{\u0004b\u0002\u0019\u0013u5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001c\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005\u000b!\u000e\u0005\u0011%B\u0003\u0002\u0011\u001fI\u0011\u0001b\u0001\r\u0002E\u001bq\u0001B\u0005\n\u0003!AQ\"\u0001E\t\u001b\u0005A)\"l\u0010\u0005\u0004aUQT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\fA\u001b\u0001!(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011)\u00016\u0011A\u0011\u0006\u000b\u0005Ay!C\u0001\u0005\u00041\u0005\u0011kA\u0004\u0005\u0016%\t\u0001\u0002C\u0007\u0002\u0011#i\u0011\u0001#\u0006.'\u0011\u001d\u0001dCO\u0007\t\u0001A9\"\u0004\u0002\u0006\u0003!]\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\u0002D)\u0004\u000b\u0011Y\u0011\"\u0001C\u0001\u001b\u0005AI\"\u000e\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @platformStatic
        @Nullable
        public final CompileTimeConstant<?> evaluate(@JetValueParameter(name="expression") @NotNull JetExpression expression2, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            ConstantExpressionEvaluator evaluator2 = ConstantExpressionEvaluator.access$init$0(trace);
            CompileTimeConstant constant = evaluator2.evaluate(expression2, expectedType);
            return !(constant instanceof ErrorValue) ? constant : (CompileTimeConstant)null;
        }

        @platformStatic
        @Nullable
        public static /* synthetic */ CompileTimeConstant evaluate$default(Companion companion, JetExpression jetExpression, BindingTrace bindingTrace, JetType jetType, int n) {
            if ((n & 4) != 0) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
            return companion.evaluate(jetExpression, bindingTrace, jetType);
        }

        @platformStatic
        public final boolean isPropertyCompileTimeConstant(@JetValueParameter(name="descriptor") @NotNull VariableDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (descriptor2.isVar()) {
                return false;
            }
            if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration()) || DescriptorUtils.isStaticDeclaration(descriptor2)) {
                JetType returnType2 = descriptor2.getType();
                return KotlinBuiltIns.isPrimitiveType(returnType2) || KotlinBuiltIns.isString(returnType2);
            }
            return false;
        }

        @platformStatic
        @Nullable
        public final CompileTimeConstant<?> getConstant(@JetValueParameter(name="expression") @NotNull JetExpression expression2, @JetValueParameter(name="bindingContext") @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            CompileTimeConstant constant = this.getPossiblyErrorConstant(expression2, bindingContext2);
            return !(constant instanceof ErrorValue) ? constant : (CompileTimeConstant)null;
        }

        @platformStatic
        private final CompileTimeConstant<?> getPossiblyErrorConstant(@JetValueParameter(name="expression") JetExpression expression2, @JetValueParameter(name="bindingContext") BindingContext bindingContext2) {
            return (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$1() {
            return new Companion();
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"n\u0004)\tr\n]3sCRLwN\\!sOVlWM\u001c;\u000b7\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\nG>t7\u000f^1oiNT\u0001\"\u001a<bYV\fG/\u001a\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\u0003wC2,XMC\u0004di\u000e$\u0016\u0010]3\u000b\u001f\r{W\u000e]5mKRKW.\u001a+za\u0016T!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*\u0019\u0001o]5\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0004PE*,7\r\u001e\u0006\u000bO\u0016$8\t^2UsB,'\"D4fi\u0016C\bO]3tg&|gN\u0003\u0005hKR4\u0016\r\\;fa*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0019AQ\u0001E\u0001\u0019\u0001)1\u0001B\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!A\u0001\u0003\u0003\r\u0001\u0015\u0019AQ\u0001\u0005\u0007\u0019\u0001)!\u0001B\u0001\t\u0010\u0015\u0019A1\u0002\u0005\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00115\u0001\u0012C\u0003\u0003\t\u001dA\u0011\"\u0002\u0002\u0005\u0006!1QA\u0001C\u0006\u0011\u001d!\u0011\u0001d\u0002\u001a\u0005\u0015\t\u0001\u0012B\u0017\u0012\t\u0001$\u00014B\u0011\u0005\u000b\u0005AQ!C\u0001\u0005\u0004U\u001b\u0001\"B\u0002\u0005\f%\t\u0001\u0002C\u0007\u0004\t'I\u0011\u0001\u0003\u0005.\u001f\u0011\u0001G\u0001'\u0004\"\u0005\u0015\t\u0001BB+\u0004\u0011\u0015\u0019AQB\u0005\u0002\u0011#i1\u0001\u0002\u0006\n\u0003!EQf\u0004\u0003a\ta)\u0011EA\u0003\u0002\u0011\u0013)6\u0001C\u0003\u0004\t\u0015I\u0011\u0001c\u0004\u000e\u0007\u0011U\u0011\"\u0001E\bk'*\t\u0006Br\u00011\u0013ij\u0001\u0002\u0001\t\u000b5\u0011Q!\u0001E\u0005!\u000e\u0001Q\u0014\u0003\u0003\u0001\u0011\u0017iA!B\u0001\t\u000b%\tA1\u0001)\u0004\u0002u5A\u0001\u0001E\u0007\u001b\t)\u0011\u0001\u0003\u0004Q\u0007\u0005\t#!B\u0001\t\bE\u001b\u0011\u0002\"\u0003\n\u0003\u0011\u0001Q\"\u0001E\b\u001b\u0005A\u0001\"D\u0001\t\u0012\u0001"})
    private static final class OperationArgument {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<?> ctcType;
        @NotNull
        private final JetExpression expression;

        static {
            $kotlinClass = Reflection.createKotlinClass(OperationArgument.class);
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType<?> getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final JetExpression getExpression() {
            return this.expression;
        }

        public OperationArgument(@JetValueParameter(name="value") @NotNull Object value2, @JetValueParameter(name="ctcType") @NotNull CompileTimeType<?> ctcType, @JetValueParameter(name="expression") @NotNull JetExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Intrinsics.checkParameterIsNotNull(ctcType, (String)"ctcType");
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            this.value = value2;
            this.ctcType = ctcType;
            this.expression = expression2;
        }
    }
}

