/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.suppress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantsPackage;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage$ConstantExpressionEvaluator$7cd19e02;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage$ConstantExpressionEvaluator$7cd19e02$WhenMappings;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatorContext;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class EvaluatePackage$ConstantExpressionEvaluator$7cd19e02 {
    @NotNull
    static final CompileTimeType<Byte> BYTE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Short> SHORT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Integer> INT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Long> LONG = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Double> DOUBLE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Float> FLOAT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Character> CHAR = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Boolean> BOOLEAN = new CompileTimeType();
    @NotNull
    static final CompileTimeType<String> STRING = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Object> ANY = new CompileTimeType();

    @Nullable
    public static final CompileTimeConstant<?> createCompileTimeConstantWithType(@JetValueParameter(name="$receiver") IntegerValueTypeConstant $receiver, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        return EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.createCompileTimeConstant$default($receiver.getValue(expectedType), new EvaluatorContext($receiver.canBeUsedInAnnotations(), true, false, 4, null), null, 4);
    }

    public static final boolean hasLongSuffix(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return KotlinPackage.endsWith$default((String)text, (char)'l', (boolean)false, (int)2) || KotlinPackage.endsWith$default((String)text, (char)'L', (boolean)false, (int)2);
    }

    @Nullable
    public static final Long parseLong(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        try {
            Function1<String, String> substringLongSuffix$ = new Function1<String, String>(text){
                final /* synthetic */ String $text;

                @NotNull
                public final String invoke(@JetValueParameter(name="s") @NotNull String s) {
                    Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                    return EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.hasLongSuffix(this.$text) ? KotlinPackage.substring((String)s, (int)0, (int)(s.length() - 1)) : s;
                }
                {
                    this.$text = string;
                    super(1);
                }
            };
            Function2<String, Integer, Long> parseLong$ = new Function2<String, Integer, Long>(substringLongSuffix$){
                final /* synthetic */ parseLong.1 $substringLongSuffix;

                public final long invoke(@JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="radix") int radix) {
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    return Long.parseLong(this.$substringLongSuffix.invoke(text), radix);
                }
                {
                    this.$substringLongSuffix = var1_1;
                    super(2);
                }
            };
            return KotlinPackage.startsWith$default((String)text, (String)"0x", (boolean)false, (int)2) || KotlinPackage.startsWith$default((String)text, (String)"0X", (boolean)false, (int)2) ? parseLong$.invoke(KotlinPackage.substring((String)text, (int)2), 16) : (KotlinPackage.startsWith$default((String)text, (String)"0b", (boolean)false, (int)2) || KotlinPackage.startsWith$default((String)text, (String)"0B", (boolean)false, (int)2) ? parseLong$.invoke(KotlinPackage.substring((String)text, (int)2), 2) : parseLong$.invoke(text, 10));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Object parseFloatingLiteral(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (KotlinPackage.endsWith$default((String)KotlinPackage.toLowerCase((String)text), (char)'f', (boolean)false, (int)2)) {
            return EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.parseFloat(text);
        }
        return EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.parseDouble(text);
    }

    @Nullable
    public static final Double parseDouble(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Float parseFloat(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final boolean parseBoolean(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if ("true".equals(text)) {
            return true;
        }
        if ("false".equals(text)) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    @Nullable
    public static final CompileTimeConstant<?> createCompileTimeConstantForEquals(@JetValueParameter(name="result", type="?") @Nullable Object result2, @JetValueParameter(name="operationReference") @NotNull JetExpression operationReference, @JetValueParameter(name="c") @NotNull EvaluatorContext c) {
        Intrinsics.checkParameterIsNotNull((Object)operationReference, (String)"operationReference");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        if (result2 instanceof Boolean) {
            BooleanValue booleanValue;
            KotlinPackage.assert((boolean)(operationReference instanceof JetSimpleNameExpression), (Object)"This method should be called only for equals operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression cannot be cast to org.jetbrains.kotlin.psi.JetSimpleNameExpression");
            }
            IElementType operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.EQEQ))) {
                booleanValue = new BooleanValue((Boolean)result2, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.EXCLEQ))) {
                booleanValue = new BooleanValue((Boolean)result2 == false, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else {
                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.IDENTIFIER))) {
                    KotlinPackage.assert((boolean)Intrinsics.areEqual((Object)((JetSimpleNameExpression)operationReference).getReferencedNameAsName(), (Object)OperatorConventions.EQUALS), (Object)"This method should be called only for equals operations");
                    return new BooleanValue((Boolean)result2, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
                }
                throw (Throwable)new IllegalStateException("Unknown equals operation token: " + operationToken + " " + ((JetSimpleNameExpression)operationReference).getText());
            }
            return booleanValue;
        }
        return null;
    }

    @Nullable
    public static final CompileTimeConstant<?> createCompileTimeConstantForCompareTo(@JetValueParameter(name="result", type="?") @Nullable Object result2, @JetValueParameter(name="operationReference") @NotNull JetExpression operationReference, @JetValueParameter(name="c") @NotNull EvaluatorContext c) {
        Intrinsics.checkParameterIsNotNull((Object)operationReference, (String)"operationReference");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        if (result2 instanceof Integer) {
            BooleanValue booleanValue;
            KotlinPackage.assert((boolean)(operationReference instanceof JetSimpleNameExpression), (Object)"This method should be called only for compareTo operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression cannot be cast to org.jetbrains.kotlin.psi.JetSimpleNameExpression");
            }
            IElementType operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.LT))) {
                booleanValue = new BooleanValue(((Number)result2).intValue() < 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.LTEQ))) {
                booleanValue = new BooleanValue(((Number)result2).intValue() <= 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.GT))) {
                booleanValue = new BooleanValue(((Number)result2).intValue() > 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.GTEQ))) {
                booleanValue = new BooleanValue(((Number)result2).intValue() >= 0, c.getCanBeUsedInAnnotation(), c.getUsesVariableAsConstant());
            } else {
                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.IDENTIFIER))) {
                    KotlinPackage.assert((boolean)Intrinsics.areEqual((Object)((JetSimpleNameExpression)operationReference).getReferencedNameAsName(), (Object)OperatorConventions.COMPARE_TO), (Object)"This method should be called only for compareTo operations");
                    return new IntValue(((Number)result2).intValue(), c.getCanBeUsedInAnnotation(), c.getIsPure(), c.getUsesVariableAsConstant());
                }
                throw (Throwable)new IllegalStateException("Unknown compareTo operation token: " + operationToken);
            }
            return booleanValue;
        }
        return null;
    }

    @Nullable
    public static final StringValue createStringConstant(@JetValueParameter(name="value", type="?") @Nullable CompileTimeConstant<?> value2) {
        CompileTimeConstant<?> compileTimeConstant = value2;
        return compileTimeConstant instanceof IntegerValueTypeConstant ? new StringValue(((IntegerValueTypeConstant)value2).getValue(TypeUtils.NO_EXPECTED_TYPE).toString(), ((IntegerValueTypeConstant)value2).canBeUsedInAnnotations(), ((IntegerValueTypeConstant)value2).usesVariableAsConstant()) : (compileTimeConstant instanceof StringValue ? (StringValue)value2 : (compileTimeConstant instanceof IntValue || compileTimeConstant instanceof ByteValue || compileTimeConstant instanceof ShortValue || compileTimeConstant instanceof LongValue || compileTimeConstant instanceof CharValue || compileTimeConstant instanceof DoubleValue || compileTimeConstant instanceof FloatValue || compileTimeConstant instanceof BooleanValue || compileTimeConstant instanceof NullValue ? new StringValue(String.valueOf(value2.getValue()), value2.canBeUsedInAnnotations(), value2.usesVariableAsConstant()) : (StringValue)null));
    }

    @Nullable
    public static final CompileTimeConstant<?> createCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value2, @JetValueParameter(name="c") @NotNull EvaluatorContext c, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        return ConstantsPackage.createCompileTimeConstant(value2, c.getCanBeUsedInAnnotation(), c.getIsPure(), c.getUsesVariableAsConstant(), expectedType);
    }

    @Nullable
    public static /* synthetic */ CompileTimeConstant createCompileTimeConstant$default(Object object, EvaluatorContext evaluatorContext, JetType jetType, int n) {
        if ((n & 4) != 0) {
            jetType = null;
        }
        return EvaluatePackage$ConstantExpressionEvaluator$7cd19e02.createCompileTimeConstant(object, evaluatorContext, jetType);
    }

    public static final boolean isIntegerType(@JetValueParameter(name="value", type="?") @Nullable Object value2) {
        return value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final JetType getReceiverExpressionType(@JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<?> resolvedCall) {
        JetType jetType;
        Intrinsics.checkParameterIsNotNull(resolvedCall, (String)"resolvedCall");
        ExplicitReceiverKind explicitReceiverKind = resolvedCall.getExplicitReceiverKind();
        if (explicitReceiverKind != null) {
            switch (EvaluatePackage$ConstantExpressionEvaluator$7cd19e02$WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()]) {
                case 1: {
                    jetType = resolvedCall.getDispatchReceiver().getType();
                    return jetType;
                }
                case 2: {
                    jetType = resolvedCall.getExtensionReceiver().getType();
                    return jetType;
                }
                case 3: {
                    jetType = null;
                    return jetType;
                }
                case 4: {
                    jetType = null;
                    return jetType;
                }
            }
        }
        jetType = null;
        return jetType;
    }

    @Nullable
    public static final CompileTimeType<? extends Object> getCompileTimeType(@JetValueParameter(name="c") @NotNull JetType c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetType jetType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual((Object)jetType, (Object)builtIns.getIntType()) ? INT : (Intrinsics.areEqual((Object)jetType, (Object)builtIns.getByteType()) ? BYTE : (Intrinsics.areEqual((Object)jetType, (Object)builtIns.getShortType()) ? SHORT : (Intrinsics.areEqual((Object)jetType, (Object)builtIns.getLongType()) ? LONG : (Intrinsics.areEqual((Object)jetType, (Object)builtIns.getDoubleType()) ? DOUBLE : (Intrinsics.areEqual((Object)jetType, (Object)builtIns.getFloatType()) ? FLOAT : (Intrinsics.areEqual((Object)jetType, (Object)builtIns.getCharType()) ? CHAR : (Intrinsics.areEqual((Object)jetType, (Object)builtIns.getBooleanType()) ? BOOLEAN : (Intrinsics.areEqual((Object)jetType, (Object)builtIns.getStringType()) ? STRING : (Intrinsics.areEqual((Object)jetType, (Object)builtIns.getAnyType()) ? ANY : (CompileTimeType)null)))))))));
    }

    @NotNull
    public static final CompileTimeType<Byte> getBYTE() {
        return BYTE;
    }

    @NotNull
    public static final CompileTimeType<Short> getSHORT() {
        return SHORT;
    }

    @NotNull
    public static final CompileTimeType<Integer> getINT() {
        return INT;
    }

    @NotNull
    public static final CompileTimeType<Long> getLONG() {
        return LONG;
    }

    @NotNull
    public static final CompileTimeType<Double> getDOUBLE() {
        return DOUBLE;
    }

    @NotNull
    public static final CompileTimeType<Float> getFLOAT() {
        return FLOAT;
    }

    @NotNull
    public static final CompileTimeType<Character> getCHAR() {
        return CHAR;
    }

    @NotNull
    public static final CompileTimeType<Boolean> getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public static final CompileTimeType<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public static final CompileTimeType<Object> getANY() {
        return ANY;
    }

    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public static final <A, B> Pair<BinaryOperationKey<A, B>, Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>> binaryOperation(@JetValueParameter(name="a") @NotNull CompileTimeType<A> a, @JetValueParameter(name="b") @NotNull CompileTimeType<B> b, @JetValueParameter(name="functionName") @NotNull String functionName, @JetValueParameter(name="operation") @NotNull Function2<? super A, ? super B, ? extends Object> operation, @JetValueParameter(name="checker") @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker2) {
        Intrinsics.checkParameterIsNotNull(a, (String)"a");
        Intrinsics.checkParameterIsNotNull(b, (String)"b");
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull(checker2, (String)"checker");
        return KotlinPackage.to(new BinaryOperationKey<A, B>(a, b, functionName), (Object)new Pair(operation, checker2));
    }

    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public static final <A> Pair<UnaryOperationKey<A>, Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>>> unaryOperation(@JetValueParameter(name="a") @NotNull CompileTimeType<A> a, @JetValueParameter(name="functionName") @NotNull String functionName, @JetValueParameter(name="operation") @NotNull Function1<? super A, ? extends Object> operation, @JetValueParameter(name="checker") @NotNull Function1<? super Long, ? extends Long> checker2) {
        Intrinsics.checkParameterIsNotNull(a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull(checker2, (String)"checker");
        return KotlinPackage.to(new UnaryOperationKey<A>(a, functionName), (Object)new Pair(operation, checker2));
    }
}

