/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.data;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwnerStub;
import org.jetbrains.kotlin.psi.JetNamedDeclarationStub;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassLikeInfo;

public abstract class JetClassOrObjectInfo<E extends JetClassOrObject>
implements JetClassLikeInfo {
    protected final E element;

    protected JetClassOrObjectInfo(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "<init>"));
        }
        this.element = element;
    }

    @Nullable
    public Name getName() {
        return ((JetNamedDeclarationStub)this.element).getNameAsName();
    }

    @Override
    public JetClassOrObject getCorrespondingClassOrObject() {
        return this.element;
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        return ((JetModifierListOwnerStub)this.element).getModifierList();
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        List<JetDeclaration> list = ((JetClassOrObject)this.element).getDeclarations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getDeclarations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetObjectDeclaration> getCompanionObjects() {
        JetClassBody body2 = ((JetClassOrObject)this.element).getBody();
        if (body2 == null) {
            List<JetObjectDeclaration> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getCompanionObjects"));
            }
            return list;
        }
        List<JetObjectDeclaration> list = body2.getAllCompanionObjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getCompanionObjects"));
        }
        return list;
    }

    @Override
    @NotNull
    public PsiElement getScopeAnchor() {
        E e = this.element;
        if (e == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getScopeAnchor"));
        }
        return e;
    }

    @Override
    @NotNull
    public FqName getContainingPackageFqName() {
        PsiFile file = this.element.getContainingFile();
        if (file instanceof JetFile) {
            JetFile jetFile = (JetFile)file;
            FqName fqName2 = jetFile.getPackageFqName();
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getContainingPackageFqName"));
            }
            return fqName2;
        }
        throw new IllegalArgumentException("Not in a JetFile: " + this.element);
    }

    @Override
    @NotNull
    public List<JetAnnotationEntry> getDanglingAnnotations() {
        JetClassBody body2 = ((JetClassOrObject)this.element).getBody();
        List<Object> list = body2 == null ? Collections.emptyList() : body2.getDanglingAnnotations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getDanglingAnnotations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends JetParameter> getPrimaryConstructorParameters() {
        List<JetParameter> list = ((JetClassOrObject)this.element).getPrimaryConstructorParameters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassOrObjectInfo", "getPrimaryConstructorParameters"));
        }
        return list;
    }

    public String toString() {
        return "info for " + this.element.getText();
    }
}

